/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.WSRMMessageSender;
import org.apache.sandesha2.wsrm.AckRequested;

public class AckRequestedProcessor
extends WSRMMessageSender {
    private static final Log log = LogFactory.getLog(AckRequestedProcessor.class);

    public boolean processAckRequestedHeaders(RMMsgContext message) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AckRequestedProcessor::processAckRequestHeaders");
        }
        boolean msgCtxPaused = false;
        Iterator ackRequests = message.getAckRequests();
        while (ackRequests.hasNext()) {
            AckRequested ackReq = (AckRequested)ackRequests.next();
            boolean paused = this.processAckRequestedHeader(message, ackReq.getOriginalAckRequestedElement(), ackReq);
            if (msgCtxPaused) continue;
            msgCtxPaused = paused;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AckRequestedProcessor::processAckRequestHeaders " + msgCtxPaused);
        }
        return msgCtxPaused;
    }

    public boolean processAckRequestedHeader(RMMsgContext rmMsgCtx, OMElement soapHeader, AckRequested ackRequested) throws AxisFault {
        boolean piggybackedAckRequest;
        if (log.isDebugEnabled()) {
            log.debug("Enter: AckRequestedProcessor::processAckRequestedHeader " + soapHeader);
        }
        boolean bl = piggybackedAckRequest = rmMsgCtx.getMessageType() != 8;
        if (piggybackedAckRequest) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AckRequestedProcessor::processAckRequestedHeader, it is a piggybacked ackrequest for seq so we can ignore as we will piggyback an ack " + Boolean.FALSE);
            }
            return false;
        }
        String sequenceId = ackRequested.getIdentifier().getIdentifier();
        MessageContext msgContext = rmMsgCtx.getMessageContext();
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId);
        if (rmdBean != null) {
            SandeshaUtil.assertProofOfPossession(rmdBean, msgContext, soapHeader);
        }
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, sequenceId, storageManager, piggybackedAckRequest)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AckRequestedProcessor::processAckRequestedHeader, Unknown sequence ");
            }
            return false;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, sequenceId, rmdBean, piggybackedAckRequest)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AckRequestedProcessor::processAckRequestedHeader, Sequence terminated");
            }
            return false;
        }
        EndpointReference acksTo = rmdBean.getAcksToEndpointReference();
        if (acksTo == null || acksTo.getAddress() == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("acksToStrNotSet"));
        }
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, rmdBean.getRMVersion(), msgContext.getAxisService());
        MessageContext ackMsgCtx = null;
        ackMsgCtx = SandeshaUtil.createNewRelatedMessageContext(rmMsgCtx, ackOperation);
        RMMsgContext ackRMMsgCtx = MsgInitializer.initializeMessage(ackMsgCtx);
        ackRMMsgCtx.setRMNamespaceValue(rmMsgCtx.getRMNamespaceValue());
        if (ackMsgCtx.getMessageID() == null) {
            ackMsgCtx.setMessageID(SandeshaUtil.getUUID());
        }
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(msgContext.getEnvelope()));
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        try {
            ackMsgCtx.setEnvelope(envelope);
        }
        catch (AxisFault e3) {
            throw new SandeshaException(e3.getMessage());
        }
        ackMsgCtx.setTo(acksTo);
        ackMsgCtx.setReplyTo(msgContext.getTo());
        RMMsgCreator.addAckMessage(ackRMMsgCtx, sequenceId, rmdBean, true);
        ackMsgCtx.setServerSide(true);
        if (acksTo.hasAnonymousAddress()) {
            if (rmMsgCtx.getMessageContext().getOperationContext() == null) {
                ServiceContext serviceCtx = msgContext.getServiceContext();
                OperationContext opCtx = OperationContextFactory.createOperationContext(ackOperation.getAxisSpecificMEPConstant(), ackOperation, serviceCtx);
                rmMsgCtx.getMessageContext().setOperationContext(opCtx);
            }
            try {
                AxisEngine.send(ackMsgCtx);
                TransportUtils.setResponseWritten(rmMsgCtx.getMessageContext(), true);
            }
            catch (AxisFault e1) {
                throw new SandeshaException(e1.getMessage());
            }
        } else {
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean(msgContext.getAxisOperation());
            long ackInterval = propertyBean.getAcknowledgementInterval();
            long timeToSend = System.currentTimeMillis() + ackInterval;
            AcknowledgementManager.addAckBeanEntry(ackRMMsgCtx, sequenceId, timeToSend, storageManager);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AckRequestedProcessor::processAckRequestedHeader " + Boolean.FALSE);
        }
        return false;
    }

    public boolean processOutgoingAckRequestMessage(RMMsgContext ackRequestRMMsg) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AckRequestedProcessor::processOutgoingAckRequestMessage");
        }
        this.setupOutMessage(ackRequestRMMsg);
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, this.getRMVersion(), this.getMsgContext().getAxisService());
        this.getMsgContext().setAxisOperation(ackOperation);
        ServiceContext serviceCtx = this.getMsgContext().getServiceContext();
        OperationContext opcontext = OperationContextFactory.createOperationContext(ackOperation.getAxisSpecificMEPConstant(), ackOperation, serviceCtx);
        opcontext.setParent(this.getMsgContext().getServiceContext());
        this.getConfigurationContext().registerOperationContext(ackRequestRMMsg.getMessageId(), opcontext);
        this.getMsgContext().setOperationContext(opcontext);
        Iterator iterator = ackRequestRMMsg.getAckRequests();
        AckRequested ackRequested = null;
        while (iterator.hasNext()) {
            ackRequested = (AckRequested)iterator.next();
        }
        if (iterator.hasNext()) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("ackRequestMultipleParts"));
        }
        if (ackRequested == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("noAckRequestPartFound"));
        }
        ackRequestRMMsg.setWSAAction(SpecSpecificConstants.getAckRequestAction(this.getRMVersion()));
        ackRequestRMMsg.setSOAPAction(SpecSpecificConstants.getAckRequestSOAPAction(this.getRMVersion()));
        this.sendOutgoingMessage(ackRequestRMMsg, 8, 0L, null);
        ackRequestRMMsg.pause();
        if (log.isDebugEnabled()) {
            log.debug("Exit: AckRequestedProcessor::processOutgoingAckRequestMessage " + Boolean.TRUE);
        }
        return true;
    }
}

