/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.handlers;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.LoggingControl;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.Sequence;

public class SandeshaGlobalInHandler
extends AbstractHandler {
    private static final long serialVersionUID = -7187928423123306156L;
    private static final Log log = LogFactory.getLog(SandeshaGlobalInHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        SOAPEnvelope env;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: SandeshaGlobalInHandler::invoke, " + msgContext.getEnvelope().getHeader());
        }
        if (msgContext.getAxisService() != null) {
            Parameter unreliableParam = msgContext.getAxisService().getParameter("Sandesha2UnreliableMessage");
            if (null != unreliableParam && "true".equals(unreliableParam.getValue())) {
                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                    log.debug("Exit: SandeshaGlobalInHandler::invoke, Service has disabled RM " + Handler.InvocationResponse.CONTINUE);
                }
                return Handler.InvocationResponse.CONTINUE;
            }
        } else if (msgContext.getConfigurationContext().getAxisConfiguration().getParameter("Sandesha2PropertyBean") == null) {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug("Exit: SandeshaGlobalInHandler::invoke, No Property Bean found " + Handler.InvocationResponse.CONTINUE);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        String soapAction = msgContext.getSoapAction();
        String wsaAction = msgContext.getWSAAction();
        if (soapAction == null && wsaAction == null && (env = msgContext.getEnvelope()) != null) {
            SOAPBody body;
            boolean lastMessageHeader;
            block15: {
                lastMessageHeader = false;
                try {
                    SOAPHeader header = env.getHeader();
                    if (header != null) {
                        SOAPHeaderBlock shb = (SOAPHeaderBlock)header.getFirstChildWithName(Sandesha2Constants.SPEC_2005_02.QNames.Sequence);
                        Sequence sequence = new Sequence("http://schemas.xmlsoap.org/ws/2005/02/rm");
                        sequence.fromHeaderBlock(shb);
                        lastMessageHeader = sequence.getLastMessage();
                    }
                }
                catch (Exception e) {
                    if (!LoggingControl.isAnyTracingEnabled() || !log.isDebugEnabled()) break block15;
                    log.debug("Exception encountered accessing Sequence Header ", e);
                }
            }
            if (lastMessageHeader && (body = env.getBody()) != null && body.getFirstElement() == null) {
                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                    log.debug("Setting SOAP Action for a WSRM 1.0 last message");
                }
                msgContext.setSoapAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
            }
        }
        RMMsgContext rmMsgCtx = MsgInitializer.initializeMessage(msgContext);
        msgContext.setProperty("RMMessageContext", rmMsgCtx);
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(rmMsgCtx.getConfigurationContext(), rmMsgCtx.getConfigurationContext().getAxisConfiguration());
        Handler.InvocationResponse response = FaultManager.processMessagesForFaults(rmMsgCtx, storageManager);
        if (rmMsgCtx.getMessageType() == 3 || rmMsgCtx.getMessageType() == 12) {
            SandeshaGlobalInHandler.processApplicationMessage(rmMsgCtx);
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: SandeshaGlobalInHandler::invoke " + response);
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processApplicationMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        block21: {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug("Enter: SandeshaGlobalInHandler::processApplicationMessage");
            }
            Sequence sequence = rmMsgCtx.getSequence();
            String sequenceId = sequence.getIdentifier().getIdentifier();
            long msgNo = sequence.getMessageNumber();
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(rmMsgCtx.getConfigurationContext(), rmMsgCtx.getConfigurationContext().getAxisConfiguration());
            Transaction transaction = null;
            try {
                try {
                    block23: {
                        MessageContext messageContext;
                        block22: {
                            transaction = storageManager.getTransaction();
                            RMDBeanMgr mgr = storageManager.getRMDBeanMgr();
                            RMDBean bean = mgr.retrieve(sequenceId);
                            messageContext = rmMsgCtx.getMessageContext();
                            if (bean == null) break block22;
                            SandeshaUtil.assertProofOfPossession(bean, messageContext, messageContext.getEnvelope().getBody());
                            SandeshaUtil.assertProofOfPossession(bean, messageContext, messageContext.getEnvelope().getHeader().getFirstChildWithName(new QName(rmMsgCtx.getRMNamespaceValue(), "Sequence")));
                            if (msgNo == 0L) {
                                String message = SandeshaMessageHelper.getMessage("invalidMsgNumber", Long.toString(msgNo));
                                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                    log.debug(message);
                                }
                                throw new SandeshaException(message);
                            }
                            RangeString serverCompletedMessageRanges = bean.getServerCompletedMessages();
                            boolean msgNoPresentInList = serverCompletedMessageRanges.isMessageNumberInRanges(msgNo);
                            if (rmMsgCtx.getMessageType() == 12 && bean.getOutboundInternalSequence() != null) {
                                rmMsgCtx.setProperty("DisableResponseAck", Boolean.TRUE);
                            }
                            if (msgNoPresentInList) {
                                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                    log.debug("Detected duplicate message " + msgNo);
                                }
                                boolean isDuplicate = true;
                                if (SandeshaUtil.isInOrder(rmMsgCtx.getMessageContext())) {
                                    InvokerBean finderBean = new InvokerBean();
                                    finderBean.setMsgNo(msgNo);
                                    finderBean.setSequenceID(sequenceId);
                                    List invokerBeanList = storageManager.getInvokerBeanMgr().find(finderBean);
                                    if ((invokerBeanList == null || invokerBeanList.size() == 0) && bean.getNextMsgNoToProcess() <= msgNo) {
                                        isDuplicate = false;
                                        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                            log.debug("Allowing completed message on sequence " + sequenceId + ", msgNo " + msgNo);
                                        }
                                    }
                                }
                                if (isDuplicate) {
                                    AxisService service = rmMsgCtx.getMessageContext().getAxisService();
                                    if (service == null) {
                                        throw new SandeshaException("Duplicate message detected. But cant dispatch since the Service has not been found");
                                    }
                                    SandeshaGlobalInHandler.setupDuplicateOperation(rmMsgCtx);
                                }
                            }
                            break block23;
                        }
                        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                            log.debug("Detected message for no sequence " + msgNo);
                        }
                        messageContext.setRelationships(null);
                        AxisService service = rmMsgCtx.getMessageContext().getAxisService();
                        if (service == null) {
                            throw new SandeshaException("Duplicate message detected. But cant dispatch since the Service has not been found");
                        }
                        SandeshaGlobalInHandler.setupDuplicateOperation(rmMsgCtx);
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                }
                catch (RuntimeException e) {
                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                        log.debug("Exit: SandeshaGlobalInHandler::processApplicationMessage", e);
                    }
                    throw e;
                }
                Object var16_17 = null;
                if (transaction == null || !transaction.isActive()) break block21;
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                throw throwable;
            }
            transaction.rollback();
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: SandeshaGlobalInHandler::processApplicationMessage");
        }
    }

    private static void setupDuplicateOperation(RMMsgContext rmMsgCtx) throws SandeshaException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: SandeshaGlobalInHandler::setupDuplicateOperation");
        }
        MessageContext ctx = rmMsgCtx.getMessageContext();
        AxisOperation duplicateMessageOperation = null;
        int mep = 10;
        AxisOperation userOp = ctx.getAxisOperation();
        if (userOp != null) {
            mep = userOp.getAxisSpecificMEPConstant();
        }
        boolean inOut = false;
        if (10 == mep) {
            duplicateMessageOperation = SpecSpecificConstants.getWSRMOperation(13, "Spec_2005_02", rmMsgCtx.getMessageContext().getAxisService());
        } else {
            duplicateMessageOperation = SpecSpecificConstants.getWSRMOperation(14, "Spec_2005_02", rmMsgCtx.getMessageContext().getAxisService());
            inOut = true;
        }
        ctx.setRelationships(null);
        ctx.setAxisOperation(duplicateMessageOperation);
        if (inOut) {
            RelatesTo relatesTo = rmMsgCtx.getRelatesTo();
            String messageID = rmMsgCtx.getMessageContext().getOptions().getMessageId();
            if (relatesTo != null && messageID == null) {
                rmMsgCtx.getMessageContext().getOptions().setMessageId(SandeshaUtil.getUUID());
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: SandeshaGlobalInHandler::setupDuplicateOperation");
        }
    }
}

