/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.MessagePending;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.SequenceFault;
import org.apache.sandesha2.wsrm.TerminateSequence;
import org.apache.sandesha2.wsrm.TerminateSequenceResponse;
import org.apache.sandesha2.wsrm.UsesSequenceSTR;

public class RMMsgContext {
    private MessageContext msgContext;
    private int messageType = 0;
    private String rmNamespaceValue = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private String rmSpecVersion = null;
    private Sequence sequence = null;
    private ArrayList sequenceAcknowledgements = new ArrayList();
    private ArrayList ackRequests = new ArrayList();
    private CreateSequence createSequence = null;
    private CreateSequenceResponse createSequenceResponse = null;
    private TerminateSequence terminateSequence = null;
    private TerminateSequenceResponse terminateSequenceResponse = null;
    private CloseSequence closeSequence = null;
    private CloseSequenceResponse closeSequenceResponse = null;
    private UsesSequenceSTR usesSequenceSTR = null;
    private MessagePending messagePending = null;
    private MakeConnection makeConnection = null;
    private SequenceFault sequenceFault = null;
    private static HashSet bodyLocalNames = new HashSet();

    public RMMsgContext() {
    }

    public void setMessageContext(MessageContext msgCtx) {
        this.msgContext = msgCtx;
    }

    public RMMsgContext(MessageContext ctx) {
        this();
        this.msgContext = ctx;
    }

    public void addSOAPEnvelope() throws AxisFault {
        boolean goingToAddHeader;
        int SOAPVersion2 = 1;
        if (!this.msgContext.isSOAP11()) {
            SOAPVersion2 = 2;
        }
        if (this.msgContext.getEnvelope() == null) {
            try {
                this.msgContext.setEnvelope(SOAPAbstractFactory.getSOAPFactory(SOAPVersion2).getDefaultEnvelope());
            }
            catch (AxisFault e) {
                throw new SandeshaException(e.getMessage());
            }
        }
        SOAPEnvelope envelope = this.msgContext.getEnvelope();
        boolean bl = goingToAddHeader = this.sequence != null || this.sequenceAcknowledgements.size() > 0 || this.ackRequests.size() > 0 || this.sequenceFault != null || this.usesSequenceSTR != null || this.messagePending != null;
        if (goingToAddHeader) {
            SOAPHeader header = envelope.getHeader();
            if (header == null) {
                header = ((SOAPFactory)envelope.getOMFactory()).createSOAPHeader(envelope);
            } else {
                Iterator existingHeaders = header.getChildElements();
                while (existingHeaders.hasNext()) {
                    OMElement oe = (OMElement)existingHeaders.next();
                    if (!this.rmNamespaceValue.equals(oe.getNamespace().getNamespaceURI())) continue;
                    oe.detach();
                }
            }
            if (this.sequence != null) {
                this.sequence.toHeader(header);
            }
            for (SequenceAcknowledgement sequenceAck : this.sequenceAcknowledgements) {
                sequenceAck.toHeader(header);
            }
            for (AckRequested ackReq : this.ackRequests) {
                ackReq.toHeader(header);
            }
            if (this.sequenceFault != null) {
                this.sequenceFault.toHeader(header);
            }
            if (this.usesSequenceSTR != null) {
                this.usesSequenceSTR.toHeader(header);
            }
            if (this.messagePending != null) {
                this.messagePending.toHeader(header);
            }
        }
        if (this.createSequence != null) {
            this.createSequence.toSOAPEnvelope(envelope);
        }
        if (this.createSequenceResponse != null) {
            this.createSequenceResponse.toSOAPEnvelope(envelope);
        }
        if (this.terminateSequence != null) {
            this.terminateSequence.toSOAPEnvelope(envelope);
        }
        if (this.terminateSequenceResponse != null) {
            this.terminateSequenceResponse.toSOAPEnvelope(envelope);
        }
        if (this.closeSequence != null) {
            this.closeSequence.toSOAPEnvelope(envelope);
        }
        if (this.closeSequenceResponse != null) {
            this.closeSequenceResponse.toSOAPEnvelope(envelope);
        }
        if (this.makeConnection != null) {
            this.makeConnection.toSOAPEnvelope(envelope);
        }
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int msgType) {
        if (msgType >= 0 && msgType <= 15) {
            this.messageType = msgType;
        }
    }

    public EndpointReference getFrom() {
        return this.msgContext.getFrom();
    }

    public EndpointReference getTo() {
        return this.msgContext.getTo();
    }

    public EndpointReference getReplyTo() {
        return this.msgContext.getReplyTo();
    }

    public RelatesTo getRelatesTo() {
        return this.msgContext.getRelatesTo();
    }

    public String getMessageId() {
        return this.msgContext.getMessageID();
    }

    public void setFaultTo(EndpointReference epr) {
        this.msgContext.setFaultTo(epr);
    }

    public EndpointReference getFaultTo() {
        return this.msgContext.getFaultTo();
    }

    public SOAPEnvelope getSOAPEnvelope() {
        return this.msgContext.getEnvelope();
    }

    public void setSOAPEnvelop(SOAPEnvelope envelope) throws SandeshaException {
        try {
            this.msgContext.setEnvelope(envelope);
        }
        catch (AxisFault e) {
            throw new SandeshaException(e.getMessage());
        }
    }

    public void setFrom(EndpointReference epr) {
        this.msgContext.setFrom(epr);
    }

    public void setTo(EndpointReference epr) {
        this.msgContext.setTo(epr);
    }

    public void setReplyTo(EndpointReference epr) {
        this.msgContext.setReplyTo(epr);
    }

    public void setMessageId(String messageId) {
        this.msgContext.setMessageID(messageId);
    }

    public void setAction(String action) {
        this.msgContext.setWSAAction(action);
    }

    public void addRelatesTo(RelatesTo relatesTo) {
        this.msgContext.addRelatesTo(relatesTo);
    }

    public void setWSAAction(String URI2) {
        this.msgContext.setWSAAction(URI2);
    }

    public String getWSAAction() {
        return this.msgContext.getWSAAction();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public Object getProperty(String key) {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getProperty(key);
    }

    public boolean setProperty(String key, Object val) {
        if (this.msgContext == null) {
            return false;
        }
        this.msgContext.setProperty(key, val);
        return true;
    }

    public ConfigurationContext getConfigurationContext() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getConfigurationContext();
    }

    public void setSOAPAction(String SOAPAction) {
        this.msgContext.setSoapAction(SOAPAction);
    }

    public void pause() {
        if (this.msgContext != null) {
            this.msgContext.pause();
        }
    }

    public void setPaused(boolean pause) {
        if (this.msgContext != null) {
            this.msgContext.setPaused(pause);
        }
    }

    public String getRMNamespaceValue() {
        return this.rmNamespaceValue;
    }

    public void setRMNamespaceValue(String rmNamespaceValue) {
        this.rmNamespaceValue = rmNamespaceValue;
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmNamespaceValue)) {
            this.rmSpecVersion = "Spec_2005_02";
        } else if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(rmNamespaceValue)) {
            this.rmSpecVersion = "Spec_2007_02";
        }
    }

    public String getRMSpecVersion() {
        if (this.rmSpecVersion == null && this.msgContext != null && this.msgContext.getOptions() != null) {
            this.rmSpecVersion = (String)this.msgContext.getOptions().getProperty("Sandesha2RMSpecVersion");
        }
        return this.rmSpecVersion;
    }

    public void setFlow(int flow) {
        this.msgContext.setFLOW(flow);
    }

    public int getFlow() {
        return this.msgContext.getFLOW();
    }

    public String getGeneratedSequenceId() {
        return (String)this.msgContext.getProperty("WSRMSequenceId");
    }

    public CreateSequence getCreateSequence() {
        return this.createSequence;
    }

    public CreateSequenceResponse getCreateSequenceResponse() {
        return this.createSequenceResponse;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public Iterator getSequenceAcknowledgements() {
        return this.sequenceAcknowledgements.iterator();
    }

    public TerminateSequence getTerminateSequence() {
        return this.terminateSequence;
    }

    public TerminateSequenceResponse getTerminateSequenceResponse() {
        return this.terminateSequenceResponse;
    }

    public void setCreateSequence(CreateSequence createSequence) {
        this.createSequence = createSequence;
    }

    public void setCreateSequenceResponse(CreateSequenceResponse createSequenceResponse) {
        this.createSequenceResponse = createSequenceResponse;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setSequenceAcknowledgements(ArrayList sequenceAcknowledgements) {
        this.sequenceAcknowledgements = sequenceAcknowledgements;
    }

    public void addSequenceAcknowledgement(SequenceAcknowledgement sequenceAcknowledgement) {
        this.sequenceAcknowledgements.add(sequenceAcknowledgement);
    }

    public void setTerminateSequence(TerminateSequence terminateSequence) {
        this.terminateSequence = terminateSequence;
    }

    public void setTerminateSequenceResponse(TerminateSequenceResponse terminateSequenceResponse) {
        this.terminateSequenceResponse = terminateSequenceResponse;
    }

    public Iterator getAckRequests() {
        return this.ackRequests.iterator();
    }

    public void setAckRequested(ArrayList ackRequests) {
        this.ackRequests = ackRequests;
    }

    public void addAckRequested(AckRequested ackRequested) {
        this.ackRequests.add(ackRequested);
    }

    public void setMakeConnection(MakeConnection makeConnection) {
        this.makeConnection = makeConnection;
    }

    public void setMessagePending(MessagePending messagePending) {
        this.messagePending = messagePending;
    }

    public CloseSequence getCloseSequence() {
        return this.closeSequence;
    }

    public void setCloseSequence(CloseSequence closeSequence) {
        this.closeSequence = closeSequence;
    }

    public CloseSequenceResponse getCloseSequenceResponse() {
        return this.closeSequenceResponse;
    }

    public void setCloseSequenceResponse(CloseSequenceResponse closeSequenceResponse) {
        this.closeSequenceResponse = closeSequenceResponse;
    }

    public UsesSequenceSTR getUsesSequenceSTR() {
        return this.usesSequenceSTR;
    }

    public void setUsesSequenceSTR(UsesSequenceSTR header) {
        this.usesSequenceSTR = header;
    }

    public MakeConnection getMakeConnection() {
        return this.makeConnection;
    }

    public MessagePending getMessagePending() {
        return this.messagePending;
    }

    public SequenceFault getSequenceFault() {
        return this.sequenceFault;
    }

    public void setSequenceFault(SequenceFault sequenceFault2) {
        this.sequenceFault = sequenceFault2;
    }

    public void fromSOAPEnvelope(SOAPEnvelope envelope, String action) throws AxisFault {
        if (envelope == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullPassedElement"));
        }
        SOAPHeader header = envelope.getHeader();
        SOAPBody body = envelope.getBody();
        if (header != null) {
            this.processHeaders(header);
        }
        if (body != null) {
            this.processBody(body);
        }
    }

    private void processBody(SOAPBody body) throws AxisFault {
        OMElement firstBodyElement;
        if (bodyLocalNames.contains(body.getFirstElementLocalName()) && (firstBodyElement = body.getFirstElement()) != null) {
            QName firstBodyQName = firstBodyElement.getQName();
            String namespace = firstBodyQName.getNamespaceURI();
            boolean isSPEC2007_02 = "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespace);
            boolean isSPEC2005_02 = false;
            if (!isSPEC2007_02) {
                isSPEC2005_02 = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespace);
            }
            if (isSPEC2005_02 || isSPEC2007_02) {
                if (Sandesha2Constants.SPEC_2007_02.QNames.CreateSequence.equals(firstBodyQName)) {
                    this.createSequence = new CreateSequence(namespace);
                    this.createSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CreateSequence.equals(firstBodyQName)) {
                    this.createSequence = new CreateSequence(namespace);
                    this.createSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.CreateSequenceResponse.equals(firstBodyQName)) {
                    this.createSequenceResponse = new CreateSequenceResponse(namespace);
                    this.createSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CreateSequenceResponse.equals(firstBodyQName)) {
                    this.createSequenceResponse = new CreateSequenceResponse(namespace);
                    this.createSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.CloseSequence.equals(firstBodyQName)) {
                    this.closeSequence = new CloseSequence(namespace);
                    this.closeSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CloseSequence.equals(firstBodyQName)) {
                    this.closeSequence = new CloseSequence(namespace);
                    this.closeSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.CloseSequenceResponse.equals(firstBodyQName)) {
                    this.closeSequenceResponse = new CloseSequenceResponse(namespace);
                    this.closeSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CloseSequenceResponse.equals(firstBodyQName)) {
                    this.closeSequenceResponse = new CloseSequenceResponse(namespace);
                    this.closeSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.TerminateSequence.equals(firstBodyQName)) {
                    this.terminateSequence = new TerminateSequence(namespace);
                    this.terminateSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.TerminateSequence.equals(firstBodyQName)) {
                    this.terminateSequence = new TerminateSequence(namespace);
                    this.terminateSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.TerminateSequenceResponse.equals(firstBodyQName)) {
                    this.terminateSequenceResponse = new TerminateSequenceResponse(namespace);
                    this.terminateSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.TerminateSequenceResponse.equals(firstBodyQName)) {
                    this.terminateSequenceResponse = new TerminateSequenceResponse(namespace);
                    this.terminateSequenceResponse.fromOMElement(body);
                }
            } else if (Sandesha2Constants.SPEC_2007_02.QNames.MakeConnection.equals(firstBodyQName)) {
                this.makeConnection = new MakeConnection();
                this.makeConnection.fromOMElement(firstBodyElement);
            }
        }
    }

    private void processHeaders(SOAPHeader header) throws AxisFault {
        Iterator headers = header.getChildElements();
        while (headers.hasNext()) {
            SOAPHeaderBlock element = (SOAPHeaderBlock)headers.next();
            QName elementName = element.getQName();
            String namespace = elementName.getNamespaceURI();
            String localName = elementName.getLocalPart();
            boolean isSPEC2007_02 = "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespace);
            boolean isSPEC2005_02 = false;
            if (!isSPEC2007_02) {
                isSPEC2005_02 = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespace);
            }
            if (!isSPEC2005_02 && !isSPEC2007_02) continue;
            boolean isProcessed = false;
            if (isSPEC2007_02) {
                if ("UsesSequenceSTR".equals(localName)) {
                    this.usesSequenceSTR = new UsesSequenceSTR();
                    this.usesSequenceSTR.fromHeaderBlock(element);
                    isProcessed = true;
                } else if ("MessagePending".equals(localName)) {
                    this.messagePending = new MessagePending();
                    this.messagePending.fromHeaderBlock(element);
                    isProcessed = true;
                }
            }
            if (isProcessed) continue;
            if ("Sequence".equals(localName)) {
                this.sequence = new Sequence(namespace);
                this.sequence.fromHeaderBlock(element);
                continue;
            }
            if ("SequenceAcknowledgement".equals(localName)) {
                SequenceAcknowledgement sequenceAcknowledgement = new SequenceAcknowledgement(namespace);
                sequenceAcknowledgement.fromHeaderBlock(element);
                this.sequenceAcknowledgements.add(sequenceAcknowledgement);
                continue;
            }
            if ("AckRequested".equals(localName)) {
                AckRequested ackRequest = new AckRequested(namespace);
                ackRequest.fromHeaderBlock(element);
                this.ackRequests.add(ackRequest);
                continue;
            }
            if (!"SequenceFault".equals(localName)) continue;
            this.sequenceFault = new SequenceFault(namespace);
            this.sequenceFault.fromHeaderBlock(element);
        }
    }

    static {
        bodyLocalNames.add("CreateSequence");
        bodyLocalNames.add("CreateSequenceResponse");
        bodyLocalNames.add("CloseSequence");
        bodyLocalNames.add("CloseSequenceResponse");
        bodyLocalNames.add("TerminateSequence");
        bodyLocalNames.add("TerminateSequenceResponse");
        bodyLocalNames.add("MakeConnection");
    }
}

