/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.namespace.Constants;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.wsdl.HTTPHeaderMessage;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.SOAPModuleMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;

public class WSDLSerializationUtil {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_START_REGEX = "<!\\[CDATA\\[";
    public static final String CDATA_END = "]]>";
    public static final String CDATA_END_REGEX = "\\]\\]>";

    public static String getPrefix(String namespace, Map nameSpaceMap) {
        Set keySet;
        if (nameSpaceMap != null && (keySet = nameSpaceMap.keySet()) != null) {
            for (String key : keySet) {
                if (!nameSpaceMap.get(key).equals(namespace)) continue;
                return key;
            }
        }
        return null;
    }

    public static String getElementName(AxisMessage axisMessage, Map nameSpaceMap) {
        QName elementQName = axisMessage.getElementQName();
        if (elementQName == null) {
            return "#none";
        }
        if (Constants.XSD_ANY.equals(elementQName)) {
            return "#any";
        }
        String prefix = WSDLSerializationUtil.getPrefix(elementQName.getNamespaceURI(), nameSpaceMap);
        return prefix + ":" + elementQName.getLocalPart();
    }

    public static void addSOAPHeaderElements(OMFactory omFactory, ArrayList list, OMNamespace wsoap, OMElement element, Map nameSpaceMap) {
        for (int i = 0; i < list.size(); ++i) {
            SOAPHeaderMessage soapHeaderMessage = (SOAPHeaderMessage)list.get(i);
            OMElement soapHeaderElement = omFactory.createOMElement("header", wsoap);
            QName qName = soapHeaderMessage.getElement();
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("element", null, WSDLSerializationUtil.getPrefix(qName.getNamespaceURI(), nameSpaceMap) + ":" + qName.getLocalPart()));
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("mustUnderstand", null, Boolean.toString(soapHeaderMessage.isMustUnderstand())));
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("required", null, Boolean.toString(soapHeaderMessage.isRequired())));
            element.addChild(soapHeaderElement);
        }
    }

    public static void addSOAPModuleElements(OMFactory omFactory, ArrayList list, OMNamespace wsoap, OMElement element) {
        for (int i = 0; i < list.size(); ++i) {
            SOAPModuleMessage soapModuleMessage = (SOAPModuleMessage)list.get(i);
            OMElement soapModuleElement = omFactory.createOMElement("module", wsoap);
            soapModuleElement.addAttribute(omFactory.createOMAttribute("ref", null, soapModuleMessage.getUri()));
            element.addChild(soapModuleElement);
        }
    }

    public static void addHTTPHeaderElements(OMFactory omFactory, ArrayList list, OMNamespace whttp, OMElement element, Map nameSpaceMap) {
        for (int i = 0; i < list.size(); ++i) {
            HTTPHeaderMessage httpHeaderMessage = (HTTPHeaderMessage)list.get(i);
            OMElement httpHeaderElement = omFactory.createOMElement("header", whttp);
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("name", null, httpHeaderMessage.getName()));
            QName qName = httpHeaderMessage.getqName();
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("type", null, WSDLSerializationUtil.getPrefix(qName.getNamespaceURI(), nameSpaceMap) + ":" + qName.getLocalPart()));
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("required", null, Boolean.valueOf(httpHeaderMessage.isRequired()).toString()));
            element.addChild(httpHeaderElement);
        }
    }

    public static OMElement generateSOAP11Binding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace wsoap, OMNamespace tns, String serviceName) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, serviceName + "SOAP11Binding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/soap"));
        binding.addAttribute(fac.createOMAttribute("version", wsoap, "1.1"));
        binding.addAttribute(fac.createOMAttribute("protocol", wsoap, "http://www.w3.org/2003/05/soap/bindings/HTTP"));
        WSDLSerializationUtil.generateDefaultSOAPBindingOperations(axisService, fac, binding, wsdl, tns, wsoap);
        return binding;
    }

    public static OMElement generateSOAP12Binding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace wsoap, OMNamespace tns, String serviceName) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, serviceName + "SOAP12Binding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/soap"));
        binding.addAttribute(fac.createOMAttribute("version", wsoap, "1.2"));
        binding.addAttribute(fac.createOMAttribute("protocol", wsoap, "http://www.w3.org/2003/05/soap/bindings/HTTP"));
        WSDLSerializationUtil.generateDefaultSOAPBindingOperations(axisService, fac, binding, wsdl, tns, wsoap);
        return binding;
    }

    public static OMElement generateHTTPBinding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace whttp, OMNamespace tns, String serviceName) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, serviceName + "HttpBinding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/http"));
        Iterator iterator = axisService.getChildren();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            OMElement opElement = fac.createOMElement("operation", wsdl);
            binding.addChild(opElement);
            String name = axisOperation.getName().getLocalPart();
            opElement.addAttribute(fac.createOMAttribute("ref", null, tns.getPrefix() + ":" + name));
            opElement.addAttribute(fac.createOMAttribute("location", whttp, name));
        }
        return binding;
    }

    private static void generateDefaultSOAPBindingOperations(AxisService axisService, OMFactory omFactory, OMElement binding, OMNamespace wsdl, OMNamespace tns, OMNamespace wsoap) {
        Iterator iterator = axisService.getChildren();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            if (axisOperation.isControlOperation()) continue;
            OMElement opElement = omFactory.createOMElement("operation", wsdl);
            binding.addChild(opElement);
            String name = axisOperation.getName().getLocalPart();
            opElement.addAttribute(omFactory.createOMAttribute("ref", null, tns.getPrefix() + ":" + name));
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) continue;
            opElement.addAttribute(omFactory.createOMAttribute("action", wsoap, soapAction));
        }
    }

    public static OMElement generateServiceElement(OMFactory omFactory, OMNamespace wsdl, OMNamespace tns, AxisService axisService, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11, String serviceName) throws AxisFault {
        return WSDLSerializationUtil.generateServiceElement(omFactory, wsdl, tns, axisService, disableREST, disableSOAP12, disableSOAP11, null, serviceName);
    }

    public static OMElement generateServiceElement(OMFactory omFactory, OMNamespace wsdl, OMNamespace tns, AxisService axisService, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11, String[] eprs, String serviceName) throws AxisFault {
        if (eprs == null && (eprs = axisService.getEPRs()) == null) {
            eprs = new String[]{serviceName};
        }
        OMElement serviceElement = omFactory.createOMElement("service", wsdl);
        serviceElement.addAttribute(omFactory.createOMAttribute("name", null, serviceName));
        serviceElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        for (int i = 0; i < eprs.length; ++i) {
            OMElement httpDocumentation;
            OMElement soap12Documentation;
            OMElement soap11Documentation;
            String name = "";
            String epr = eprs[i];
            if (epr.startsWith("https://")) {
                name = "Secure";
            }
            OMElement soap11EndpointElement = null;
            if (!disableSOAP11) {
                soap11EndpointElement = omFactory.createOMElement("endpoint", wsdl);
                soap11EndpointElement.addAttribute(omFactory.createOMAttribute("name", null, name + "SOAP11Endpoint"));
                soap11EndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + serviceName + "SOAP11Binding"));
                soap11EndpointElement.addAttribute(omFactory.createOMAttribute("address", null, epr));
                serviceElement.addChild(soap11EndpointElement);
            }
            OMElement soap12EndpointElement = null;
            if (!disableSOAP12) {
                soap12EndpointElement = omFactory.createOMElement("endpoint", wsdl);
                soap12EndpointElement.addAttribute(omFactory.createOMAttribute("name", null, name + "SOAP12Endpoint"));
                soap12EndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + serviceName + "SOAP12Binding"));
                soap12EndpointElement.addAttribute(omFactory.createOMAttribute("address", null, epr));
                serviceElement.addChild(soap12EndpointElement);
            }
            OMElement httpEndpointElement = null;
            if (!disableREST) {
                httpEndpointElement = omFactory.createOMElement("endpoint", wsdl);
                httpEndpointElement.addAttribute(omFactory.createOMAttribute("name", null, name + "HTTPEndpoint"));
                httpEndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + serviceName + "HttpBinding"));
                httpEndpointElement.addAttribute(omFactory.createOMAttribute("address", null, epr));
                serviceElement.addChild(httpEndpointElement);
            }
            if (epr.startsWith("https://")) {
                if (!disableSOAP11) {
                    soap11Documentation = omFactory.createOMElement("documentation", wsdl);
                    soap11Documentation.setText("This endpoint exposes a SOAP 11 binding over a HTTPS");
                    soap11EndpointElement.addChild(soap11Documentation);
                }
                if (!disableSOAP12) {
                    soap12Documentation = omFactory.createOMElement("documentation", wsdl);
                    soap12Documentation.setText("This endpoint exposes a SOAP 12 binding over a HTTPS");
                    soap12EndpointElement.addChild(soap12Documentation);
                }
                if (disableREST) continue;
                httpDocumentation = omFactory.createOMElement("documentation", wsdl);
                httpDocumentation.setText("This endpoint exposes a HTTP binding over a HTTPS");
                httpEndpointElement.addChild(httpDocumentation);
                continue;
            }
            if (!epr.startsWith("http://")) continue;
            if (!disableSOAP11) {
                soap11Documentation = omFactory.createOMElement("documentation", wsdl);
                soap11Documentation.setText("This endpoint exposes a SOAP 11 binding over a HTTP");
                soap11EndpointElement.addChild(soap11Documentation);
            }
            if (!disableSOAP12) {
                soap12Documentation = omFactory.createOMElement("documentation", wsdl);
                soap12Documentation.setText("This endpoint exposes a SOAP 12 binding over a HTTP");
                soap12EndpointElement.addChild(soap12Documentation);
            }
            if (disableREST) continue;
            httpDocumentation = omFactory.createOMElement("documentation", wsdl);
            httpDocumentation.setText("This endpoint exposes a HTTP binding over a HTTP");
            httpEndpointElement.addChild(httpDocumentation);
        }
        return serviceElement;
    }

    public static void populateNamespaces(OMElement descriptionElement, Map nameSpaceMap) {
        if (nameSpaceMap != null) {
            for (String key : nameSpaceMap.keySet()) {
                if ("".equals(key)) {
                    descriptionElement.declareDefaultNamespace((String)nameSpaceMap.get(key));
                    continue;
                }
                descriptionElement.declareNamespace((String)nameSpaceMap.get(key), key);
            }
        }
    }

    public static void addWSAWActionAttribute(OMElement element, String action, OMNamespace wsaw) {
        if (action == null || action.length() == 0 || "\\\"\\\"".equals(action)) {
            return;
        }
        element.addAttribute("Action", action, wsaw);
    }

    public static void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement(name, soapNameSpace);
        element.addChild(extElement);
        extElement.addAttribute(att1Name, att1Value, null);
    }

    public static void addWSAddressingToBinding(String addressingFlag, OMFactory omFactory, OMElement bindingElement, OMNamespace wsaw) {
        if (addressingFlag.equals("optional")) {
            WSDLSerializationUtil.addExtensionElement(omFactory, bindingElement, "UsingAddressing", "required", "true", wsaw);
        } else if (addressingFlag.equals("required")) {
            WSDLSerializationUtil.addExtensionElement(omFactory, bindingElement, "UsingAddressing", "required", "true", wsaw);
        }
    }

    public static void addWSDLDocumentationElement(AxisDescription axisDescription, OMElement omElement, OMFactory omFactory, OMNamespace wsdl) {
        OMNode documentationNode = axisDescription.getDocumentationNode();
        if (documentationNode != null) {
            OMElement documentation = omFactory.createOMElement("documentation", wsdl);
            documentation.addChild(documentationNode);
            omElement.addChild(documentation);
        }
    }

    public static void addPoliciesAsExtensibleElement(AxisDescription description, OMElement descriptionElement) {
        PolicySubject policySubject = description.getPolicySubject();
        Collection attachPolicyComponents = policySubject.getAttachedPolicyComponents();
        ArrayList policies = new ArrayList();
        for (Object policyElement : attachPolicyComponents) {
            AxisService service;
            PolicyLocator locator;
            Policy p;
            if (policyElement instanceof Policy) {
                policies.add(policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = (locator = new PolicyLocator(service = WSDLSerializationUtil.getAxisService(description))).lookup(key)) == null) {
                throw new RuntimeException("Policy not found for uri : " + key);
            }
            policies.add(p);
        }
        ExternalPolicySerializer filter = null;
        if (!policies.isEmpty()) {
            filter = new ExternalPolicySerializer();
            AxisConfiguration axisConfiguration = description.getAxisConfiguration();
            if (axisConfiguration != null) {
                filter.setAssertionsToFilter(axisConfiguration.getLocalPolicyAssertions());
            }
        }
        for (Policy policy : policies) {
            OMElement policyElement;
            try {
                policyElement = PolicyUtil.getPolicyComponentAsOMElement(policy, filter);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            OMNode firstChild = descriptionElement.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore(policyElement);
                continue;
            }
            descriptionElement.addChild(policyElement);
        }
    }

    private static AxisService getAxisService(AxisDescription description) {
        if (description == null || description instanceof AxisService) {
            return (AxisService)description;
        }
        return WSDLSerializationUtil.getAxisService(description.getParent());
    }
}

