/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.xmpp.util.XMPPClientSidePacketListener;
import org.apache.axis2.transport.xmpp.util.XMPPConnectionFactory;
import org.apache.axis2.transport.xmpp.util.XMPPOutTransportInfo;
import org.apache.axis2.transport.xmpp.util.XMPPServerCredentials;
import org.apache.axis2.transport.xmpp.util.XMPPUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;

public class XMPPSender
extends AbstractHandler
implements TransportSender {
    Log log = LogFactory.getLog(XMPPSender.class);
    XMPPConnectionFactory connectionFactory;

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        XMPPServerCredentials serverCredentials = new XMPPServerCredentials();
        this.getConnectionDetailsFromAxisConfiguration(serverCredentials, transportOut);
        this.connectionFactory = new XMPPConnectionFactory();
        this.connectionFactory.connect(serverCredentials);
    }

    private void connectUsingClientOptions(MessageContext msgCtx) throws AxisFault {
        XMPPServerCredentials serverCredentials = new XMPPServerCredentials();
        this.getConnectionDetailsFromClientOptions(serverCredentials, msgCtx);
        this.connectionFactory = new XMPPConnectionFactory();
        this.connectionFactory.connect(serverCredentials);
    }

    public void stop() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        String targetAddress = (String)msgContext.getProperty("TransportURL");
        if (targetAddress != null) {
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            targetAddress = msgContext.getTo().getAddress();
            if (msgContext.getTo().hasNoneAddress()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else {
            if (!msgContext.isServerSide()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, null, (OutTransportInfo)msgContext.getProperty("OutTransportInfo"));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        XMPPConnection xmppConnection = null;
        XMPPOutTransportInfo xmppOutTransportInfo = null;
        if (!msgCtx.isServerSide()) {
            this.connectUsingClientOptions(msgCtx);
        }
        Message message = new Message();
        Options options = msgCtx.getOptions();
        String serviceName = XMPPUtils.getServiceName(targetAddress);
        if (targetAddress != null) {
            xmppOutTransportInfo = new XMPPOutTransportInfo(targetAddress);
            xmppOutTransportInfo.setConnectionFactory(this.connectionFactory);
        } else if ((msgCtx.getTo() == null || msgCtx.getTo().hasAnonymousAddress()) && msgCtx.isServerSide()) {
            xmppOutTransportInfo = (XMPPOutTransportInfo)msgCtx.getProperty("OutTransportInfo");
        }
        if (msgCtx.isServerSide()) {
            xmppConnection = xmppOutTransportInfo.getConnectionFactory().getXmppConnection();
            message.setProperty("isServerSide", (Object)new Boolean(false));
            message.setProperty("inReplyTo", (Object)xmppOutTransportInfo.getInReplyTo());
        } else {
            xmppConnection = xmppOutTransportInfo.getConnectionFactory().getXmppConnection();
            message.setProperty("isServerSide", (Object)new Boolean(true));
            message.setProperty("ServiceName", (Object)serviceName);
            message.setProperty("Action", (Object)options.getAction());
        }
        if (xmppConnection == null) {
            this.handleException("Connection to XMPP Server is not established.");
        }
        ChatManager chatManager = xmppConnection.getChatManager();
        Chat chat = chatManager.createChat(xmppOutTransportInfo.getDestinationAccount(), null);
        try {
            OMElement msgElement = msgCtx.getEnvelope();
            if (msgCtx.isDoingREST()) {
                msgElement = msgCtx.getEnvelope().getBody().getFirstElement();
            }
            boolean waitForResponse = msgCtx.getOperationContext() != null && "http://www.w3.org/ns/wsdl/out-in".equals(msgCtx.getOperationContext().getAxisOperation().getMessageExchangePattern());
            String soapMessage = ((Object)msgElement).toString();
            message.setBody(soapMessage);
            XMPPClientSidePacketListener xmppClientSidePacketListener = null;
            if (waitForResponse && !msgCtx.isServerSide()) {
                PacketTypeFilter filter = new PacketTypeFilter(message.getClass());
                xmppClientSidePacketListener = new XMPPClientSidePacketListener(msgCtx);
                xmppConnection.addPacketListener((PacketListener)xmppClientSidePacketListener, (PacketFilter)filter);
            }
            chat.sendMessage(message);
            this.log.debug("Sent message :" + message.toXML());
            if (waitForResponse && !msgCtx.isServerSide()) {
                while (!xmppClientSidePacketListener.isResponseReceived()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this.log.debug("Sleep interrupted", e);
                    }
                }
                xmppConnection.disconnect();
            }
        }
        catch (XMPPException e) {
            this.log.error("Error occurred while sending the message : " + message.toXML(), e);
            this.handleException("Error occurred while sending the message : " + message.toXML(), (Exception)((Object)e));
        }
        finally {
            if (!msgCtx.isServerSide()) {
                xmppConnection.disconnect();
            }
        }
    }

    private void getConnectionDetailsFromAxisConfiguration(XMPPServerCredentials serverCredentials, TransportOutDescription transportOut) {
        if (transportOut != null) {
            Parameter serverType;
            Parameter password;
            Parameter userName;
            Parameter serverUrl = transportOut.getParameter("transport.xmpp.ServerUrl");
            if (serverUrl != null) {
                serverCredentials.setServerUrl(Utils.getParameterValue(serverUrl));
            }
            if ((userName = transportOut.getParameter("transport.xmpp.ServerAccountUserName")) != null) {
                serverCredentials.setAccountName(Utils.getParameterValue(userName));
            }
            if ((password = transportOut.getParameter("transport.xmpp.ServerAccountPassword")) != null) {
                serverCredentials.setPassword(Utils.getParameterValue(password));
            }
            if ((serverType = transportOut.getParameter("transport.xmpp.ServerType")) != null) {
                serverCredentials.setServerType(Utils.getParameterValue(serverType));
            }
        }
    }

    private void getConnectionDetailsFromClientOptions(XMPPServerCredentials serverCredentials, MessageContext msgContext) {
        Options clientOptions = msgContext.getOptions();
        if (clientOptions.getProperty("transport.xmpp.ServerAccountUserName") != null) {
            serverCredentials.setAccountName((String)clientOptions.getProperty("transport.xmpp.ServerAccountUserName"));
        }
        if (clientOptions.getProperty("transport.xmpp.ServerAccountPassword") != null) {
            serverCredentials.setPassword((String)clientOptions.getProperty("transport.xmpp.ServerAccountPassword"));
        }
        if (clientOptions.getProperty("transport.xmpp.ServerUrl") != null) {
            serverCredentials.setServerUrl((String)clientOptions.getProperty("transport.xmpp.ServerUrl"));
        }
        if (clientOptions.getProperty("transport.xmpp.ServerType") != null) {
            serverCredentials.setServerType((String)clientOptions.getProperty("transport.xmpp.ServerType"));
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        this.log.error(msg, e);
        throw new AxisFault(msg, e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error(msg);
        throw new AxisFault(msg);
    }
}

