/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSToolingUtils {
    private static final Log log = LogFactory.getLog(WSToolingUtils.class);

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static String getWsGenVersion() throws ClassNotFoundException, IOException {
        Class clazz = null;
        try {
            clazz = WSToolingUtils.forName("com.sun.tools.ws.WsGen", false, WSToolingUtils.getContextClassLoader(null));
        }
        catch (ClassNotFoundException e1) {
            try {
                clazz = WSToolingUtils.forName("com.sun.tools.internal.ws.WsGen", false, WSToolingUtils.getContextClassLoader(null));
            }
            catch (ClassNotFoundException e2) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception thrown from getWsGenVersion: " + e2.getMessage(), e2);
                }
                throw (ClassNotFoundException)e2.getException();
            }
        }
        Properties p = new Properties();
        try {
            p.load(clazz.getResourceAsStream("version.properties"));
        }
        catch (IOException ioex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from getWsGenVersion: " + ioex.getMessage(), ioex);
            }
            throw (IOException)ioex.getCause();
        }
        return p.getProperty("major-version");
    }

    private static ClassLoader getContextClassLoader(final ClassLoader classLoader) {
        ClassLoader cl;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e.getMessage(), e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e.getMessage(), e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public static boolean isValidVersion(String wsGenVersion) {
        int dotIndex;
        if (log.isDebugEnabled()) {
            log.debug("isValidVersion: Determining if WsGen version: " + wsGenVersion + " is appropriate version for using new SUN RI behavior");
        }
        int VERSION_FIELD_1 = 2;
        boolean VERSION_FIELD_2 = true;
        int VERSION_FIELD_3 = 6;
        String version = wsGenVersion.trim();
        int subField = Integer.valueOf(version.substring(0, dotIndex = version.indexOf(".")));
        if (subField < 2) {
            return false;
        }
        if (subField > 2) {
            return true;
        }
        String subString2 = version.substring(dotIndex + 1);
        subField = Integer.valueOf(subString2.substring(0, dotIndex = subString2.indexOf(".")));
        if (subField < 1) {
            return false;
        }
        if (subField > 1) {
            return true;
        }
        String subString3 = subString2.substring(dotIndex + 1);
        subField = (dotIndex = subString3.indexOf(".")) == -1 ? Integer.valueOf(subString3).intValue() : Integer.valueOf(subString3.substring(0, dotIndex)).intValue();
        return subField >= 6;
    }
}

