/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.util.Map;
import java.util.TreeSet;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.utility.PropertyDescriptorPlus;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalServiceRuntimeDescriptionImpl
implements MarshalServiceRuntimeDescription {
    private ServiceDescription serviceDesc;
    private String key;
    private TreeSet<String> packages;
    private String packagesKey;
    private Map<String, AnnotationDesc> annotationMap = null;
    private Map<Class, Map<String, PropertyDescriptorPlus>> pdMapCache = null;
    private Map<OperationDescription, String> requestWrapperMap = null;
    private Map<OperationDescription, String> responseWrapperMap = null;
    private Map<FaultDescription, FaultBeanDesc> faultBeanDescMap = null;
    private MessageFactory messageFactory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);

    protected MarshalServiceRuntimeDescriptionImpl(String key, ServiceDescription serviceDesc) {
        this.serviceDesc = serviceDesc;
        this.key = key;
    }

    @Override
    public ServiceDescription getServiceDescription() {
        return this.serviceDesc;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public TreeSet<String> getPackages() {
        return this.packages;
    }

    @Override
    public String getPackagesKey() {
        return this.packagesKey;
    }

    void setPackages(TreeSet<String> packages) {
        this.packages = packages;
        this.packagesKey = packages.toString();
    }

    @Override
    public AnnotationDesc getAnnotationDesc(Class cls) {
        String className = cls.getCanonicalName();
        AnnotationDesc aDesc = this.annotationMap.get(className);
        if (aDesc != null) {
            return aDesc;
        }
        aDesc = AnnotationDescImpl.create(cls);
        return aDesc;
    }

    void setAnnotationMap(Map<String, AnnotationDesc> map) {
        this.annotationMap = map;
    }

    @Override
    public Map<String, PropertyDescriptorPlus> getPropertyDescriptorMap(Class cls) {
        Map<String, PropertyDescriptorPlus> pdMap = this.pdMapCache.get(cls);
        if (pdMap != null) {
            return pdMap;
        }
        try {
            pdMap = XMLRootElementUtil.createPropertyDescriptorMap(cls);
        }
        catch (Throwable t) {
            throw ExceptionFactory.makeWebServiceException(t);
        }
        return pdMap;
    }

    void setPropertyDescriptorMapCache(Map<Class, Map<String, PropertyDescriptorPlus>> cache) {
        this.pdMapCache = cache;
    }

    @Override
    public String getRequestWrapperClassName(OperationDescription operationDesc) {
        return this.requestWrapperMap.get(operationDesc);
    }

    void setRequestWrapperMap(Map<OperationDescription, String> map) {
        this.requestWrapperMap = map;
    }

    @Override
    public String getResponseWrapperClassName(OperationDescription operationDesc) {
        return this.responseWrapperMap.get(operationDesc);
    }

    void setResponseWrapperMap(Map<OperationDescription, String> map) {
        this.responseWrapperMap = map;
    }

    @Override
    public FaultBeanDesc getFaultBeanDesc(FaultDescription faultDesc) {
        return this.faultBeanDescMap.get(faultDesc);
    }

    void setFaultBeanDescMap(Map<FaultDescription, FaultBeanDesc> map) {
        this.faultBeanDescMap = map;
    }

    public String toString() {
        try {
            String newline = "\n";
            String sameline = " ";
            StringBuffer string = new StringBuffer();
            string.append("\n");
            string.append("  MarshalServiceRuntime:" + this.getKey());
            string.append("\n");
            String pkgs = this.getPackages() == null ? "none" : this.getPackages().toString();
            string.append("    Packages = " + pkgs);
            for (Map.Entry<String, AnnotationDesc> entry : this.annotationMap.entrySet()) {
                string.append("\n");
                string.append("    AnnotationDesc cached for:" + entry.getKey());
                string.append(entry.getValue().toString());
            }
            for (Map.Entry<Object, Object> entry : this.pdMapCache.entrySet()) {
                string.append("\n");
                string.append("    PropertyDescriptorPlus Map cached for:" + ((Class)entry.getKey()).getCanonicalName());
                for (PropertyDescriptorPlus pdp : ((Map)entry.getValue()).values()) {
                    string.append("\n");
                    string.append("      propertyName   =" + pdp.getPropertyName());
                    string.append("\n");
                    string.append("        xmlName      =" + pdp.getXmlName());
                    string.append("\n");
                    string.append("        propertyType =" + pdp.getPropertyType().getCanonicalName());
                    string.append("\n");
                }
            }
            string.append("    RequestWrappers");
            for (Map.Entry<Object, Object> entry : this.requestWrapperMap.entrySet()) {
                string.append("\n");
                string.append("    Operation:" + ((OperationDescription)entry.getKey()).getJavaMethodName() + " RequestWrapper:" + (String)entry.getValue());
            }
            string.append("    ResponseWrappers");
            for (Map.Entry<Object, Object> entry : this.responseWrapperMap.entrySet()) {
                string.append("\n");
                string.append("    Operation:" + ((OperationDescription)entry.getKey()).getJavaMethodName() + " ResponseWrapper:" + (String)entry.getValue());
            }
            string.append("    FaultBeanDesc");
            for (Map.Entry<Object, Object> entry : this.faultBeanDescMap.entrySet()) {
                string.append("\n");
                string.append("    FaultException:" + ((FaultDescription)entry.getKey()).getExceptionClassName());
                string.append("\n");
                string.append(((FaultBeanDesc)entry.getValue()).toString());
            }
            return string.toString();
        }
        catch (Throwable t) {
            return "An error occured while dumping the debug contents of MarshalServiceRuntimeDescriptionImpl:" + t.toString();
        }
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }
}

