/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core.controller.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.InvocationController;
import org.apache.axis2.jaxws.core.controller.InvocationPattern;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationControllerImpl
implements InvocationController {
    private static final Log log = LogFactory.getLog(InvocationControllerImpl.class);

    @Override
    public InvocationContext invoke(InvocationContext ic2) {
        if (log.isDebugEnabled()) {
            log.debug("Invocation pattern: synchronous");
        }
        if (ic2 == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr1"));
        }
        if (ic2.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr2"));
        }
        MessageContext request = ic2.getRequestMessageContext();
        MessageContext response = null;
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.SYNC);
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic2.getHandlers(), HandlerChainProcessor.MEP.REQUEST, false);
        if (success) {
            this.registerUnderstoodHeaders(request, ic2.getHandlers());
            this.prepareRequest(request);
            response = this.doInvoke(request);
            this.prepareResponse(response);
            response.setMEPContext(request.getMEPContext());
            response.setEndpointDescription(request.getEndpointDescription());
            TransportHeadersAdapter.install(response);
            AttachmentsAdapter.install(response);
            SOAPHeadersAdapter.install(response);
            HandlerInvokerUtils.invokeInboundHandlers(response.getMEPContext(), ic2.getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
        } else {
            response = MessageContextUtils.createMinimalResponseMessageContext(request);
            response.setMEPContext(request.getMEPContext());
            response.setMessage(request.getMessage());
        }
        ic2.setResponseMessageContext(response);
        return ic2;
    }

    protected abstract MessageContext doInvoke(MessageContext var1);

    @Override
    public void invokeOneWay(InvocationContext ic2) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Invocation pattern: one-way");
        }
        if (ic2 == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr1"));
        }
        if (ic2.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr2"));
        }
        MessageContext request = ic2.getRequestMessageContext();
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ONEWAY);
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic2.getHandlers(), HandlerChainProcessor.MEP.REQUEST, true);
        if (success) {
            this.prepareRequest(request);
            this.doInvokeOneWay(request);
        } else {
            AxisFault e = request.getCausedByException();
            if (e != null) {
                throw (Exception)((Throwable)e).getCause();
            }
        }
    }

    protected abstract void doInvokeOneWay(MessageContext var1);

    @Override
    public Response invokeAsync(InvocationContext ic2) {
        if (log.isDebugEnabled()) {
            log.debug("Invocation pattern: asynchronous(polling)");
        }
        if (ic2 == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr1"));
        }
        if (ic2.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr2"));
        }
        MessageContext request = ic2.getRequestMessageContext();
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ASYNC_POLLING);
        Response resp = null;
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic2.getHandlers(), HandlerChainProcessor.MEP.REQUEST, false);
        if (success) {
            this.registerUnderstoodHeaders(request, ic2.getHandlers());
            this.prepareRequest(request);
            resp = this.doInvokeAsync(request);
        }
        return resp;
    }

    public abstract Response doInvokeAsync(MessageContext var1);

    @Override
    public Future<?> invokeAsync(InvocationContext ic2, AsyncHandler asyncHandler) {
        ExecutorService es;
        if (log.isDebugEnabled()) {
            log.debug("Invocation pattern: asynchronous(callback)");
        }
        if (ic2 == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr1"));
        }
        if (ic2.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr2"));
        }
        if (ic2.getExecutor() != null && ic2.getExecutor() instanceof ExecutorService && (es = (ExecutorService)ic2.getExecutor()).isShutdown()) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ExecutorShutdown"));
        }
        MessageContext request = ic2.getRequestMessageContext();
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ASYNC_CALLBACK);
        Future<?> future = null;
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic2.getHandlers(), HandlerChainProcessor.MEP.REQUEST, false);
        if (!success) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invokeAsyncErr"));
        }
        this.registerUnderstoodHeaders(request, ic2.getHandlers());
        this.prepareRequest(request);
        future = this.doInvokeAsync(request, asyncHandler);
        return future;
    }

    public abstract Future<?> doInvokeAsync(MessageContext var1, AsyncHandler var2);

    protected abstract void prepareRequest(MessageContext var1);

    protected abstract void prepareResponse(MessageContext var1);

    private void registerUnderstoodHeaders(MessageContext request, List<Handler> handlerList) {
        if (handlerList != null && handlerList.size() > 0) {
            HashSet understoodHeaders = new HashSet();
            for (Handler handler : handlerList) {
                SOAPHandler soapHandler;
                Set headers;
                if (!(handler instanceof SOAPHandler) || (headers = (soapHandler = (SOAPHandler)handler).getHeaders()) == null || headers.size() <= 0) continue;
                understoodHeaders.addAll(headers);
            }
            if (understoodHeaders != null && understoodHeaders.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding understood header QName collection to message context " + understoodHeaders);
                }
                request.setProperty("client.UnderstoodHeaders", understoodHeaders);
            }
        }
    }
}

