/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.listener;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.attachments.utils.BAAInputStream;
import org.apache.axiom.attachments.utils.BAAOutputStream;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.util.CommonUtils;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParsedEntityDataSource
extends OMDataSourceExtBase {
    private static final Log log = LogFactory.getLog(ParsedEntityDataSource.class);
    private Data data = null;
    private static final Behavior defaultBehavior = Behavior.NOT_DESTRUCTIVE;

    public ParsedEntityDataSource(InputStream payload, String encoding) {
        this(payload, encoding, defaultBehavior);
    }

    public ParsedEntityDataSource(InputStream payload, String encoding, Behavior behavior) {
        this.data = new Data(payload, encoding != null ? encoding : "UTF-8", behavior);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug("Entry ParsedEntityDataSource.serialize(OutputStream, OMOutputFormat");
        }
        String encoding = format != null ? format.getCharSetEncoding() : null;
        try {
            if (!this.data.encoding.equalsIgnoreCase(encoding)) {
                byte[] bytes = this.getXMLBytes(encoding);
                output.write(bytes);
            } else {
                InputStream is = this.data.readParsedEntityStream();
                if (is != null) {
                    BufferUtils.inputStream2OutputStream(is, output);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit ParsedEntityDataSource.serialize(OutputStream, OMOutputFormat");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug("Entry ParsedEntityDataSource.serialize(XMLStreamWriter)");
        }
        super.serialize(xmlWriter);
        if (log.isDebugEnabled()) {
            log.debug("Exit ParsedEntityDataSource.serialize(XMLStreamWriter)");
        }
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        InputStream is;
        if (log.isDebugEnabled()) {
            log.debug("Entry ParsedEntityDataSource.getReader()");
        }
        if ((is = this.data.readParsedEntityStream()) == null && log.isDebugEnabled()) {
            log.warn("Parser content has already been read");
        }
        XMLStreamReader reader = StAXUtils.createXMLStreamReader(is, this.data.encoding);
        if (log.isDebugEnabled()) {
            log.debug("Exit ParsedEntityDataSource.getReader()");
        }
        return reader;
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        try {
            return this.data.readParsedEntityStream();
        }
        catch (XMLStreamException e) {
            throw new OMException(e);
        }
    }

    public int numReads() {
        return this.data.numReads;
    }

    public Object getObject() {
        return this.data;
    }

    public boolean isDestructiveRead() {
        return this.data.behavior == Behavior.DESTRUCTIVE;
    }

    public boolean isDestructiveWrite() {
        return this.data.behavior == Behavior.DESTRUCTIVE;
    }

    public byte[] getXMLBytes(String encoding) {
        if (log.isDebugEnabled()) {
            log.debug("Entry ParsedEntityDataSource.getXMLBytes(encoding)");
        }
        try {
            InputStream is = this.data.readParsedEntityStream();
            if (is != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OMOutputFormat format = new OMOutputFormat();
                format.setCharSetEncoding(encoding);
                try {
                    BufferUtils.inputStream2OutputStream(is, baos);
                    if (log.isDebugEnabled()) {
                        log.debug("Exit ParsedEntityDataSource.getXMLBytes(encoding)");
                    }
                    return baos.toByteArray();
                }
                catch (IOException e) {
                    throw new OMException(e);
                }
            }
            if (log.isDebugEnabled()) {
                log.warn("Parser was already read, recovering by just returning new byte[0]");
                log.debug("Exit ParsedEntityDataSource.getXMLBytes(encoding)");
            }
            return new byte[0];
        }
        catch (XMLStreamException e) {
            throw new OMException(e);
        }
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("Entry ParsedEntityDataSource.close()");
        }
        if (this.data.payload != null) {
            try {
                this.data.payload.close();
            }
            catch (IOException e) {
                throw new OMException(e);
            }
            this.data.payload = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit ParsedEntityDataSource.close()");
        }
    }

    public OMDataSourceExt copy() {
        if (log.isDebugEnabled()) {
            log.debug("Enter ParsedEntityDataSource.copy()");
        }
        try {
            BAAOutputStream baaos = new BAAOutputStream();
            BufferUtils.inputStream2OutputStream(this.data.readParsedEntityStream(), baaos);
            BAAInputStream baais = new BAAInputStream(baaos.buffers(), baaos.length());
            if (log.isDebugEnabled()) {
                log.debug("Exit ParsedEntityDataSource.copy()");
            }
            return new ParsedEntityDataSource(baais, this.data.encoding, this.data.behavior);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("Error ParsedEntityDataSource.copy(): ", t);
            }
            throw new OMException(t);
        }
    }

    public class Data {
        private InputStream payload = null;
        private String encoding = null;
        private Behavior behavior;
        private int numReads = 0;
        private String firstUseStack = null;

        private Data(InputStream payload, String encoding, Behavior behavior) {
            this.payload = payload;
            this.encoding = encoding;
            this.behavior = behavior;
            this.setInputStream(payload);
        }

        public InputStream readParsedEntityStream() throws XMLStreamException {
            ++this.numReads;
            if (log.isDebugEnabled()) {
                log.debug("Entry readParsedEntityStream()");
                log.debug("Data Encoding = " + this.encoding);
                log.debug("numReads = " + this.numReads);
                log.debug("behavior = " + (Object)((Object)this.behavior));
                String stack = CommonUtils.stackToString(new OMException());
                log.debug("call stack:" + stack);
            }
            if (this.payload == null) {
                throw new OMException("ParsedEntityDataSource's InputStream is null.");
            }
            if (this.behavior == Behavior.NOT_DESTRUCTIVE) {
                if (this.numReads > 1) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("reset InputStream for reuse");
                        }
                        this.payload.reset();
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            } else if (this.behavior == Behavior.ONE_USE_UNSAFE) {
                if (this.numReads == 1) {
                    this.firstUseStack = CommonUtils.stackToString(new OMException());
                    if (log.isDebugEnabled()) {
                        log.debug("ONE_USE_UNSAFE mode stack:" + this.firstUseStack);
                    }
                } else {
                    OMException ome = new OMException("A second read of ParsedEntityDataSource is not allowed.The first read was done here: " + this.firstUseStack);
                    if (log.isDebugEnabled()) {
                        log.debug("ONE_USE_UNSAFE second use exception:" + ome);
                    }
                    throw ome;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit readParsedEntityStream()");
            }
            return this.payload;
        }

        public void setInputStream(InputStream inputStream) {
            if (log.isDebugEnabled()) {
                String clsName = inputStream == null ? null : inputStream.getClass().getCanonicalName();
                log.debug("Enter setInputStream: The kind of InputStream is:" + clsName);
            }
            this.numReads = 0;
            this.firstUseStack = null;
            if (inputStream == null) {
                if (log.isDebugEnabled()) {
                    log.debug("The inputStream is null");
                }
                this.payload = null;
            } else if (this.behavior == Behavior.NOT_DESTRUCTIVE) {
                if (inputStream.markSupported()) {
                    if (log.isDebugEnabled()) {
                        log.debug("The inputStream supports mark().  Setting mark()");
                    }
                    this.payload = inputStream;
                    this.payload.mark(Integer.MAX_VALUE);
                } else {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("The inputStream does not supports mark().  Copying Stream");
                        }
                        BAAOutputStream baaos = new BAAOutputStream();
                        BufferUtils.inputStream2OutputStream(inputStream, baaos);
                        BAAInputStream baais = new BAAInputStream(baaos.buffers(), baaos.length());
                        this.payload = baais;
                        this.payload.mark(Integer.MAX_VALUE);
                    }
                    catch (Throwable t) {
                        if (log.isDebugEnabled()) {
                            log.debug("Error:", t);
                        }
                        throw new OMException(t);
                    }
                }
            } else {
                this.payload = inputStream;
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit setInputStream");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Behavior {
        DESTRUCTIVE,
        NOT_DESTRUCTIVE,
        ONE_USE_UNSAFE;

    }
}

