/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.listener;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.jaxws.context.listener.ContextListenerUtils;
import org.apache.axis2.jaxws.context.listener.ParsedEntityDataSource;
import org.apache.axis2.jaxws.message.databinding.ParsedEntityReader;
import org.apache.axis2.jaxws.message.factory.ParsedEntityReaderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParsedEntityCustomBuilder
implements CustomBuilder {
    private static final Log log = LogFactory.getLog(ParsedEntityCustomBuilder.class);
    private String encoding = null;

    public ParsedEntityCustomBuilder(String encoding) {
        this.encoding = encoding == null ? "utf-8" : encoding;
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug("create namespace = " + namespace);
            log.debug("  localPart = " + localPart);
            log.debug("  reader = " + reader.getClass());
        }
        try {
            ParsedEntityReaderFactory perf = (ParsedEntityReaderFactory)FactoryRegistry.getFactory(ParsedEntityReaderFactory.class);
            ParsedEntityReader entityReader = perf.getParsedEntityReader();
            if (!entityReader.isParsedEntityStreamAvailable()) {
                return null;
            }
            InputStream parsedStream = this.getPayloadContent(reader, entityReader);
            if (parsedStream == null) {
                return null;
            }
            if (reader.hasNext()) {
                reader.next();
            }
            if (namespace == null && (namespace = reader.getNamespaceURI()) == null) {
                namespace = "";
            }
            OMNamespace ns = factory.createOMNamespace(namespace, reader.getPrefix());
            InputStream payload = ContextListenerUtils.createPayloadElement(parsedStream, ns, localPart, parent);
            ParsedEntityDataSource ds2 = new ParsedEntityDataSource(payload, this.encoding);
            OMSourcedElement om = null;
            om = parent instanceof SOAPHeader && factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock(localPart, ns, ds2) : factory.createOMElement(ds2, localPart, ns);
            parent.addChild(om);
            return om;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory, InputStream payload) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug("create namespace = " + namespace);
            log.debug("  localPart = " + localPart);
            log.debug("  reader = " + reader.getClass());
        }
        try {
            if (namespace == null && (namespace = reader.getNamespaceURI()) == null) {
                namespace = "";
            }
            OMNamespace ns = factory.createOMNamespace(namespace, reader.getPrefix());
            ParsedEntityDataSource ds2 = new ParsedEntityDataSource(payload, this.encoding);
            OMSourcedElement om = null;
            om = parent instanceof SOAPHeader && factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock(localPart, ns, ds2) : factory.createOMElement(ds2, localPart, ns);
            parent.addChild(om);
            return om;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }

    private InputStream getPayloadContent(XMLStreamReader parser, ParsedEntityReader entityReader) {
        int event = parser.getEventType();
        if (log.isDebugEnabled()) {
            log.debug("checking if event is START_ELEMENT");
        }
        InputStream parsedStream = null;
        if (event == 1) {
            if (log.isDebugEnabled()) {
                log.debug("event is START_ELEMENT");
            }
            if ((parsedStream = entityReader.readParsedEntityStream(parser)) != null && log.isDebugEnabled()) {
                log.debug("Read Parsed EntityStream");
            }
        }
        return parsedStream;
    }
}

