/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.dispatch;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.jaxws.BindingProvider;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.InvocationController;
import org.apache.axis2.jaxws.core.controller.InvocationControllerFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDispatch<T>
extends BindingProvider
implements Dispatch {
    private static Log log = LogFactory.getLog(BaseDispatch.class);
    protected InvocationController ic;
    protected ServiceClient serviceClient;
    protected Service.Mode mode;

    protected BaseDispatch(ServiceDelegate svcDelgate, EndpointDescription epDesc, EndpointReference epr, String addressingNamespace, WebServiceFeature ... features) {
        super(svcDelgate, epDesc, epr, addressingNamespace, features);
        InvocationControllerFactory icf = (InvocationControllerFactory)FactoryRegistry.getFactory(InvocationControllerFactory.class);
        this.ic = icf.getInvocationController();
        if (this.ic == null) {
            throw new WebServiceException(Messages.getMessage("missingInvocationController"));
        }
    }

    protected abstract Message createMessageFromValue(Object var1);

    protected abstract Object getValueFromMessage(Message var1);

    protected abstract AsyncResponse createAsyncResponseListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object obj) throws WebServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Entered synchronous invocation: BaseDispatch.invoke()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.BindingProvider", this);
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            Binding binding = (Binding)this.getBinding();
            invocationContext.setHandlers(binding.getHandlerChain());
            this.initMessageContext(obj, requestMsgCtx);
            if (this.requestContext.containsKey("javax.xml.ws.session.maintain") && ((Boolean)this.requestContext.get("javax.xml.ws.session.maintain")).booleanValue() && this.requestContext.containsKey("Cookie") && this.requestContext.get("Cookie") != null && invocationContext.getServiceClient().getServiceContext().getProperty("Cookie") == null) {
                invocationContext.getServiceClient().getServiceContext().setProperty("Cookie", this.requestContext.get("Cookie"));
                if (log.isDebugEnabled()) {
                    log.debug("Client-app defined Cookie property (assume to be session cookie) on request context copied to service context.  Caution:  server may or may not support sessions, but client app will not be informed when not supported.");
                }
            }
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            binding.configure(requestMsgCtx, this);
            this.ic.invoke(invocationContext);
            MessageContext responseMsgCtx = invocationContext.getResponseMessageContext();
            responseMsgCtx.setEndpointDescription(requestMsgCtx.getEndpointDescription());
            ApplicationContextMigratorUtil.performMigrationFromMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getResponseContext(), responseMsgCtx);
            if (this.hasFaultResponse(responseMsgCtx)) {
                WebServiceException wse = BaseDispatch.getFaultResponse(responseMsgCtx);
                throw wse;
            }
            Object returnObj = null;
            try {
                Message responseMsg = responseMsgCtx.getMessage();
                returnObj = this.getValueFromMessage(responseMsg);
            }
            finally {
                try {
                    responseMsgCtx.freeInputStream();
                }
                catch (Throwable t) {
                    throw ExceptionFactory.makeWebServiceException(t);
                }
            }
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (log.isDebugEnabled()) {
                log.debug("Synchronous invocation completed: BaseDispatch.invoke()");
            }
            return returnObj;
        }
        catch (WebServiceException e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invoke(): Synchronous invocation failed, caught a WebServiceException: " + e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invoke(): Synchronous invocation failed, caught an Exception, wrapping into a WebServiceException. Exception caught: " + e.toString());
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    protected void initMessageContext(Object obj, MessageContext requestMsgCtx) {
        Message requestMsg = this.createRequestMessage(obj);
        this.setupMessageProperties(requestMsg);
        requestMsgCtx.setMessage(requestMsg);
        String method = (String)this.requestContext.get("javax.xml.ws.http.request.method");
        if (method != null) {
            requestMsgCtx.setProperty("HTTP_METHOD", method);
        }
    }

    public void invokeOneWay(Object obj) throws WebServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Entered one-way invocation: BaseDispatch.invokeOneWay()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.BindingProvider", this);
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            Binding binding = (Binding)this.getBinding();
            invocationContext.setHandlers(binding.getHandlerChain());
            this.initMessageContext(obj, requestMsgCtx);
            if (this.requestContext.containsKey("javax.xml.ws.session.maintain") && ((Boolean)this.requestContext.get("javax.xml.ws.session.maintain")).booleanValue() && this.requestContext.containsKey("Cookie") && this.requestContext.get("Cookie") != null && invocationContext.getServiceClient().getServiceContext().getProperty("Cookie") == null) {
                invocationContext.getServiceClient().getServiceContext().setProperty("Cookie", this.requestContext.get("Cookie"));
                if (log.isDebugEnabled()) {
                    log.debug("Client-app defined Cookie property (assume to be session cookie) on request context copied to service context.  Caution:  server may or may not support sessions, but client app will not be informed when not supported.");
                }
            }
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            binding.configure(requestMsgCtx, this);
            this.ic.invokeOneWay(invocationContext);
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (log.isDebugEnabled()) {
                log.debug("One-way invocation completed: BaseDispatch.invokeOneWay()");
            }
            return;
        }
        catch (WebServiceException e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invokeOneWay(): One-way invocation failed, caught a WebServiceException: " + e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invokeOneWay(): One-way invocation failed, caught an Exception, wrapping into a WebServicesException.  Exception caught: " + e.toString());
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Future<?> invokeAsync(Object obj, AsyncHandler asynchandler) throws WebServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Entered asynchronous (callback) invocation: BaseDispatch.invokeAsync()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.BindingProvider", this);
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            Binding binding = (Binding)this.getBinding();
            invocationContext.setHandlers(binding.getHandlerChain());
            this.initMessageContext(obj, requestMsgCtx);
            if (this.requestContext.containsKey("javax.xml.ws.session.maintain") && ((Boolean)this.requestContext.get("javax.xml.ws.session.maintain")).booleanValue() && this.requestContext.containsKey("Cookie") && this.requestContext.get("Cookie") != null && invocationContext.getServiceClient().getServiceContext().getProperty("Cookie") == null) {
                invocationContext.getServiceClient().getServiceContext().setProperty("Cookie", this.requestContext.get("Cookie"));
                if (log.isDebugEnabled()) {
                    log.debug("Client-app defined Cookie property (assume to be session cookie) on request context copied to service context.  Caution:  server may or may not support sessions, but client app will not be informed when not supported.");
                }
            }
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            binding.configure(requestMsgCtx, this);
            Executor e = this.serviceDelegate.getExecutor();
            invocationContext.setExecutor(e);
            AsyncResponse listener = this.createAsyncResponseListener();
            invocationContext.setAsyncResponseListener(listener);
            Future<?> asyncResponse = this.ic.invokeAsync(invocationContext, asynchandler);
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (log.isDebugEnabled()) {
                log.debug("Asynchronous (callback) invocation sent: BaseDispatch.invokeAsync()");
            }
            return asyncResponse;
        }
        catch (WebServiceException e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invokeAsync() [Callback]: Asynchronous invocation failed, caught a WebServiceException: " + e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invokeAsync() [Callback]: Asynchronous invocation failed, caught an Exception, wrapping into a WebServiceException. Exception caught: " + e.toString());
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Response invokeAsync(Object obj) throws WebServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Entered asynchronous (polling) invocation: BaseDispatch.invokeAsync()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.BindingProvider", this);
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            Binding binding = (Binding)this.getBinding();
            invocationContext.setHandlers(binding.getHandlerChain());
            this.initMessageContext(obj, requestMsgCtx);
            if (this.requestContext.containsKey("javax.xml.ws.session.maintain") && ((Boolean)this.requestContext.get("javax.xml.ws.session.maintain")).booleanValue() && this.requestContext.containsKey("Cookie") && this.requestContext.get("Cookie") != null && invocationContext.getServiceClient().getServiceContext().getProperty("Cookie") == null) {
                invocationContext.getServiceClient().getServiceContext().setProperty("Cookie", this.requestContext.get("Cookie"));
                if (log.isDebugEnabled()) {
                    log.debug("Client-app defined Cookie property (assume to be session cookie) on request context copied to service context.  Caution:  server may or may not support sessions, but client app will not be informed when not supported.");
                }
            }
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            binding.configure(requestMsgCtx, this);
            Executor e = this.serviceDelegate.getExecutor();
            invocationContext.setExecutor(e);
            AsyncResponse listener = this.createAsyncResponseListener();
            invocationContext.setAsyncResponseListener(listener);
            Response asyncResponse = this.ic.invokeAsync(invocationContext);
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (log.isDebugEnabled()) {
                log.debug("Asynchronous (polling) invocation sent: BaseDispatch.invokeAsync()");
            }
            return asyncResponse;
        }
        catch (WebServiceException e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invokeAsync() [Polling]: Asynchronous invocation failed, caught a WebServiceException: " + e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("BaseDispatch.invokeAsync() [Polling]: Asynchronous invocation failed, caught an Exception, wrapping into a WebServiceException. Exception caught: " + e.toString());
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public void setServiceClient(ServiceClient sc) {
        this.serviceClient = sc;
    }

    public Service.Mode getMode() {
        return this.mode;
    }

    public void setMode(Service.Mode m) {
        this.mode = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServiceException getFaultResponse(MessageContext msgCtx) {
        try {
            Message msg = msgCtx.getMessage();
            if (msg != null && msg.isFault()) {
                ProtocolException pe;
                ProtocolException protocolException = pe = MethodMarshallerUtils.createSystemException(msg.getXMLFault(), msg);
                return protocolException;
            }
            if (msgCtx.getLocalException() != null) {
                WebServiceException webServiceException = ExceptionFactory.makeWebServiceException(msgCtx.getLocalException());
                return webServiceException;
            }
        }
        finally {
            try {
                msgCtx.freeInputStream();
            }
            catch (IOException ioe) {
                return ExceptionFactory.makeWebServiceException(ioe);
            }
        }
        return null;
    }

    public boolean hasFaultResponse(MessageContext msgCtx) {
        if (msgCtx.getMessage() != null && msgCtx.getMessage().isFault()) {
            return true;
        }
        return msgCtx.getLocalException() != null;
    }

    private void setupMessageProperties(Message msg) {
        SOAPBinding soapBinding;
        Binding binding = (Binding)this.getBinding();
        if (binding != null && binding instanceof SOAPBinding && (soapBinding = (SOAPBinding)binding).isMTOMEnabled()) {
            msg.setMTOMEnabled(true);
        }
    }

    private boolean isValidInvocationParam(Object object) {
        DOMSource ds2;
        String bindingId = this.endpointDesc.getClientBindingID();
        if (bindingId == null) {
            bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (!bindingId.equals("http://www.w3.org/2004/08/wsdl/http")) {
            if (this.mode.equals((Object)Service.Mode.MESSAGE) && object == null) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchNullParamMessageMode"));
            }
        } else if (object == null && this.isPOSTorPUTRequest()) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchNullParamHttpBinding"));
        }
        if (object instanceof DOMSource && (ds2 = (DOMSource)object).getNode() == null && ds2.getSystemId() == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchBadDOMSource"));
        }
        return true;
    }

    private boolean isPOSTorPUTRequest() {
        String method = (String)this.requestContext.get("javax.xml.ws.http.request.method");
        return method == null || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method);
    }

    private Message createRequestMessage(Object obj) throws WebServiceException {
        if (!this.isValidInvocationParam(obj)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchInvalidParam"));
        }
        Message requestMsg = null;
        try {
            requestMsg = this.createMessageFromValue(obj);
        }
        catch (Throwable t) {
            throw ExceptionFactory.makeWebServiceException(t);
        }
        return requestMsg;
    }
}

