/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListenerManager {
    private static final Log log = LogFactory.getLog(ListenerManager.class);
    public static ConfigurationContext defaultConfigurationContext;
    private ConfigurationContext configctx;
    private HashMap startedTransports = new HashMap();
    private boolean stopped;

    public static ListenerManager getDefaultListenerManager() {
        if (defaultConfigurationContext == null) {
            return null;
        }
        return defaultConfigurationContext.getListenerManager();
    }

    public void init(ConfigurationContext configCtx) {
        configCtx.setTransportManager(this);
        this.configctx = configCtx;
    }

    public ConfigurationContext getConfigctx() {
        return this.configctx;
    }

    public synchronized EndpointReference getEPRforService(String serviceName, String opName, String transportName) throws AxisFault {
        if (transportName == null || "".equals(transportName)) {
            AxisService service = this.configctx.getAxisConfiguration().getService(serviceName);
            if (service == null) {
                throw new AxisFault(Messages.getMessage("servicenotfoundinthesystem", serviceName));
            }
            if (service.isEnableAllTransports()) {
                for (TransportListener transportListener : this.startedTransports.values()) {
                    EndpointReference[] epRsForService = transportListener.getEPRsForService(serviceName, null);
                    if (epRsForService == null) continue;
                    return epRsForService[0];
                }
                return null;
            }
            List exposeTransport = service.getExposedTransports();
            TransportListener listener = (TransportListener)this.startedTransports.get(exposeTransport.get(0));
            EndpointReference[] eprsForService = listener.getEPRsForService(serviceName, null);
            return eprsForService != null ? eprsForService[0] : null;
        }
        TransportInDescription trsIN = this.configctx.getAxisConfiguration().getTransportIn(transportName);
        TransportListener listener = trsIN.getReceiver();
        EndpointReference[] eprsForService = listener.getEPRsForService(serviceName, null);
        return eprsForService != null ? eprsForService[0] : null;
    }

    public synchronized void start() {
        Iterator transportNames = this.configctx.getAxisConfiguration().getTransportsIn().values().iterator();
        while (transportNames.hasNext()) {
            try {
                TransportInDescription transportIn = (TransportInDescription)transportNames.next();
                TransportListener listener = transportIn.getReceiver();
                if (listener == null || this.startedTransports.get(transportIn.getName()) != null) continue;
                listener.init(this.configctx, transportIn);
                listener.start();
                if (this.startedTransports.get(transportIn.getName()) != null) continue;
                this.startedTransports.put(transportIn.getName(), listener);
            }
            catch (Exception e) {
                log.info(e.getMessage(), e);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ListenerManagerShutdownThread(this));
    }

    public synchronized void startSystem(ConfigurationContext configurationContext) {
        this.init(configurationContext);
        this.start();
    }

    public synchronized void stop() throws AxisFault {
        HashMap transportOut;
        if (this.stopped) {
            return;
        }
        for (TransportListener transportListener : this.startedTransports.values()) {
            transportListener.stop();
        }
        if (log.isDebugEnabled()) {
            log.debug("Start invoke transport sender shutdown.");
        }
        if ((transportOut = this.configctx.getAxisConfiguration().getTransportsOut()).size() > 0) {
            for (TransportOutDescription outDescription : transportOut.values()) {
                TransportSender trsSededer = outDescription.getSender();
                if (trsSededer == null) continue;
                trsSededer.stop();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("End Invoke transport sender shutdown.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Start Invoke modules and services shutdown.");
        }
        this.configctx.shutdownModulesAndServices();
        if (log.isDebugEnabled()) {
            log.debug("End Invoke modules and services shutdown.");
        }
        this.stopped = true;
    }

    public synchronized void addListener(TransportInDescription trsIn, boolean started) throws AxisFault {
        this.configctx.getAxisConfiguration().addTransportIn(trsIn);
        TransportListener transportListener = trsIn.getReceiver();
        if (transportListener != null) {
            if (!started) {
                transportListener.init(this.configctx, trsIn);
                transportListener.start();
            }
            this.startedTransports.put(trsIn.getName(), transportListener);
        }
    }

    public synchronized boolean isListenerRunning(String transportName) {
        return this.startedTransports.get(transportName) != null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void destroy() throws AxisFault {
        this.stop();
        this.configctx.setTransportManager(null);
        for (TransportListener transportListener : this.startedTransports.values()) {
            transportListener.destroy();
        }
        this.startedTransports.clear();
        this.configctx = null;
        defaultConfigurationContext = null;
    }

    static class ListenerManagerShutdownThread
    extends Thread {
        ListenerManager listenerManager;

        public ListenerManagerShutdownThread(ListenerManager listenerManager) {
            this.listenerManager = listenerManager;
        }

        public void run() {
            try {
                if (!this.listenerManager.stopped) {
                    this.listenerManager.stop();
                }
            }
            catch (AxisFault axisFault) {
                log.error(axisFault.getMessage(), axisFault);
            }
        }
    }
}

