/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPLocationBasedDispatcher
extends AbstractDispatcher {
    public static final String NAME = "HTTPLocationBasedDispatcher";
    private static final Log log = LogFactory.getLog(HTTPLocationBasedDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        AxisService axisService = messageContext.getAxisService();
        if (axisService != null && messageContext.getTo() != null) {
            String uri = messageContext.getTo().getAddress();
            String httpLocation = this.parseRequestURL(uri, messageContext.getConfigurationContext().getServiceContextPath());
            String httpMethod = (String)messageContext.getProperty("HTTP_METHOD_OBJECT");
            if (httpLocation != null) {
                Map httpLocationTable;
                httpLocation = httpMethod + httpLocation;
                AxisEndpoint axisEndpoint = (AxisEndpoint)messageContext.getProperty("endpoint");
                if (axisEndpoint != null && (httpLocationTable = (Map)axisEndpoint.getBinding().getProperty("HTTPLocationTable")) != null) {
                    return this.getOperationFromHTTPLocation(httpLocation, httpLocationTable);
                }
            } else {
                log.debug("Attempt to check for Operation using HTTP Location failed");
                return null;
            }
        }
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    private String parseRequestURL(String path, String servicePath) {
        int index = path.lastIndexOf(servicePath);
        String service = null;
        if (-1 != index) {
            int serviceStart = index + servicePath.length();
            if (path.length() > serviceStart + 1) {
                service = path.substring(serviceStart + 1);
            }
        }
        if (service != null) {
            index = service.indexOf("/");
            if (-1 != index) {
                service = service.substring(index);
            } else {
                int queryIndex = service.indexOf("?");
                if (queryIndex != -1) {
                    service = service.substring(queryIndex);
                }
            }
        }
        return service;
    }

    private AxisOperation getOperationFromHTTPLocation(String requestPath, Map httpLocationTable) {
        Set httpLocations = httpLocationTable.keySet();
        for (String location : httpLocations) {
            int index = requestPath.indexOf(location);
            if (index != 0) continue;
            return (AxisOperation)httpLocationTable.get(location);
        }
        return null;
    }
}

