/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.ws.commons.schema.XmlSchema;

public class AxisService2WSDL11
implements Java2WSDLConstants {
    private AxisService axisService;
    private String serviceName;
    private String[] serviceEndpointURLs;
    private String targetNamespace;
    private OMElement definition;
    private OMNamespace soap;
    private OMNamespace soap12;
    private OMNamespace http;
    private OMNamespace mime;
    private OMNamespace tns;
    private OMNamespace wsdl;
    private OMNamespace wsaw;
    private String style = "document";
    private String use = "literal";
    private HashMap policiesInDefinitions;
    private ExternalPolicySerializer serializer;
    private HashMap messagesMap;

    public AxisService2WSDL11(AxisService service) throws Exception {
        this.axisService = service;
        this.serviceName = service.getName();
        this.init();
    }

    private void init() throws AxisFault {
        this.serviceEndpointURLs = this.axisService.getEPRs();
        if (this.serviceEndpointURLs == null) {
            Map endpointMap = this.axisService.getEndpoints();
            if (endpointMap.size() > 0) {
                Iterator endpointItr = endpointMap.values().iterator();
                if (endpointItr.hasNext()) {
                    AxisEndpoint endpoint = (AxisEndpoint)endpointItr.next();
                    this.serviceEndpointURLs = new String[]{endpoint.getEndpointURL()};
                }
            } else {
                this.serviceEndpointURLs = new String[]{this.axisService.getEndpointName()};
            }
        }
        this.targetNamespace = this.axisService.getTargetNamespace();
        this.serializer = new ExternalPolicySerializer();
        AxisConfiguration configuration = this.axisService.getAxisConfiguration();
        if (configuration != null) {
            this.serializer.setAssertionsToFilter(configuration.getLocalPolicyAssertions());
        }
    }

    public AxisService2WSDL11(AxisService service, String serviceName) throws Exception {
        this.axisService = service;
        this.serviceName = serviceName;
        this.init();
    }

    public OMElement generateOM() throws Exception {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        this.wsdl = fac.createOMNamespace("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        OMElement ele = fac.createOMElement("definitions", this.wsdl);
        this.setDefinitionElement(ele);
        this.policiesInDefinitions = new HashMap();
        HashMap<String, String> namespaceMap = this.axisService.getNamespaceMap();
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, String>();
        }
        WSDLSerializationUtil.populateNamespaces(ele, namespaceMap);
        this.soap = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.soap12 = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        this.http = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/http/", "http");
        this.mime = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        this.wsaw = ele.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        String prefix = WSDLSerializationUtil.getPrefix(this.axisService.getTargetNamespace(), namespaceMap);
        if (prefix == null || "".equals(prefix)) {
            prefix = "axis2";
        }
        namespaceMap.put(prefix, this.axisService.getTargetNamespace());
        this.tns = ele.declareNamespace(this.axisService.getTargetNamespace(), prefix);
        boolean disableREST = false;
        Parameter disableRESTParameter = this.axisService.getParameter("disableREST");
        if (disableRESTParameter != null && JavaUtils.isTrueExplicitly(disableRESTParameter.getValue())) {
            disableREST = true;
        }
        boolean disableSOAP11 = false;
        Parameter disableSOAP11Parameter = this.axisService.getParameter("disableSOAP11");
        if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP11Parameter.getValue())) {
            disableSOAP11 = true;
        }
        boolean disableSOAP12 = false;
        Parameter disableSOAP12Parameter = this.axisService.getParameter("disableSOAP12");
        if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP12Parameter.getValue())) {
            disableSOAP12 = true;
        }
        WSDLSerializationUtil.addWSDLDocumentationElement(this.axisService, ele, fac, this.wsdl);
        ele.addAttribute("targetNamespace", this.axisService.getTargetNamespace(), null);
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        ele.addChild(wsdlTypes);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            String targetNamespace = schema.getTargetNamespace();
            if ("http://www.w3.org/XML/1998/namespace".equals(targetNamespace)) continue;
            schema.write(writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            wsdlTypes.addChild(XMLUtils.toOM(new StringReader(schemaString)));
        }
        this.generateMessages(fac, ele);
        this.generatePortType(fac, ele);
        this.generateService(fac, ele, disableREST, disableSOAP12, disableSOAP11);
        this.addPoliciesToDefinitionElement(this.policiesInDefinitions.values().iterator(), this.definition);
        return ele;
    }

    private void generateMessages(OMFactory fac, OMElement defintions) {
        HashSet<String> faultMessageNames = new HashSet<String>();
        this.messagesMap = new HashMap();
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                this.writeMessage(inaxisMessage, fac, defintions);
                this.generateHeaderMessages(inaxisMessage, fac, defintions);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                this.writeMessage(outAxisMessage, fac, defintions);
                this.generateHeaderMessages(outAxisMessage, fac, defintions);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage axisMessage = (AxisMessage)faultyMessages.get(i);
                String name = axisMessage.getName();
                if (!faultMessageNames.add(name)) continue;
                this.writeMessage(axisMessage, fac, defintions);
                this.generateHeaderMessages(axisMessage, fac, defintions);
            }
        }
    }

    private void generateHeaderMessages(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        ArrayList extList = axismessage.getSoapHeaders();
        for (int i = 0; i < extList.size(); ++i) {
            SOAPHeaderMessage header = (SOAPHeaderMessage)extList.get(i);
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", header.getMessage().getLocalPart(), null);
            defintions.addChild(messageElement);
            OMElement messagePart = fac.createOMElement("part", this.wsdl);
            messageElement.addChild(messagePart);
            messagePart.addAttribute("name", header.part(), null);
            if (header.getElement() == null) {
                throw new RuntimeException("element is null for " + header.getMessage());
            }
            messagePart.addAttribute("element", WSDLSerializationUtil.getPrefix(header.getElement().getNamespaceURI(), this.axisService.getNamespaceMap()) + ":" + header.getElement().getLocalPart(), null);
        }
    }

    private void writeMessage(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        if (this.messagesMap.get(axismessage.getName()) == null) {
            this.messagesMap.put(axismessage.getName(), axismessage);
            QName schemaElementName = axismessage.getElementQName();
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", axismessage.getName(), null);
            defintions.addChild(messageElement);
            if (schemaElementName != null) {
                OMElement messagePart = fac.createOMElement("part", this.wsdl);
                messageElement.addChild(messagePart);
                if (axismessage.getMessagePartName() != null) {
                    messagePart.addAttribute("name", axismessage.getMessagePartName(), null);
                } else {
                    messagePart.addAttribute("name", axismessage.getPartName(), null);
                }
                messagePart.addAttribute("element", WSDLSerializationUtil.getPrefix(schemaElementName.getNamespaceURI(), this.axisService.getNamespaceMap()) + ":" + schemaElementName.getLocalPart(), null);
            }
        }
    }

    private void generatePortType(OMFactory fac, OMElement defintions) throws Exception {
        OMElement portType = fac.createOMElement("portType", this.wsdl);
        defintions.addChild(portType);
        portType.addAttribute("name", this.serviceName + "PortType", null);
        this.addPolicyAsExtAttribute(this.axisService, portType, fac);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            WSDLSerializationUtil.addWSDLDocumentationElement(axisOperation, operation, fac, this.wsdl);
            portType.addChild(operation);
            operation.addAttribute("name", operationName, null);
            this.addPolicyAsExtElement(axisOperation, operation);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                OMElement input = fac.createOMElement("input", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement(inaxisMessage, input, fac, this.wsdl);
                input.addAttribute("message", this.tns.getPrefix() + ":" + inaxisMessage.getName(), null);
                this.addPolicyAsExtElement(inaxisMessage, input);
                WSDLSerializationUtil.addWSAWActionAttribute(input, axisOperation.getInputAction(), this.wsaw);
                operation.addChild(input);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement(outAxisMessage, output, fac, this.wsdl);
                output.addAttribute("message", this.tns.getPrefix() + ":" + outAxisMessage.getName(), null);
                this.addPolicyAsExtElement(outAxisMessage, output);
                WSDLSerializationUtil.addWSAWActionAttribute(output, axisOperation.getOutputAction(), this.wsaw);
                operation.addChild(output);
            }
            if ((faultMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultMessages.size(); ++i) {
                AxisMessage faultyMessage = (AxisMessage)faultMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement(faultyMessage, fault, fac, this.wsdl);
                fault.addAttribute("message", this.tns.getPrefix() + ":" + faultyMessage.getName(), null);
                fault.addAttribute("name", faultyMessage.getName(), null);
                WSDLSerializationUtil.addWSAWActionAttribute(fault, axisOperation.getFaultAction(faultyMessage.getName()), this.wsaw);
                operation.addChild(fault);
            }
        }
    }

    public void generateService(OMFactory fac, OMElement defintions, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11) throws Exception {
        OMElement service = fac.createOMElement("service", this.wsdl);
        defintions.addChild(service);
        service.addAttribute("name", this.serviceName, null);
        if (!disableSOAP11) {
            this.generateSoap11Port(fac, defintions, service);
        }
        if (!disableSOAP12) {
            this.generateSoap12Port(fac, defintions, service);
        }
        this.addPolicyAsExtElement(6, this.axisService.getPolicyInclude(), service);
        if (!disableREST) {
            this.generateHttpPort(fac, this.definition, service);
        }
    }

    private void writeSoapHeaders(AxisMessage inaxisMessage, OMFactory fac, OMElement input, OMNamespace soapNameSpace) throws Exception {
        ArrayList extElementList = inaxisMessage.getSoapHeaders();
        if (extElementList != null) {
            for (SOAPHeaderMessage soapheader : extElementList) {
                this.addSOAPHeader(fac, input, soapheader, soapNameSpace);
            }
        }
    }

    private void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, String att2Name, String att2Value, OMNamespace soapNameSpace) {
        OMElement soapbinding = fac.createOMElement(name, soapNameSpace);
        element.addChild(soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        if (att2Name != null) {
            soapbinding.addAttribute(att2Name, att2Value, null);
        }
    }

    private void setDefinitionElement(OMElement defintion) {
        this.definition = defintion;
    }

    private void addSOAPHeader(OMFactory fac, OMElement element, SOAPHeaderMessage header, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement("header", soapNameSpace);
        element.addChild(extElement);
        String use = header.getUse();
        if (use != null) {
            extElement.addAttribute("use", use, null);
        }
        if (header.part() != null) {
            extElement.addAttribute("part", header.part(), null);
        }
        if (header.getMessage() != null) {
            extElement.addAttribute("message", WSDLSerializationUtil.getPrefix(this.targetNamespace, this.axisService.getNamespaceMap()) + ":" + header.getMessage().getLocalPart(), null);
        }
    }

    private void addPolicyAsExtElement(int type, PolicyInclude policyInclude, OMElement parentElement) throws Exception {
        ArrayList elementList = policyInclude.getPolicyElements(type);
        for (Object policyElement : elementList) {
            Policy p;
            OMElement firstChildElem;
            OMElement child;
            if (policyElement instanceof Policy) {
                child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyElement, this.serializer);
                firstChildElem = parentElement.getFirstElement();
                parentElement.addChild(child);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyElement);
            firstChildElem = parentElement.getFirstElement();
            if (firstChildElem == null) {
                parentElement.addChild(child);
            } else {
                firstChildElem.insertSiblingBefore(child);
            }
            PolicyRegistry reg = policyInclude.getPolicyRegistry();
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = reg.lookup(key)) == null) {
                throw new Exception("Policy not found for uri : " + key);
            }
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    private void addPoliciesToDefinitionElement(Iterator iterator, OMElement definitionElement) throws Exception {
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            OMElement policyElement = PolicyUtil.getPolicyComponentAsOMElement(policy, this.serializer);
            OMNode firstChild = this.definition.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore(policyElement);
                continue;
            }
            definitionElement.addChild(policyElement);
        }
    }

    private void addPolicyToDefinitionElement(String key, Policy policy) {
        this.policiesInDefinitions.put(key, policy);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    private void generateSoap11Port(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        Iterator iterator = this.axisService.getEndpoints().values().iterator();
        AxisEndpoint axisEndpoint = null;
        AxisBinding axisBinding = null;
        while (iterator.hasNext()) {
            String version;
            String type;
            axisEndpoint = (AxisEndpoint)iterator.next();
            if (!axisEndpoint.isActive() || !"http://schemas.xmlsoap.org/soap/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild(port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement(fac, port, "address", "location", endpointURL == null ? "" : endpointURL, this.soap);
            this.addPolicyAsExtElement(axisEndpoint, port);
            this.generateSoap11Binding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateSoap12Port(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        Iterator iterator = this.axisService.getEndpoints().values().iterator();
        AxisEndpoint axisEndpoint = null;
        AxisBinding axisBinding = null;
        while (iterator.hasNext()) {
            String version;
            String type;
            axisEndpoint = (AxisEndpoint)iterator.next();
            if (!axisEndpoint.isActive() || !"http://schemas.xmlsoap.org/soap/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://www.w3.org/2003/05/soap-envelope".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild(port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement(fac, port, "address", "location", endpointURL == null ? "" : endpointURL, this.soap12);
            this.addPolicyAsExtElement(axisEndpoint, port);
            this.generateSoap12Binding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateHttpPort(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        Iterator iterator = this.axisService.getEndpoints().values().iterator();
        AxisEndpoint axisEndpoint = null;
        AxisBinding axisBinding = null;
        while (iterator.hasNext()) {
            String type;
            axisEndpoint = (AxisEndpoint)iterator.next();
            if (!axisEndpoint.isActive() || !"http://www.w3.org/ns/wsdl/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType())) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild(port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            OMElement extElement = fac.createOMElement("address", this.http);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            extElement.addAttribute("location", endpointURL == null ? "" : endpointURL, null);
            port.addChild(extElement);
            this.addPolicyAsExtElement(axisEndpoint, port);
            this.generateHttpBinding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateSoap11Binding(OMFactory fac, OMElement defintions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, defintions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = defintions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore(binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        this.addPolicyAsExtElement(axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap);
        if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", this.wsaw);
        }
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild(operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement(axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild("In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement(axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild(input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement(axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild(output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisBindingOperation.getFaults()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisBindingMessage bindingFaultyMessage = (AxisBindingMessage)faultyMessages.get(i);
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement(bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild(fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap);
            }
        }
    }

    private void generateSoap12Binding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, definitions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore(binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        this.addPolicyAsExtElement(axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap12);
        if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", this.wsaw);
        }
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild(operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement(axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap12);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild("In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement(axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild(input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement(axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild(output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisBindingOperation.getFaults()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisBindingMessage bindingFaultyMessage = (AxisBindingMessage)faultyMessages.get(i);
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement(bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap12);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild(fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap12);
            }
        }
    }

    private void generateHttpBinding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, definitions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore(binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        OMElement httpBinding = fac.createOMElement("binding", this.http);
        binding.addChild(httpBinding);
        httpBinding.addAttribute("verb", "POST", null);
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild(operation);
            OMElement httpOperation = fac.createOMElement("operation", this.http);
            operation.addChild(httpOperation);
            httpOperation.addAttribute("location", this.serviceName + "/" + axisOperation.getName().getLocalPart(), null);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP2)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild("In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                OMElement inputelement = fac.createOMElement("content", this.mime);
                input.addChild(inputelement);
                inputelement.addAttribute("type", "text/xml", null);
                inputelement.addAttribute("part", axisOperation.getName().getLocalPart(), null);
                operation.addChild(input);
            }
            if (!"http://www.w3.org/ns/wsdl/out-only".equals(MEP2) && !"http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP2) && !"http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP2) && !"http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP2) && !"http://www.w3.org/ns/wsdl/in-out".equals(MEP2) || (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out")) == null || (outAxisMessage = axisBindingOutMessage.getAxisMessage()) == null) continue;
            OMElement output = fac.createOMElement("output", this.wsdl);
            OMElement outElement = fac.createOMElement("content", this.mime);
            outElement.addChild(outElement);
            outElement.addAttribute("type", "text/xml", null);
            outElement.addAttribute("part", axisOperation.getName().getLocalPart(), null);
            output.addChild(outElement);
            operation.addChild(output);
        }
    }

    private void addPolicyAsExtElement(AxisDescription axisDescription, OMElement wsdlElement) throws Exception {
        PolicySubject policySubject = axisDescription.getPolicySubject();
        Collection attachPolicyComponents = policySubject.getAttachedPolicyComponents();
        for (Object policyElement : attachPolicyComponents) {
            PolicyLocator locator;
            Policy p;
            if (policyElement instanceof Policy) {
                PolicyReference policyReference = PolicyUtil.createPolicyReference((Policy)policyElement);
                OMElement policyRefElement = PolicyUtil.getPolicyComponentAsOMElement(policyReference, this.serializer);
                OMElement firstChildElem = wsdlElement.getFirstElement();
                if (firstChildElem == null) {
                    wsdlElement.addChild(policyRefElement);
                } else {
                    firstChildElem.insertSiblingBefore(policyRefElement);
                }
                String key = policyReference.getURI();
                if (key.startsWith("#")) {
                    key = key.substring(key.indexOf("#") + 1);
                }
                this.addPolicyToDefinitionElement(key, (Policy)policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            OMElement child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyElement, this.serializer);
            OMElement firstChildElem = wsdlElement.getFirstElement();
            if (firstChildElem == null) {
                wsdlElement.addChild(child);
            } else {
                firstChildElem.insertSiblingBefore(child);
            }
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = (locator = new PolicyLocator(this.axisService)).lookup(key)) == null) {
                throw new Exception("Policy not found for uri : " + key);
            }
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    private void addPolicyAsExtAttribute(AxisDescription axisDescription, OMElement element, OMFactory factory) throws Exception {
        PolicySubject policySubject = axisDescription.getPolicySubject();
        ArrayList<String> policyURIs = new ArrayList<String>();
        for (Object policyElement : policySubject.getAttachedPolicyComponents()) {
            String key;
            if (policyElement instanceof Policy) {
                Policy p = (Policy)policyElement;
                if (p.getId() != null) {
                    key = "#" + p.getId();
                } else if (p.getName() != null) {
                    key = p.getName();
                } else {
                    throw new RuntimeException("Can't add the Policy as an extensibility attribute since it doesn't have a id or a name attribute");
                }
                policyURIs.add(key);
                this.addPolicyToDefinitionElement(key, p);
                continue;
            }
            PolicyLocator locator = new PolicyLocator(this.axisService);
            String uri = ((PolicyReference)policyElement).getURI();
            key = uri.startsWith("#") ? uri.substring(uri.indexOf(35) + 1) : uri;
            Policy p = locator.lookup(key);
            if (p == null) {
                throw new RuntimeException("Cannot resolve " + uri + " to a Policy");
            }
            this.addPolicyToDefinitionElement(key, p);
        }
        if (!policyURIs.isEmpty()) {
            String value = null;
            for (String uri : policyURIs) {
                value = value == null ? uri : value + " " + uri;
            }
            OMNamespace ns = factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            OMAttribute URIs = factory.createOMAttribute("PolicyURIs", ns, value);
            element.addAttribute(URIs);
        }
    }

    private boolean isAlreadyAdded(AxisBinding axisBinding, OMElement definitionElement) {
        QName bindingName = axisBinding.getName();
        QName name = new QName("name");
        Iterator iterator = definitionElement.getChildrenWithName(new QName(this.wsdl.getNamespaceURI(), "binding"));
        while (iterator.hasNext()) {
            OMElement element = (OMElement)iterator.next();
            String value = element.getAttributeValue(name);
            if (!bindingName.getLocalPart().equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getEndpointURL(AxisEndpoint axisEndpoint) {
        Parameter modifyAddressParam = this.axisService.getParameter("modifyUserWSDLPortAddress");
        if (modifyAddressParam != null && Boolean.parseBoolean((String)modifyAddressParam.getValue())) {
            return axisEndpoint.calculateEndpointURL();
        }
        return axisEndpoint.getEndpointURL();
    }
}

