/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.HashMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.JAXBAttachmentMarshaller;
import org.apache.axis2.datasource.jaxb.JAXBAttachmentUnmarshaller;
import org.apache.axis2.datasource.jaxb.XSDListUtils;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.message.util.XMLStreamWriterWithOS;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDSContext {
    private static final Log log = LogFactory.getLog(JAXBDSContext.class);
    public static final boolean DEBUG_ENABLED = log.isDebugEnabled();
    private TreeSet<String> contextPackages;
    private String contextPackagesKey;
    private JAXBContext customerJAXBContext;
    private WeakReference<JAXBContext> autoJAXBContext = null;
    private JAXBUtils.CONSTRUCTION_TYPE constructionType = JAXBUtils.CONSTRUCTION_TYPE.UNKNOWN;
    private MessageContext msgContext;
    private Class processType = null;
    private boolean isxmlList = false;
    private String webServiceNamespace;

    public JAXBDSContext(TreeSet<String> packages, String packagesKey) {
        this.contextPackages = packages;
        this.contextPackagesKey = packagesKey;
    }

    public JAXBDSContext(TreeSet<String> packages) {
        this(packages, packages.toString());
    }

    public JAXBDSContext(String contextPackage) {
        this.contextPackages = new TreeSet();
        this.contextPackages.add(contextPackage);
        this.contextPackagesKey = this.contextPackages.toString();
    }

    public JAXBDSContext(JAXBContext jaxbContext) {
        this.customerJAXBContext = jaxbContext;
    }

    public TreeSet<String> getContextPackages() {
        return this.contextPackages;
    }

    public JAXBContext getJAXBContext() throws JAXBException {
        return this.getJAXBContext(null);
    }

    public JAXBContext getJAXBContext(ClassLoader cl) throws JAXBException {
        if (this.customerJAXBContext != null) {
            return this.customerJAXBContext;
        }
        JAXBContext jc = null;
        if (this.autoJAXBContext != null) {
            jc = (JAXBContext)this.autoJAXBContext.get();
        }
        if (jc == null) {
            if (log.isDebugEnabled()) {
                log.debug("A JAXBContext did not exist, creating a new one with the context packages.");
            }
            Holder constructType = new Holder();
            HashMap<String, String> properties = null;
            if (this.webServiceNamespace != null) {
                properties = new HashMap<String, String>();
                properties.put("com.sun.xml.bind.defaultNamespaceRemap", this.webServiceNamespace);
            }
            jc = JAXBUtils.getJAXBContext(this.contextPackages, (Holder<JAXBUtils.CONSTRUCTION_TYPE>)constructType, this.contextPackagesKey, cl, properties);
            this.constructionType = (JAXBUtils.CONSTRUCTION_TYPE)((Object)constructType.value);
            this.autoJAXBContext = new WeakReference<JAXBContext>(jc);
        } else if (log.isDebugEnabled()) {
            log.debug("Using an existing JAXBContext");
        }
        return jc;
    }

    public void setWebServiceNamespace(String namespace) {
        this.webServiceNamespace = namespace;
    }

    public Class getProcessType() {
        return this.processType;
    }

    public void setProcessType(Class type) {
        this.processType = type;
    }

    public JAXBUtils.CONSTRUCTION_TYPE getConstructionType() {
        return this.constructionType;
    }

    public boolean isxmlList() {
        return this.isxmlList;
    }

    public void setIsxmlList(boolean isxmlList) {
        this.isxmlList = isxmlList;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public ClassLoader getClassLoader() {
        MessageContext context = this.getMessageContext();
        if (context != null) {
            return (ClassLoader)context.getProperty("CACHE_CLASSLOADER");
        }
        return null;
    }

    protected AttachmentMarshaller createAttachmentMarshaller(XMLStreamWriter writer) {
        return new JAXBAttachmentMarshaller(this.getMessageContext(), writer);
    }

    protected AttachmentUnmarshaller createAttachmentUnmarshaller(XMLStreamReader reader) {
        return new JAXBAttachmentUnmarshaller(this.getMessageContext(), reader);
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        ClassLoader cl = this.getClassLoader();
        Unmarshaller u = JAXBUtils.getJAXBUnmarshaller(this.getJAXBContext(cl));
        AttachmentUnmarshaller aum = this.createAttachmentUnmarshaller(reader);
        if (aum != null) {
            if (DEBUG_ENABLED) {
                log.debug("Adding JAXBAttachmentUnmarshaller to Unmarshaller");
            }
            u.setAttachmentUnmarshaller(aum);
        }
        Object jaxb = null;
        jaxb = this.getProcessType() == null ? JAXBDSContext.unmarshalByElement(u, reader) : JAXBDSContext.unmarshalByType(u, reader, this.getProcessType(), this.isxmlList(), this.getConstructionType());
        JAXBUtils.releaseJAXBUnmarshaller(this.getJAXBContext(cl), u);
        return jaxb;
    }

    public void marshal(Object obj, XMLStreamWriter writer) throws JAXBException {
        AttachmentMarshaller am;
        String encoding;
        ClassLoader cl = this.getClassLoader();
        Marshaller m = JAXBUtils.getJAXBMarshaller(this.getJAXBContext(cl));
        if (writer instanceof MTOMXMLStreamWriter && ((MTOMXMLStreamWriter)writer).getOutputFormat() != null && (encoding = ((MTOMXMLStreamWriter)writer).getOutputFormat().getCharSetEncoding()) != null && !"UTF-8".equalsIgnoreCase(encoding)) {
            if (log.isDebugEnabled()) {
                log.debug("Setting the Marshaller.JAXB_ENCODING to " + encoding);
            }
            m.setProperty("jaxb.encoding", (Object)encoding);
        }
        if ((am = this.createAttachmentMarshaller(writer)) != null) {
            if (DEBUG_ENABLED) {
                log.debug("Adding JAXBAttachmentMarshaller to Marshaller");
            }
            m.setAttachmentMarshaller(am);
        }
        if (this.getProcessType() == null) {
            JAXBDSContext.marshalByElement(obj, m, writer, true);
        } else {
            JAXBDSContext.marshalByType(obj, m, writer, this.getProcessType(), this.isxmlList(), this.getConstructionType());
        }
        JAXBUtils.releaseJAXBMarshaller(this.getJAXBContext(cl), m);
    }

    private static void marshalByElement(final Object b, final Marshaller m, final XMLStreamWriter writer, final boolean optimize) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    OutputStream os;
                    if (!optimize) {
                        log.debug(JavaUtils.stackToString());
                        JAXBDSContext.getOutputStream(writer);
                    }
                    OutputStream outputStream = os = optimize ? JAXBDSContext.getOutputStream(writer) : null;
                    if (os != null) {
                        if (DEBUG_ENABLED) {
                            log.debug("Invoking marshalByElement.  Marshaling to an OutputStream. Object is " + JAXBDSContext.getDebugName(b));
                        }
                        writer.flush();
                        m.marshal(b, os);
                    } else {
                        if (DEBUG_ENABLED) {
                            log.debug("Invoking marshalByElement.  Marshaling to an XMLStreamWriter. Object is " + JAXBDSContext.getDebugName(b));
                        }
                        m.marshal(b, writer);
                    }
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
                return null;
            }
        });
    }

    private static String getDebugName(Object o) {
        return o == null ? "null" : o.getClass().getCanonicalName();
    }

    private static OutputStream getOutputStream(XMLStreamWriter writer) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug("XMLStreamWriter is " + writer);
        }
        OutputStream os = null;
        if (writer.getClass() == MTOMXMLStreamWriter.class) {
            os = ((MTOMXMLStreamWriter)writer).getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug("OutputStream accessible from MTOMXMLStreamWriter is " + os);
            }
        }
        if (writer.getClass() == XMLStreamWriterWithOS.class) {
            os = ((XMLStreamWriterWithOS)writer).getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug("OutputStream accessible from XMLStreamWriterWithOS is " + os);
            }
        }
        return os;
    }

    public static Object unmarshalByType(final Unmarshaller u, final XMLStreamReader reader, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype) throws WebServiceException {
        if (DEBUG_ENABLED) {
            log.debug("Invoking unmarshalByType.");
            log.debug("  type = " + type);
            log.debug("  isList = " + isList);
            log.debug("  ctype = " + (Object)((Object)ctype));
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Object jaxb;
                    if (!isList) {
                        if (type.isArray()) {
                            if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                                if (DEBUG_ENABLED) {
                                    log.debug("Unmarshal Array via BY_CONTEXT_PATH approach");
                                }
                                jaxb = u.unmarshal(reader, type);
                            } else if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY) {
                                Class<?> cType = type.getComponentType();
                                while (cType.isArray()) {
                                    cType = cType.getComponentType();
                                }
                                if (cType.isPrimitive()) {
                                    if (DEBUG_ENABLED) {
                                        log.debug("Unmarshal Array of primitive via BY_CLASS_ARRAY approach");
                                    }
                                    jaxb = u.unmarshal(reader, type);
                                } else {
                                    if (DEBUG_ENABLED) {
                                        log.debug("Unmarshal Array of non-primitive via BY_CLASS_ARRAY approach");
                                    }
                                    jaxb = JAXBDSContext.unmarshalArray(reader, u, type);
                                }
                            } else {
                                if (DEBUG_ENABLED) {
                                    log.debug("Unmarshal Array");
                                }
                                jaxb = u.unmarshal(reader, type);
                            }
                        } else if (type.isEnum()) {
                            JAXBElement enumValue;
                            if (DEBUG_ENABLED) {
                                log.debug("Unmarshalling " + type.getName() + " as Enum");
                            }
                            if ((enumValue = u.unmarshal(reader, String.class)) != null) {
                                Method m = type.getMethod("fromValue", String.class);
                                jaxb = m.invoke(null, enumValue.getValue());
                            } else {
                                jaxb = null;
                            }
                        } else {
                            if (DEBUG_ENABLED) {
                                log.debug("Unmarshalling normal case (not array, not xsd:list, not enum)");
                            }
                            jaxb = u.unmarshal(reader, type);
                        }
                    } else {
                        if (DEBUG_ENABLED) {
                            log.debug("Unmarshalling xsd:list");
                        }
                        jaxb = JAXBDSContext.unmarshalAsListOrArray(reader, u, type);
                    }
                    if (log.isDebugEnabled()) {
                        if (jaxb == null) {
                            if (DEBUG_ENABLED) {
                                log.debug("End unmarshalByType returning null object");
                            }
                        } else if (jaxb instanceof JAXBElement) {
                            JAXBElement jbe = (JAXBElement)jaxb;
                            if (DEBUG_ENABLED) {
                                log.debug("End unmarshalByType returning JAXBElement");
                                log.debug("  Class = " + jbe.getDeclaredType());
                                log.debug("  QName = " + jbe.getName());
                            }
                        } else if (DEBUG_ENABLED) {
                            log.debug("End unmarshalByType returning " + jaxb.getClass());
                        }
                    }
                    return jaxb;
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
            }
        });
    }

    private static Object unmarshalArray(final XMLStreamReader reader, final Unmarshaller u, Class type) throws Exception {
        try {
            Object jaxb;
            Object typeObj;
            if (DEBUG_ENABLED) {
                log.debug("Invoking unmarshalArray");
            }
            if ((typeObj = JAXBDSContext.getTypeEnabledObject(jaxb = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader, String[].class);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            }))) instanceof String[]) {
                String[] strArray = (String[])typeObj;
                Object obj = XSDListUtils.fromStringArray(strArray, type);
                QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
                jaxb = new JAXBElement(qName, type, obj);
            }
            return jaxb;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }

    public static Object unmarshalAsListOrArray(final XMLStreamReader reader, final Unmarshaller u, Class type) throws IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, DatatypeConfigurationException, InvocationTargetException, JAXBException {
        if (DEBUG_ENABLED) {
            log.debug("Invoking unmarshaArray");
        }
        Object jaxb = null;
        try {
            jaxb = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader, String.class);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            });
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
        if (JAXBDSContext.getTypeEnabledObject(jaxb) instanceof String) {
            QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
            Object obj = XSDListUtils.fromXSDListString((String)JAXBDSContext.getTypeEnabledObject(jaxb), type);
            return new JAXBElement(qName, type, obj);
        }
        return jaxb;
    }

    static Object getTypeEnabledObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    private static void marshalByType(final Object b, final Marshaller m, final XMLStreamWriter writer, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype) throws WebServiceException {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Object jbo = b;
                    if (DEBUG_ENABLED) {
                        log.debug("check if marshalling type list or array object type = " + (b != null ? b.getClass().getName() : "null"));
                    }
                    if (isList) {
                        String text;
                        QName qName;
                        if (DEBUG_ENABLED) {
                            log.debug("marshalling type which is a List");
                        }
                        if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                            qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                            text = XSDListUtils.toXSDListString(JAXBDSContext.getTypeEnabledObject(b));
                            if (DEBUG_ENABLED) {
                                log.debug("marshalling [context path approach] with xmllist text = " + text);
                            }
                            jbo = new JAXBElement(qName, String.class, (Object)text);
                        } else if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY) {
                            qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                            text = XSDListUtils.toXSDListString(JAXBDSContext.getTypeEnabledObject(b));
                            if (DEBUG_ENABLED) {
                                log.debug("marshalling [class array approach] with xmllist text = " + text);
                            }
                            jbo = new JAXBElement(qName, String.class, (Object)text);
                        }
                    }
                    if (type.isEnum() && b != null) {
                        if (DEBUG_ENABLED) {
                            log.debug("marshalByType. Marshaling " + type.getName() + " as Enum");
                        }
                        JAXBElement jbe = (JAXBElement)b;
                        String value = XMLRootElementUtil.getEnumValue((Enum)jbe.getValue());
                        jbo = new JAXBElement(jbe.getName(), String.class, (Object)value);
                    }
                    if (DEBUG_ENABLED) {
                        log.debug("Invoking marshalByType.  Marshaling to an XMLStreamWriter. Object is " + JAXBDSContext.getDebugName(b));
                    }
                    m.marshal(jbo, writer);
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
                return null;
            }
        });
    }

    public static Object unmarshalByElement(final Unmarshaller u, final XMLStreamReader reader) throws WebServiceException {
        try {
            if (DEBUG_ENABLED) {
                log.debug("Invoking unMarshalByElement");
            }
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            });
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }
}

