/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.JAXBCustomBuilderMonitor;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.datasource.jaxb.JAXBDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBCustomBuilder
implements CustomBuilder {
    private static final Log log = LogFactory.getLog(JAXBCustomBuilder.class);
    JAXBDSContext jdsContext;

    public JAXBCustomBuilder(JAXBDSContext context) {
        this.jdsContext = context;
        JAXBCustomBuilderMonitor.updateTotalBuilders();
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug("create namespace = " + namespace);
            log.debug("  localPart = " + localPart);
            log.debug("  reader = " + reader.getClass());
        }
        if (!this.shouldUnmarshal(namespace, localPart)) {
            JAXBCustomBuilderMonitor.updateTotalFailedCreates();
            return null;
        }
        try {
            OMNamespace ns = factory.createOMNamespace(namespace, reader.getPrefix());
            Object jaxb = this.jdsContext.unmarshal(reader);
            if (log.isDebugEnabled()) {
                log.debug("Successfully unmarshalled jaxb object " + jaxb);
            }
            JAXBDataSource ds2 = new JAXBDataSource(jaxb, this.jdsContext);
            if (log.isDebugEnabled()) {
                log.debug("The JAXBDataSource is " + ds2);
            }
            OMSourcedElement omse = factory.createOMElement(ds2, localPart, ns);
            parent.addChild(omse);
            JAXBCustomBuilderMonitor.updateTotalCreates();
            return omse;
        }
        catch (JAXBException e) {
            JAXBCustomBuilderMonitor.updateTotalFailedCreates();
            throw new OMException(e);
        }
    }

    private boolean shouldUnmarshal(String namespace, String localPart) {
        boolean streamingEnabled;
        Object value = null;
        MessageContext msgCtx = this.jdsContext.getMessageContext();
        if (msgCtx != null) {
            value = msgCtx.getProperty("org.apache.axis2.jaxws.enableJAXBPayloadStreaming");
        }
        if (value != null && value instanceof Boolean && !(streamingEnabled = ((Boolean)value).booleanValue())) {
            if (log.isDebugEnabled()) {
                log.debug("JAXB payload streaming disabled by messageContext property org.apache.axis2.jaxws.enableJAXBPayloadStreaming set to " + streamingEnabled);
            }
            return false;
        }
        if (localPart == null || namespace == null || namespace.length() == 0 || "http://schemas.xmlsoap.org/soap/envelope/".equals(namespace) || "http://www.w3.org/2003/05/soap-envelope".equals(namespace)) {
            return false;
        }
        return !localPart.equals("EncryptedData");
    }
}

