/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.externalize.ActivateUtils;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceGroupContext
extends AbstractContext
implements Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(ServiceGroupContext.class);
    private static final String myClassName = "ServiceGroupContext";
    private static final long serialVersionUID = 9014471144479928885L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    private transient AxisServiceGroup axisServiceGroup;
    private String id;
    private Map serviceContextMap;
    private transient boolean needsToBeReconciled = false;
    private transient MetaDataEntry metaAxisServiceGroup = null;

    public ServiceGroupContext() {
        super(null);
        this.serviceContextMap = new HashMap();
    }

    public ServiceGroupContext(ConfigurationContext parent, AxisServiceGroup axisServiceGroup) {
        super(parent);
        this.axisServiceGroup = axisServiceGroup;
        this.serviceContextMap = new HashMap();
        if (axisServiceGroup != null) {
            this.setId(axisServiceGroup.getServiceGroupName());
        }
    }

    public AxisServiceGroup getDescription() {
        this.checkActivateWarning("getDescription");
        return this.axisServiceGroup;
    }

    public String getId() {
        return this.id;
    }

    public ServiceContext getServiceContext(AxisService service) throws AxisFault {
        ServiceContext serviceContext;
        AxisService axisService = this.axisServiceGroup.getService(service.getName());
        if (axisService == null) {
            throw new AxisFault(Messages.getMessage("invalidserviceinagroup", service.getName(), this.axisServiceGroup.getServiceGroupName()));
        }
        if (this.serviceContextMap == null) {
            this.serviceContextMap = new HashMap();
        }
        if ((serviceContext = (ServiceContext)this.serviceContextMap.get(service.getName())) == null) {
            serviceContext = new ServiceContext(service, this);
            this.getRootContext().contextCreated(serviceContext);
            this.serviceContextMap.put(service.getName(), serviceContext);
        }
        return serviceContext;
    }

    public Iterator getServiceContexts() {
        if (this.serviceContextMap == null) {
            this.serviceContextMap = new HashMap();
        }
        if (this.serviceContextMap.isEmpty()) {
            return null;
        }
        return this.serviceContextMap.values().iterator();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addServiceContext(ServiceContext srvctx) {
        if (srvctx == null) {
            return;
        }
        AxisService axisService = srvctx.getAxisService();
        if (axisService == null) {
            return;
        }
        if (this.serviceContextMap == null) {
            this.serviceContextMap = new HashMap();
        }
        this.serviceContextMap.put(axisService.getName(), srvctx);
    }

    public ServiceContext findServiceContext(String name) {
        if (this.serviceContextMap == null) {
            return null;
        }
        return (ServiceContext)this.serviceContextMap.get(name);
    }

    public ServiceContext findServiceContext(AxisService axisSrv) {
        if (axisSrv == null) {
            return null;
        }
        if (this.serviceContextMap == null) {
            return null;
        }
        return (ServiceContext)this.serviceContextMap.get(axisSrv.getName());
    }

    public void putContextProperties(ServiceGroupContext context) {
        if (context != null) {
            Map props = this.getProperties();
            context.mergeProperties(props);
        }
    }

    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(9014471144479928885L);
        out.writeInt(2);
        out.writeLong(this.getLastTouchedTime());
        if (this.id == null) {
            this.id = UUIDGenerator.getUUID();
        }
        out.writeObject(this.id);
        out.writeMap(this.getProperties());
        this.metaAxisServiceGroup = null;
        if (this.axisServiceGroup != null) {
            this.metaAxisServiceGroup = new MetaDataEntry(this.axisServiceGroup.getClass().getName(), this.axisServiceGroup.getServiceGroupName());
        }
        out.writeObject(this.metaAxisServiceGroup);
    }

    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        this.needsToBeReconciled = true;
        if (log.isTraceEnabled()) {
            log.trace("ServiceGroupContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  ");
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 9014471144479928885L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.id = (String)in.readObject();
        this.properties = in.readMap(new HashMap());
        this.axisServiceGroup = null;
        this.metaAxisServiceGroup = (MetaDataEntry)in.readObject();
        this.serviceContextMap = new HashMap();
    }

    public void activate(ConfigurationContext cc) {
        if (!this.needsToBeReconciled) {
            return;
        }
        AxisConfiguration axisConfig = cc.getAxisConfiguration();
        this.axisServiceGroup = this.metaAxisServiceGroup != null ? ActivateUtils.findServiceGroup(axisConfig, this.metaAxisServiceGroup.getClassName(), this.metaAxisServiceGroup.getQNameAsString()) : null;
        this.setParent(cc);
        cc.addServiceGroupContextIntoSoapSessionTable(this);
        this.needsToBeReconciled = false;
    }

    public boolean isEquivalent(ServiceGroupContext ctx) {
        if (!this.axisServiceGroup.equals(ctx.getDescription())) {
            return false;
        }
        String ctxid = ctx.getId();
        if (this.id != null && ctxid != null) {
            if (!this.id.equals(ctxid)) {
                return false;
            }
        } else if (this.id != null || ctxid != null) {
            return false;
        }
        return true;
    }

    private void checkActivateWarning(String methodname) {
        if (this.needsToBeReconciled) {
            log.warn("ServiceGroupContext:" + methodname + "(): ****WARNING**** " + myClassName + ".activate(configurationContext) needs to be invoked.");
        }
    }

    public ConfigurationContext getRootContext() {
        return (ConfigurationContext)this.getParent();
    }
}

