/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesUtil {
    private static Log log = LogFactory.getLog(TribesUtil.class);

    public static void printMembers(MembershipManager membershipManager) {
        Member[] members = membershipManager.getMembers();
        if (members != null) {
            int length = members.length;
            if (length > 0) {
                log.info("Members of current cluster");
                for (int i = 0; i < length; ++i) {
                    log.info("Member" + (i + 1) + " " + TribesUtil.getName(members[i]));
                }
            } else {
                log.info("No members in current cluster");
            }
        }
    }

    public static String getName(Member member) {
        return TribesUtil.getHost(member) + ":" + member.getPort() + "(" + new String(member.getDomain()) + ")";
    }

    public static String getHost(Member member) {
        byte[] hostBytes = member.getHost();
        StringBuffer host = new StringBuffer();
        if (hostBytes != null) {
            for (int i = 0; i < hostBytes.length; ++i) {
                int hostByte = hostBytes[i] >= 0 ? hostBytes[i] : hostBytes[i] + 256;
                host.append(hostByte);
                if (i >= hostBytes.length - 1) continue;
                host.append(".");
            }
        }
        return host.toString();
    }

    public static String getLocalHost(Channel channel) {
        return TribesUtil.getName(channel.getLocalMember(true));
    }

    public static byte[] getRpcMembershipChannelId(byte[] domain) {
        return (new String(domain) + ":" + "rpc.membership.channel").getBytes();
    }

    public static byte[] getRpcInitChannelId(byte[] domain) {
        return (new String(domain) + ":" + "rpc.init.channel").getBytes();
    }

    public static boolean isInDomain(Member member, byte[] domain) {
        return Arrays.equals((byte[])domain, (byte[])member.getDomain());
    }

    public static boolean areInSameDomain(Member member1, Member member2) {
        return Arrays.equals((byte[])member1.getDomain(), (byte[])member2.getDomain());
    }
}

