/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesMembershipListener
implements MembershipListener {
    private static Log log = LogFactory.getLog(TribesMembershipListener.class);
    private MembershipManager membershipManager;

    public TribesMembershipListener(MembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public void memberAdded(Member member) {
        if (this.membershipManager.memberAdded(member)) {
            log.info("New member " + TribesUtil.getName(member) + " joined cluster.");
        }
    }

    public void memberDisappeared(Member member) {
        log.info("Member " + TribesUtil.getName(member) + " left cluster");
        this.membershipManager.memberDisappeared(member);
    }
}

