/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.LoadBalanceEventHandler;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.MembershipScheme;
import org.apache.axis2.clustering.RequestBlockingHandler;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.apache.axis2.clustering.context.ClusteringContextListener;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.context.DefaultContextManager;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.tribes.ApplicationMode;
import org.apache.axis2.clustering.tribes.ChannelListener;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.LoadBalancerMode;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.MulticastBasedMembershipScheme;
import org.apache.axis2.clustering.tribes.OperationMode;
import org.apache.axis2.clustering.tribes.RpcInitializationRequestHandler;
import org.apache.axis2.clustering.tribes.TribesMembershipListener;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.clustering.tribes.WkaBasedMembershipScheme;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.Phase;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TribesClusterManager
implements ClusterManager {
    private static final Log log = LogFactory.getLog(TribesClusterManager.class);
    private DefaultConfigurationManager configurationManager;
    private DefaultContextManager contextManager;
    private HashMap<String, Parameter> parameters;
    private ManagedChannel channel;
    private RpcChannel rpcInitChannel;
    private RpcChannel membershipRpcChannel;
    private ConfigurationContext configurationContext;
    private ChannelListener channelListener;
    private ChannelSender channelSender;
    private MembershipManager primaryMembershipManager;
    private RpcInitializationRequestHandler rpcInitRequestHandler;
    private MembershipScheme membershipScheme;
    private OperationMode mode;
    private List<Member> members;
    private final Map<String, LoadBalanceEventHandler> lbEventHandlers = new HashMap<String, LoadBalanceEventHandler>();
    private boolean loadBalanceMode;

    public TribesClusterManager() {
        this.parameters = new HashMap();
    }

    @Override
    public void setMembers(List<Member> members) {
        this.members = members;
    }

    @Override
    public List<Member> getMembers() {
        return this.members;
    }

    @Override
    public void addLoadBalanceEventHandler(LoadBalanceEventHandler eventHandler, String applicationDomain) {
        log.info("Load balancing for application domain " + applicationDomain + " using event handler " + eventHandler.getClass());
        this.lbEventHandlers.put(applicationDomain, eventHandler);
        this.loadBalanceMode = true;
    }

    @Override
    public LoadBalanceEventHandler getLoadBalanceEventHandler(String applicationDomain) {
        return this.lbEventHandlers.get(applicationDomain);
    }

    @Override
    public ContextManager getContextManager() {
        return this.contextManager;
    }

    @Override
    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    @Override
    public void init() throws ClusteringFault {
        log.info("Initializing cluster...");
        this.addRequestBlockingHandlerToInFlows();
        this.primaryMembershipManager = new MembershipManager(this.configurationContext);
        this.channel = new GroupChannel();
        this.channelSender = new ChannelSender((Channel)this.channel, this.primaryMembershipManager, this.synchronizeAllMembers());
        this.channelListener = new ChannelListener(this.configurationContext, this.configurationManager, this.contextManager);
        this.channel.addChannelListener((org.apache.catalina.tribes.ChannelListener)this.channelListener);
        byte[] domain = this.getClusterDomain();
        log.info("Cluster domain: " + new String(domain));
        this.primaryMembershipManager.setDomain(domain);
        this.rpcInitRequestHandler = new RpcInitializationRequestHandler(this.configurationContext);
        this.rpcInitChannel = new RpcChannel(TribesUtil.getRpcInitChannelId(domain), (Channel)this.channel, (RpcCallback)this.rpcInitRequestHandler);
        if (log.isDebugEnabled()) {
            log.debug("Created RPC Channel for domain " + new String(domain));
        }
        this.setMaximumRetries();
        this.configureMode(domain);
        this.configureMembershipScheme(domain, this.mode.getMembershipManagers());
        this.setMemberTransportInfo();
        TribesMembershipListener membershipListener = new TribesMembershipListener(this.primaryMembershipManager);
        this.channel.addMembershipListener((MembershipListener)membershipListener);
        try {
            this.channel.start(15);
            String localHost = TribesUtil.getLocalHost((Channel)this.channel);
            if (localHost.startsWith("127.0.")) {
                this.channel.stop(15);
                throw new ClusteringFault("Cannot join cluster using IP " + localHost + ". Please set an IP address other than " + localHost + " in the axis2.xml file");
            }
        }
        catch (ChannelException e) {
            String msg = "Error starting Tribes channel";
            log.error(msg, e);
            throw new ClusteringFault(msg, (Exception)((Object)e));
        }
        log.info("Local Member " + TribesUtil.getLocalHost((Channel)this.channel));
        TribesUtil.printMembers(this.primaryMembershipManager);
        this.membershipScheme.joinGroup();
        if (this.configurationManager != null) {
            this.configurationManager.setSender(this.channelSender);
            this.initializeSystem(new GetConfigurationCommand());
        }
        if (this.contextManager != null) {
            this.contextManager.setSender(this.channelSender);
            this.channelListener.setContextManager(this.contextManager);
            this.initializeSystem(new GetStateCommand());
            ClusteringContextListener contextListener = new ClusteringContextListener(this.channelSender);
            this.configurationContext.addContextListener(contextListener);
        }
        this.configurationContext.setNonReplicableProperty("local_cluster.initialized", "true");
        log.info("Cluster initialization completed.");
    }

    private void setMemberTransportInfo() throws ClusteringFault {
        Parameter port;
        TransportInDescription httpsTransport;
        Parameter port2;
        Properties transportInfo = new Properties();
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        TransportInDescription httpTransport = axisConfig.getTransportIn("http");
        if (httpTransport != null && (port2 = httpTransport.getParameter("port")) != null) {
            transportInfo.put("HTTP", port2.getValue());
        }
        if ((httpsTransport = axisConfig.getTransportIn("https")) != null && (port = httpsTransport.getParameter("port")) != null) {
            transportInfo.put("HTTPS", port.getValue());
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            transportInfo.store(bout, "");
        }
        catch (IOException e) {
            String msg = "Cannot store member transport properties in the ByteArrayOutputStream";
            log.error(msg, e);
            throw new ClusteringFault(msg, e);
        }
        this.channel.getMembershipService().setPayload(bout.toByteArray());
    }

    private String getMembershipScheme() throws ClusteringFault {
        Parameter membershipSchemeParam = this.getParameter("membershipScheme");
        String mbrScheme = "multicast";
        if (membershipSchemeParam != null) {
            mbrScheme = ((String)membershipSchemeParam.getValue()).trim();
        }
        if (!mbrScheme.equals("multicast") && !mbrScheme.equals("wka")) {
            String msg = "Invalid membership scheme '" + mbrScheme + "'. Supported schemes are " + "multicast" + " & " + "wka";
            log.error(msg);
            throw new ClusteringFault(msg);
        }
        return mbrScheme;
    }

    private byte[] getClusterDomain() {
        Parameter domainParam = this.getParameter("domain");
        byte[] domain = domainParam != null ? ((String)domainParam.getValue()).getBytes() : "apache.axis2.domain".getBytes();
        return domain;
    }

    private void setMaximumRetries() {
        Parameter maxRetriesParam = this.getParameter("maxRetries");
        int maxRetries = 10;
        if (maxRetriesParam != null) {
            maxRetries = Integer.parseInt((String)maxRetriesParam.getValue());
        }
        ReplicationTransmitter replicationTransmitter = (ReplicationTransmitter)this.channel.getChannelSender();
        MultiPointSender multiPointSender = replicationTransmitter.getTransport();
        multiPointSender.setMaxRetryAttempts(maxRetries);
    }

    private void addRequestBlockingHandlerToInFlows() {
        HandlerDescription handlerDesc;
        PhaseRule rule;
        RequestBlockingHandler requestBlockingHandler;
        Phase phase;
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        for (Object o : axisConfig.getInFlowPhases()) {
            phase = (Phase)o;
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) continue;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler(requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler(requestBlockingHandler);
            log.debug("Added RequestBlockingHandler between SOAPMessageBodyBasedDispatcher & InstanceDispatcher to InFlow");
            break;
        }
        for (Object o : axisConfig.getInFaultFlowPhases()) {
            phase = (Phase)o;
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) continue;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler(requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler(requestBlockingHandler);
            log.debug("Added RequestBlockingHandler between SOAPMessageBodyBasedDispatcher & InstanceDispatcher to InFaultFlow");
            break;
        }
    }

    private void configureMode(byte[] domain) {
        this.mode = this.loadBalanceMode ? new LoadBalancerMode(domain, this.lbEventHandlers, this.primaryMembershipManager) : new ApplicationMode(domain, this.primaryMembershipManager);
        this.mode.init((Channel)this.channel);
    }

    private void configureMembershipScheme(byte[] localDomain, List<MembershipManager> membershipManagers) throws ClusteringFault {
        String scheme = this.getMembershipScheme();
        log.info("Using " + scheme + " based membership management scheme");
        if (scheme.equals("wka")) {
            this.membershipScheme = new WkaBasedMembershipScheme(this.channel, this.mode, membershipManagers, this.primaryMembershipManager, this.parameters, localDomain, this.members);
        } else if (scheme.equals("multicast")) {
            this.membershipScheme = new MulticastBasedMembershipScheme(this.channel, this.mode, this.parameters, localDomain);
        } else {
            String msg = "Invalid membership scheme '" + scheme + "'. Supported schemes are multicast & wka";
            log.error(msg);
            throw new ClusteringFault(msg);
        }
        this.membershipScheme.init();
    }

    private void initializeSystem(ControlCommand command) throws ClusteringFault {
        int numberOfTries = 0;
        ArrayList<String> sentMembersList = new ArrayList<String>();
        sentMembersList.add(TribesUtil.getLocalHost((Channel)this.channel));
        org.apache.catalina.tribes.Member[] members = this.primaryMembershipManager.getMembers();
        if (members.length == 0) {
            return;
        }
        while (members.length > 0 && numberOfTries < 5) {
            org.apache.catalina.tribes.Member member = numberOfTries == 0 ? this.primaryMembershipManager.getLongestLivingMember() : this.primaryMembershipManager.getRandomMember();
            String memberHost = TribesUtil.getName(member);
            log.info("Trying to send intialization request to " + memberHost);
            try {
                if (!sentMembersList.contains(memberHost)) {
                    Response[] responses;
                    do {
                        if ((responses = this.rpcInitChannel.send(new org.apache.catalina.tribes.Member[]{member}, (Serializable)command, 1, 8, 10000L)).length != 0) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    } while (responses.length == 0 || responses[0] == null || responses[0].getMessage() == null);
                    ((ControlCommand)responses[0].getMessage()).execute(this.configurationContext);
                    break;
                }
            }
            catch (Exception e) {
                log.error("Cannot get initialization information from " + memberHost + ". Will retry in 2 secs.", e);
                sentMembersList.add(memberHost);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    log.debug("Interrupted", ignored);
                }
            }
            if (++numberOfTries < (members = this.primaryMembershipManager.getMembers()).length) continue;
            break;
        }
    }

    @Override
    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = (DefaultConfigurationManager)configurationManager;
        this.configurationManager.setSender(this.channelSender);
    }

    @Override
    public void setContextManager(ContextManager contextManager) {
        this.contextManager = (DefaultContextManager)contextManager;
        this.contextManager.setSender(this.channelSender);
    }

    @Override
    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    @Override
    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    @Override
    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public ArrayList getParameters() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (String msg : this.parameters.keySet()) {
            list.add(this.parameters.get(msg));
        }
        return list;
    }

    @Override
    public boolean isParameterLocked(String parameterName) {
        Parameter parameter = this.parameters.get(parameterName);
        return parameter != null && parameter.isLocked();
    }

    @Override
    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    @Override
    public void shutdown() throws ClusteringFault {
        log.debug("Enter: TribesClusterManager::shutdown");
        if (this.channel != null) {
            try {
                this.channel.removeChannelListener((org.apache.catalina.tribes.ChannelListener)this.rpcInitChannel);
                this.channel.removeChannelListener((org.apache.catalina.tribes.ChannelListener)this.channelListener);
                this.channel.stop(15);
            }
            catch (ChannelException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: TribesClusterManager::shutdown");
                }
                throw new ClusteringFault((Exception)((Object)e));
            }
        }
        log.debug("Exit: TribesClusterManager::shutdown");
    }

    @Override
    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        if (this.rpcInitRequestHandler != null) {
            this.rpcInitRequestHandler.setConfigurationContext(configurationContext);
        }
        if (this.channelListener != null) {
            this.channelListener.setConfigurationContext(configurationContext);
        }
        if (this.configurationManager != null) {
            this.configurationManager.setConfigurationContext(configurationContext);
        }
        if (this.contextManager != null) {
            this.contextManager.setConfigurationContext(configurationContext);
        }
    }

    public boolean synchronizeAllMembers() {
        Parameter syncAllParam = this.getParameter("synchronizeAll");
        return syncAllParam == null || Boolean.parseBoolean((String)syncAllParam.getValue());
    }
}

