/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.clustering.LoadBalanceEventHandler;
import org.apache.axis2.clustering.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLoadBalanceEventHandler
implements LoadBalanceEventHandler {
    private static final Log log = LogFactory.getLog(DefaultLoadBalanceEventHandler.class);
    private List<Member> members = new ArrayList<Member>();

    @Override
    public void applicationMemberAdded(Member member) {
        Thread th = new Thread(new MemberAdder(member));
        th.setPriority(10);
        th.start();
    }

    @Override
    public void applicationMemberRemoved(Member member) {
        log.info("Application member " + member + " left cluster.");
        this.members.remove(member);
    }

    @Override
    public List<Member> getMembers() {
        return this.members;
    }

    private class MemberAdder
    implements Runnable {
        private final Member member;

        private MemberAdder(Member member) {
            this.member = member;
        }

        public void run() {
            if (DefaultLoadBalanceEventHandler.this.members.contains(this.member)) {
                return;
            }
            if (this.canConnect(this.member)) {
                DefaultLoadBalanceEventHandler.this.members.add(this.member);
                log.info("Application member " + this.member + " joined application cluster");
            } else {
                log.error("Could not add application member " + this.member);
            }
        }

        private boolean canConnect(Member member) {
            if (log.isDebugEnabled()) {
                log.debug("Trying to connect to member " + member + "...");
            }
            for (int retries = 30; retries > 0; --retries) {
                try {
                    InetAddress addr = InetAddress.getByName(member.getHostName());
                    int httpPort = member.getHttpPort();
                    if (log.isDebugEnabled()) {
                        log.debug("HTTP Port=" + httpPort);
                    }
                    if (httpPort != -1) {
                        InetSocketAddress httpSockaddr = new InetSocketAddress(addr, httpPort);
                        new Socket().connect(httpSockaddr, 10000);
                    }
                    int httpsPort = member.getHttpsPort();
                    if (log.isDebugEnabled()) {
                        log.debug("HTTPS Port=" + httpPort);
                    }
                    if (httpsPort != -1) {
                        InetSocketAddress httpsSockaddr = new InetSocketAddress(addr, httpsPort);
                        new Socket().connect(httpsSockaddr, 10000);
                    }
                    return true;
                }
                catch (IOException e) {
                    String msg;
                    if (log.isDebugEnabled()) {
                        log.debug("", e);
                    }
                    if ((msg = e.getMessage()).indexOf("Connection refused") == -1 && msg.indexOf("connect timed out") == -1) {
                        log.error("Cannot connect to member " + member, e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    continue;
                }
            }
            return false;
        }
    }
}

