/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementHelper {
    private OMElement element;
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$om$util$ElementHelper == null ? (class$org$apache$axiom$om$util$ElementHelper = ElementHelper.class$("org.apache.axiom.om.util.ElementHelper")) : class$org$apache$axiom$om$util$ElementHelper);
    static /* synthetic */ Class class$org$apache$axiom$om$util$ElementHelper;

    public ElementHelper(OMElement element) {
        this.element = element;
    }

    public QName resolveQName(String qname, boolean defaultToParentNameSpace) {
        int colon = qname.indexOf(58);
        if (colon < 0) {
            OMNamespace namespace;
            if (defaultToParentNameSpace && (namespace = this.element.getNamespace()) != null) {
                if (namespace.getPrefix() == null) {
                    return new QName(namespace.getNamespaceURI(), qname);
                }
                return new QName(namespace.getNamespaceURI(), qname, namespace.getPrefix());
            }
            return new QName(qname);
        }
        String prefix = qname.substring(0, colon);
        String local = qname.substring(colon + 1);
        if (local.length() == 0) {
            return null;
        }
        OMNamespace namespace = this.element.findNamespaceURI(prefix);
        if (namespace == null) {
            return null;
        }
        return new QName(namespace.getNamespaceURI(), local, prefix);
    }

    public QName resolveQName(String qname) {
        return this.resolveQName(qname, true);
    }

    public static void setNewElement(OMElement parent, OMElement myElement, OMElement newElement) {
        if (myElement != null) {
            myElement.discard();
        }
        parent.addChild(newElement);
    }

    public static OMElement getChildWithName(OMElement parent, String childName) {
        Iterator childrenIter = parent.getChildren();
        while (childrenIter.hasNext()) {
            OMNode node = (OMNode)childrenIter.next();
            if (node.getType() != 1 || !childName.equals(((OMElement)node).getLocalName())) continue;
            return (OMElement)node;
        }
        return null;
    }

    public static String getContentID(XMLStreamReader parser, String charsetEncoding) {
        if (log.isDebugEnabled()) {
            log.debug("deprecated getContentID is being called");
        }
        return ElementHelper.getContentID(parser);
    }

    public static String getContentID(XMLStreamReader parser) {
        if (parser.getAttributeCount() > 0 && parser.getAttributeLocalName(0).equals("href")) {
            return ElementHelper.getContentIDFromHref(parser.getAttributeValue(0));
        }
        if (log.isDebugEnabled()) {
            int count = parser.getAttributeCount();
            log.debug("parser attribute count was : " + count);
            if (count > 0) {
                log.debug("getAttributeLocalName was : " + parser.getAttributeLocalName(0));
            }
        }
        throw new OMException("Href attribute not found in XOP:Include element");
    }

    public static String getContentIDFromHref(String href) {
        if (log.isDebugEnabled()) {
            log.debug("getContentIDFromHref called with : " + href);
        }
        if (href.startsWith("cid:")) {
            try {
                String uri = URLDecoder.decode(href.substring(4), "ascii");
                if (log.isDebugEnabled()) {
                    log.debug("getContentIDFromHref - decoded uri : " + uri);
                }
                return uri;
            }
            catch (UnsupportedEncodingException ex) {
                throw new OMException(ex);
            }
        }
        throw new OMException("href attribute didn't contain a valid \"cid:\" URI - found [" + href + "]");
    }

    public static OMElement importOMElement(OMElement omElement, OMFactory omFactory) {
        if (omElement.getOMFactory().getClass().isInstance(omFactory)) {
            return omElement;
        }
        OMElement documentElement = new StAXOMBuilder(omFactory, omElement.getXMLStreamReader()).getDocumentElement();
        documentElement.build();
        return documentElement;
    }

    public static SOAPHeaderBlock toSOAPHeaderBlock(OMElement omElement, SOAPFactory factory) throws Exception {
        if (omElement instanceof SOAPHeaderBlock) {
            return (SOAPHeaderBlock)omElement;
        }
        QName name = omElement.getQName();
        String localName = name.getLocalPart();
        OMNamespace namespace = factory.createOMNamespace(name.getNamespaceURI(), name.getPrefix());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        omElement.serialize(baos);
        ByteArrayDataSource bads = new ByteArrayDataSource(baos.toByteArray(), "utf-8");
        SOAPHeaderBlock block = factory.createSOAPHeaderBlock(localName, namespace, bads);
        return block;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

