/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.om.util.CommonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMSerializerUtil {
    private static Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$util$OMSerializerUtil == null ? (class$org$apache$axiom$om$impl$util$OMSerializerUtil = OMSerializerUtil.class$("org.apache.axiom.om.impl.util.OMSerializerUtil")) : class$org$apache$axiom$om$impl$util$OMSerializerUtil);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    private static boolean ADV_DEBUG_ENABLED = true;
    static long nsCounter = 0L;
    private static final String IS_SET_PREFIX_BEFORE_PROPERTY = "javax.xml.stream.XMLStreamWriter.isSetPrefixBeforeStartElement";
    private static ThreadLocal prefixCache = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[2];
        }
    };
    static /* synthetic */ Class class$org$apache$axiom$om$impl$util$OMSerializerUtil;

    public static void serializeEndpart(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    public static void serializeAttribute(OMAttribute attr, XMLStreamWriter writer) throws XMLStreamException {
        OMNamespace ns = attr.getNamespace();
        String prefix = null;
        String namespaceName = null;
        if (ns != null) {
            prefix = ns.getPrefix();
            namespaceName = ns.getNamespaceURI();
            if (prefix != null) {
                writer.writeAttribute(prefix, namespaceName, attr.getLocalName(), attr.getAttributeValue());
            } else {
                writer.writeAttribute(namespaceName, attr.getLocalName(), attr.getAttributeValue());
            }
        } else {
            String localName = attr.getLocalName();
            String attributeValue = attr.getAttributeValue();
            writer.writeAttribute(localName, attributeValue);
        }
    }

    public static void serializeNamespace(OMNamespace namespace, XMLStreamWriter writer) throws XMLStreamException {
        if (namespace == null) {
            return;
        }
        String uri = namespace.getNamespaceURI();
        String prefix = namespace.getPrefix();
        if (uri != null && !"".equals(uri)) {
            String prefixFromWriter = writer.getPrefix(uri);
            if ("".equals(prefix) && "".equals(prefixFromWriter) && !uri.equals(writer.getNamespaceContext().getNamespaceURI("")) || prefix != null && "".equals(prefix) && (prefixFromWriter == null || !prefix.equals(prefixFromWriter))) {
                writer.writeDefaultNamespace(uri);
                writer.setDefaultNamespace(uri);
            } else {
                String string = prefix = prefix == null ? OMSerializerUtil.getNextNSPrefix(writer) : prefix;
                if (prefix != null && !prefix.equals(prefixFromWriter) && !OMSerializerUtil.checkForPrefixInTheCurrentContext(writer, uri, prefix)) {
                    writer.writeNamespace(prefix, uri);
                    writer.setPrefix(prefix, uri);
                }
            }
        } else {
            String currentDefaultNSURI = writer.getNamespaceContext().getNamespaceURI("");
            if (currentDefaultNSURI != null && !currentDefaultNSURI.equals(uri) || uri != null && !uri.equals(currentDefaultNSURI)) {
                writer.writeDefaultNamespace(uri);
                writer.setDefaultNamespace(uri);
            }
        }
    }

    public static boolean isSetPrefixBeforeStartElement(XMLStreamWriter writer) {
        Object[] objects = (Object[])prefixCache.get();
        XMLStreamWriter cached_Writer = (XMLStreamWriter)objects[0];
        Boolean cached_Property = (Boolean)objects[1];
        if (cached_Writer == writer && cached_Property != null) {
            return cached_Property;
        }
        boolean ret = false;
        try {
            Boolean value = (Boolean)writer.getProperty(IS_SET_PREFIX_BEFORE_PROPERTY);
            if (value != null) {
                ret = value;
                objects[0] = writer;
                objects[1] = ret ? Boolean.TRUE : Boolean.FALSE;
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (!ret) {
            NamespaceContext nc = writer.getNamespaceContext();
            ret = nc == null || nc.getClass().getName().indexOf("wstx") == -1 && nc.getClass().getName().indexOf("sun") == -1;
        }
        objects[0] = writer;
        objects[1] = ret ? Boolean.TRUE : Boolean.FALSE;
        return ret;
    }

    public static void serializeStartpart(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        OMSerializerUtil.serializeStartpart(element, element.getLocalName(), writer);
    }

    public static void serializeStartpart(OMElement element, String localName, XMLStreamWriter writer) throws XMLStreamException {
        String namespace;
        String prefix;
        OMNamespace omNamespace;
        ArrayList<String> writePrefixList = null;
        ArrayList<String> writeNSList = null;
        OMNamespace eOMNamespace = element.getNamespace();
        String ePrefix = null;
        String eNamespace = null;
        if (eOMNamespace != null) {
            ePrefix = eOMNamespace.getPrefix();
            eNamespace = eOMNamespace.getNamespaceURI();
        }
        ePrefix = ePrefix != null && ePrefix.length() == 0 ? null : ePrefix;
        eNamespace = eNamespace != null && eNamespace.length() == 0 ? null : eNamespace;
        boolean setPrefixFirst = OMSerializerUtil.isSetPrefixBeforeStartElement(writer);
        if (!setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    if (!OMSerializerUtil.isAssociated("", eNamespace, writer)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList<String>();
                            writeNSList = new ArrayList<String>();
                        }
                        if (!writePrefixList.contains("")) {
                            writePrefixList.add("");
                            writeNSList.add(eNamespace);
                        }
                    }
                    writer.writeStartElement("", localName, eNamespace);
                } else {
                    if (!OMSerializerUtil.isAssociated(ePrefix, eNamespace, writer)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList();
                            writeNSList = new ArrayList();
                        }
                        if (!writePrefixList.contains(ePrefix)) {
                            writePrefixList.add(ePrefix);
                            writeNSList.add(eNamespace);
                        }
                    }
                    writer.writeStartElement(ePrefix, localName, eNamespace);
                }
            } else {
                writer.writeStartElement(localName);
            }
        }
        Iterator it = element.getAllDeclaredNamespaces();
        while (it != null && it.hasNext()) {
            String newPrefix;
            OMNamespace omNamespace2 = (OMNamespace)it.next();
            String prefix2 = null;
            String namespace2 = null;
            if (omNamespace2 != null) {
                prefix2 = omNamespace2.getPrefix();
                namespace2 = omNamespace2.getNamespaceURI();
            }
            if ((newPrefix = OMSerializerUtil.generateSetPrefix(prefix2 = prefix2 != null && prefix2.length() == 0 ? null : prefix2, namespace2 = namespace2 != null && namespace2.length() == 0 ? null : namespace2, writer, false, setPrefixFirst)) == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace2);
        }
        String newPrefix = OMSerializerUtil.generateSetPrefix(ePrefix, eNamespace, writer, false, setPrefixFirst);
        if (newPrefix != null) {
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (!writePrefixList.contains(newPrefix)) {
                writePrefixList.add(newPrefix);
                writeNSList.add(eNamespace);
            }
        }
        Iterator attrs = element.getAllAttributes();
        while (attrs != null && attrs.hasNext()) {
            OMAttribute attr = (OMAttribute)attrs.next();
            omNamespace = attr.getNamespace();
            prefix = null;
            namespace = null;
            if (omNamespace != null) {
                prefix = omNamespace.getPrefix();
                namespace = omNamespace.getNamespaceURI();
            }
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            String string = namespace = namespace != null && namespace.length() == 0 ? null : namespace;
            if (prefix == null && namespace != null) {
                String writerPrefix = writer.getPrefix(namespace);
                writerPrefix = writerPrefix != null && writerPrefix.length() == 0 ? null : writerPrefix;
                String string2 = prefix = writerPrefix != null ? writerPrefix : OMSerializerUtil.getNextNSPrefix();
            }
            if ((newPrefix = OMSerializerUtil.generateSetPrefix(prefix, namespace, writer, true, setPrefixFirst)) == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace);
        }
        if (setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    writer.writeStartElement("", localName, eNamespace);
                } else {
                    writer.writeStartElement(ePrefix, localName, eNamespace);
                }
            } else {
                writer.writeStartElement(localName);
            }
        }
        if (writePrefixList != null) {
            for (int i = 0; i < writePrefixList.size(); ++i) {
                String prefix3 = (String)writePrefixList.get(i);
                String namespace3 = (String)writeNSList.get(i);
                if (prefix3 != null) {
                    if (namespace3 == null) {
                        writer.writeNamespace(prefix3, "");
                        continue;
                    }
                    writer.writeNamespace(prefix3, namespace3);
                    continue;
                }
                writer.writeDefaultNamespace(namespace3);
            }
        }
        attrs = element.getAllAttributes();
        while (attrs != null && attrs.hasNext()) {
            String writerPrefix;
            OMAttribute attr = (OMAttribute)attrs.next();
            omNamespace = attr.getNamespace();
            prefix = null;
            namespace = null;
            if (omNamespace != null) {
                prefix = omNamespace.getPrefix();
                namespace = omNamespace.getNamespaceURI();
            }
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            String string = namespace = namespace != null && namespace.length() == 0 ? null : namespace;
            if (prefix == null && namespace != null) {
                prefix = writer.getPrefix(namespace);
                if (prefix == null || "".equals(prefix)) {
                    for (int i = 0; i < writePrefixList.size(); ++i) {
                        if (!namespace.equals((String)writeNSList.get(i))) continue;
                        prefix = (String)writePrefixList.get(i);
                    }
                }
            } else if (namespace != null && !prefix.equals(writerPrefix = writer.getPrefix(namespace)) && writerPrefix != null && !"".equals(writerPrefix)) {
                prefix = writerPrefix;
            }
            if (namespace != null) {
                if (prefix == null && "http://www.w3.org/XML/1998/namespace".equals(namespace)) {
                    prefix = "xml";
                }
                writer.writeAttribute(prefix, namespace, attr.getLocalName(), attr.getAttributeValue());
                continue;
            }
            writer.writeAttribute(attr.getLocalName(), attr.getAttributeValue());
        }
    }

    private static boolean checkForPrefixInTheCurrentContext(XMLStreamWriter writer, String nameSpaceName, String prefix) throws XMLStreamException {
        Iterator<String> prefixesIter = writer.getNamespaceContext().getPrefixes(nameSpaceName);
        while (prefixesIter.hasNext()) {
            String prefix_w = prefixesIter.next();
            if (!prefix_w.equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public static void serializeNamespaces(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        Iterator namespaces = element.getAllDeclaredNamespaces();
        if (namespaces != null) {
            while (namespaces.hasNext()) {
                OMSerializerUtil.serializeNamespace((OMNamespace)namespaces.next(), writer);
            }
        }
    }

    public static void serializeAttributes(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        Iterator attributes = element.getAllAttributes();
        if (attributes != null && attributes.hasNext()) {
            while (attributes.hasNext()) {
                OMSerializerUtil.serializeAttribute((OMAttribute)attributes.next(), writer);
            }
        }
    }

    public static void serializeNormal(OMElement element, XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (cache) {
            element.build();
        }
        OMSerializerUtil.serializeStartpart(element, writer);
        OMNode firstChild = element.getFirstOMChild();
        if (firstChild != null) {
            if (cache) {
                firstChild.serialize(writer);
            } else {
                firstChild.serializeAndConsume(writer);
            }
        }
        OMSerializerUtil.serializeEndpart(writer);
    }

    public static void serializeByPullStream(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        OMSerializerUtil.serializeByPullStream(element, writer, false);
    }

    public static void serializeByPullStream(OMElement element, XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        StreamingOMSerializer streamingOMSerializer = new StreamingOMSerializer();
        if (cache) {
            streamingOMSerializer.serialize(element.getXMLStreamReader(), writer);
        } else {
            XMLStreamReader xmlStreamReaderWithoutCaching = element.getXMLStreamReaderWithoutCaching();
            streamingOMSerializer.serialize(xmlStreamReaderWithoutCaching, writer);
        }
    }

    public static String getNextNSPrefix() {
        String prefix = "axis2ns" + ++nsCounter % Long.MAX_VALUE;
        if (DEBUG_ENABLED) {
            log.debug("Obtained next prefix:" + prefix);
            if (ADV_DEBUG_ENABLED) {
                log.debug(CommonUtils.callStackToString());
            }
        }
        return prefix;
    }

    public static String getNextNSPrefix(XMLStreamWriter writer) {
        String prefix = OMSerializerUtil.getNextNSPrefix();
        while (writer.getNamespaceContext().getNamespaceURI(prefix) != null) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        return prefix;
    }

    public static String generateSetPrefix(String prefix, String namespace, XMLStreamWriter writer, boolean attr, boolean isSetPrefixFirst) throws XMLStreamException {
        String string = prefix = prefix == null ? "" : prefix;
        if (OMSerializerUtil.isAssociated(prefix, namespace, writer)) {
            return null;
        }
        if (prefix.length() == 0 && namespace == null && attr) {
            return null;
        }
        String newPrefix = null;
        if (namespace != null) {
            if (prefix.length() == 0) {
                writer.setDefaultNamespace(namespace);
                newPrefix = "";
            } else {
                writer.setPrefix(prefix, namespace);
                newPrefix = prefix;
            }
        } else {
            writer.setDefaultNamespace("");
            newPrefix = "";
        }
        return newPrefix;
    }

    public static boolean isAssociated(String prefix, String namespace, XMLStreamWriter writer) throws XMLStreamException {
        String writerNS;
        NamespaceContext nsContext;
        block7: {
            prefix = prefix == null ? "" : prefix;
            String string = namespace = namespace == null ? "" : namespace;
            if (namespace.length() > 0) {
                NamespaceContext nsContext2;
                String writerPrefix = writer.getPrefix(namespace);
                if (prefix.equals(writerPrefix)) {
                    return true;
                }
                if (writerPrefix != null && (nsContext2 = writer.getNamespaceContext()) != null) {
                    String writerNS2 = nsContext2.getNamespaceURI(prefix);
                    return namespace.equals(writerNS2);
                }
                return false;
            }
            if (prefix.length() > 0) {
                return true;
            }
            try {
                String writerPrefix = writer.getPrefix("");
                if (writerPrefix != null && writerPrefix.length() == 0) {
                    return true;
                }
            }
            catch (Throwable t) {
                if (!DEBUG_ENABLED) break block7;
                log.debug("Caught exception from getPrefix(\"\"). Processing continues: " + t);
            }
        }
        return (nsContext = writer.getNamespaceContext()) == null || (writerNS = nsContext.getNamespaceURI("")) == null || writerNS.length() <= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

