/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMSourcedElementImpl
extends OMElementImpl
implements OMSourcedElement {
    private OMDataSource dataSource;
    private OMNamespace definedNamespace = null;
    private boolean isExpanded = false;
    private static Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl == null ? (class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl = OMSourcedElementImpl.class$("org.apache.axiom.om.impl.llom.OMSourcedElementImpl")) : class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private XMLStreamReader readerFromDS = null;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl;

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMFactory factory, OMDataSource source) {
        super(localName, null, factory);
        this.dataSource = source;
        boolean bl = this.isExpanded = this.dataSource == null;
        this.definedNamespace = !this.isExpanded ? (!this.isLossyPrefix(this.dataSource) ? ns : new DeferredNamespace(ns.getNamespaceURI())) : ns;
    }

    public OMSourcedElementImpl(QName qName, OMFactory factory, OMDataSource source) {
        super(qName.getLocalPart(), null, factory);
        this.dataSource = source;
        boolean bl = this.isExpanded = this.dataSource == null;
        this.definedNamespace = !this.isExpanded ? (!this.isLossyPrefix(this.dataSource) ? new OMNamespaceImpl(qName.getNamespaceURI(), qName.getPrefix()) : new DeferredNamespace(qName.getNamespaceURI())) : new OMNamespaceImpl(qName.getNamespaceURI(), qName.getPrefix());
    }

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMContainer parent, OMFactory factory) {
        super(localName, null, parent, factory);
        this.dataSource = null;
        this.definedNamespace = ns;
        this.isExpanded = true;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(localName, null, parent, builder, factory);
        this.dataSource = null;
        this.definedNamespace = ns;
        this.isExpanded = true;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMFactory factory) {
        super(localName, null, factory);
        this.dataSource = null;
        this.definedNamespace = ns;
        this.isExpanded = true;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    private boolean isLossyPrefix(OMDataSource source) {
        Object lossyPrefix = null;
        if (source instanceof OMDataSourceExt) {
            lossyPrefix = ((OMDataSourceExt)source).getProperty("lossyPrefix");
        }
        return lossyPrefix == Boolean.TRUE;
    }

    private void setDeferredNamespace(OMDataSource source, String uri, String prefix) {
        Object lossyPrefix = null;
        if (source instanceof OMDataSourceExt) {
            lossyPrefix = ((OMDataSourceExt)source).getProperty("lossyPrefix");
        }
        this.definedNamespace = lossyPrefix != Boolean.TRUE ? new OMNamespaceImpl(uri, prefix) : new DeferredNamespace(uri);
    }

    private String getPrintableName() {
        String uri = this.getNamespace().getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return this.getLocalName();
        }
        return "{" + uri + '}' + this.getLocalName();
    }

    private XMLStreamReader getDirectReader() {
        try {
            if (this.isExpanded()) {
                return super.getXMLStreamReader();
            }
            return this.dataSource.getReader();
        }
        catch (XMLStreamException e) {
            log.error("Could not get parser from data source for element " + this.getPrintableName(), e);
            throw new RuntimeException("Error obtaining parser from data source:" + e.getMessage());
        }
    }

    private void forceExpand() {
        if (!this.isExpanded) {
            String uri;
            if (isDebugEnabled) {
                log.debug("forceExpand: expanding element " + this.getPrintableName());
            }
            this.readerFromDS = this.getDirectReader();
            String characterEncoding = this.readerFromDS.getCharacterEncodingScheme();
            if (characterEncoding != null) {
                characterEncoding = this.readerFromDS.getEncoding();
            }
            try {
                if (this.readerFromDS.getEventType() != 1) {
                    while (this.readerFromDS.next() != 1) {
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error("forceExpand: error parsing data soruce document for element " + this.getLocalName(), e);
                throw new RuntimeException("Error parsing data source document:" + e.getMessage());
            }
            if (!this.readerFromDS.getLocalName().equals(this.getLocalName())) {
                log.error("forceExpand: expected element name " + this.getLocalName() + ", found " + this.readerFromDS.getLocalName());
                throw new RuntimeException("Element name from data source is " + this.readerFromDS.getLocalName() + ", not the expected " + this.getLocalName());
            }
            String readerURI = this.readerFromDS.getNamespaceURI();
            readerURI = readerURI == null ? "" : readerURI;
            if (!readerURI.equals(uri = this.getNamespace().getNamespaceURI())) {
                log.error("forceExpand: expected element namespace " + this.getLocalName() + ", found " + uri);
                throw new RuntimeException("Element namespace from data source is " + readerURI + ", not the expected " + uri);
            }
            String readerPrefix = this.readerFromDS.getPrefix();
            readerPrefix = readerPrefix == null ? "" : readerPrefix;
            String prefix = null;
            OMNamespace ns = this.getNamespace();
            if (!(ns instanceof DeferredNamespace)) {
                prefix = ns.getPrefix();
            }
            this.isExpanded = true;
            super.setBuilder(new StAXOMBuilder(this.getOMFactory(), this.readerFromDS, this, characterEncoding));
            this.setComplete(false);
            if (!readerPrefix.equals(prefix) || this.getNamespace() == null || ns instanceof DeferredNamespace) {
                if (log.isDebugEnabled()) {
                    log.debug("forceExpand: changing prefix from " + prefix + " to " + readerPrefix);
                }
                this.setNamespace(new OMNamespaceImpl(readerURI, readerPrefix));
            }
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public Iterator getChildElements() {
        this.forceExpand();
        return super.getChildElements();
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.declareNamespace(uri, prefix);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        this.forceExpand();
        return super.declareDefaultNamespace(uri);
    }

    public OMNamespace getDefaultNamespace() {
        this.forceExpand();
        return super.getDefaultNamespace();
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        this.forceExpand();
        return super.declareNamespace(namespace);
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.findNamespace(uri, prefix);
    }

    public OMNamespace findNamespaceURI(String prefix) {
        this.forceExpand();
        return super.findNamespaceURI(prefix);
    }

    public Iterator getAllDeclaredNamespaces() throws OMException {
        this.forceExpand();
        return super.getAllDeclaredNamespaces();
    }

    public Iterator getAllAttributes() {
        this.forceExpand();
        return super.getAllAttributes();
    }

    public OMAttribute getAttribute(QName qname) {
        this.forceExpand();
        return super.getAttribute(qname);
    }

    public String getAttributeValue(QName qname) {
        this.forceExpand();
        return super.getAttributeValue(qname);
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        this.forceExpand();
        return super.addAttribute(attr);
    }

    public OMAttribute addAttribute(String attributeName, String value, OMNamespace namespace) {
        this.forceExpand();
        return super.addAttribute(attributeName, value, namespace);
    }

    public void removeAttribute(OMAttribute attr) {
        this.forceExpand();
        super.removeAttribute(attr);
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        throw new UnsupportedOperationException("Builder cannot be set for element backed by data source");
    }

    public OMXMLParserWrapper getBuilder() {
        this.forceExpand();
        return super.getBuilder();
    }

    public void setFirstChild(OMNode node) {
        this.forceExpand();
        super.setFirstChild(node);
    }

    public void setLastChild(OMNode omNode) {
        this.forceExpand();
        super.setLastChild(omNode);
    }

    public OMElement getFirstElement() {
        this.forceExpand();
        return super.getFirstElement();
    }

    public XMLStreamReader getXMLStreamReader() {
        if (isDebugEnabled) {
            log.debug("getting XMLStreamReader for " + this.getPrintableName());
        }
        if (this.isExpanded) {
            return super.getXMLStreamReader();
        }
        if (this.isDestructiveRead()) {
            this.forceExpand();
            return super.getXMLStreamReader();
        }
        return this.getDirectReader();
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        if (isDebugEnabled) {
            log.debug("getting XMLStreamReader without caching for " + this.getPrintableName());
        }
        if (this.isExpanded) {
            XMLStreamReader reader = super.getXMLStreamReaderWithoutCaching();
            return reader;
        }
        return this.getDirectReader();
    }

    public void setText(String text) {
        this.forceExpand();
        super.setText(text);
    }

    public void setText(QName text) {
        this.forceExpand();
        super.setText(text);
    }

    public String getText() {
        this.forceExpand();
        return super.getText();
    }

    public QName getTextAsQName() {
        this.forceExpand();
        return super.getTextAsQName();
    }

    public String getLocalName() {
        return super.getLocalName();
    }

    public void setLocalName(String localName) {
        super.setLocalName(localName);
    }

    public OMNamespace getNamespace() throws OMException {
        if (this.isExpanded()) {
            return super.getNamespace();
        }
        return this.definedNamespace;
    }

    public void setNamespace(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespace(namespace);
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespaceWithNoFindInCurrentScope(namespace);
    }

    public QName getQName() {
        if (this.isExpanded()) {
            return super.getQName();
        }
        if (this.getNamespace() != null) {
            return new QName(this.getNamespace().getNamespaceURI(), this.getLocalName());
        }
        return new QName(this.getLocalName());
    }

    public String toStringWithConsume() throws XMLStreamException {
        if (this.isExpanded()) {
            return super.toStringWithConsume();
        }
        StringWriter writer = new StringWriter();
        XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter(writer);
        this.dataSource.serialize(writer2);
        writer2.flush();
        return writer.toString();
    }

    private boolean isDestructiveWrite() {
        if (this.dataSource instanceof OMDataSourceExt) {
            return ((OMDataSourceExt)this.dataSource).isDestructiveWrite();
        }
        return true;
    }

    private boolean isDestructiveRead() {
        if (this.dataSource instanceof OMDataSourceExt) {
            return ((OMDataSourceExt)this.dataSource).isDestructiveRead();
        }
        return false;
    }

    public QName resolveQName(String qname) {
        this.forceExpand();
        return super.resolveQName(qname);
    }

    public OMElement cloneOMElement() {
        this.forceExpand();
        return super.cloneOMElement();
    }

    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
    }

    public int getLineNumber() {
        return super.getLineNumber();
    }

    public void discard() throws OMException {
        this.setComplete(true);
        super.detach();
    }

    public int getType() {
        return super.getType();
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        if (this.isExpanded()) {
            super.internalSerialize(writer);
        } else if (this.isDestructiveWrite()) {
            this.forceExpand();
            super.internalSerialize(writer);
        } else {
            this.dataSource.serialize(writer);
        }
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (this.isExpanded()) {
            super.internalSerialize(writer, cache);
        } else if (cache) {
            if (this.isDestructiveWrite()) {
                this.forceExpand();
                super.internalSerialize(writer, true);
            } else {
                this.dataSource.serialize(writer);
            }
        } else {
            this.internalSerializeAndConsume(writer);
        }
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("serialize " + this.getPrintableName() + " to XMLStreamWriter");
        }
        if (this.isExpanded()) {
            super.internalSerializeAndConsume(writer);
        } else {
            this.dataSource.serialize(writer);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerialize(xmlWriter);
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        OMOutputFormat format = new OMOutputFormat();
        this.serialize(output, format);
    }

    public void serialize(Writer writer) throws XMLStreamException {
        OMOutputFormat format = new OMOutputFormat();
        this.serialize(writer, format);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        if (this.isDestructiveWrite()) {
            this.forceExpand();
            super.serialize(output, format);
        } else {
            this.dataSource.serialize(output, format);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        if (this.isDestructiveWrite()) {
            this.forceExpand();
            super.serialize(writer, format);
        } else {
            this.dataSource.serialize(writer, format);
        }
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerializeAndConsume(xmlWriter);
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("serialize " + this.getPrintableName() + " to output stream");
        }
        OMOutputFormat format = new OMOutputFormat();
        format.setAutoCloseWriter(true);
        if (this.isExpanded()) {
            super.serializeAndConsume(output, format);
        } else {
            this.dataSource.serialize(output, format);
        }
    }

    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("serialize " + this.getPrintableName() + " to writer");
        }
        if (this.isExpanded()) {
            super.serializeAndConsume(writer);
        } else {
            OMOutputFormat format = new OMOutputFormat();
            format.setAutoCloseWriter(true);
            this.dataSource.serialize(writer, format);
        }
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("serialize formatted " + this.getPrintableName() + " to output stream");
        }
        if (this.isExpanded()) {
            super.serializeAndConsume(output, format);
        } else {
            this.dataSource.serialize(output, format);
        }
    }

    public void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("serialize formatted " + this.getPrintableName() + " to writer");
        }
        if (this.isExpanded()) {
            super.serializeAndConsume(writer, format);
        } else {
            this.dataSource.serialize(writer, format);
        }
    }

    public void addChild(OMNode omNode) {
        this.forceExpand();
        super.addChild(omNode);
    }

    public Iterator getChildrenWithName(QName elementQName) {
        this.forceExpand();
        return super.getChildrenWithName(elementQName);
    }

    public Iterator getChildrenWithLocalName(String localName) {
        this.forceExpand();
        return super.getChildrenWithLocalName(localName);
    }

    public Iterator getChildrenWithNamespaceURI(String uri) {
        this.forceExpand();
        return super.getChildrenWithNamespaceURI(uri);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        this.forceExpand();
        return super.getFirstChildWithName(elementQName);
    }

    public Iterator getChildren() {
        this.forceExpand();
        return super.getChildren();
    }

    public OMNode getFirstOMChild() {
        this.forceExpand();
        return super.getFirstOMChild();
    }

    public void buildNext() {
        this.forceExpand();
        super.buildNext();
    }

    public OMNode detach() throws OMException {
        boolean complete = this.isComplete();
        this.setComplete(true);
        OMNode result = super.detach();
        this.setComplete(complete);
        return result;
    }

    public OMNode getNextOMSibling() throws OMException {
        return super.getNextOMSibling();
    }

    public String getTrimmedText() {
        this.forceExpand();
        return super.getTrimmedText();
    }

    OMNamespace handleNamespace(QName qname) {
        this.forceExpand();
        return super.handleNamespace(qname);
    }

    public boolean isComplete() {
        if (this.isExpanded) {
            return super.isComplete();
        }
        return true;
    }

    public String toString() {
        if (this.isDestructiveWrite()) {
            this.forceExpand();
            return super.toString();
        }
        try {
            StringWriter writer = new StringWriter();
            OMOutputFormat format = new OMOutputFormat();
            this.dataSource.serialize(writer, format);
            String text = writer.toString();
            writer.close();
            return text;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cannot serialize OM Element " + this.getLocalName(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize OM Element " + this.getLocalName(), e);
        }
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        if (this.isExpanded()) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                node.buildWithAttachments();
            }
        }
    }

    public void build() throws OMException {
        super.build();
    }

    protected void notifyChildComplete() {
        super.notifyChildComplete();
    }

    OMNamespace handleNamespace(String namespaceURI, String prefix) {
        return super.handleNamespace(namespaceURI, prefix);
    }

    public OMDataSource getDataSource() {
        return this.dataSource;
    }

    public OMDataSource setDataSource(OMDataSource dataSource) {
        if (!this.isExpanded()) {
            OMDataSource oldDS = this.dataSource;
            this.dataSource = dataSource;
            return oldDS;
        }
        OMDataSource oldDS = this.dataSource;
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            OMNode node = (OMNode)it.next();
            node.detach();
        }
        this.dataSource = dataSource;
        this.setComplete(false);
        this.isExpanded = false;
        if (this.isLossyPrefix(dataSource)) {
            this.definedNamespace = new DeferredNamespace(this.definedNamespace.getNamespaceURI());
        }
        return oldDS;
    }

    public void setComplete(boolean value) {
        this.done = value;
        if (this.done) {
            if (this.readerFromDS != null) {
                try {
                    this.readerFromDS.close();
                }
                catch (XMLStreamException e) {
                    // empty catch block
                }
                this.readerFromDS = null;
            }
            if (this.dataSource != null) {
                if (this.dataSource instanceof OMDataSourceExt) {
                    ((OMDataSourceExt)this.dataSource).close();
                }
                this.dataSource = null;
            }
        }
        if (this.done && this.readerFromDS != null) {
            try {
                this.readerFromDS.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            this.readerFromDS = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DeferredNamespace
    implements OMNamespace {
        String uri;

        DeferredNamespace(String ns) {
            this.uri = ns;
        }

        public boolean equals(String uri, String prefix) {
            String thisPrefix = this.getPrefix();
            return this.uri.equals(uri) && (thisPrefix == null ? prefix == null : thisPrefix.equals(prefix));
        }

        public String getName() {
            return this.uri;
        }

        public String getNamespaceURI() {
            return this.uri;
        }

        public String getPrefix() {
            if (!OMSourcedElementImpl.this.isExpanded()) {
                OMSourcedElementImpl.this.forceExpand();
            }
            return OMSourcedElementImpl.this.getNamespace().getPrefix();
        }

        public int hashCode() {
            String thisPrefix = this.getPrefix();
            return this.uri.hashCode() ^ (thisPrefix != null ? thisPrefix.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OMNamespace)) {
                return false;
            }
            OMNamespace other = (OMNamespace)obj;
            String otherPrefix = other.getPrefix();
            String thisPrefix = this.getPrefix();
            return this.uri.equals(other.getNamespaceURI()) && (thisPrefix == null ? otherPrefix == null : thisPrefix.equals(otherPrefix));
        }
    }
}

