/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int permits) {
        this.sync = new NonfairSync(permits);
    }

    public Semaphore(int permits, boolean fair) {
        this.sync = fair ? new FairSync(permits) : new NonfairSync(permits);
    }

    public void acquire() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public void acquireUninterruptibly() {
        this.sync.acquireShared(1);
    }

    public boolean tryAcquire() {
        return this.sync.nonfairTryAcquireShared(1) >= 0;
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void release() {
        this.sync.releaseShared(1);
    }

    public void acquire(int permits) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireSharedInterruptibly(permits);
    }

    public void acquireUninterruptibly(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireShared(permits);
    }

    public boolean tryAcquire(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.nonfairTryAcquireShared(permits) >= 0;
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.tryAcquireSharedNanos(permits, unit.toNanos(timeout));
    }

    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.releaseShared(permits);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drainPermits();
    }

    protected void reducePermits(int reduction) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reducePermits(reduction);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        if (!this.isFair()) {
            throw new UnsupportedOperationException("Use FAIR version");
        }
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        if (!this.isFair()) {
            throw new UnsupportedOperationException("Use FAIR version");
        }
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        if (!this.isFair()) {
            throw new UnsupportedOperationException("Use FAIR version");
        }
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + "]";
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = 2014338818796000944L;

        FairSync(int permits) {
            super(permits);
        }

        protected int tryAcquireShared(int acquires) {
            int available;
            int remaining;
            Thread current = Thread.currentThread();
            do {
                Thread first;
                if ((first = this.getFirstQueuedThread()) == null || first == current) continue;
                return -1;
            } while ((remaining = (available = this.getState()) - acquires) >= 0 && !this.compareAndSetState(available, remaining));
            return remaining;
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        NonfairSync(int permits) {
            super(permits);
        }

        protected int tryAcquireShared(int acquires) {
            return this.nonfairTryAcquireShared(acquires);
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1192457210091910933L;

        Sync(int permits) {
            this.setState(permits);
        }

        final int getPermits() {
            return this.getState();
        }

        final int nonfairTryAcquireShared(int acquires) {
            int available;
            int remaining;
            while ((remaining = (available = this.getState()) - acquires) >= 0 && !this.compareAndSetState(available, remaining)) {
            }
            return remaining;
        }

        protected final boolean tryReleaseShared(int releases) {
            int p;
            while (!this.compareAndSetState(p = this.getState(), p + releases)) {
            }
            return true;
        }

        final void reducePermits(int reductions) {
            int next;
            int current;
            while (!this.compareAndSetState(current = this.getState(), next = current - reductions)) {
            }
        }

        final int drainPermits() {
            int current;
            while ((current = this.getState()) != 0 && !this.compareAndSetState(current, 0)) {
            }
            return current;
        }
    }
}

