/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DocumentScanner;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.Symbol;
import com.ibm.xml.xlxp2.scan.util.SymbolMapHolder;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class SymbolMap
implements Cloneable {
    private static final boolean TRACE_REBALANCING = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("trace.symbol.map.rebalancing");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private static final boolean TRACE_ADDITIONS = false;
    private static final boolean CHECK_DUPLICATES = false;
    private static final boolean DUMP_TABLES = false;
    private static final boolean CHECK_SYMBOLS = false;
    private static final boolean REBALANCE_BUCKETS = true;
    private static final int INITIAL_ALLOCATION_SIZE = 8192;
    private static final int B_HASHCODE = 0;
    private static final int B_NEXT = 1;
    private static final int B_NSTART = 2;
    private static final int B_NEND = 3;
    private static final int B_SYMINDEX = 4;
    private static final int B_SIZE = 5;
    private static int fgInstanceCounter;
    SymbolMap parent;
    int id;
    private Symbol[] fSymbols = ArrayAllocator.newObjectArray(Symbol.class, 256);
    private DataBufferFactory fBufferFactory;
    private DataBuffer fSymbolBuffer;
    byte[] fSymbolBytes;
    private int fSymbolBytesOffset = 1;
    private boolean immutable;
    private boolean rebalancing;
    private int[] fTable = ArrayAllocator.newIntArray(2560);
    private int[] fBuckets = ArrayAllocator.newIntArray(640);
    private int fNextBucketBase = 5;
    private int fMask = 511;
    private XMLString fSymbolSubstring;
    private int fSymbolCount = 0;
    private int fResetCount;
    private int fNextRebalanceCount;
    private final int fCountHitsResetCount;
    private int fRebalanceCountFreq = 64;
    private boolean fCountHits;

    SymbolMap() {
        this.fCountHitsResetCount = 16;
        this.fSymbolBytes = ArrayAllocator.newByteArray(8192);
        this.fBufferFactory = new SimpleDataBufferFactory();
        this.fSymbolBuffer = this.fBufferFactory.createBuffer();
        this.fSymbolBuffer.bytes = this.fSymbolBytes;
        this.fSymbolBuffer.startOffset = 1;
        this.fSymbolBuffer.endOffset = this.fSymbolBytesOffset;
        this.fSymbolSubstring = new XMLString();
        this.fNextRebalanceCount = this.fRebalanceCountFreq;
        this.fRebalanceCountFreq <<= 1;
        this.put("");
        this.put("xmlns");
        this.id = fgInstanceCounter++;
    }

    public SymbolMap clone() {
        try {
            SymbolMap symbolMap = (SymbolMap)super.clone();
            symbolMap.id = fgInstanceCounter++;
            symbolMap.parent = this;
            symbolMap.fSymbolSubstring = new XMLString();
            return symbolMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    SymbolMap prepareForSharing() {
        if (!this.immutable) {
            this.immutable = true;
            this.fSymbolSubstring = null;
            this.fCountHits = false;
            this.fNextRebalanceCount = this.fRebalanceCountFreq = 64;
            this.fRebalanceCountFreq <<= 1;
            this.fResetCount = 0;
        }
        return this;
    }

    void reset(boolean bl, SymbolMapHolder symbolMapHolder) {
        if (this.parent != null) {
            this.fCountHits = this.parent.checkForRebalance(symbolMapHolder, this);
        } else {
            this.checkForRebalance(symbolMapHolder, null);
        }
    }

    boolean checkForRebalance(SymbolMapHolder symbolMapHolder, SymbolMap symbolMap) {
        if (this.rebalancing) {
            return false;
        }
        ++this.fResetCount;
        if (this.fResetCount == this.fNextRebalanceCount) {
            if (this.fCountHits) {
                this.rebalancing = true;
                this.fCountHits = false;
                if (this.tablesBalanced()) {
                    this.fRebalanceCountFreq <<= 1;
                } else if (symbolMap != null) {
                    if (TRACE_REBALANCING) {
                        System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** Rebalancing SymbolMap " + this.id + " using child SymbolMap " + symbolMap.id);
                    }
                    symbolMapHolder.rebalanceMap(symbolMap);
                } else {
                    if (TRACE_REBALANCING) {
                        System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** Rebalancing SymbolMap " + this.id);
                    }
                    this.rebalanceTables();
                }
                this.fNextRebalanceCount += this.fRebalanceCountFreq;
                this.fRebalanceCountFreq <<= 1;
                this.rebalancing = false;
            } else {
                this.fCountHits = true;
                for (int i = 0; i < this.fSymbolCount; ++i) {
                    this.fSymbols[i].hitCount = 0;
                }
                this.fNextRebalanceCount += this.fCountHitsResetCount;
            }
        }
        return this.fCountHits;
    }

    String addSymbol(XMLString xMLString) {
        int n = xMLString.hashCode();
        Symbol symbol = this.get(xMLString, n);
        if (symbol != null) {
            return symbol.str;
        }
        symbol = this.put(xMLString, n);
        return symbol.str;
    }

    String addSymbolSetValues(XMLString xMLString, XMLString xMLString2) {
        int n = xMLString.hashCode();
        Symbol symbol = this.get(xMLString, n);
        if (symbol == null) {
            symbol = this.put(xMLString, n);
        }
        xMLString2.setValues(this.fSymbolBuffer, symbol.nameStart, symbol.nameEnd);
        return symbol.str;
    }

    String addSymbolSetValues(String string, XMLString xMLString) {
        Symbol symbol = this.get(string);
        if (symbol == null && (symbol = this.put(string)) == null) {
            xMLString.clear();
            return null;
        }
        xMLString.setValues(this.fSymbolBuffer, symbol.nameStart, symbol.nameEnd);
        return symbol.str;
    }

    String addSymbol(String string) {
        Symbol symbol = this.get(string);
        if (symbol == null && (symbol = this.put(string)) == null) {
            return null;
        }
        return symbol.str;
    }

    Symbol addNameSymbol(QName qName) {
        int n = qName.hashCode();
        Symbol symbol = this.get(qName, n);
        if (symbol == null) {
            symbol = this.put(qName, n);
        }
        qName.rawName = qName.localName = symbol.str;
        qName.nsURI = "";
        qName.prefix = "";
        return symbol;
    }

    Symbol getQNameSymbol(QName qName, int n, int n2) {
        Symbol symbol = this.get(qName, n);
        if (symbol != null) {
            symbol.setQNameValues(qName, n2);
            return symbol;
        }
        return null;
    }

    Symbol putQNameSymbol(QName qName, int n, int n2) {
        Symbol symbol = this.put(qName, n);
        symbol.setQNameValues(qName, n2);
        return symbol;
    }

    Symbol getQNameSymbol(QName qName) {
        int n;
        int n2 = qName.hashcode;
        Symbol symbol = this.get(qName.bytes, qName.startOffset, qName.endOffset, n2);
        if (symbol != null) {
            if (this.fCountHits) {
                ++symbol.hitCount;
            }
            if (symbol.setValuesIfKnownQName(qName)) {
                return symbol;
            }
        }
        if ((n = DocumentScanner.checkQName(qName)) >= 0) {
            if (symbol == null) {
                symbol = this.put(qName, n2);
            }
            symbol.setQNameValues(qName, n);
            return symbol;
        }
        return null;
    }

    private Symbol get(byte[] byArray, int n, int n2, int n3) {
        int[] nArray = this.fTable;
        int n4 = (SymbolMap.hash(n3) & this.fMask) * 5;
        if (nArray[n4 + 2] != 0) {
            int n5;
            if (nArray[n4 + 0] == n3) {
                int n6 = n;
                byte[] byArray2 = this.fSymbolBytes;
                n5 = nArray[n4 + 2];
                int n7 = nArray[n4 + 3];
                while (byArray[n6++] == byArray2[n5] && ++n5 < n7) {
                }
                if (n5 == n7 && n6 == n2) {
                    return this.fSymbols[nArray[n4 + 4]];
                }
            }
            int[] nArray2 = this.fBuckets;
            int n8 = nArray[n4 + 1];
            while (n8 != 0) {
                if (nArray2[n8 + 0] == n3) {
                    n5 = n;
                    byte[] byArray3 = this.fSymbolBytes;
                    int n9 = nArray2[n8 + 2];
                    int n10 = nArray2[n8 + 3];
                    while (byArray[n5++] == byArray3[n9] && ++n9 < n10) {
                    }
                    if (n9 == n10 && n5 == n2) {
                        return this.fSymbols[nArray2[n8 + 4]];
                    }
                }
                n8 = nArray2[n8 + 1];
            }
        }
        return null;
    }

    private Symbol get(XMLString xMLString, int n) {
        int[] nArray = this.fTable;
        int n2 = (SymbolMap.hash(n) & this.fMask) * 5;
        if (nArray[n2 + 2] != 0) {
            if (nArray[n2 + 0] == n && xMLString.equalsString(this.fSymbolBytes, nArray[n2 + 2], nArray[n2 + 3])) {
                int n3 = nArray[n2 + 4];
                Symbol symbol = this.fSymbols[n3];
                if (this.fCountHits) {
                    ++symbol.hitCount;
                }
                return symbol;
            }
            if ((n2 = nArray[n2 + 1]) != 0) {
                nArray = this.fBuckets;
                do {
                    if (nArray[n2 + 0] != n || !xMLString.equalsString(this.fSymbolBytes, nArray[n2 + 2], nArray[n2 + 3])) continue;
                    int n4 = nArray[n2 + 4];
                    Symbol symbol = this.fSymbols[n4];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                } while ((n2 = nArray[n2 + 1]) != 0);
            }
        }
        return null;
    }

    private Symbol get(String string) {
        int n = string.hashCode();
        int n2 = (SymbolMap.hash(n) & this.fMask) * 5;
        if (this.fTable[n2 + 2] != 0) {
            int[] nArray = this.fTable;
            if (nArray[n2 + 0] == n && this.bucketEquals(string, nArray[n2 + 2], nArray[n2 + 3])) {
                int n3 = nArray[n2 + 4];
                Symbol symbol = this.fSymbols[n3];
                if (this.fCountHits) {
                    ++symbol.hitCount;
                }
                return symbol;
            }
            if ((n2 = nArray[n2 + 1]) != 0) {
                nArray = this.fBuckets;
                do {
                    if (nArray[n2 + 0] != n || !this.bucketEquals(string, nArray[n2 + 2], nArray[n2 + 3])) continue;
                    int n4 = nArray[n2 + 4];
                    Symbol symbol = this.fSymbols[n4];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                } while ((n2 = nArray[n2 + 1]) != 0);
            }
        }
        return null;
    }

    Symbol put(XMLString xMLString, int n) {
        if (this.immutable) {
            this.copyObjectsFromParent();
        }
        int n2 = this.fSymbolBytesOffset;
        if (xMLString.bytes != null) {
            this.appendToSymbolBytes(xMLString.bytes, xMLString.startOffset, xMLString.endOffset);
        } else {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            this.appendToSymbolBytes(dataBuffer.bytes, xMLString.startOffset, dataBuffer.endOffset);
            while ((dataBuffer = dataBuffer.next) != xMLString.lastBuffer) {
                this.appendToSymbolBytes(dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset);
            }
            this.appendToSymbolBytes(dataBuffer.bytes, dataBuffer.startOffset, xMLString.endOffset);
        }
        return this.put(xMLString.toString().intern(), n, n2, this.fSymbolBytesOffset);
    }

    Symbol put(String string) {
        if (this.immutable) {
            this.copyObjectsFromParent();
        }
        int n = this.fSymbolBytesOffset;
        if (this.appendStringToSymbolBytes(string) == null) {
            return this.put(string.intern(), string.hashCode(), n, this.fSymbolBytesOffset);
        }
        return null;
    }

    Symbol addSymbolSubstring(int n, int n2) {
        if (this.immutable) {
            this.copyObjectsFromParent();
        }
        this.fSymbolSubstring.setValues(this.fSymbolBuffer, n, n2);
        int n3 = this.fSymbolSubstring.hashCode();
        Symbol symbol = this.get(this.fSymbolSubstring, n3);
        if (symbol == null) {
            symbol = this.put(this.fSymbolSubstring.toString().intern(), n3, n, n2);
        }
        this.fSymbolSubstring.clear();
        return symbol;
    }

    private void copyObjectsFromParent() {
        if (TRACE_REBALANCING) {
            System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** SymbolMap " + this.id + " no longer immutable");
        }
        this.fSymbols = (Symbol[])this.parent.fSymbols.clone();
        this.fTable = (int[])this.parent.fTable.clone();
        this.fBuckets = (int[])this.parent.fBuckets.clone();
        this.fSymbolBytes = (byte[])this.parent.fSymbolBytes.clone();
        this.fBufferFactory = new SimpleDataBufferFactory();
        this.fSymbolBuffer = this.fBufferFactory.createBuffer();
        this.fSymbolBuffer.bytes = this.fSymbolBytes;
        this.fSymbolBuffer.startOffset = 1;
        this.fSymbolBuffer.endOffset = this.fSymbolBytesOffset;
        this.immutable = false;
        this.parent = null;
    }

    private static int hash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private boolean bucketEquals(String string, int n, int n2) {
        int n3 = string.length();
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            int n5 = string.charAt(i);
            if (n5 == this.fSymbolBytes[n4]) {
                ++n4;
                continue;
            }
            if (n5 < 128) {
                return false;
            }
            if (n5 < 2048) {
                if (this.fSymbolBytes[n4] != (byte)(0xC0 | n5 >> 6)) {
                    return false;
                }
                if (this.fSymbolBytes[++n4] != (byte)(0x80 | 0x3F & n5)) {
                    return false;
                }
                ++n4;
                continue;
            }
            if (n5 < 55296 || n5 >= 57344) {
                if (this.fSymbolBytes[n4] != (byte)(0xE0 | n5 >> 12)) {
                    return false;
                }
                if (this.fSymbolBytes[++n4] != (byte)(0x80 | 0x3F & n5 >> 6)) {
                    return false;
                }
                if (this.fSymbolBytes[++n4] != (byte)(0x80 | 0x3F & n5)) {
                    return false;
                }
                ++n4;
                continue;
            }
            if (n5 < 56320) {
                if (++i == n3) {
                    return false;
                }
                char c = string.charAt(i);
                if (c < '\udc00' || c >= '\ue000') {
                    return false;
                }
                if (this.fSymbolBytes[n4] != (byte)(0xF0 | (n5 = 65536 + (n5 - 55296 << 10) + (c - 56320)) >> 18)) {
                    return false;
                }
                if (this.fSymbolBytes[++n4] != (byte)(0x80 | 0x3F & n5 >> 12)) {
                    return false;
                }
                if (this.fSymbolBytes[++n4] != (byte)(0x80 | 0x3F & n5 >> 6)) {
                    return false;
                }
                if (this.fSymbolBytes[++n4] != (byte)(0x80 | 0x3F & n5)) {
                    return false;
                }
                ++n4;
                continue;
            }
            return false;
        }
        return n4 == n2;
    }

    private int allocateBucket() {
        int n = this.fNextBucketBase;
        if (n == this.fBuckets.length) {
            this.fBuckets = ArrayAllocator.resizeIntArray(this.fBuckets, n << 1);
        }
        this.fNextBucketBase += 5;
        return n;
    }

    private void addHashedSymbolToBucket(Symbol symbol, int n, int n2, int n3, int n4) {
        int[] nArray;
        int n5 = (SymbolMap.hash(n4) & this.fMask) * 5;
        if (this.fTable[n5 + 2] == 0) {
            nArray = this.fTable;
        } else {
            int n6 = this.allocateBucket();
            nArray = this.fBuckets;
            if (this.fTable[n5 + 1] == 0) {
                this.fTable[n5 + 1] = n6;
                n5 = n6;
            } else {
                n5 = this.fTable[n5 + 1];
                while (nArray[n5 + 1] != 0) {
                    n5 = nArray[n5 + 1];
                }
                nArray[n5 + 1] = n6;
                n5 = n6;
            }
        }
        nArray[n5 + 0] = n4;
        nArray[n5 + 1] = 0;
        nArray[n5 + 2] = n2;
        nArray[n5 + 3] = n3;
        nArray[n5 + 4] = n;
    }

    private void rehash() {
        this.fTable = ArrayAllocator.replaceIntArray(this.fTable, this.fTable.length << 1);
        this.fMask = (this.fMask + 1 << 1) - 1;
        this.fNextBucketBase = 5;
        for (int i = 0; i < this.fSymbolCount; ++i) {
            Symbol symbol = this.fSymbols[i];
            this.addHashedSymbolToBucket(symbol, i, symbol.nameStart, symbol.nameEnd, symbol.str.hashCode());
        }
    }

    private Symbol put(String string, int n, int n2, int n3) {
        int n4;
        Symbol symbol = new Symbol(string, this, n2, n3);
        if ((n4 = this.fSymbolCount++) == this.fSymbols.length) {
            this.fSymbols = ArrayAllocator.resizeObjectArray(Symbol.class, this.fSymbols, this.fSymbols.length << 1);
        }
        this.fSymbols[n4] = symbol;
        if (n4 == this.fMask - (this.fMask >> 2)) {
            this.rehash();
        }
        this.addHashedSymbolToBucket(symbol, n4, n2, n3, n);
        return symbol;
    }

    private void checkSymbols() {
    }

    private boolean tablesBalanced() {
        for (int i = 0; i < this.fTable.length; i += 5) {
            if (this.fTable[i + 2] == 0 || this.fTable[i + 1] == 0) continue;
            int n = this.fTable[i + 4];
            int n2 = this.fSymbols[n].hitCount;
            int n3 = this.fTable[i + 1];
            while (n3 != 0) {
                n = this.fBuckets[n3 + 4];
                int n4 = this.fSymbols[n].hitCount;
                if (n2 < n4) {
                    return false;
                }
                n2 = n4;
                n3 = this.fBuckets[n3 + 1];
            }
        }
        return true;
    }

    void rebalanceTables() {
        int n;
        int n2;
        if (this.immutable) {
            this.copyObjectsFromParent();
        }
        Comparator<Symbol> comparator = new Comparator<Symbol>(){

            @Override
            public int compare(Symbol symbol, Symbol symbol2) {
                if (symbol.hitCount == symbol2.hitCount) {
                    return 0;
                }
                if (symbol.hitCount > symbol2.hitCount) {
                    return -1;
                }
                return 1;
            }
        };
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>(this.fSymbolCount);
        int n3 = 1;
        Symbol symbol = this.fSymbols[0];
        n3 += symbol.nameEnd - symbol.nameStart;
        arrayList.add(symbol);
        int n4 = this.fSymbols[0].hitCount == 0 ? 0 : 1;
        for (int i = 1; i < this.fSymbolCount; ++i) {
            int n5;
            symbol = this.fSymbols[i];
            n3 += symbol.nameEnd - symbol.nameStart;
            n2 = symbol.hitCount;
            if (n2 == 0) {
                arrayList.add(symbol);
                continue;
            }
            if (n4 > 0) {
                n5 = Collections.binarySearch(arrayList, symbol, comparator);
                if (n5 < 0) {
                    n5 = -(n5 + 1);
                }
            } else {
                n5 = 0;
            }
            arrayList.add(n5, symbol);
            ++n4;
        }
        arrayList.toArray(this.fSymbols);
        byte[] byArray = this.fSymbolBytes;
        for (n2 = byArray.length; n2 < n3; n2 <<= 1) {
        }
        if (TRACE_REBALANCING) {
            if (byArray.length < n2) {
                System.err.println("rebalancing grew symbol bytes array from " + byArray.length + " to " + n2);
            }
            System.err.println("rebalanced symbol bytes offset was " + this.fSymbolBytesOffset + ", but will now be " + n3 + " due to lost reuse of common substrings");
        }
        byte[] byArray2 = ArrayAllocator.newByteArray(n2);
        if (this.fBufferFactory.isReferenced(this.fSymbolBuffer)) {
            this.fSymbolBuffer = this.fBufferFactory.createBuffer();
        }
        this.fSymbolBuffer.bytes = byArray2;
        this.fSymbolBytes = byArray2;
        this.fSymbolBytesOffset = 1;
        for (n = 0; n < this.fTable.length; ++n) {
            this.fTable[n] = 0;
        }
        this.fNextBucketBase = 5;
        for (n = 0; n < this.fSymbolCount; ++n) {
            symbol = this.fSymbols[n];
            int n6 = symbol.nameEnd - symbol.nameStart;
            System.arraycopy(byArray, symbol.nameStart, byArray2, this.fSymbolBytesOffset, n6);
            symbol = new Symbol(symbol, this, this.fSymbolBytesOffset, this.fSymbolBytesOffset + n6);
            this.fSymbolBytesOffset += n6;
            this.fSymbols[n] = symbol;
            this.addHashedSymbolToBucket(symbol, n, symbol.nameStart, symbol.nameEnd, symbol.str.hashCode());
        }
    }

    private void growSymbolBytes(int n) {
        int n2;
        for (n2 = this.fSymbolBytes.length << 1; n2 < n; n2 <<= 1) {
        }
        this.fSymbolBytes = ArrayAllocator.resizeByteArray(this.fSymbolBytes, n2);
        this.fSymbolBuffer.bytes = this.fSymbolBytes;
    }

    private void appendToSymbolBytes(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (this.fSymbolBytes.length < this.fSymbolBytesOffset + n3) {
            this.growSymbolBytes(this.fSymbolBytesOffset + n3);
        }
        System.arraycopy(byArray, n, this.fSymbolBytes, this.fSymbolBytesOffset, n3);
        this.fSymbolBytesOffset += n3;
        this.fSymbolBuffer.endOffset = this.fSymbolBytesOffset;
    }

    private CharConversionError appendStringToSymbolBytes(String string) {
        int n;
        int n2;
        int n3 = this.fSymbolBytesOffset;
        int n4 = string.length();
        if (n3 + n4 <= this.fSymbolBytes.length) {
            for (n2 = 0; n2 < n4 && (n = string.charAt(n2)) < 128; ++n2) {
                this.fSymbolBytes[n3++] = (byte)n;
            }
            if (n2 == n4) {
                this.fSymbolBuffer.endOffset = this.fSymbolBytesOffset = n3;
                return null;
            }
        }
        while (n2 < n4) {
            n = string.charAt(n2);
            ++n2;
            if (n < 128) {
                if (n3 == this.fSymbolBytes.length) {
                    this.growSymbolBytes(n3 << 1);
                }
                this.fSymbolBytes[n3++] = (byte)n;
                continue;
            }
            if (n < 2048) {
                if (n3 + 1 >= this.fSymbolBytes.length) {
                    this.growSymbolBytes(n3 << 1);
                }
                this.fSymbolBytes[n3++] = (byte)(0xC0 | n >> 6);
                this.fSymbolBytes[n3++] = (byte)(0x80 | 0x3F & n);
                continue;
            }
            if (n < 55296 || n >= 57344) {
                if (n3 + 2 >= this.fSymbolBytes.length) {
                    this.growSymbolBytes(n3 << 1);
                }
                this.fSymbolBytes[n3++] = (byte)(0xE0 | n >> 12);
                this.fSymbolBytes[n3++] = (byte)(0x80 | 0x3F & n >> 6);
                this.fSymbolBytes[n3++] = (byte)(0x80 | 0x3F & n);
                continue;
            }
            if (n < 56320) {
                if (n2 == n4) {
                    return CharConversionError.missingSecondHalfOfSurrogatePair();
                }
                char c = string.charAt(n2);
                ++n2;
                if (c < '\udc00' || c >= '\ue000') {
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n = 65536 + (n - 55296 << 10) + (c - 56320);
                if (n3 + 3 >= this.fSymbolBytes.length) {
                    this.growSymbolBytes(n3 << 1);
                }
                this.fSymbolBytes[n3++] = (byte)(0xF0 | n >> 18);
                this.fSymbolBytes[n3++] = (byte)(0x80 | 0x3F & n >> 12);
                this.fSymbolBytes[n3++] = (byte)(0x80 | 0x3F & n >> 6);
                this.fSymbolBytes[n3++] = (byte)(0x80 | 0x3F & n);
                continue;
            }
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        this.fSymbolBuffer.endOffset = this.fSymbolBytesOffset = n3;
        return null;
    }

    private void dumpTables() {
    }
}

