/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgBinOp;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgField;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgReferenceType;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgVariable;
import com.ibm.xml.xlxp2.jaxb.codegen.fcg.FCGTypeUtil;
import com.ibm.xml.xlxp2.jaxb.model.PropertyTypeInformation;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.FCGDeserializationStubGenerator;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class FCGDeserializationStubGeneratorHelper {
    private static final int METHOD_SPLIT_THRESHOLD_DEFAULT = 200;
    protected final int fMethodSplitThreshold;
    final String stubClassName;
    private final ClassLoader cl;
    private int objectFactoryCounter;
    private List<String> objectFactoryHolders = new ArrayList<String>();
    private int adapterCounter;
    private List<String> adapterHolders = new ArrayList<String>();

    public FCGDeserializationStubGeneratorHelper(String string, ClassLoader classLoader) {
        this.stubClassName = string;
        this.cl = classLoader;
        this.fMethodSplitThreshold = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    String string = System.getProperty("com.ibm.xml.xlxp.jaxb.unmarshal.codegen.split.threshold");
                    if (string != null) {
                        int n = Integer.parseInt(string);
                        return n >= 2 ? n : 2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 200;
            }
        });
    }

    public ClassLoader getDeserializationStubClassLoader() {
        return this.cl;
    }

    public static void callJAXBElementSetNil(FcgCodeGen fcgCodeGen, FcgClassReferenceType fcgClassReferenceType, FcgInstructionList fcgInstructionList) {
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType("javax.xml.bind.JAXBElement");
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(FCGDeserializationStubGenerator.CLASS_CONTEXT);
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgClassReferenceType, "o", FcgType.OBJECT);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType2);
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgClassReferenceType, "fContext", fcgClassReferenceType3);
        fcgInstructionList.loadInstanceField(fcgClassReferenceType3, "currentElementNilled", FcgType.BOOLEAN);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "setNil", (FcgType)FcgType.VOID, 1);
    }

    public FcgReferenceType callAdapter(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, PropertyTypeInformation propertyTypeInformation, FcgType fcgType) {
        FcgType fcgType2 = FCGTypeUtil.getFcgType(propertyTypeInformation.adapterClass, fcgCodeGen);
        FcgField fcgField = this.getAdapterField(fcgClassGen, fcgType2);
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgField);
        fcgInstructionList.loadNull();
        fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgField);
        fcgInstructionList.createObjectExpr(fcgType2, 0);
        fcgInstructionList.storeAtStmt();
        fcgInstructionList.endIf();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgField);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgType);
        FcgReferenceType fcgReferenceType = propertyTypeInformation.boundType instanceof ParameterizedType ? (FcgClassReferenceType)FCGTypeUtil.getFcgType((Class)((ParameterizedType)propertyTypeInformation.boundType).getActualTypeArguments()[0], fcgCodeGen) : (FcgReferenceType)FCGTypeUtil.getFcgType((Class)propertyTypeInformation.boundType, fcgCodeGen);
        fcgInstructionList.invokeInstanceMethod((FcgClassReferenceType)fcgType2, "unmarshal", (FcgType)fcgReferenceType, 1);
        return fcgReferenceType;
    }

    private FcgField getAdapterField(FcgClassGen fcgClassGen, FcgType fcgType) {
        FcgField fcgField = null;
        for (int i = 0; fcgField == null && i < this.adapterHolders.size(); ++i) {
            if (fcgClassGen.findField(this.adapterHolders.get(i)) == null || fcgClassGen.findField(this.adapterHolders.get(i)).getType() != fcgType) continue;
            fcgField = fcgClassGen.findField(this.adapterHolders.get(i));
        }
        if (fcgField == null) {
            String string = "_a" + this.adapterCounter++;
            this.adapterHolders.add(string);
            fcgField = fcgClassGen.newInstanceField(FcgAttrs.PRIVATE, fcgType, string);
        }
        return fcgField;
    }

    public FcgClassReferenceType callJAXBFactory(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, PropertyTypeInformation propertyTypeInformation, FcgType fcgType, Method method) {
        Object object;
        FcgType fcgType2 = FCGTypeUtil.getFcgType(method.getDeclaringClass(), fcgCodeGen);
        FcgField fcgField = this.getFactoryField(fcgClassGen, fcgType2);
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgField);
        fcgInstructionList.loadNull();
        fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgField);
        fcgInstructionList.createObjectExpr(fcgType2, 0);
        fcgInstructionList.storeAtStmt();
        fcgInstructionList.endIf();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgField);
        Class<?> clazz = method.getParameterTypes()[0];
        FcgType fcgType3 = FCGTypeUtil.getFcgType(clazz, fcgCodeGen);
        fcgInstructionList.loadVar(fcgVariable);
        if (FCGTypeUtil.isPrimitiveType(fcgVariable.getType()) && FCGTypeUtil.isPrimitiveWrapperClass(clazz)) {
            fcgInstructionList.invokeClassMethod((FcgClassReferenceType)fcgType3, "valueOf", fcgType3, 1);
        } else {
            fcgInstructionList.convertExpr(fcgVariable.getType(), fcgType);
            if (FCGTypeUtil.isPrimitiveClass(clazz) && FCGTypeUtil.isPrimitiveWrapperType(fcgType)) {
                object = null;
                object = clazz == Boolean.TYPE ? "booleanValue" : (clazz == Byte.TYPE ? "byteValue" : (clazz == Short.TYPE ? "shortValue" : (clazz == Integer.TYPE ? "intValue" : (clazz == Long.TYPE ? "longValue" : (clazz == Float.TYPE ? "floatValue" : (clazz == Double.TYPE ? "doubleValue" : "charValue"))))));
                fcgInstructionList.invokeInstanceMethod((FcgClassReferenceType)fcgType, (String)object, fcgType3, 0);
            }
        }
        object = fcgCodeGen.getClassReferenceType("javax.xml.bind.JAXBElement");
        fcgInstructionList.invokeInstanceMethod((FcgClassReferenceType)fcgType2, method.getName(), (FcgType)object, new FcgType[]{fcgType3});
        return object;
    }

    private FcgField getFactoryField(FcgClassGen fcgClassGen, FcgType fcgType) {
        FcgField fcgField = null;
        if (fcgClassGen.findField("_f") != null && fcgClassGen.findField("_f").getType() == fcgType) {
            fcgField = fcgClassGen.findField("_f");
        }
        for (int i = 0; fcgField == null && i < this.objectFactoryHolders.size(); ++i) {
            if (fcgClassGen.findField(this.objectFactoryHolders.get(i)) == null || fcgClassGen.findField(this.objectFactoryHolders.get(i)).getType() != fcgType) continue;
            fcgField = fcgClassGen.findField(this.objectFactoryHolders.get(i));
        }
        if (fcgField == null) {
            String string = "_f" + this.objectFactoryCounter++;
            this.objectFactoryHolders.add(string);
            fcgField = fcgClassGen.newInstanceField(FcgAttrs.PRIVATE, fcgType, string);
        }
        return fcgField;
    }
}

