/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal.impl;

import com.ibm.xml.jaxp.datatype.Duration2;
import com.ibm.xml.jaxp.datatype.XMLGregorianCalendar2;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.BufferedOutput;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.UTF8Support;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ValueWriter {
    private static final byte SPACE = 32;
    private static final byte MINUS = 45;
    private static final byte PLUS = 43;
    private static final byte ZERO = 48;
    private static final byte PAD = 61;
    private static final byte[] HEX;
    private static final byte[] BASE64;
    private static final byte[] TRUE;
    private static final byte[] FALSE;
    private static final byte[] LONG_MIN;
    private static final byte[] INT_MIN;
    private static final byte[] XOP_ELEMENT;
    private static final String XOP_NS = "http://www.w3.org/2004/08/xop/include";
    private static final String XOP_INCLUDE = "Include";
    private static final byte[][] ESCAPE_ATTR;
    private static final byte[][] ESCAPE_ELEM;

    private ValueWriter() {
    }

    private static CharConversionError charsToBytes(char[] cArray, int n, byte[] byArray, int[] nArray) {
        char c;
        int n2;
        for (n2 = 0; n2 < n && (c = cArray[n2]) < '\u0080'; ++n2) {
            byArray[n2] = (byte)c;
        }
        if (n2 == n) {
            nArray[0] = n2;
            nArray[1] = n2;
            return null;
        }
        return UTF8Support.convertCharsToBytes(cArray, n2, n, byArray, n2, byArray.length, nArray);
    }

    private static CharConversionError escapeCharsToBytesAttr(char[] cArray, int n, byte[] byArray, int[] nArray) {
        char c;
        int n2;
        for (n2 = 0; n2 < n && (c = cArray[n2]) < '\u0080' && ESCAPE_ATTR[c] == null; ++n2) {
            byArray[n2] = (byte)c;
        }
        if (n2 == n) {
            nArray[0] = n2;
            nArray[1] = n2;
            return null;
        }
        return ValueWriter.escapeCharsToBytes(cArray, n2, n, byArray, n2, byArray.length, nArray, ESCAPE_ATTR);
    }

    private static CharConversionError escapeCharsToBytesElem(char[] cArray, int n, byte[] byArray, int[] nArray) {
        char c;
        int n2;
        for (n2 = 0; n2 < n && (c = cArray[n2]) < '\u0080' && ESCAPE_ELEM[c] == null; ++n2) {
            byArray[n2] = (byte)c;
        }
        if (n2 == n) {
            nArray[0] = n2;
            nArray[1] = n2;
            return null;
        }
        return ValueWriter.escapeCharsToBytes(cArray, n2, n, byArray, n2, byArray.length, nArray, ESCAPE_ELEM);
    }

    private static CharConversionError escapeCharsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, int[] nArray, byte[][] byArray2) {
        while (n < n2) {
            int n5 = cArray[n];
            if (n5 < 128) {
                if (byArray2[n5] != null) {
                    ++n;
                    System.arraycopy(byArray2[n5], 0, byArray, n3, byArray2[n5].length);
                    n3 += byArray2[n5].length;
                    continue;
                }
                if (n3 == n4) {
                    nArray[0] = n;
                    nArray[1] = n3;
                    return null;
                }
                ++n;
                byArray[n3++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                if (n3 + 2 > n4) {
                    nArray[0] = n;
                    nArray[1] = n3;
                    return null;
                }
                ++n;
                byArray[n3] = (byte)(0xC0 | n5 >> 6);
                byArray[n3 + 1] = (byte)(0x80 | 0x3F & n5);
                n3 += 2;
                continue;
            }
            if (n5 < 55296 || n5 >= 57344) {
                if (n3 + 3 > n4) {
                    nArray[0] = n;
                    nArray[1] = n3;
                    return null;
                }
                ++n;
                byArray[n3] = (byte)(0xE0 | n5 >> 12);
                byArray[n3 + 1] = (byte)(0x80 | 0x3F & n5 >> 6);
                byArray[n3 + 2] = (byte)(0x80 | 0x3F & n5);
                n3 += 3;
                continue;
            }
            if (n5 < 56320) {
                if (++n == n2 || n3 + 4 > n4) {
                    nArray[0] = n - 1;
                    nArray[1] = n3;
                    return null;
                }
                char c = cArray[n];
                if (c >= '\udc00' && c < '\ue000') {
                    ++n;
                } else {
                    nArray[0] = n - 1;
                    nArray[1] = n3;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n5 = 65536 + (n5 - 55296 << 10) + (c - 56320);
                byArray[n3] = (byte)(0xF0 | n5 >> 18);
                byArray[n3 + 1] = (byte)(0x80 | 0x3F & n5 >> 12);
                byArray[n3 + 2] = (byte)(0x80 | 0x3F & n5 >> 6);
                byArray[n3 + 3] = (byte)(0x80 | 0x3F & n5);
                n3 += 4;
                continue;
            }
            nArray[0] = n;
            nArray[1] = n3;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        nArray[0] = n;
        nArray[1] = n3;
        return null;
    }

    public static void writeStringAttr(BufferedOutput bufferedOutput, String string) throws IOException {
        CharConversionError charConversionError;
        int n = string.length();
        char[] cArray = bufferedOutput.chars;
        byte[] byArray = bufferedOutput.bytes;
        int[] nArray = bufferedOutput.results;
        int n2 = 0;
        int n3 = 1024;
        while (n3 < n) {
            string.getChars(n2, n3, cArray, 0);
            charConversionError = ValueWriter.escapeCharsToBytesAttr(cArray, 1024, byArray, nArray);
            if (charConversionError != null) {
                throw new CharConversionException(charConversionError.formatErrorMessage());
            }
            bufferedOutput.write(byArray, 0, nArray[1]);
            n3 = (n2 += nArray[0]) + 1024;
        }
        string.getChars(n2, n, cArray, 0);
        charConversionError = ValueWriter.escapeCharsToBytesAttr(cArray, n - n2, byArray, nArray);
        if (charConversionError != null) {
            throw new CharConversionException(charConversionError.formatErrorMessage());
        }
        bufferedOutput.write(byArray, 0, nArray[1]);
    }

    public static void writeStringElem(BufferedOutput bufferedOutput, String string) throws IOException {
        CharConversionError charConversionError;
        int n = string.length();
        char[] cArray = bufferedOutput.chars;
        byte[] byArray = bufferedOutput.bytes;
        int[] nArray = bufferedOutput.results;
        int n2 = 0;
        int n3 = 1024;
        while (n3 < n) {
            string.getChars(n2, n3, cArray, 0);
            charConversionError = ValueWriter.escapeCharsToBytesElem(cArray, 1024, byArray, nArray);
            if (charConversionError != null) {
                throw new CharConversionException(charConversionError.formatErrorMessage());
            }
            bufferedOutput.write(byArray, 0, nArray[1]);
            n3 = (n2 += nArray[0]) + 1024;
        }
        string.getChars(n2, n, cArray, 0);
        charConversionError = ValueWriter.escapeCharsToBytesElem(cArray, n - n2, byArray, nArray);
        if (charConversionError != null) {
            throw new CharConversionException(charConversionError.formatErrorMessage());
        }
        bufferedOutput.write(byArray, 0, nArray[1]);
    }

    public static void writeStringNoEscapeElem(BufferedOutput bufferedOutput, String string) throws IOException {
        CharConversionError charConversionError;
        int n = string.length();
        char[] cArray = bufferedOutput.chars;
        byte[] byArray = bufferedOutput.bytes;
        int[] nArray = bufferedOutput.results;
        int n2 = 0;
        int n3 = 1024;
        while (n3 < n) {
            string.getChars(n2, n3, cArray, 0);
            charConversionError = ValueWriter.charsToBytes(cArray, 1024, byArray, nArray);
            if (charConversionError != null) {
                throw new CharConversionException(charConversionError.formatErrorMessage());
            }
            bufferedOutput.write(byArray, 0, nArray[1]);
            n3 = (n2 += nArray[0]) + 1024;
        }
        string.getChars(n2, n, cArray, 0);
        charConversionError = ValueWriter.charsToBytes(cArray, n - n2, byArray, nArray);
        if (charConversionError != null) {
            throw new CharConversionException(charConversionError.formatErrorMessage());
        }
        bufferedOutput.write(byArray, 0, nArray[1]);
    }

    public static void writeBooleanElem(BufferedOutput bufferedOutput, boolean bl) throws IOException {
        bufferedOutput.write(bl ? TRUE : FALSE);
    }

    public static void writeBooleanElem(BufferedOutput bufferedOutput, Boolean bl) throws IOException {
        ValueWriter.writeBooleanElem(bufferedOutput, (boolean)bl);
    }

    public static void writeBigDecimalElem(BufferedOutput bufferedOutput, BigDecimal bigDecimal) throws IOException {
        ValueWriter.writeStringNoEscapeElem(bufferedOutput, bigDecimal.toPlainString());
    }

    public static void writeBigIntegerElem(BufferedOutput bufferedOutput, BigInteger bigInteger) throws IOException {
        int n = bigInteger.bitLength();
        if (n < 32) {
            ValueWriter.writeIntElem(bufferedOutput, bigInteger.intValue());
        } else if (n < 64) {
            ValueWriter.writeLongElem(bufferedOutput, bigInteger.longValue());
        } else {
            ValueWriter.writeStringNoEscapeElem(bufferedOutput, bigInteger.toString());
        }
    }

    public static void writeLongElem(BufferedOutput bufferedOutput, long l) throws IOException {
        long l2;
        if (l == 0L) {
            bufferedOutput.write((byte)48);
            return;
        }
        if (l < 0L) {
            if (l == Long.MIN_VALUE) {
                bufferedOutput.write(LONG_MIN);
                return;
            }
            bufferedOutput.write((byte)45);
            l = -l;
        }
        byte[] byArray = bufferedOutput.bytes;
        int n = 6144;
        do {
            l2 = l / 10L;
            int n2 = (int)(l - (l2 << 3) - (l2 << 1));
            byArray[--n] = (byte)(n2 + 48);
        } while ((l = l2) != 0L);
        bufferedOutput.write(byArray, n, 6144 - n);
    }

    public static void writeLongElem(BufferedOutput bufferedOutput, Long l) throws IOException {
        ValueWriter.writeLongElem(bufferedOutput, (long)l);
    }

    public static void writeIntElem(BufferedOutput bufferedOutput, int n) throws IOException {
        if (n == 0) {
            bufferedOutput.write((byte)48);
            return;
        }
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                bufferedOutput.write(INT_MIN);
                return;
            }
            bufferedOutput.write((byte)45);
            n = -n;
        }
        byte[] byArray = bufferedOutput.bytes;
        int n2 = 6144;
        do {
            int n3 = n / 10;
            int n4 = n - (n3 << 3) - (n3 << 1);
            n = n3;
            byArray[--n2] = (byte)(n4 + 48);
        } while (n != 0);
        bufferedOutput.write(byArray, n2, 6144 - n2);
    }

    public static void writeIntegerElem(BufferedOutput bufferedOutput, Integer n) throws IOException {
        ValueWriter.writeIntElem(bufferedOutput, n);
    }

    public static void writeShortElem(BufferedOutput bufferedOutput, short s) throws IOException {
        ValueWriter.writeIntElem(bufferedOutput, s);
    }

    public static void writeShortElem(BufferedOutput bufferedOutput, Short s) throws IOException {
        ValueWriter.writeShortElem(bufferedOutput, (short)s);
    }

    public static void writeByteElem(BufferedOutput bufferedOutput, byte by) throws IOException {
        ValueWriter.writeIntElem(bufferedOutput, by);
    }

    public static void writeByteElem(BufferedOutput bufferedOutput, Byte by) throws IOException {
        ValueWriter.writeByteElem(bufferedOutput, (byte)by);
    }

    public static void writeFloatElem(BufferedOutput bufferedOutput, float f) throws IOException {
        if (f == Float.POSITIVE_INFINITY) {
            bufferedOutput.write((byte)73);
            bufferedOutput.write((byte)78);
            bufferedOutput.write((byte)70);
            return;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            bufferedOutput.write((byte)45);
            bufferedOutput.write((byte)73);
            bufferedOutput.write((byte)78);
            bufferedOutput.write((byte)70);
            return;
        }
        if (f != f) {
            bufferedOutput.write((byte)78);
            bufferedOutput.write((byte)97);
            bufferedOutput.write((byte)78);
            return;
        }
        ValueWriter.writeStringNoEscapeElem(bufferedOutput, Float.toString(f));
    }

    public static void writeFloatElem(BufferedOutput bufferedOutput, Float f) throws IOException {
        ValueWriter.writeFloatElem(bufferedOutput, f.floatValue());
    }

    public static void writeDoubleElem(BufferedOutput bufferedOutput, double d) throws IOException {
        if (d == Double.POSITIVE_INFINITY) {
            bufferedOutput.write((byte)73);
            bufferedOutput.write((byte)78);
            bufferedOutput.write((byte)70);
            return;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            bufferedOutput.write((byte)45);
            bufferedOutput.write((byte)73);
            bufferedOutput.write((byte)78);
            bufferedOutput.write((byte)70);
            return;
        }
        if (d != d) {
            bufferedOutput.write((byte)78);
            bufferedOutput.write((byte)97);
            bufferedOutput.write((byte)78);
            return;
        }
        ValueWriter.writeStringNoEscapeElem(bufferedOutput, Double.toString(d));
    }

    public static void writeDoubleElem(BufferedOutput bufferedOutput, Double d) throws IOException {
        ValueWriter.writeDoubleElem(bufferedOutput, (double)d);
    }

    public static void writeCharElem(BufferedOutput bufferedOutput, char c) throws IOException {
        ValueWriter.writeIntElem(bufferedOutput, c);
    }

    public static void writeCharacterElem(BufferedOutput bufferedOutput, Character c) throws IOException {
        ValueWriter.writeCharElem(bufferedOutput, c.charValue());
    }

    public static void writeDurationElem(BufferedOutput bufferedOutput, Duration duration) throws IOException {
        Duration2 duration2;
        if (duration instanceof Duration2 && (duration2 = (Duration2)duration).areFieldsPrimitive()) {
            ValueWriter.writeDuration(bufferedOutput, duration2);
            return;
        }
        ValueWriter.writeStringNoEscapeElem(bufferedOutput, duration.toString());
    }

    private static void writeDuration(BufferedOutput bufferedOutput, Duration2 duration2) throws IOException {
        int n;
        int n2;
        int n3 = duration2.getSign();
        if (n3 == 0) {
            bufferedOutput.write((byte)80);
            bufferedOutput.write((byte)84);
            bufferedOutput.write((byte)48);
            bufferedOutput.write((byte)83);
            return;
        }
        if (n3 < 0) {
            bufferedOutput.write((byte)45);
        }
        bufferedOutput.write((byte)80);
        int n4 = duration2.getYears();
        if (n4 != 0) {
            ValueWriter.writeIntElem(bufferedOutput, n4);
            bufferedOutput.write((byte)89);
        }
        if ((n2 = duration2.getMonths()) != 0) {
            ValueWriter.writeIntElem(bufferedOutput, n2);
            bufferedOutput.write((byte)77);
        }
        if ((n = duration2.getDays()) != 0) {
            ValueWriter.writeIntElem(bufferedOutput, n);
            bufferedOutput.write((byte)68);
        }
        int n5 = duration2.getHours();
        int n6 = duration2.getMinutes();
        int n7 = duration2.getSeconds();
        if (n5 != 0 || n6 != 0 || n7 != 0) {
            bufferedOutput.write((byte)84);
            if (n5 != 0) {
                ValueWriter.writeIntElem(bufferedOutput, n5);
                bufferedOutput.write((byte)72);
            }
            if (n6 != 0) {
                ValueWriter.writeIntElem(bufferedOutput, n6);
                bufferedOutput.write((byte)77);
            }
            if (n7 != 0) {
                ValueWriter.writeIntElem(bufferedOutput, n7);
                bufferedOutput.write((byte)83);
            }
        }
    }

    private static void writeYear(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        BigInteger bigInteger = xMLGregorianCalendar.getEon();
        if (bigInteger == null) {
            ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar.getYear());
        } else {
            ValueWriter.writeBigIntegerElem(bufferedOutput, xMLGregorianCalendar.getEonAndYear());
        }
    }

    private static void writeYear(BufferedOutput bufferedOutput, int n) throws IOException {
        if (n < 10000 && n > -10000) {
            if (n < 0) {
                bufferedOutput.write((byte)45);
                n = -n;
            }
            ValueWriter.writeIntFourDigits(bufferedOutput, n);
        } else {
            ValueWriter.writeIntElem(bufferedOutput, n);
        }
    }

    private static void writeIntTwoDigits(BufferedOutput bufferedOutput, int n) throws IOException {
        if (n < 0 || n > 99) {
            ValueWriter.writeIntElem(bufferedOutput, n);
            return;
        }
        int n2 = n / 10;
        int n3 = n - (n2 << 3) - (n2 << 1);
        bufferedOutput.write((byte)(n2 + 48));
        bufferedOutput.write((byte)(n3 + 48));
    }

    private static void writeIntFourDigits(BufferedOutput bufferedOutput, int n) throws IOException {
        if (n < 0 || n > 9999) {
            ValueWriter.writeIntElem(bufferedOutput, n);
            return;
        }
        int n2 = n / 10;
        int n3 = n - (n2 << 3) - (n2 << 1);
        n = n2;
        n2 = n / 10;
        int n4 = n - (n2 << 3) - (n2 << 1);
        n = n2;
        n2 = n / 10;
        int n5 = n - (n2 << 3) - (n2 << 1);
        bufferedOutput.write((byte)(n2 + 48));
        bufferedOutput.write((byte)(n5 + 48));
        bufferedOutput.write((byte)(n4 + 48));
        bufferedOutput.write((byte)(n3 + 48));
    }

    private static void writeMilliseconds(BufferedOutput bufferedOutput, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        int n3 = n / 10;
        int n4 = n - (n3 << 3) - (n3 << 1);
        n = n3;
        n3 = n / 10;
        int n5 = n - (n3 << 3) - (n3 << 1);
        bufferedOutput.write((byte)46);
        bufferedOutput.write((byte)(n3 + 48));
        if (n2 == 1) {
            return;
        }
        bufferedOutput.write((byte)(n5 + 48));
        if (n2 == 2) {
            return;
        }
        bufferedOutput.write((byte)(n4 + 48));
        for (int i = 3; i < n2; ++i) {
            bufferedOutput.write((byte)48);
        }
    }

    private static void writeFractionalSeconds(BufferedOutput bufferedOutput, BigDecimal bigDecimal) throws IOException {
        if (bigDecimal != null) {
            ValueWriter.writeStringNoEscapeElem(bufferedOutput, bigDecimal.toPlainString().substring(1));
        }
    }

    private static void writeTimezone(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        int n = xMLGregorianCalendar.getTimezone();
        if (n != Integer.MIN_VALUE) {
            ValueWriter.writeTimezone(bufferedOutput, n);
        }
    }

    private static void writeTimezone(BufferedOutput bufferedOutput, int n) throws IOException {
        if (n == 0) {
            bufferedOutput.write((byte)90);
            return;
        }
        if (n < 0) {
            bufferedOutput.write((byte)45);
            n = -n;
        } else {
            bufferedOutput.write((byte)43);
        }
        int n2 = n / 60;
        int n3 = n % 60;
        ValueWriter.writeIntTwoDigits(bufferedOutput, n2);
        bufferedOutput.write((byte)58);
        ValueWriter.writeIntTwoDigits(bufferedOutput, n3);
    }

    public static void writeGCalendarElem(BufferedOutput bufferedOutput, GregorianCalendar gregorianCalendar) throws IOException {
        ValueWriter.writeCalendarElem(bufferedOutput, gregorianCalendar);
    }

    private static void writeDate(BufferedOutput bufferedOutput, Date date, int n, int n2) throws IOException {
        ValueWriter.writeYear(bufferedOutput, date.getYear() + 1900);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, date.getMonth() + 1);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, date.getDate());
        bufferedOutput.write((byte)84);
        ValueWriter.writeIntTwoDigits(bufferedOutput, date.getHours());
        bufferedOutput.write((byte)58);
        ValueWriter.writeIntTwoDigits(bufferedOutput, date.getMinutes());
        bufferedOutput.write((byte)58);
        ValueWriter.writeIntTwoDigits(bufferedOutput, date.getSeconds());
        if (n > 0) {
            ValueWriter.writeMilliseconds(bufferedOutput, n, 3);
        }
        ValueWriter.writeTimezone(bufferedOutput, n2);
    }

    public static void writeCalendarElem(BufferedOutput bufferedOutput, Calendar calendar) throws IOException {
        long l = calendar.getTimeInMillis();
        int n = (int)(l % 1000L);
        Date date = new Date(l - (long)n);
        int n2 = calendar.getTimeZone().getOffset(l) / 60000;
        ValueWriter.writeDate(bufferedOutput, date, n, n2);
    }

    public static void writeDateElem(BufferedOutput bufferedOutput, Date date) throws IOException {
        long l = date.getTime();
        int n = (int)(l % 1000L);
        Date date2 = n == 0 ? date : new Date(l - (long)n);
        int n2 = -date.getTimezoneOffset();
        ValueWriter.writeDate(bufferedOutput, date2, n, n2);
    }

    public static void writeXGCalendarElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        QName qName = xMLGregorianCalendar.getXMLSchemaType();
        if (qName == DatatypeConstants.DATETIME) {
            ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
            bufferedOutput.write((byte)84);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getHour());
            bufferedOutput.write((byte)58);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMinute());
            bufferedOutput.write((byte)58);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getSecond());
            if (xMLGregorianCalendar instanceof XMLGregorianCalendar2 && ((XMLGregorianCalendar2)xMLGregorianCalendar).isFractionalSecondInMilliseconds()) {
                XMLGregorianCalendar2 xMLGregorianCalendar2 = (XMLGregorianCalendar2)xMLGregorianCalendar;
                int n = xMLGregorianCalendar.getMillisecond();
                int n2 = xMLGregorianCalendar2.getFractionalSecondScale();
                ValueWriter.writeMilliseconds(bufferedOutput, n, n2);
            } else {
                ValueWriter.writeFractionalSeconds(bufferedOutput, xMLGregorianCalendar.getFractionalSecond());
            }
        } else if (qName == DatatypeConstants.DATE) {
            ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
        } else if (qName == DatatypeConstants.TIME) {
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getHour());
            bufferedOutput.write((byte)58);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMinute());
            bufferedOutput.write((byte)58);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getSecond());
            if (xMLGregorianCalendar instanceof XMLGregorianCalendar2 && ((XMLGregorianCalendar2)xMLGregorianCalendar).isFractionalSecondInMilliseconds()) {
                XMLGregorianCalendar2 xMLGregorianCalendar2 = (XMLGregorianCalendar2)xMLGregorianCalendar;
                int n = xMLGregorianCalendar.getMillisecond();
                int n3 = xMLGregorianCalendar2.getFractionalSecondScale();
                ValueWriter.writeMilliseconds(bufferedOutput, n, n3);
            } else {
                ValueWriter.writeFractionalSeconds(bufferedOutput, xMLGregorianCalendar.getFractionalSecond());
            }
        } else if (qName == DatatypeConstants.GYEAR) {
            ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
        } else if (qName == DatatypeConstants.GMONTH) {
            bufferedOutput.write((byte)45);
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
            bufferedOutput.write((byte)45);
            bufferedOutput.write((byte)45);
        } else if (qName == DatatypeConstants.GDAY) {
            bufferedOutput.write((byte)45);
            bufferedOutput.write((byte)45);
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
        } else if (qName == DatatypeConstants.GYEARMONTH) {
            ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
        } else if (qName == DatatypeConstants.GMONTHDAY) {
            bufferedOutput.write((byte)45);
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
            bufferedOutput.write((byte)45);
            ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
        }
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCDateTimeElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
        bufferedOutput.write((byte)84);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getHour());
        bufferedOutput.write((byte)58);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMinute());
        bufferedOutput.write((byte)58);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getSecond());
        if (xMLGregorianCalendar instanceof XMLGregorianCalendar2 && ((XMLGregorianCalendar2)xMLGregorianCalendar).isFractionalSecondInMilliseconds()) {
            XMLGregorianCalendar2 xMLGregorianCalendar2 = (XMLGregorianCalendar2)xMLGregorianCalendar;
            int n = xMLGregorianCalendar.getMillisecond();
            int n2 = xMLGregorianCalendar2.getFractionalSecondScale();
            ValueWriter.writeMilliseconds(bufferedOutput, n, n2);
        } else {
            ValueWriter.writeFractionalSeconds(bufferedOutput, xMLGregorianCalendar.getFractionalSecond());
        }
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCDateElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCTimeElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getHour());
        bufferedOutput.write((byte)58);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMinute());
        bufferedOutput.write((byte)58);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getSecond());
        if (xMLGregorianCalendar instanceof XMLGregorianCalendar2 && ((XMLGregorianCalendar2)xMLGregorianCalendar).isFractionalSecondInMilliseconds()) {
            XMLGregorianCalendar2 xMLGregorianCalendar2 = (XMLGregorianCalendar2)xMLGregorianCalendar;
            int n = xMLGregorianCalendar.getMillisecond();
            int n2 = xMLGregorianCalendar2.getFractionalSecondScale();
            ValueWriter.writeMilliseconds(bufferedOutput, n, n2);
        } else {
            ValueWriter.writeFractionalSeconds(bufferedOutput, xMLGregorianCalendar.getFractionalSecond());
        }
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGYearElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGMonthElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        bufferedOutput.write((byte)45);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
        bufferedOutput.write((byte)45);
        bufferedOutput.write((byte)45);
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGDayElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        bufferedOutput.write((byte)45);
        bufferedOutput.write((byte)45);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGYearMonthElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeYear(bufferedOutput, xMLGregorianCalendar);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGMonthDayElem(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        bufferedOutput.write((byte)45);
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getMonth());
        bufferedOutput.write((byte)45);
        ValueWriter.writeIntTwoDigits(bufferedOutput, xMLGregorianCalendar.getDay());
        ValueWriter.writeTimezone(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeHexBinaryElem(BufferedOutput bufferedOutput, byte[] byArray) throws IOException {
        for (byte by : byArray) {
            bufferedOutput.write(HEX[by >> 4 & 0xF]);
            bufferedOutput.write(HEX[by & 0xF]);
        }
    }

    public static void writeBase64BinaryElem(BufferedOutput bufferedOutput, byte[] byArray) throws IOException {
        ValueWriter.writeBase64Binary(bufferedOutput, byArray, byArray.length);
    }

    static void writeBase64Binary(BufferedOutput bufferedOutput, byte[] byArray, int n) throws IOException {
        byte by;
        byte by2;
        int n2 = n % 3;
        int n3 = 0;
        while (n3 < n - n2) {
            by2 = byArray[n3++];
            by = byArray[n3++];
            byte by3 = byArray[n3++];
            bufferedOutput.write(BASE64[by2 >> 2 & 0x3F]);
            bufferedOutput.write(BASE64[(by2 & 3) << 4 | by >> 4 & 0xF]);
            bufferedOutput.write(BASE64[(by & 0xF) << 2 | by3 >> 6 & 3]);
            bufferedOutput.write(BASE64[by3 & 0x3F]);
        }
        if (n2 == 1) {
            by2 = byArray[n3];
            bufferedOutput.write(BASE64[by2 >> 2 & 0x3F]);
            bufferedOutput.write(BASE64[(by2 & 3) << 4]);
            bufferedOutput.write((byte)61);
            bufferedOutput.write((byte)61);
        } else if (n2 == 2) {
            by2 = byArray[n3++];
            by = byArray[n3++];
            bufferedOutput.write(BASE64[by2 >> 2 & 0x3F]);
            bufferedOutput.write(BASE64[(by2 & 3) << 4 | by >> 4 & 0xF]);
            bufferedOutput.write(BASE64[(by & 0xF) << 2]);
            bufferedOutput.write((byte)61);
        }
    }

    public static void writeBase64BinaryMtomAttachmentAttr(BufferedOutput bufferedOutput, byte[] byArray, AttachmentMarshaller attachmentMarshaller, String string) throws IOException {
    }

    private static void writeMtomAttachment(BufferedOutput bufferedOutput, String string) throws IOException {
        bufferedOutput.write(XOP_ELEMENT);
        ValueWriter.writeStringAttr(bufferedOutput, string);
        bufferedOutput.write((byte)34);
        bufferedOutput.write((byte)47);
        bufferedOutput.write((byte)62);
    }

    public static void writeBase64BinaryMtomAttachmentElem(BufferedOutput bufferedOutput, byte[] byArray, AttachmentMarshaller attachmentMarshaller, String string) throws IOException {
        ValueWriter.writeMtomAttachment(bufferedOutput, attachmentMarshaller.addMtomAttachment(byArray, 0, byArray.length, string, XOP_NS, XOP_INCLUDE));
    }

    public static void writeQNameAttr(BufferedOutput bufferedOutput, QName qName, int n) throws IOException {
        if (n != -2) {
            if (n < 0) {
                bufferedOutput.write((byte)(-n));
            } else {
                bufferedOutput.write(bufferedOutput.nsContext.getPrefix(n));
            }
            bufferedOutput.write((byte)58);
        }
        ValueWriter.writeStringAttr(bufferedOutput, qName.getLocalPart());
    }

    public static void writeQNameElem(BufferedOutput bufferedOutput, QName qName, int n) throws IOException {
        if (n != -2) {
            if (n < 0) {
                bufferedOutput.write((byte)(-n));
            } else {
                bufferedOutput.write(bufferedOutput.nsContext.getPrefix(n));
            }
            bufferedOutput.write((byte)58);
        }
        ValueWriter.writeStringElem(bufferedOutput, qName.getLocalPart());
    }

    public static void writeQNameNoEscape(BufferedOutput bufferedOutput, QName qName, int n) throws IOException {
        if (n != -2) {
            if (n < 0) {
                bufferedOutput.write((byte)(-n));
            } else {
                bufferedOutput.write(bufferedOutput.nsContext.getPrefix(n));
            }
            bufferedOutput.write((byte)58);
        }
        ValueWriter.writeStringNoEscapeElem(bufferedOutput, qName.getLocalPart());
    }

    public static void writeURIAttr(BufferedOutput bufferedOutput, URI uRI) throws IOException {
        ValueWriter.writeStringAttr(bufferedOutput, uRI.toString());
    }

    public static void writeURIElem(BufferedOutput bufferedOutput, URI uRI) throws IOException {
        ValueWriter.writeStringElem(bufferedOutput, uRI.toString());
    }

    private static boolean writeImageToStream(Image image, final String string, final OutputStream outputStream) throws IOException {
        int n;
        RenderedImage renderedImage;
        if (image instanceof RenderedImage) {
            renderedImage = (RenderedImage)((Object)image);
        } else {
            n = image.getWidth(null);
            int n2 = image.getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            renderedImage = bufferedImage;
        }
        n = 0;
        try {
            n = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return ImageIO.write(renderedImage, string, outputStream);
                }
            }).booleanValue() ? 1 : 0;
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        catch (BufferedOutput.IOExceptionWrapper iOExceptionWrapper) {
            throw (IOException)iOExceptionWrapper.getCause();
        }
        return n != 0;
    }

    public static void writeImageElem(BufferedOutput bufferedOutput, Image image, String string) throws IOException {
        if (ValueWriter.writeImageToStream(image, string, bufferedOutput.base64Stream)) {
            bufferedOutput.base64Stream.close();
        }
    }

    public static void writeImageMtomAttachmentAttr(BufferedOutput bufferedOutput, Image image, String string, AttachmentMarshaller attachmentMarshaller, String string2) throws IOException {
    }

    public static void writeImageMtomAttachmentElem(BufferedOutput bufferedOutput, Image image, String string, AttachmentMarshaller attachmentMarshaller, String string2) throws IOException {
        BufferedOutput.ByteArrayOutput byteArrayOutput = bufferedOutput.getByteArrayOutput();
        byteArrayOutput.reset();
        ValueWriter.writeImageToStream(image, string, byteArrayOutput);
        ValueWriter.writeMtomAttachment(bufferedOutput, attachmentMarshaller.addMtomAttachment(byteArrayOutput.getBytes(), 0, byteArrayOutput.size(), string2, XOP_NS, XOP_INCLUDE));
    }

    public static void writeDataHandlerElem(BufferedOutput bufferedOutput, DataHandler dataHandler) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = bufferedOutput.base64Stream;
        dataHandler.writeTo(byteArrayOutputStream);
        ((OutputStream)byteArrayOutputStream).close();
    }

    public static void writeDataHandlerMtomAttachmentAttr(BufferedOutput bufferedOutput, DataHandler dataHandler, AttachmentMarshaller attachmentMarshaller) throws IOException {
    }

    public static void writeDataHandlerMtomAttachmentElem(BufferedOutput bufferedOutput, DataHandler dataHandler, AttachmentMarshaller attachmentMarshaller) throws IOException {
        ValueWriter.writeMtomAttachment(bufferedOutput, attachmentMarshaller.addMtomAttachment(dataHandler, XOP_NS, XOP_INCLUDE));
    }

    public static void writeDataHandlerSwaRefAttachmentAttr(BufferedOutput bufferedOutput, DataHandler dataHandler, AttachmentMarshaller attachmentMarshaller) throws IOException {
        ValueWriter.writeStringAttr(bufferedOutput, attachmentMarshaller.addSwaRefAttachment(dataHandler));
    }

    public static void writeDataHandlerSwaRefAttachmentElem(BufferedOutput bufferedOutput, DataHandler dataHandler, AttachmentMarshaller attachmentMarshaller) throws IOException {
        ValueWriter.writeStringElem(bufferedOutput, attachmentMarshaller.addSwaRefAttachment(dataHandler));
    }

    public static void writeSourceElem(BufferedOutput bufferedOutput, Source source) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = bufferedOutput.base64Stream;
        if (source instanceof StreamSource) {
            int n;
            StreamSource streamSource = (StreamSource)source;
            Reader reader = streamSource.getReader();
            if (reader != null) {
                int n2;
                char[] cArray = bufferedOutput.chars;
                byte[] byArray = bufferedOutput.bytes;
                int[] nArray = bufferedOutput.results;
                while ((n2 = reader.read(cArray)) >= 0) {
                    CharConversionError charConversionError = UTF8Support.convertCharsToBytes(cArray, 0, n2, byArray, 0, 6144, nArray);
                    if (charConversionError != null) {
                        throw new CharConversionException(charConversionError.formatErrorMessage());
                    }
                    ((OutputStream)byteArrayOutputStream).write(byArray, 0, nArray[1]);
                }
                ((OutputStream)byteArrayOutputStream).close();
                return;
            }
            boolean bl = false;
            InputStream inputStream = streamSource.getInputStream();
            if (inputStream == null) {
                inputStream = new URL(streamSource.getSystemId()).openStream();
                bl = true;
            }
            byte[] byArray = bufferedOutput.bytes;
            while ((n = inputStream.read(byArray)) >= 0) {
                ((OutputStream)byteArrayOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)byteArrayOutputStream).close();
            if (bl) {
                inputStream.close();
            }
            return;
        }
        Transformer transformer = bufferedOutput.getIdentityTransformer();
        try {
            transformer.transform(source, bufferedOutput.getStreamResult());
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        ((OutputStream)byteArrayOutputStream).close();
    }

    public static void writeUUIDElem(BufferedOutput bufferedOutput, UUID uUID) throws IOException {
        ValueWriter.writeStringNoEscapeElem(bufferedOutput, uUID.toString());
    }

    public static void writeFileAttr(BufferedOutput bufferedOutput, File file) throws IOException {
        ValueWriter.writeStringAttr(bufferedOutput, file.getPath());
    }

    public static void writeFileElem(BufferedOutput bufferedOutput, File file) throws IOException {
        ValueWriter.writeStringElem(bufferedOutput, file.getPath());
    }

    public static void writeURLAttr(BufferedOutput bufferedOutput, URL uRL) throws IOException {
        ValueWriter.writeStringAttr(bufferedOutput, uRL.toString());
    }

    public static void writeURLElem(BufferedOutput bufferedOutput, URL uRL) throws IOException {
        ValueWriter.writeStringElem(bufferedOutput, uRL.toString());
    }

    public static void writeQNameAttrList(BufferedOutput bufferedOutput, List<QName> list, int[] nArray) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            QName qName = list.get(i);
            if (qName == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeQNameAttr(bufferedOutput, qName, nArray[i]);
        }
    }

    public static void writeQNameAttrCollection(BufferedOutput bufferedOutput, Collection<QName> collection, int[] nArray) throws IOException {
        Iterator<QName> iterator = collection.iterator();
        boolean bl = true;
        int n = 0;
        while (iterator.hasNext()) {
            QName qName = iterator.next();
            if (qName != null) {
                if (bl) {
                    bl = false;
                } else {
                    bufferedOutput.write((byte)32);
                }
                ValueWriter.writeQNameAttr(bufferedOutput, qName, nArray[n]);
            }
            ++n;
        }
    }

    public static void writeQNameElemList(BufferedOutput bufferedOutput, List<QName> list, int[] nArray) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            QName qName = list.get(i);
            if (qName == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeQNameElem(bufferedOutput, qName, nArray[i]);
        }
    }

    public static void writeQNameElemCollection(BufferedOutput bufferedOutput, Collection<QName> collection, int[] nArray) throws IOException {
        Iterator<QName> iterator = collection.iterator();
        boolean bl = true;
        int n = 0;
        while (iterator.hasNext()) {
            QName qName = iterator.next();
            if (qName != null) {
                if (bl) {
                    bl = false;
                } else {
                    bufferedOutput.write((byte)32);
                }
                ValueWriter.writeQNameElem(bufferedOutput, qName, nArray[n]);
            }
            ++n;
        }
    }

    public static void writeStringElemList(BufferedOutput bufferedOutput, List<String> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeStringElem(bufferedOutput, string);
        }
    }

    public static void writeStringElemCollection(BufferedOutput bufferedOutput, Collection<String> collection) throws IOException {
        Iterator<String> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeStringElem(bufferedOutput, string);
        }
    }

    public static void writeStringAttrList(BufferedOutput bufferedOutput, List<String> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeStringAttr(bufferedOutput, string);
        }
    }

    public static void writeStringAttrCollection(BufferedOutput bufferedOutput, Collection<String> collection) throws IOException {
        Iterator<String> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeStringAttr(bufferedOutput, string);
        }
    }

    public static void writeStringNoEscapeElemList(BufferedOutput bufferedOutput, List<String> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeStringNoEscapeElem(bufferedOutput, string);
        }
    }

    public static void writeStringNoEscapeElemCollection(BufferedOutput bufferedOutput, Collection<String> collection) throws IOException {
        Iterator<String> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeStringNoEscapeElem(bufferedOutput, string);
        }
    }

    public static void writeBooleanElemList(BufferedOutput bufferedOutput, List<Boolean> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Boolean bl2 = list.get(i);
            if (bl2 == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBooleanElem(bufferedOutput, bl2);
        }
    }

    public static void writeBooleanElemCollection(BufferedOutput bufferedOutput, Collection<Boolean> collection) throws IOException {
        Iterator<Boolean> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Boolean bl2 = iterator.next();
            if (bl2 == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBooleanElem(bufferedOutput, bl2);
        }
    }

    public static void writeBigDecimalElemList(BufferedOutput bufferedOutput, List<BigDecimal> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BigDecimal bigDecimal = list.get(i);
            if (bigDecimal == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBigDecimalElem(bufferedOutput, bigDecimal);
        }
    }

    public static void writeBigDecimalElemCollection(BufferedOutput bufferedOutput, Collection<BigDecimal> collection) throws IOException {
        Iterator<BigDecimal> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            BigDecimal bigDecimal = iterator.next();
            if (bigDecimal == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBigDecimalElem(bufferedOutput, bigDecimal);
        }
    }

    public static void writeBigIntegerElemList(BufferedOutput bufferedOutput, List<BigInteger> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger = list.get(i);
            if (bigInteger == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBigIntegerElem(bufferedOutput, bigInteger);
        }
    }

    public static void writeBigIntegerElemCollection(BufferedOutput bufferedOutput, Collection<BigInteger> collection) throws IOException {
        Iterator<BigInteger> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            BigInteger bigInteger = iterator.next();
            if (bigInteger == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBigIntegerElem(bufferedOutput, bigInteger);
        }
    }

    public static void writeLongElemList(BufferedOutput bufferedOutput, List<Long> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Long l = list.get(i);
            if (l == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeLongElem(bufferedOutput, l);
        }
    }

    public static void writeLongElemCollection(BufferedOutput bufferedOutput, Collection<Long> collection) throws IOException {
        Iterator<Long> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Long l = iterator.next();
            if (l == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeLongElem(bufferedOutput, l);
        }
    }

    public static void writeIntegerElemList(BufferedOutput bufferedOutput, List<Integer> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Integer n2 = list.get(i);
            if (n2 == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeIntegerElem(bufferedOutput, n2);
        }
    }

    public static void writeIntegerElemCollection(BufferedOutput bufferedOutput, Collection<Integer> collection) throws IOException {
        Iterator<Integer> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            if (n == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeIntegerElem(bufferedOutput, n);
        }
    }

    public static void writeShortElemList(BufferedOutput bufferedOutput, List<Short> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Short s = list.get(i);
            if (s == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeShortElem(bufferedOutput, s);
        }
    }

    public static void writeShortElemCollection(BufferedOutput bufferedOutput, Collection<Short> collection) throws IOException {
        Iterator<Short> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Short s = iterator.next();
            if (s == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeShortElem(bufferedOutput, s);
        }
    }

    public static void writeByteElemList(BufferedOutput bufferedOutput, List<Byte> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Byte by = list.get(i);
            if (by == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeByteElem(bufferedOutput, by);
        }
    }

    public static void writeByteElemCollection(BufferedOutput bufferedOutput, Collection<Byte> collection) throws IOException {
        Iterator<Byte> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Byte by = iterator.next();
            if (by == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeByteElem(bufferedOutput, by);
        }
    }

    public static void writeFloatElemList(BufferedOutput bufferedOutput, List<Float> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Float f = list.get(i);
            if (f == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeFloatElem(bufferedOutput, f);
        }
    }

    public static void writeFloatElemCollection(BufferedOutput bufferedOutput, Collection<Float> collection) throws IOException {
        Iterator<Float> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Float f = iterator.next();
            if (f == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeFloatElem(bufferedOutput, f);
        }
    }

    public static void writeDoubleElemList(BufferedOutput bufferedOutput, List<Double> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Double d = list.get(i);
            if (d == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDoubleElem(bufferedOutput, d);
        }
    }

    public static void writeDoubleElemCollection(BufferedOutput bufferedOutput, Collection<Double> collection) throws IOException {
        Iterator<Double> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Double d = iterator.next();
            if (d == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDoubleElem(bufferedOutput, d);
        }
    }

    public static void writeCharacterElemList(BufferedOutput bufferedOutput, List<Character> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Character c = list.get(i);
            if (c == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeCharacterElem(bufferedOutput, c);
        }
    }

    public static void writeCharacterElemCollection(BufferedOutput bufferedOutput, Collection<Character> collection) throws IOException {
        Iterator<Character> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Character c = iterator.next();
            if (c == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeCharacterElem(bufferedOutput, c);
        }
    }

    public static void writeDurationElemList(BufferedOutput bufferedOutput, List<Duration> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Duration duration = list.get(i);
            if (duration == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDurationElem(bufferedOutput, duration);
        }
    }

    public static void writeDurationElemCollection(BufferedOutput bufferedOutput, Collection<Duration> collection) throws IOException {
        Iterator<Duration> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Duration duration = iterator.next();
            if (duration == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDurationElem(bufferedOutput, duration);
        }
    }

    public static void writeGCalendarElemList(BufferedOutput bufferedOutput, List<GregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            GregorianCalendar gregorianCalendar = list.get(i);
            if (gregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeGCalendarElem(bufferedOutput, gregorianCalendar);
        }
    }

    public static void writeGCalendarElemCollection(BufferedOutput bufferedOutput, Collection<GregorianCalendar> collection) throws IOException {
        Iterator<GregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            GregorianCalendar gregorianCalendar = iterator.next();
            if (gregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeGCalendarElem(bufferedOutput, gregorianCalendar);
        }
    }

    public static void writeCalendarElemList(BufferedOutput bufferedOutput, List<Calendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Calendar calendar = list.get(i);
            if (calendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeCalendarElem(bufferedOutput, calendar);
        }
    }

    public static void writeCalendarElemCollection(BufferedOutput bufferedOutput, Collection<Calendar> collection) throws IOException {
        Iterator<Calendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Calendar calendar = iterator.next();
            if (calendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeCalendarElem(bufferedOutput, calendar);
        }
    }

    public static void writeDateElemList(BufferedOutput bufferedOutput, List<Date> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Date date = list.get(i);
            if (date == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDateElem(bufferedOutput, date);
        }
    }

    public static void writeDateElemCollection(BufferedOutput bufferedOutput, Collection<Date> collection) throws IOException {
        Iterator<Date> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Date date = iterator.next();
            if (date == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDateElem(bufferedOutput, date);
        }
    }

    public static void writeXGCalendarElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCalendarElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCalendarElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCalendarElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCDateTimeElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCDateTimeElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCDateTimeElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCDateTimeElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCDateElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCDateElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCDateElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCDateElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCTimeElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCTimeElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCTimeElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCTimeElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGYearElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGYearElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGYearElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGYearElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGMonthElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGMonthElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGMonthElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGMonthElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGDayElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGDayElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGDayElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGDayElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGYearMonthElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGYearMonthElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGYearMonthElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGYearMonthElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGMonthDayElemList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            XMLGregorianCalendar xMLGregorianCalendar = list.get(i);
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGMonthDayElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeXGCGMonthDayElemCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        Iterator<XMLGregorianCalendar> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            XMLGregorianCalendar xMLGregorianCalendar = iterator.next();
            if (xMLGregorianCalendar == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeXGCGMonthDayElem(bufferedOutput, xMLGregorianCalendar);
        }
    }

    public static void writeHexBinaryElemList(BufferedOutput bufferedOutput, List<byte[]> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = list.get(i);
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeHexBinaryElem(bufferedOutput, byArray);
        }
    }

    public static void writeHexBinaryElemCollection(BufferedOutput bufferedOutput, Collection<byte[]> collection) throws IOException {
        Iterator<byte[]> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeHexBinaryElem(bufferedOutput, byArray);
        }
    }

    public static void writeBase64BinaryElemList(BufferedOutput bufferedOutput, List<byte[]> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = list.get(i);
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBase64BinaryElem(bufferedOutput, byArray);
        }
    }

    public static void writeBase64BinaryElemCollection(BufferedOutput bufferedOutput, Collection<byte[]> collection) throws IOException {
        Iterator<byte[]> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBase64BinaryElem(bufferedOutput, byArray);
        }
    }

    public static void writeBase64BinaryMtomAttachmentElemList(BufferedOutput bufferedOutput, List<byte[]> list, AttachmentMarshaller attachmentMarshaller, String string) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = list.get(i);
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBase64BinaryMtomAttachmentElem(bufferedOutput, byArray, attachmentMarshaller, string);
        }
    }

    public static void writeBase64BinaryMtomAttachmentElemCollection(BufferedOutput bufferedOutput, Collection<byte[]> collection, AttachmentMarshaller attachmentMarshaller, String string) throws IOException {
        Iterator<byte[]> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBase64BinaryMtomAttachmentElem(bufferedOutput, byArray, attachmentMarshaller, string);
        }
    }

    public static void writeBase64BinaryMtomAttachmentAttrList(BufferedOutput bufferedOutput, List<byte[]> list, AttachmentMarshaller attachmentMarshaller, String string) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = list.get(i);
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBase64BinaryMtomAttachmentAttr(bufferedOutput, byArray, attachmentMarshaller, string);
        }
    }

    public static void writeBase64BinaryMtomAttachmentAttrCollection(BufferedOutput bufferedOutput, Collection<byte[]> collection, AttachmentMarshaller attachmentMarshaller, String string) throws IOException {
        Iterator<byte[]> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            if (byArray == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeBase64BinaryMtomAttachmentAttr(bufferedOutput, byArray, attachmentMarshaller, string);
        }
    }

    public static void writeURIElemList(BufferedOutput bufferedOutput, List<URI> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            URI uRI = list.get(i);
            if (uRI == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURIElem(bufferedOutput, uRI);
        }
    }

    public static void writeURIElemCollection(BufferedOutput bufferedOutput, Collection<URI> collection) throws IOException {
        Iterator<URI> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            URI uRI = iterator.next();
            if (uRI == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURIElem(bufferedOutput, uRI);
        }
    }

    public static void writeURIAttrList(BufferedOutput bufferedOutput, List<URI> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            URI uRI = list.get(i);
            if (uRI == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURIAttr(bufferedOutput, uRI);
        }
    }

    public static void writeURIAttrCollection(BufferedOutput bufferedOutput, Collection<URI> collection) throws IOException {
        Iterator<URI> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            URI uRI = iterator.next();
            if (uRI == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURIAttr(bufferedOutput, uRI);
        }
    }

    public static void writeImageElemList(BufferedOutput bufferedOutput, List<Image> list, String string) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Image image = list.get(i);
            if (image == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeImageElem(bufferedOutput, image, string);
        }
    }

    public static void writeImageElemCollection(BufferedOutput bufferedOutput, Collection<Image> collection, String string) throws IOException {
        Iterator<Image> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Image image = iterator.next();
            if (image == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeImageElem(bufferedOutput, image, string);
        }
    }

    public static void writeImageMtomAttachmentElemList(BufferedOutput bufferedOutput, List<Image> list, String string, AttachmentMarshaller attachmentMarshaller, String string2) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Image image = list.get(i);
            if (image == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeImageMtomAttachmentElem(bufferedOutput, image, string, attachmentMarshaller, string2);
        }
    }

    public static void writeImageMtomAttachmentElemCollection(BufferedOutput bufferedOutput, Collection<Image> collection, String string, AttachmentMarshaller attachmentMarshaller, String string2) throws IOException {
        Iterator<Image> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Image image = iterator.next();
            if (image == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeImageMtomAttachmentElem(bufferedOutput, image, string, attachmentMarshaller, string2);
        }
    }

    public static void writeImageMtomAttachmentAttrList(BufferedOutput bufferedOutput, List<Image> list, String string, AttachmentMarshaller attachmentMarshaller, String string2) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Image image = list.get(i);
            if (image == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeImageMtomAttachmentAttr(bufferedOutput, image, string, attachmentMarshaller, string2);
        }
    }

    public static void writeImageMtomAttachmentAttrCollection(BufferedOutput bufferedOutput, Collection<Image> collection, String string, AttachmentMarshaller attachmentMarshaller, String string2) throws IOException {
        Iterator<Image> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Image image = iterator.next();
            if (image == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeImageMtomAttachmentAttr(bufferedOutput, image, string, attachmentMarshaller, string2);
        }
    }

    public static void writeDataHandlerElemList(BufferedOutput bufferedOutput, List<DataHandler> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DataHandler dataHandler = list.get(i);
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerElem(bufferedOutput, dataHandler);
        }
    }

    public static void writeDataHandlerElemCollection(BufferedOutput bufferedOutput, Collection<DataHandler> collection) throws IOException {
        Iterator<DataHandler> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DataHandler dataHandler = iterator.next();
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerElem(bufferedOutput, dataHandler);
        }
    }

    public static void writeDataHandlerMtomAttachmentElemList(BufferedOutput bufferedOutput, List<DataHandler> list, AttachmentMarshaller attachmentMarshaller) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DataHandler dataHandler = list.get(i);
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerMtomAttachmentElem(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeDataHandlerMtomAttachmentElemCollection(BufferedOutput bufferedOutput, Collection<DataHandler> collection, AttachmentMarshaller attachmentMarshaller) throws IOException {
        Iterator<DataHandler> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DataHandler dataHandler = iterator.next();
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerMtomAttachmentElem(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeDataHandlerMtomAttachmentAttrList(BufferedOutput bufferedOutput, List<DataHandler> list, AttachmentMarshaller attachmentMarshaller) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DataHandler dataHandler = list.get(i);
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerMtomAttachmentAttr(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeDataHandlerMtomAttachmentAttrCollection(BufferedOutput bufferedOutput, Collection<DataHandler> collection, AttachmentMarshaller attachmentMarshaller) throws IOException {
        Iterator<DataHandler> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DataHandler dataHandler = iterator.next();
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerMtomAttachmentAttr(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeDataHandlerSwaRefAttachmentElemList(BufferedOutput bufferedOutput, List<DataHandler> list, AttachmentMarshaller attachmentMarshaller) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DataHandler dataHandler = list.get(i);
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerSwaRefAttachmentElem(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeDataHandlerSwaRefAttachmentElemCollection(BufferedOutput bufferedOutput, Collection<DataHandler> collection, AttachmentMarshaller attachmentMarshaller) throws IOException {
        Iterator<DataHandler> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DataHandler dataHandler = iterator.next();
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerSwaRefAttachmentElem(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeDataHandlerSwaRefAttachmentAttrList(BufferedOutput bufferedOutput, List<DataHandler> list, AttachmentMarshaller attachmentMarshaller) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DataHandler dataHandler = list.get(i);
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerSwaRefAttachmentAttr(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeDataHandlerSwaRefAttachmentAttrCollection(BufferedOutput bufferedOutput, Collection<DataHandler> collection, AttachmentMarshaller attachmentMarshaller) throws IOException {
        Iterator<DataHandler> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DataHandler dataHandler = iterator.next();
            if (dataHandler == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeDataHandlerSwaRefAttachmentAttr(bufferedOutput, dataHandler, attachmentMarshaller);
        }
    }

    public static void writeSourceElemList(BufferedOutput bufferedOutput, List<Source> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Source source = list.get(i);
            if (source == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeSourceElem(bufferedOutput, source);
        }
    }

    public static void writeSourceElemCollection(BufferedOutput bufferedOutput, Collection<Source> collection) throws IOException {
        Iterator<Source> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Source source = iterator.next();
            if (source == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeSourceElem(bufferedOutput, source);
        }
    }

    public static void writeUUIDElemList(BufferedOutput bufferedOutput, List<UUID> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UUID uUID = list.get(i);
            if (uUID == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeUUIDElem(bufferedOutput, uUID);
        }
    }

    public static void writeUUIDElemCollection(BufferedOutput bufferedOutput, Collection<UUID> collection) throws IOException {
        Iterator<UUID> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            UUID uUID = iterator.next();
            if (uUID == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeUUIDElem(bufferedOutput, uUID);
        }
    }

    public static void writeFileElemList(BufferedOutput bufferedOutput, List<File> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            File file = list.get(i);
            if (file == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeFileElem(bufferedOutput, file);
        }
    }

    public static void writeFileElemCollection(BufferedOutput bufferedOutput, Collection<File> collection) throws IOException {
        Iterator<File> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (file == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeFileElem(bufferedOutput, file);
        }
    }

    public static void writeFileAttrList(BufferedOutput bufferedOutput, List<File> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            File file = list.get(i);
            if (file == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeFileAttr(bufferedOutput, file);
        }
    }

    public static void writeFileAttrCollection(BufferedOutput bufferedOutput, Collection<File> collection) throws IOException {
        Iterator<File> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (file == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeFileAttr(bufferedOutput, file);
        }
    }

    public static void writeURLElemList(BufferedOutput bufferedOutput, List<URL> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            URL uRL = list.get(i);
            if (uRL == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURLElem(bufferedOutput, uRL);
        }
    }

    public static void writeURLElemCollection(BufferedOutput bufferedOutput, Collection<URL> collection) throws IOException {
        Iterator<URL> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            URL uRL = iterator.next();
            if (uRL == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURLElem(bufferedOutput, uRL);
        }
    }

    public static void writeURLAttrList(BufferedOutput bufferedOutput, List<URL> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            URL uRL = list.get(i);
            if (uRL == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURLAttr(bufferedOutput, uRL);
        }
    }

    public static void writeURLAttrCollection(BufferedOutput bufferedOutput, Collection<URL> collection) throws IOException {
        Iterator<URL> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            URL uRL = iterator.next();
            if (uRL == null) continue;
            if (bl) {
                bl = false;
            } else {
                bufferedOutput.write((byte)32);
            }
            ValueWriter.writeURLAttr(bufferedOutput, uRL);
        }
    }

    public static void writeStringNoEscapeAttr(BufferedOutput bufferedOutput, String string) throws IOException {
        ValueWriter.writeStringNoEscapeElem(bufferedOutput, string);
    }

    public static void writeStringNoEscapeAttrList(BufferedOutput bufferedOutput, List<String> list) throws IOException {
        ValueWriter.writeStringNoEscapeElemList(bufferedOutput, list);
    }

    public static void writeStringNoEscapeAttrCollection(BufferedOutput bufferedOutput, Collection<String> collection) throws IOException {
        ValueWriter.writeStringNoEscapeElemCollection(bufferedOutput, collection);
    }

    public static void writeBooleanAttr(BufferedOutput bufferedOutput, boolean bl) throws IOException {
        ValueWriter.writeBooleanElem(bufferedOutput, bl);
    }

    public static void writeBooleanAttr(BufferedOutput bufferedOutput, Boolean bl) throws IOException {
        ValueWriter.writeBooleanElem(bufferedOutput, bl);
    }

    public static void writeBooleanAttrList(BufferedOutput bufferedOutput, List<Boolean> list) throws IOException {
        ValueWriter.writeBooleanElemList(bufferedOutput, list);
    }

    public static void writeBooleanAttrCollection(BufferedOutput bufferedOutput, Collection<Boolean> collection) throws IOException {
        ValueWriter.writeBooleanElemCollection(bufferedOutput, collection);
    }

    public static void writeBigDecimalAttr(BufferedOutput bufferedOutput, BigDecimal bigDecimal) throws IOException {
        ValueWriter.writeBigDecimalElem(bufferedOutput, bigDecimal);
    }

    public static void writeBigDecimalAttrList(BufferedOutput bufferedOutput, List<BigDecimal> list) throws IOException {
        ValueWriter.writeBigDecimalElemList(bufferedOutput, list);
    }

    public static void writeBigDecimalAttrCollection(BufferedOutput bufferedOutput, Collection<BigDecimal> collection) throws IOException {
        ValueWriter.writeBigDecimalElemCollection(bufferedOutput, collection);
    }

    public static void writeBigIntegerAttr(BufferedOutput bufferedOutput, BigInteger bigInteger) throws IOException {
        ValueWriter.writeBigIntegerElem(bufferedOutput, bigInteger);
    }

    public static void writeBigIntegerAttrList(BufferedOutput bufferedOutput, List<BigInteger> list) throws IOException {
        ValueWriter.writeBigIntegerElemList(bufferedOutput, list);
    }

    public static void writeBigIntegerAttrCollection(BufferedOutput bufferedOutput, Collection<BigInteger> collection) throws IOException {
        ValueWriter.writeBigIntegerElemCollection(bufferedOutput, collection);
    }

    public static void writeLongAttr(BufferedOutput bufferedOutput, long l) throws IOException {
        ValueWriter.writeLongElem(bufferedOutput, l);
    }

    public static void writeLongAttr(BufferedOutput bufferedOutput, Long l) throws IOException {
        ValueWriter.writeLongElem(bufferedOutput, l);
    }

    public static void writeLongAttrList(BufferedOutput bufferedOutput, List<Long> list) throws IOException {
        ValueWriter.writeLongElemList(bufferedOutput, list);
    }

    public static void writeLongAttrCollection(BufferedOutput bufferedOutput, Collection<Long> collection) throws IOException {
        ValueWriter.writeLongElemCollection(bufferedOutput, collection);
    }

    public static void writeIntAttr(BufferedOutput bufferedOutput, int n) throws IOException {
        ValueWriter.writeIntElem(bufferedOutput, n);
    }

    public static void writeIntegerAttr(BufferedOutput bufferedOutput, Integer n) throws IOException {
        ValueWriter.writeIntegerElem(bufferedOutput, n);
    }

    public static void writeIntegerAttrList(BufferedOutput bufferedOutput, List<Integer> list) throws IOException {
        ValueWriter.writeIntegerElemList(bufferedOutput, list);
    }

    public static void writeIntegerAttrCollection(BufferedOutput bufferedOutput, Collection<Integer> collection) throws IOException {
        ValueWriter.writeIntegerElemCollection(bufferedOutput, collection);
    }

    public static void writeShortAttr(BufferedOutput bufferedOutput, short s) throws IOException {
        ValueWriter.writeShortElem(bufferedOutput, s);
    }

    public static void writeShortAttr(BufferedOutput bufferedOutput, Short s) throws IOException {
        ValueWriter.writeShortElem(bufferedOutput, s);
    }

    public static void writeShortAttrList(BufferedOutput bufferedOutput, List<Short> list) throws IOException {
        ValueWriter.writeShortElemList(bufferedOutput, list);
    }

    public static void writeShortAttrCollection(BufferedOutput bufferedOutput, Collection<Short> collection) throws IOException {
        ValueWriter.writeShortElemCollection(bufferedOutput, collection);
    }

    public static void writeByteAttr(BufferedOutput bufferedOutput, byte by) throws IOException {
        ValueWriter.writeByteElem(bufferedOutput, by);
    }

    public static void writeByteAttr(BufferedOutput bufferedOutput, Byte by) throws IOException {
        ValueWriter.writeByteElem(bufferedOutput, by);
    }

    public static void writeByteAttrList(BufferedOutput bufferedOutput, List<Byte> list) throws IOException {
        ValueWriter.writeByteElemList(bufferedOutput, list);
    }

    public static void writeByteAttrCollection(BufferedOutput bufferedOutput, Collection<Byte> collection) throws IOException {
        ValueWriter.writeByteElemCollection(bufferedOutput, collection);
    }

    public static void writeFloatAttr(BufferedOutput bufferedOutput, float f) throws IOException {
        ValueWriter.writeFloatElem(bufferedOutput, f);
    }

    public static void writeFloatAttr(BufferedOutput bufferedOutput, Float f) throws IOException {
        ValueWriter.writeFloatElem(bufferedOutput, f);
    }

    public static void writeFloatAttrList(BufferedOutput bufferedOutput, List<Float> list) throws IOException {
        ValueWriter.writeFloatElemList(bufferedOutput, list);
    }

    public static void writeFloatAttrCollection(BufferedOutput bufferedOutput, Collection<Float> collection) throws IOException {
        ValueWriter.writeFloatElemCollection(bufferedOutput, collection);
    }

    public static void writeDoubleAttr(BufferedOutput bufferedOutput, double d) throws IOException {
        ValueWriter.writeDoubleElem(bufferedOutput, d);
    }

    public static void writeDoubleAttr(BufferedOutput bufferedOutput, Double d) throws IOException {
        ValueWriter.writeDoubleElem(bufferedOutput, d);
    }

    public static void writeDoubleAttrList(BufferedOutput bufferedOutput, List<Double> list) throws IOException {
        ValueWriter.writeDoubleElemList(bufferedOutput, list);
    }

    public static void writeDoubleAttrCollection(BufferedOutput bufferedOutput, Collection<Double> collection) throws IOException {
        ValueWriter.writeDoubleElemCollection(bufferedOutput, collection);
    }

    public static void writeCharAttr(BufferedOutput bufferedOutput, char c) throws IOException {
        ValueWriter.writeCharElem(bufferedOutput, c);
    }

    public static void writeCharacterAttr(BufferedOutput bufferedOutput, Character c) throws IOException {
        ValueWriter.writeCharacterElem(bufferedOutput, c);
    }

    public static void writeCharacterAttrList(BufferedOutput bufferedOutput, List<Character> list) throws IOException {
        ValueWriter.writeCharacterElemList(bufferedOutput, list);
    }

    public static void writeCharacterAttrCollection(BufferedOutput bufferedOutput, Collection<Character> collection) throws IOException {
        ValueWriter.writeCharacterElemCollection(bufferedOutput, collection);
    }

    public static void writeDurationAttr(BufferedOutput bufferedOutput, Duration duration) throws IOException {
        ValueWriter.writeDurationElem(bufferedOutput, duration);
    }

    public static void writeDurationAttrList(BufferedOutput bufferedOutput, List<Duration> list) throws IOException {
        ValueWriter.writeDurationElemList(bufferedOutput, list);
    }

    public static void writeDurationAttrCollection(BufferedOutput bufferedOutput, Collection<Duration> collection) throws IOException {
        ValueWriter.writeDurationElemCollection(bufferedOutput, collection);
    }

    public static void writeGCalendarAttr(BufferedOutput bufferedOutput, GregorianCalendar gregorianCalendar) throws IOException {
        ValueWriter.writeGCalendarElem(bufferedOutput, gregorianCalendar);
    }

    public static void writeGCalendarAttrList(BufferedOutput bufferedOutput, List<GregorianCalendar> list) throws IOException {
        ValueWriter.writeGCalendarElemList(bufferedOutput, list);
    }

    public static void writeGCalendarAttrCollection(BufferedOutput bufferedOutput, Collection<GregorianCalendar> collection) throws IOException {
        ValueWriter.writeGCalendarElemCollection(bufferedOutput, collection);
    }

    public static void writeCalendarAttr(BufferedOutput bufferedOutput, Calendar calendar) throws IOException {
        ValueWriter.writeCalendarElem(bufferedOutput, calendar);
    }

    public static void writeCalendarAttrList(BufferedOutput bufferedOutput, List<Calendar> list) throws IOException {
        ValueWriter.writeCalendarElemList(bufferedOutput, list);
    }

    public static void writeCalendarAttrCollection(BufferedOutput bufferedOutput, Collection<Calendar> collection) throws IOException {
        ValueWriter.writeCalendarElemCollection(bufferedOutput, collection);
    }

    public static void writeDateAttr(BufferedOutput bufferedOutput, Date date) throws IOException {
        ValueWriter.writeDateElem(bufferedOutput, date);
    }

    public static void writeDateAttrList(BufferedOutput bufferedOutput, List<Date> list) throws IOException {
        ValueWriter.writeDateElemList(bufferedOutput, list);
    }

    public static void writeDateAttrCollection(BufferedOutput bufferedOutput, Collection<Date> collection) throws IOException {
        ValueWriter.writeDateElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCalendarAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCalendarElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCalendarAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCalendarElemList(bufferedOutput, list);
    }

    public static void writeXGCalendarAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCalendarElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCDateTimeAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCDateTimeElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCDateTimeAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCDateTimeElemList(bufferedOutput, list);
    }

    public static void writeXGCDateTimeAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCDateTimeElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCDateAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCDateElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCDateAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCDateElemList(bufferedOutput, list);
    }

    public static void writeXGCDateAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCDateElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCTimeAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCTimeElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCTimeAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCTimeElemList(bufferedOutput, list);
    }

    public static void writeXGCTimeAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCTimeElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCGYearAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGYearElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGYearAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGYearElemList(bufferedOutput, list);
    }

    public static void writeXGCGYearAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGYearElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCGMonthAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGMonthElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGMonthAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGMonthElemList(bufferedOutput, list);
    }

    public static void writeXGCGMonthAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGMonthElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCGDayAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGDayElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGDayAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGDayElemList(bufferedOutput, list);
    }

    public static void writeXGCGDayAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGDayElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCGYearMonthAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGYearMonthElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGYearMonthAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGYearMonthElemList(bufferedOutput, list);
    }

    public static void writeXGCGYearMonthAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGYearMonthElemCollection(bufferedOutput, collection);
    }

    public static void writeXGCGMonthDayAttr(BufferedOutput bufferedOutput, XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGMonthDayElem(bufferedOutput, xMLGregorianCalendar);
    }

    public static void writeXGCGMonthDayAttrList(BufferedOutput bufferedOutput, List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGMonthDayElemList(bufferedOutput, list);
    }

    public static void writeXGCGMonthDayAttrCollection(BufferedOutput bufferedOutput, Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGMonthDayElemCollection(bufferedOutput, collection);
    }

    public static void writeHexBinaryAttr(BufferedOutput bufferedOutput, byte[] byArray) throws IOException {
        ValueWriter.writeHexBinaryElem(bufferedOutput, byArray);
    }

    public static void writeHexBinaryAttrList(BufferedOutput bufferedOutput, List<byte[]> list) throws IOException {
        ValueWriter.writeHexBinaryElemList(bufferedOutput, list);
    }

    public static void writeHexBinaryAttrCollection(BufferedOutput bufferedOutput, Collection<byte[]> collection) throws IOException {
        ValueWriter.writeHexBinaryElemCollection(bufferedOutput, collection);
    }

    public static void writeBase64BinaryAttr(BufferedOutput bufferedOutput, byte[] byArray) throws IOException {
        ValueWriter.writeBase64BinaryElem(bufferedOutput, byArray);
    }

    public static void writeBase64BinaryAttrList(BufferedOutput bufferedOutput, List<byte[]> list) throws IOException {
        ValueWriter.writeBase64BinaryElemList(bufferedOutput, list);
    }

    public static void writeBase64BinaryAttrCollection(BufferedOutput bufferedOutput, Collection<byte[]> collection) throws IOException {
        ValueWriter.writeBase64BinaryElemCollection(bufferedOutput, collection);
    }

    public static void writeImageAttr(BufferedOutput bufferedOutput, Image image, String string) throws IOException {
        ValueWriter.writeImageElem(bufferedOutput, image, string);
    }

    public static void writeImageAttrList(BufferedOutput bufferedOutput, List<Image> list, String string) throws IOException {
        ValueWriter.writeImageElemList(bufferedOutput, list, string);
    }

    public static void writeImageAttrCollection(BufferedOutput bufferedOutput, Collection<Image> collection, String string) throws IOException {
        ValueWriter.writeImageElemCollection(bufferedOutput, collection, string);
    }

    public static void writeDataHandlerAttr(BufferedOutput bufferedOutput, DataHandler dataHandler) throws IOException {
        ValueWriter.writeDataHandlerElem(bufferedOutput, dataHandler);
    }

    public static void writeDataHandlerAttrList(BufferedOutput bufferedOutput, List<DataHandler> list) throws IOException {
        ValueWriter.writeDataHandlerElemList(bufferedOutput, list);
    }

    public static void writeDataHandlerAttrCollection(BufferedOutput bufferedOutput, Collection<DataHandler> collection) throws IOException {
        ValueWriter.writeDataHandlerElemCollection(bufferedOutput, collection);
    }

    public static void writeSourceAttr(BufferedOutput bufferedOutput, Source source) throws IOException {
        ValueWriter.writeSourceElem(bufferedOutput, source);
    }

    public static void writeSourceAttrList(BufferedOutput bufferedOutput, List<Source> list) throws IOException {
        ValueWriter.writeSourceElemList(bufferedOutput, list);
    }

    public static void writeSourceAttrCollection(BufferedOutput bufferedOutput, Collection<Source> collection) throws IOException {
        ValueWriter.writeSourceElemCollection(bufferedOutput, collection);
    }

    public static void writeUUIDAttr(BufferedOutput bufferedOutput, UUID uUID) throws IOException {
        ValueWriter.writeUUIDElem(bufferedOutput, uUID);
    }

    public static void writeUUIDAttrList(BufferedOutput bufferedOutput, List<UUID> list) throws IOException {
        ValueWriter.writeUUIDElemList(bufferedOutput, list);
    }

    public static void writeUUIDAttrCollection(BufferedOutput bufferedOutput, Collection<UUID> collection) throws IOException {
        ValueWriter.writeUUIDElemCollection(bufferedOutput, collection);
    }

    static {
        int n;
        HEX = new byte[16];
        for (n = 0; n < 10; ++n) {
            ValueWriter.HEX[n] = (byte)(n + 48);
        }
        for (n = 10; n < 16; ++n) {
            ValueWriter.HEX[n] = (byte)(n - 10 + 65);
        }
        BASE64 = new byte[64];
        for (n = 0; n < 26; ++n) {
            ValueWriter.BASE64[n] = (byte)(n + 65);
        }
        for (n = 0; n < 26; ++n) {
            ValueWriter.BASE64[n + 26] = (byte)(n + 97);
        }
        for (n = 0; n < 10; ++n) {
            ValueWriter.BASE64[n + 52] = (byte)(n + 48);
        }
        ValueWriter.BASE64[62] = 43;
        ValueWriter.BASE64[63] = 47;
        TRUE = new byte[]{116, 114, 117, 101};
        FALSE = new byte[]{102, 97, 108, 115, 101};
        LONG_MIN = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
        INT_MIN = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
        byte[] byArray = null;
        try {
            byArray = "<xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"".getBytes("UTF-8");
        }
        catch (Exception exception) {
            byArray = null;
        }
        XOP_ELEMENT = byArray;
        ESCAPE_ATTR = new byte[128][];
        ValueWriter.ESCAPE_ATTR[60] = new byte[]{38, 108, 116, 59};
        ValueWriter.ESCAPE_ATTR[38] = new byte[]{38, 97, 109, 112, 59};
        ValueWriter.ESCAPE_ATTR[34] = new byte[]{38, 113, 117, 111, 116, 59};
        ValueWriter.ESCAPE_ATTR[9] = new byte[]{38, 35, 120, 57, 59};
        ValueWriter.ESCAPE_ATTR[10] = new byte[]{38, 35, 120, 65, 59};
        ValueWriter.ESCAPE_ATTR[13] = new byte[]{38, 35, 120, 68, 59};
        ESCAPE_ELEM = new byte[128][];
        ValueWriter.ESCAPE_ELEM[60] = new byte[]{38, 108, 116, 59};
        ValueWriter.ESCAPE_ELEM[62] = new byte[]{38, 103, 116, 59};
        ValueWriter.ESCAPE_ELEM[38] = new byte[]{38, 97, 109, 112, 59};
        ValueWriter.ESCAPE_ELEM[13] = new byte[]{38, 35, 120, 68, 59};
    }
}

