/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal.impl;

import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationContext;
import com.ibm.xml.xlxp2.jaxb.model.AttributeProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementWildcardProperty;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.MixedContentProperty;
import com.ibm.xml.xlxp2.jaxb.model.Property;
import com.ibm.xml.xlxp2.jaxb.model.PropertyGroup;
import com.ibm.xml.xlxp2.jaxb.model.SimpleContentProperty;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class SerializationStub {
    public static final byte[] ERROR = new byte[0];
    public static final int QNAME_ID = -20;
    public static final QName XSI_TYPE = QName.valueOf("{http://www.w3.org/2001/XMLSchema-instance}type");
    public static final QName XSI_NIL = QName.valueOf("{http://www.w3.org/2001/XMLSchema-instance}nil");
    public final ValueClass valueClass;
    public final int typeId;
    protected SerializationContext fContext;

    public SerializationStub(ValueClass valueClass) {
        this.valueClass = valueClass;
        this.typeId = valueClass != null ? valueClass.classId : -1;
    }

    public final void invokeBeforeMarshalMethod(Object object) {
        try {
            Method method = SerializationStub.getBeforeMarshalMethod(this.valueClass.javaType);
            method.invoke(object, this.fContext.marshaller);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public final void invokeAfterMarshalMethod(Object object) {
        try {
            Method method = SerializationStub.getAfterMarshalMethod(this.valueClass.javaType);
            method.invoke(object, this.fContext.marshaller);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public final void setContext(SerializationContext serializationContext) {
        this.fContext = serializationContext;
    }

    public abstract void write(Object var1) throws IOException;

    public void writeSimpleContent(Object object) throws IOException {
    }

    public final void writeSimpleTypeObjectList(List<Object> list, SerializationStub serializationStub) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object = list.get(i);
            if (object == null) continue;
            if (bl) {
                bl = false;
            } else {
                this.fContext.writeRawByte((byte)32);
            }
            serializationStub.writeSimpleContent(object);
        }
    }

    public final void writeSimpleTypeObjectCollection(Collection<Object> collection, SerializationStub serializationStub) throws IOException {
        Iterator<Object> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            if (bl) {
                bl = false;
            } else {
                this.fContext.writeRawByte((byte)32);
            }
            serializationStub.writeSimpleContent(object);
        }
    }

    protected String readIDValue(Object object) {
        return null;
    }

    public final void writeWildcardAttributes(Map<QName, String> map) throws IOException {
        SerializationContext serializationContext = this.fContext;
        for (Map.Entry<QName, String> entry : map.entrySet()) {
            QName qName = entry.getKey();
            String string = entry.getValue();
            int n = serializationContext.getPrefixAndDeclareNS(qName);
            serializationContext.writeRawByte((byte)32);
            serializationContext.writeQNameAttributeValue(qName, n);
            serializationContext.writeRawByte((byte)61);
            serializationContext.writeRawByte((byte)34);
            serializationContext.writeStringAttributeValue(string);
            serializationContext.writeRawByte((byte)34);
        }
    }

    public final void writeRootJAXBElement(JAXBElement<?> jAXBElement, byte[] byArray) throws IOException {
        this.writeJAXBElementCommon(jAXBElement, byArray);
    }

    public final void writeJAXBElement(JAXBElement<?> jAXBElement) throws IOException {
        this.writeJAXBElementCommon(jAXBElement, null);
    }

    private void writeJAXBElementCommon(JAXBElement<?> jAXBElement, byte[] byArray) throws IOException {
        SerializationContext serializationContext = this.fContext;
        Object object = jAXBElement.getValue();
        if (!(object instanceof Element)) {
            int n;
            QName qName = jAXBElement.getName();
            serializationContext.pushNSContext();
            serializationContext.writeRawByte((byte)60);
            int n2 = serializationContext.getPrefixDeclareNSAndWriteQName(qName);
            if (byArray != null) {
                serializationContext.writeRawBytes(byArray);
            }
            if (jAXBElement.isTypeSubstituted()) {
                this.writeXSIType(object);
            }
            if (jAXBElement.isNil()) {
                this.writeXSINil();
            }
            int n3 = n = object != null ? serializationContext.getClassIdentifier(object) : -1;
            if (n >= 0) {
                SerializationStub serializationStub = serializationContext.getSerializationStub(n);
                serializationStub.write(object);
            } else {
                int n4 = 0;
                if (n == -20) {
                    n4 = serializationContext.getPrefixAndDeclareNS((QName)object);
                }
                serializationContext.writeRawByte((byte)62);
                if (n < -1) {
                    serializationContext.writeSimpleContent(object, -(n + 2), n4);
                }
            }
            serializationContext.writeRawByte((byte)60);
            serializationContext.writeRawByte((byte)47);
            serializationContext.writeQNameAttributeValue(qName, n2);
            serializationContext.writeRawByte((byte)62);
            serializationContext.popNSContext();
        } else {
            serializationContext.writeElement((Element)object);
        }
    }

    public final void writeXSIType(Object object) throws IOException {
        SerializationContext serializationContext = this.fContext;
        QName qName = serializationContext.getSchemaTypeName(object);
        if (qName != null) {
            int n = serializationContext.getPrefixAndDeclareNS(XSI_TYPE);
            int n2 = serializationContext.getPrefixAndDeclareNS(qName);
            serializationContext.writeRawByte((byte)32);
            serializationContext.writeQNameAttributeValue(XSI_TYPE, n);
            serializationContext.writeRawByte((byte)61);
            serializationContext.writeRawByte((byte)34);
            serializationContext.writeQNameAttributeValue(qName, n2);
            serializationContext.writeRawByte((byte)34);
        }
    }

    public final void writeXSINil() throws IOException {
        SerializationContext serializationContext = this.fContext;
        int n = serializationContext.getPrefixAndDeclareNS(XSI_NIL);
        serializationContext.writeRawByte((byte)32);
        serializationContext.writeQNameAttributeValue(XSI_NIL, n);
        serializationContext.writeRawByte((byte)61);
        serializationContext.writeRawByte((byte)34);
        serializationContext.writeBooleanValue(true);
        serializationContext.writeRawByte((byte)34);
    }

    public final Object readElementPropertyField(Object object, int n) {
        try {
            return this.valueClass.elementProperties[n].propertyField.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readElementPropertyCollectionField(Object object, int n) {
        try {
            Field field = this.valueClass.elementProperties[n].propertyField;
            Collection collection = (Collection)field.get(object);
            return collection != null ? collection : Collections.EMPTY_LIST;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Object readElementPropertyMethod(Object object, int n) {
        try {
            return this.valueClass.elementProperties[n].accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readElementPropertyCollectionMethod(Object object, int n) {
        try {
            return (Collection)this.valueClass.elementProperties[n].accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Object readAttributePropertyField(Object object, int n) {
        try {
            return this.valueClass.attributeProperties[n].propertyField.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readAttributePropertyCollectionField(Object object, int n) {
        try {
            Field field = this.valueClass.attributeProperties[n].propertyField;
            Collection collection = (Collection)field.get(object);
            return collection != null ? collection : Collections.EMPTY_LIST;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Object readAttributePropertyMethod(Object object, int n) {
        try {
            return this.valueClass.attributeProperties[n].accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readAttributePropertyCollectionMethod(Object object, int n) {
        try {
            return (Collection)this.valueClass.attributeProperties[n].accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Object readSimpleContentPropertyField(Object object) {
        try {
            return this.valueClass.simpleContentProperty.propertyField.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readSimpleContentPropertyCollectionField(Object object) {
        try {
            Field field = this.valueClass.simpleContentProperty.propertyField;
            Collection collection = (Collection)field.get(object);
            return collection != null ? collection : Collections.EMPTY_LIST;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Object readSimpleContentPropertyMethod(Object object) {
        try {
            return this.valueClass.simpleContentProperty.accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readSimpleContentPropertyCollectionMethod(Object object) {
        try {
            return (Collection)this.valueClass.simpleContentProperty.accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readMixedContentPropertyCollectionField(Object object) {
        try {
            Field field = this.valueClass.mixedContentProperty.propertyField;
            Collection collection = (Collection)field.get(object);
            return collection != null ? collection : Collections.EMPTY_LIST;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Collection readMixedContentPropertyCollectionMethod(Object object) {
        try {
            return (Collection)this.valueClass.mixedContentProperty.accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Object readElementWildcardPropertyField(Object object) {
        try {
            return this.valueClass.elementWildcardProperty.propertyField.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Object readElementWildcardPropertyMethod(Object object) {
        try {
            return this.valueClass.elementWildcardProperty.accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final String readIDPropertyField(Object object) {
        try {
            return (String)this.valueClass.idProperty.propertyField.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final String readIDPropertyMethod(Object object) {
        try {
            return (String)this.valueClass.idProperty.accessor.readMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method getBeforeMarshalMethod(Class<?> clazz) {
        return SerializationStub.getMarshalCallback(clazz, "beforeMarshal");
    }

    public static Method getAfterMarshalMethod(Class<?> clazz) {
        return SerializationStub.getMarshalCallback(clazz, "afterMarshal");
    }

    private static Method getMarshalCallback(final Class<?> clazz, final String string) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Method method = clazz.getDeclaredMethod(string, Marshaller.class);
                    if (method != null && method.getReturnType() == Void.TYPE) {
                        method.setAccessible(true);
                        return method;
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static HashMap<Class<?>, Integer> createElementContentChoiceMap(ValueClass valueClass, int n) {
        HashMap hashMap = new HashMap();
        PropertyGroup propertyGroup = valueClass.propOrder[n];
        List<Property> list = propertyGroup.properties;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Property property = list.get(i);
            if (!property.propertyTypeInfo.isJAXBElementWrapped) {
                int n3;
                Integer n4 = i;
                if (property instanceof MixedContentProperty) {
                    hashMap.put(String.class, n4);
                    continue;
                }
                if (property instanceof ElementWildcardProperty) {
                    hashMap.put(JAXBElement.class, n2);
                    n3 = n2 + 1;
                    hashMap.put(Element.class, n3);
                    hashMap.put(ElementImpl.class, n3);
                    hashMap.put(ElementNSImpl.class, n3);
                    continue;
                }
                hashMap.put(property.propertyTypeInfo.valueType.javaType, n4);
                if (property instanceof ElementProperty && ((ElementProperty)property).nillable && !hashMap.containsKey(null)) {
                    hashMap.put(null, n4);
                }
                if (property.propertyTypeInfo.valueType.valueClass == null || property.propertyTypeInfo.valueType.valueClass.javaType != Object.class) continue;
                n3 = n2 + 1;
                hashMap.put(Element.class, n3);
                hashMap.put(ElementImpl.class, n3);
                hashMap.put(ElementNSImpl.class, n3);
                continue;
            }
            hashMap.put(JAXBElement.class, n2);
        }
        return hashMap;
    }

    public static HashMap<QName, Integer> createJAXBElementChoiceMap(ValueClass valueClass, int n) {
        HashMap<QName, Integer> hashMap = new HashMap<QName, Integer>();
        PropertyGroup propertyGroup = valueClass.propOrder[n];
        List<Property> list = propertyGroup.properties;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Property property = list.get(i);
            if (!(property instanceof ElementProperty) || !property.propertyTypeInfo.isJAXBElementWrapped) continue;
            ElementProperty elementProperty = (ElementProperty)property;
            QName qName = null;
            if (elementProperty.elementDecl != null && elementProperty.elementDecl.factoryMethod != null) {
                try {
                    Method method = elementProperty.elementDecl.factoryMethod;
                    Class<?> clazz = method.getDeclaringClass();
                    JAXBElement jAXBElement = (JAXBElement)method.invoke(clazz.newInstance(), new Object[]{null});
                    qName = jAXBElement.getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (qName == null || !elementProperty.schemaComponentName.qName.equals(qName)) {
                qName = elementProperty.schemaComponentName.qName;
            }
            hashMap.put(qName, i);
        }
        return hashMap;
    }

    public static boolean checkNamespaceMapping(JAXBModel jAXBModel, String string, String string2) {
        return string.equals(jAXBModel.ns2PrefixMap.get(string2));
    }

    public static boolean checkElementPropertyCount(ValueClass valueClass, int n) {
        return n == (valueClass.elementProperties != null ? valueClass.elementProperties.length : 0);
    }

    public static boolean checkElementPropertyClassId(ValueClass valueClass, int n, int n2) {
        ValueClass valueClass2;
        ElementProperty elementProperty;
        ElementProperty elementProperty2 = elementProperty = valueClass.elementProperties != null ? valueClass.elementProperties[n] : null;
        if (elementProperty != null && (valueClass2 = elementProperty.propertyTypeInfo.valueType.valueClass) != null) {
            return valueClass2.classId == n2;
        }
        return false;
    }

    public static boolean checkAttributePropertyClassId(ValueClass valueClass, int n, int n2) {
        ValueClass valueClass2;
        AttributeProperty attributeProperty;
        AttributeProperty attributeProperty2 = attributeProperty = valueClass.attributeProperties != null ? valueClass.attributeProperties[n] : null;
        if (attributeProperty != null && (valueClass2 = attributeProperty.propertyTypeInfo.valueType.valueClass) != null) {
            return valueClass2.classId == n2;
        }
        return false;
    }

    public static boolean checkSimpleContentPropertyClassId(ValueClass valueClass, int n) {
        ValueClass valueClass2;
        SimpleContentProperty simpleContentProperty = valueClass.simpleContentProperty;
        if (simpleContentProperty != null && (valueClass2 = simpleContentProperty.propertyTypeInfo.valueType.valueClass) != null) {
            return valueClass2.classId == n;
        }
        return false;
    }
}

