/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal.impl;

import com.ibm.xml.xlxp2.scan.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class NSContext {
    public static final int PREFIX_UNDECLARED = -1;
    public static final int PREFIX_EMPTY = -2;
    private static final int SIZE = 5;
    private static final byte[][] PREDEFINED = new byte[][]{{120, 109, 108}, {120, 109, 108, 110, 115}, {112, 99}};
    private String defaultURI;
    private String defaultBackup;
    private int defaultURIContext = -1;
    private String[] uris;
    private int[] prefixes;
    private int currentPosition;
    private int shortCount = 97;
    private byte[][] longPrefixes;
    private int longCount;
    private int[] contexts = new int[24];
    private int currentContext = 0;

    public NSContext(String[] stringArray, String[] stringArray2, String string) {
        int n = stringArray == null ? 0 : stringArray.length;
        this.uris = new String[n + 5];
        this.prefixes = new int[n + 5];
        this.longPrefixes = PREDEFINED;
        this.uris[0] = "http://www.w3.org/XML/1998/namespace";
        this.prefixes[0] = 0;
        this.uris[1] = "http://www.w3.org/2000/xmlns/";
        this.prefixes[1] = 1;
        this.currentPosition = 2;
        this.longCount = 2;
        for (int i = 0; i < n; ++i) {
            int n2 = this.addPrefix(stringArray[i]);
            if (stringArray2 == null) continue;
            stringArray2[i] = n2 < 0 ? String.valueOf((char)(-n2)) : new String(this.getPrefix(n2), 0);
        }
        this.defaultURI = this.defaultBackup = string;
    }

    public NSContext(NSContext nSContext) {
        int n;
        int n2;
        assert (nSContext.currentContext == 0);
        this.defaultURI = nSContext.defaultURI;
        this.defaultBackup = nSContext.defaultBackup;
        this.currentPosition = n2 = nSContext.currentPosition;
        this.uris = new String[n2 + 5];
        this.prefixes = new int[n2 + 5];
        System.arraycopy(nSContext.uris, 0, this.uris, 0, n2);
        System.arraycopy(nSContext.prefixes, 0, this.prefixes, 0, n2);
        this.shortCount = nSContext.shortCount;
        this.longCount = n = nSContext.longCount;
        if (n > PREDEFINED.length) {
            this.longPrefixes = new byte[n + 8][];
            System.arraycopy(nSContext.longPrefixes, 0, this.longPrefixes, 0, n);
        } else {
            this.longPrefixes = PREDEFINED;
        }
    }

    public void reset() {
        if (this.currentContext != 0) {
            this.defaultURI = this.defaultBackup;
            this.longCount = this.contexts[2];
            this.shortCount = this.contexts[1];
            this.currentPosition = this.contexts[0];
            this.currentContext = 0;
        }
    }

    public void push() {
        int n = this.contexts.length;
        if (this.currentContext == n) {
            int[] nArray = new int[n * 2];
            System.arraycopy(this.contexts, 0, nArray, 0, n);
            this.contexts = nArray;
        }
        this.contexts[this.currentContext++] = this.currentPosition;
        this.contexts[this.currentContext++] = this.shortCount;
        this.contexts[this.currentContext++] = this.longCount;
    }

    public void pop() {
        if (this.currentContext == this.defaultURIContext) {
            this.defaultURI = this.defaultBackup;
            this.defaultURIContext = -1;
        }
        this.longCount = this.contexts[--this.currentContext];
        this.shortCount = this.contexts[--this.currentContext];
        this.currentPosition = this.contexts[--this.currentContext];
    }

    public int getPrefix(String string, boolean bl) {
        assert (string != null && string.length() > 0);
        if (bl && string.equals(this.defaultURI)) {
            return -2;
        }
        for (int i = this.currentPosition - 1; i >= 0; --i) {
            if (!string.equals(this.uris[i])) continue;
            return this.prefixes[i];
        }
        return -1;
    }

    public byte[] getPrefix(int n) {
        assert (n >= 0 && n < this.longCount);
        return this.longPrefixes[n];
    }

    public int addPrefix(String string) {
        Object object;
        assert (string != null && string.length() > 0);
        assert (this.currentContext > 0);
        int n = this.uris.length;
        if (this.currentPosition == n) {
            String[] stringArray = new String[n * 2];
            System.arraycopy(this.uris, 0, stringArray, 0, n);
            this.uris = stringArray;
            object = new int[n * 2];
            System.arraycopy(this.prefixes, 0, object, 0, n);
            this.prefixes = object;
        }
        this.uris[this.currentPosition] = string;
        if (this.shortCount <= 122) {
            this.prefixes[this.currentPosition] = -this.shortCount;
            this.shortCount = this.shortCount == 122 ? 65 : (this.shortCount == 90 ? 123 : ++this.shortCount);
        } else {
            int n2 = this.longPrefixes.length;
            if (this.longCount == n2) {
                object = new byte[n2 * 2][];
                System.arraycopy(this.longPrefixes, 0, object, 0, n2);
                this.longPrefixes = (byte[][])object;
            }
            if (this.longPrefixes[this.longCount] == null) {
                int n3 = this.longPrefixes[this.longCount - 1].length;
                if (this.longCount == 1 << (n3 - 1 << 2)) {
                    ++n3;
                }
                byte[] byArray = new byte[n3];
                byArray[0] = 112;
                int n4 = this.longCount;
                for (int i = n3 - 1; i > 0; --i) {
                    byArray[i] = (byte)((n4 & 0xF) + 97);
                    n4 >>= 4;
                }
                this.longPrefixes[this.longCount] = byArray;
            }
            ++this.longCount;
        }
        return this.prefixes[this.currentPosition++];
    }

    public int getOrAddPrefix(String string, boolean bl) {
        assert (string != null && string.length() > 0);
        assert (this.currentContext > 0);
        int n = this.getPrefix(string, bl);
        if (n == -1) {
            n = this.addPrefix(string);
        }
        return n;
    }

    public int undeclareDefaultNamespace(boolean bl) {
        assert (this.currentContext > 0);
        int n = -1;
        if (bl) {
            n = this.getOrAddPrefix(this.defaultURI, false);
        }
        this.defaultURI = null;
        this.defaultURIContext = this.currentContext;
        return n;
    }
}

