/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgBinOp;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgFactory;
import com.ibm.fcg.FcgField;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgUnaryOp;
import com.ibm.fcg.FcgVariable;
import com.ibm.xml.xlxp2.jaxb.codegen.Generatable;
import com.ibm.xml.xlxp2.jaxb.codegen.fcg.FCGTypeUtil;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.AttributeGroupGenerator;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.FCGSerializationStubGeneratorHelper;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.PropertyGroupGenerator;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.SimpleContentPropertyGenerator;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationStub;
import com.ibm.xml.xlxp2.jaxb.model.AttributeProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementWildcardProperty;
import com.ibm.xml.xlxp2.jaxb.model.EnumClass;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.MixedContentProperty;
import com.ibm.xml.xlxp2.jaxb.model.Property;
import com.ibm.xml.xlxp2.jaxb.model.PropertyGroup;
import com.ibm.xml.xlxp2.jaxb.model.SimpleContentProperty;
import com.ibm.xml.xlxp2.jaxb.model.TypedProperty;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.jaxb.model.ValueTypeInformation;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class FCGSerializationStubGenerator
extends FCGSerializationStubGeneratorHelper
implements Generatable {
    private final ValueClass valueClass;
    private final Method beforeMarshalMethod;
    private final Method afterMarshalMethod;

    public static String getStubClassName(ValueClass valueClass) {
        return valueClass.javaType.getName() + "_JAXB_Serialization_Stub";
    }

    public FCGSerializationStubGenerator(String string, ValueClass valueClass, JAXBModel jAXBModel, ClassLoader classLoader) {
        super(string, jAXBModel, classLoader);
        this.valueClass = valueClass;
        this.beforeMarshalMethod = SerializationStub.getBeforeMarshalMethod(valueClass.javaType);
        this.afterMarshalMethod = SerializationStub.getAfterMarshalMethod(valueClass.javaType);
    }

    @Override
    public void generate(String string, OutputStream outputStream) throws IOException {
        FcgCodeGen fcgCodeGen = FcgFactory.createCodeGen(string);
        FcgClassGen fcgClassGen = this.generateClassDeclaration(fcgCodeGen);
        FcgField[] fcgFieldArray = this.generateStaticFieldDeclarations4Attributes(fcgCodeGen, fcgClassGen);
        FcgField[][][] fcgFieldArray2 = this.generateStaticFieldDeclarations4Elements(fcgCodeGen, fcgClassGen);
        FcgField[] fcgFieldArray3 = this.generateStaticFields4ElementTypeChoices(fcgCodeGen, fcgClassGen);
        FcgField[] fcgFieldArray4 = this.generateStaticFields4JAXBElementChoices(fcgCodeGen, fcgClassGen);
        this.generateStaticInitializer(fcgCodeGen, fcgClassGen, fcgFieldArray2, fcgFieldArray);
        this.generateIsCompatibleMethod(fcgCodeGen, fcgClassGen);
        Map<?, Integer>[][] mapArray = this.generateConstructor(fcgCodeGen, fcgClassGen, fcgFieldArray3, fcgFieldArray4);
        boolean bl = this.generateWriteAttributesMethod(fcgCodeGen, fcgClassGen, fcgFieldArray);
        this.generateWriteMethod(fcgCodeGen, fcgClassGen, fcgFieldArray2, fcgFieldArray3, fcgFieldArray4, mapArray, bl);
        if (this.valueClass.simpleContentProperty != null) {
            this.generateWriteSimpleContentMethod(fcgCodeGen, fcgClassGen, this.valueClass.simpleContentProperty);
        }
        if (this.valueClass.idProperty != null) {
            this.generateReadIDValueMethod(fcgCodeGen, fcgClassGen, this.valueClass.idProperty);
        }
        fcgClassGen.dump(outputStream);
    }

    private FcgClassGen generateClassDeclaration(FcgCodeGen fcgCodeGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(this.stubClassName);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
        FcgClassGen fcgClassGen = fcgCodeGen.newClassGen(fcgClassReferenceType, fcgClassReferenceType2, FcgAttrs.PUBLIC_FINAL);
        return fcgClassGen;
    }

    private FcgField[] generateStaticFieldDeclarations4Attributes(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        AttributeProperty[] attributePropertyArray = this.valueClass.attributeProperties;
        int n = attributePropertyArray != null ? attributePropertyArray.length : 0;
        FcgField[] fcgFieldArray = new FcgField[n];
        for (int i = 0; i < n; ++i) {
            fcgFieldArray[i] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, FcgType.BYTE_ARRAY, "ATTR_" + i);
        }
        return fcgFieldArray;
    }

    private FcgField[][][] generateStaticFieldDeclarations4Elements(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
        int n = propertyGroupArray != null ? propertyGroupArray.length : 0;
        FcgField[][][] fcgFieldArray = new FcgField[n][][];
        for (int i = 0; i < n; ++i) {
            List<Property> list = propertyGroupArray[i].properties;
            int n2 = list.size();
            fcgFieldArray[i] = new FcgField[n2][];
            for (int j = 0; j < n2; ++j) {
                Property property = list.get(j);
                if (!(property instanceof ElementProperty)) continue;
                fcgFieldArray[i][j] = new FcgField[2];
                fcgFieldArray[i][j][0] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, FcgType.BYTE_ARRAY, "START_" + i + '_' + j);
                fcgFieldArray[i][j][1] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, FcgType.BYTE_ARRAY, "END_" + i + '_' + j);
            }
        }
        return fcgFieldArray;
    }

    private FcgField[] generateStaticFields4ElementTypeChoices(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_HASH_MAP);
        PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
        int n = propertyGroupArray != null ? propertyGroupArray.length : 0;
        FcgField[] fcgFieldArray = new FcgField[n];
        block0: for (int i = 0; i < n; ++i) {
            HashSet hashSet = new HashSet();
            List<Property> list = propertyGroupArray[i].properties;
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                Property property = list.get(j);
                if (!property.propertyTypeInfo.isJAXBElementWrapped) {
                    if (property instanceof MixedContentProperty) {
                        hashSet.add(String.class);
                    } else if (property instanceof ElementWildcardProperty) {
                        hashSet.add(Element.class);
                        hashSet.add(JAXBElement.class);
                    } else {
                        hashSet.add(property.propertyTypeInfo.valueType.javaType);
                        if (property.propertyTypeInfo.valueType.valueClass != null && property.propertyTypeInfo.valueType.valueClass.javaType == Object.class) {
                            hashSet.add(Element.class);
                        }
                    }
                } else {
                    hashSet.add(JAXBElement.class);
                }
                if (hashSet.size() <= 1) continue;
                fcgFieldArray[i] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, fcgClassReferenceType, "TYPE_CHOICE_MAP_" + i);
                continue block0;
            }
        }
        return fcgFieldArray;
    }

    private FcgField[] generateStaticFields4JAXBElementChoices(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_HASH_MAP);
        PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
        int n = propertyGroupArray != null ? propertyGroupArray.length : 0;
        FcgField[] fcgFieldArray = new FcgField[n];
        block0: for (int i = 0; i < n; ++i) {
            List<Property> list = propertyGroupArray[i].properties;
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                Property property = list.get(j);
                if (!property.propertyTypeInfo.isJAXBElementWrapped) continue;
                fcgFieldArray[i] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, fcgClassReferenceType, "JAXB_ELEMENT_CHOICE_MAP_" + i);
                continue block0;
            }
        }
        return fcgFieldArray;
    }

    private void generateStaticInitializer(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][][] fcgFieldArray, FcgField[] fcgFieldArray2) {
        if (fcgFieldArray.length > 0 || fcgFieldArray2.length > 0) {
            FcgMethodGen fcgMethodGen = fcgClassGen.getClassInitMethod();
            FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
            fcgInstructionList.beginMethod();
            AttributeProperty[] attributePropertyArray = this.valueClass.attributeProperties;
            int n = attributePropertyArray != null ? attributePropertyArray.length : 0;
            for (int i = 0; i < n; ++i) {
                AttributeProperty attributeProperty = attributePropertyArray[i];
                String string = this.createQNameString(attributeProperty.schemaComponentName.qName);
                FCGSerializationStubGenerator.initializeStaticByteArrayField(fcgInstructionList, fcgFieldArray2[i], " " + string + "=\"");
            }
            PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
            int n2 = propertyGroupArray != null ? propertyGroupArray.length : 0;
            for (int i = 0; i < n2; ++i) {
                List<Property> list = propertyGroupArray[i].properties;
                int n3 = list.size();
                for (int j = 0; j < n3; ++j) {
                    Property property = list.get(j);
                    if (!(property instanceof ElementProperty)) continue;
                    ElementProperty elementProperty = (ElementProperty)property;
                    String string = this.createQNameString(elementProperty.schemaComponentName.qName);
                    FCGSerializationStubGenerator.initializeStaticByteArrayField(fcgInstructionList, fcgFieldArray[i][j][0], "<" + string + (elementProperty.propertyTypeInfo.valueType.valueClass == null ? ">" : ""));
                    FCGSerializationStubGenerator.initializeStaticByteArrayField(fcgInstructionList, fcgFieldArray[i][j][1], "</" + string + ">");
                }
            }
            fcgInstructionList.endMethod();
        }
    }

    private void generateIsCompatibleMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        Object object;
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.BOOLEAN, "isCompatible");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(FCGSerializationStubGeneratorHelper.CLASS_STUB);
        for (Map.Entry<String, String> entry : this.model.ns2PrefixMap.entrySet()) {
            String string = entry.getValue();
            if ("xml".equals(string) || "xmlns".equals(string) || !this.prefixesUsed.contains(string)) continue;
            object = entry.getKey();
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.loadLiteral(string);
            fcgInstructionList.loadLiteral((String)object);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType3, "checkNamespaceMapping", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType2, FcgType.STRING, FcgType.STRING});
            fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            fcgInstructionList.beginIf();
            fcgInstructionList.loadLiteral(false);
            fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
            fcgInstructionList.endIf();
        }
        ElementProperty[] elementPropertyArray = this.valueClass.elementProperties;
        int n = elementPropertyArray != null ? elementPropertyArray.length : 0;
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadLiteral(n);
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType3, "checkElementPropertyCount", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT});
        fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadLiteral(false);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endIf();
        for (int i = 0; i < n; ++i) {
            object = elementPropertyArray[i];
            if (((ElementProperty)object).propertyTypeInfo.valueType.valueClass == null) continue;
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(i);
            fcgInstructionList.loadLiteral(((ElementProperty)object).propertyTypeInfo.valueType.valueClass.classId);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType3, "checkElementPropertyClassId", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT, FcgType.INT});
            fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            fcgInstructionList.beginIf();
            fcgInstructionList.loadLiteral(false);
            fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
            fcgInstructionList.endIf();
        }
        AttributeProperty[] attributePropertyArray = this.valueClass.attributeProperties;
        int n2 = attributePropertyArray != null ? attributePropertyArray.length : 0;
        for (int i = 0; i < n2; ++i) {
            AttributeProperty attributeProperty = attributePropertyArray[i];
            if (attributeProperty.propertyTypeInfo.valueType.valueClass == null) continue;
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(i);
            fcgInstructionList.loadLiteral(attributeProperty.propertyTypeInfo.valueType.valueClass.classId);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType3, "checkAttributePropertyClassId", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT, FcgType.INT});
            fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            fcgInstructionList.beginIf();
            fcgInstructionList.loadLiteral(false);
            fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
            fcgInstructionList.endIf();
        }
        SimpleContentProperty simpleContentProperty = this.valueClass.simpleContentProperty;
        if (simpleContentProperty != null && simpleContentProperty.propertyTypeInfo.valueType.valueClass != null) {
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(simpleContentProperty.propertyTypeInfo.valueType.valueClass.classId);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType3, "checkSimpleContentPropertyClassId", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT});
            fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            fcgInstructionList.beginIf();
            fcgInstructionList.loadLiteral(false);
            fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
            fcgInstructionList.endIf();
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
    }

    private Map<?, Integer>[][] generateConstructor(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[] fcgFieldArray, FcgField[] fcgFieldArray2) {
        Map[] mapArray;
        int n;
        FcgMethodGen fcgMethodGen = fcgClassGen.newConstructorGen(FcgAttrs.PUBLIC);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
        fcgInstructionList.invokeSuperConstructor(fcgClassReferenceType2, 1);
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_HASH_MAP);
        int n2 = fcgFieldArray != null ? fcgFieldArray.length : 0;
        Map[] mapArray2 = new Map[n2];
        for (n = 0; n < n2; ++n) {
            mapArray = fcgFieldArray[n];
            if (mapArray == null) continue;
            mapArray2[n] = SerializationStub.createElementContentChoiceMap(this.valueClass, n);
            fcgInstructionList.loadClassField((FcgField)mapArray);
            fcgInstructionList.loadNull();
            fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
            fcgInstructionList.beginIf();
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(n);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, "createElementContentChoiceMap", (FcgType)fcgClassReferenceType3, new FcgType[]{fcgClassReferenceType, FcgType.INT});
            fcgInstructionList.storeClassFieldStmt((FcgField)mapArray);
            fcgInstructionList.endIf();
        }
        n = fcgFieldArray2 != null ? fcgFieldArray2.length : 0;
        mapArray = new Map[n2];
        for (int i = 0; i < n; ++i) {
            FcgField fcgField = fcgFieldArray2[i];
            if (fcgField == null) continue;
            mapArray[i] = SerializationStub.createJAXBElementChoiceMap(this.valueClass, i);
            fcgInstructionList.loadClassField(fcgField);
            fcgInstructionList.loadNull();
            fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
            fcgInstructionList.beginIf();
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(i);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, "createJAXBElementChoiceMap", (FcgType)fcgClassReferenceType3, new FcgType[]{fcgClassReferenceType, FcgType.INT});
            fcgInstructionList.storeClassFieldStmt(fcgField);
            fcgInstructionList.endIf();
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
        Map[][] mapArrayArray = new Map[][]{mapArray2, mapArray};
        return mapArrayArray;
    }

    private boolean generateWriteAttributesMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[] fcgFieldArray) {
        if (fcgFieldArray.length > 0 || this.valueClass.attributeWildcardProperty != null) {
            FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
            FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE, FcgType.VOID, "writeAttributes");
            FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "o");
            FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
            fcgInstructionList.beginMethod();
            AttributeGroupGenerator attributeGroupGenerator = new AttributeGroupGenerator(this, this.valueClass, fcgFieldArray);
            attributeGroupGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable);
            fcgInstructionList.endMethod();
            return true;
        }
        return false;
    }

    private void generateWriteMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][][] fcgFieldArray, FcgField[] fcgFieldArray2, FcgField[] fcgFieldArray3, Map<?, Integer>[][] mapArray, boolean bl) {
        PropertyGroup[] propertyGroupArray;
        boolean bl2;
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "write");
        FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.OBJECT, "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgClassReferenceType, "_o", true);
        if (this.beforeMarshalMethod != null) {
            this.invokeBeforeMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        if (bl2 = this.requireNSContextPushAndPop()) {
            FCGSerializationStubGenerator.invokePushNSContext(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList);
        }
        if (bl) {
            FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "writeAttributes", (FcgType)FcgType.VOID, new FcgType[]{fcgClassReferenceType});
        }
        boolean bl3 = false;
        if (this.valueClass.simpleContentProperty != null) {
            propertyGroupArray = this.valueClass.simpleContentProperty.propertyTypeInfo.valueType;
            boolean bl4 = bl3 = propertyGroupArray.typeId == 18;
        }
        if (!bl3) {
            FCGSerializationStubGenerator.invokeWriteByte(fcgCodeGen, fcgClassGen, fcgInstructionList, (byte)62);
        }
        int n = (propertyGroupArray = this.valueClass.propOrder) != null ? propertyGroupArray.length : 0;
        for (int i = 0; i < n; ++i) {
            Map<Class<?>, Integer> map = mapArray[0][i];
            Map<QName, Integer> map2 = mapArray[1][i];
            PropertyGroupGenerator propertyGroupGenerator = new PropertyGroupGenerator(this, this.valueClass, propertyGroupArray[i], i, fcgFieldArray[i], fcgFieldArray2[i], fcgFieldArray3[i], map, map2);
            propertyGroupGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2);
        }
        if (bl2) {
            FCGSerializationStubGenerator.invokePopNSContext(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList);
        }
        if (this.afterMarshalMethod != null) {
            this.invokeAfterMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateWriteSimpleContentMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, SimpleContentProperty simpleContentProperty) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "writeSimpleContent");
        FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.OBJECT, "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgClassReferenceType, "_o", true);
        if (this.beforeMarshalMethod != null) {
            this.invokeBeforeMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        FcgType fcgType = null;
        Class<?> clazz = null;
        FcgVariable fcgVariable3 = null;
        SimpleContentPropertyGenerator simpleContentPropertyGenerator = new SimpleContentPropertyGenerator(this, this.valueClass, simpleContentProperty, 0);
        if (simpleContentProperty.propertyField != null) {
            clazz = simpleContentProperty.propertyField.getType();
            fcgType = FCGTypeUtil.getFcgType(clazz, fcgCodeGen);
            boolean bl = simpleContentProperty.propertyField.getDeclaringClass().getPackage() == this.valueClass.javaType.getPackage();
            int n = simpleContentProperty.propertyField.getModifiers();
            if (!bl && !Modifier.isPublic(n) || Modifier.isPrivate(n)) {
                simpleContentPropertyGenerator.invokeReadPropertyField(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgType);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.loadInstanceField(fcgClassReferenceType, simpleContentProperty.propertyField.getName(), fcgType);
            }
            fcgVariable3 = fcgInstructionList.defineVar(fcgType, "value", true);
        } else if (simpleContentProperty.accessor.readMethod != null) {
            Method method = simpleContentProperty.accessor.readMethod;
            clazz = method.getReturnType();
            fcgType = FCGTypeUtil.getFcgType(clazz, fcgCodeGen);
            boolean bl = method.getDeclaringClass().getPackage() == this.valueClass.javaType.getPackage();
            int n = method.getModifiers();
            if (!bl && !Modifier.isPublic(n) || Modifier.isPrivate(n)) {
                simpleContentPropertyGenerator.invokeReadPropertyMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgType);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, method.getName(), fcgType, 0);
            }
            fcgVariable3 = fcgInstructionList.defineVar(fcgType, "value", true);
        }
        simpleContentPropertyGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable3);
        if (this.afterMarshalMethod != null) {
            this.invokeAfterMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateReadIDValueMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, TypedProperty typedProperty) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.STRING, "readIDValue");
        FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.OBJECT, "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgClassReferenceType, "_o", true);
        if (typedProperty.propertyField != null) {
            boolean bl = typedProperty.propertyField.getDeclaringClass().getPackage() == this.valueClass.javaType.getPackage();
            int n = typedProperty.propertyField.getModifiers();
            if (!bl && !Modifier.isPublic(n) || Modifier.isPrivate(n)) {
                this.invokeReadIDPropertyField(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.loadInstanceField(fcgClassReferenceType, typedProperty.propertyField.getName(), FcgType.STRING);
            }
        } else if (typedProperty.accessor.readMethod != null) {
            Method method = typedProperty.accessor.readMethod;
            boolean bl = method.getDeclaringClass().getPackage() == this.valueClass.javaType.getPackage();
            int n = method.getModifiers();
            if (!bl && !Modifier.isPublic(n) || Modifier.isPrivate(n)) {
                this.invokeReadIDPropertyMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, method.getName(), (FcgType)FcgType.STRING, 0);
            }
        } else {
            fcgInstructionList.loadNull();
        }
        fcgInstructionList.returnInstruction(FcgType.STRING);
        fcgInstructionList.endMethod();
    }

    private boolean requireNSContextPushAndPop() {
        int n;
        Object object;
        if (this.valueClass.simpleContentProperty != null) {
            object = this.valueClass.simpleContentProperty.propertyTypeInfo.valueType;
            EnumClass enumClass = object.enumClass;
            int n2 = n = enumClass == null ? object.typeId : enumClass.getPrimitiveEnumConstantValueTypeId();
            if (n == 18) {
                return true;
            }
        }
        int n3 = (object = this.valueClass.attributeProperties) != null ? ((AttributeProperty[])object).length : 0;
        for (n = 0; n < n3; ++n) {
            int n4;
            AttributeProperty attributeProperty = object[n];
            if (attributeProperty == null) continue;
            ValueTypeInformation valueTypeInformation = attributeProperty.propertyTypeInfo.valueType;
            EnumClass enumClass = valueTypeInformation.enumClass;
            int n5 = n4 = enumClass == null ? valueTypeInformation.typeId : enumClass.getPrimitiveEnumConstantValueTypeId();
            if (n4 != 18) continue;
            return true;
        }
        return this.valueClass.attributeWildcardProperty != null;
    }

    private void invokeReadIDPropertyField(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        this.invokeReadIDPropertyCommon("readIDPropertyField", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable);
    }

    private void invokeReadIDPropertyMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        this.invokeReadIDPropertyCommon("readIDPropertyMethod", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable);
    }

    private void invokeReadIDPropertyCommon(String string, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        FcgClassReferenceType fcgClassReferenceType = fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, string, (FcgType)FcgType.STRING, new FcgType[]{FcgType.OBJECT});
    }

    private void invokeBeforeMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, FcgClassReferenceType fcgClassReferenceType) {
        if (Modifier.isPrivate(this.beforeMarshalMethod.getModifiers())) {
            FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "invokeBeforeMarshalMethod", (FcgType)FcgType.VOID, new FcgType[]{FcgType.OBJECT});
        } else {
            FCGSerializationStubGenerator.invokeBeforeMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgClassReferenceType);
        }
    }

    private void invokeAfterMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, FcgClassReferenceType fcgClassReferenceType) {
        if (Modifier.isPrivate(this.afterMarshalMethod.getModifiers())) {
            FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "invokeAfterMarshalMethod", (FcgType)FcgType.VOID, new FcgType[]{FcgType.OBJECT});
        } else {
            FCGSerializationStubGenerator.invokeAfterMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgClassReferenceType);
        }
    }

    static void invokeBeforeMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType) {
        FCGSerializationStubGenerator.invokeMarshalCallback("beforeMarshal", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgClassReferenceType);
    }

    static void invokeAfterMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType) {
        FCGSerializationStubGenerator.invokeMarshalCallback("afterMarshal", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgClassReferenceType);
    }

    private static void invokeMarshalCallback(String string, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType) {
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_MARSHALLER);
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_CONTEXT);
        fcgInstructionList.loadVar(fcgVariable);
        FcgClassReferenceType fcgClassReferenceType4 = fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgClassReferenceType4, "fContext", fcgClassReferenceType3);
        fcgInstructionList.loadInstanceField(fcgClassReferenceType3, "marshaller", fcgClassReferenceType2);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, string, (FcgType)FcgType.VOID, new FcgType[]{fcgClassReferenceType2});
    }
}

