/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgFactory;
import com.ibm.fcg.FcgField;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgReferenceType;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgUnaryOp;
import com.ibm.fcg.FcgVariable;
import com.ibm.xml.xlxp2.jaxb.codegen.Generatable;
import com.ibm.xml.xlxp2.jaxb.codegen.fcg.FCGTypeUtil;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.FCGSerializationStubGeneratorHelper;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.Variety;
import com.ibm.xml.xlxp2.jaxb.model.ElementDeclaration;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.PropertyTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.ValueTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.builder.Context;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class FCGSerializationRootStubGenerator
extends FCGSerializationStubGeneratorHelper
implements Generatable {
    private final int elementDeclCount;

    public static String getRootStubClassName(JAXBModel jAXBModel) {
        return "com.ibm.xml.xlxp2.jaxb.marshal.JAXB_Serialization_Root_Stub";
    }

    public FCGSerializationRootStubGenerator(String string, JAXBModel jAXBModel, ClassLoader classLoader) {
        super(string, jAXBModel, classLoader);
        ElementDeclaration[] elementDeclarationArray = jAXBModel.elementDeclarations;
        this.elementDeclCount = elementDeclarationArray != null ? elementDeclarationArray.length : 0;
    }

    public void generate(String string, OutputStream outputStream) throws IOException {
        FcgCodeGen fcgCodeGen = FcgFactory.createCodeGen(string);
        FcgClassGen fcgClassGen = this.generateClassDeclaration(fcgCodeGen);
        FcgField[][] fcgFieldArray = this.generateStaticFieldDeclarations(fcgCodeGen, fcgClassGen);
        FcgField fcgField = this.generateNamespaceDeclStaticField(fcgCodeGen, fcgClassGen);
        this.generateStaticInitializer(fcgCodeGen, fcgClassGen, fcgFieldArray, fcgField);
        this.generateConstructor(fcgCodeGen, fcgClassGen);
        this.generateWriteMethod(fcgCodeGen, fcgClassGen, fcgFieldArray, fcgField);
        fcgClassGen.dump(outputStream);
    }

    private FcgClassGen generateClassDeclaration(FcgCodeGen fcgCodeGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(this.stubClassName);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
        FcgClassGen fcgClassGen = fcgCodeGen.newClassGen(fcgClassReferenceType, fcgClassReferenceType2, FcgAttrs.PUBLIC_FINAL);
        return fcgClassGen;
    }

    private FcgField[][] generateStaticFieldDeclarations(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgField[][] fcgFieldArray = new FcgField[this.elementDeclCount][2];
        for (int i = 0; i < this.elementDeclCount; ++i) {
            fcgFieldArray[i][0] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, FcgType.BYTE_ARRAY, "START_" + i);
            fcgFieldArray[i][1] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, FcgType.BYTE_ARRAY, "END_" + i);
        }
        return fcgFieldArray;
    }

    private FcgField generateNamespaceDeclStaticField(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        if (this.model.ns2PrefixMap.size() > 0) {
            return fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC_FINAL, FcgType.BYTE_ARRAY, "NS_DECLS");
        }
        return null;
    }

    private void generateStaticInitializer(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][] fcgFieldArray, FcgField fcgField) {
        if (this.elementDeclCount > 0 || fcgField != null) {
            FcgMethodGen fcgMethodGen = fcgClassGen.getClassInitMethod();
            FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
            ElementDeclaration[] elementDeclarationArray = this.model.elementDeclarations;
            fcgInstructionList.beginMethod();
            for (int i = 0; i < this.elementDeclCount; ++i) {
                ElementDeclaration elementDeclaration = elementDeclarationArray[i];
                String object = this.createQNameString(elementDeclaration.elementName.qName);
                FCGSerializationRootStubGenerator.initializeStaticByteArrayField(fcgInstructionList, fcgFieldArray[i][0], "<" + object);
                FCGSerializationRootStubGenerator.initializeStaticByteArrayField(fcgInstructionList, fcgFieldArray[i][1], "</" + object + ">");
            }
            if (fcgField != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry entry : this.model.ns2PrefixMap.entrySet()) {
                    String string = (String)entry.getValue();
                    if ("xml".equals(string) || "xmlns".equals(string)) continue;
                    String string2 = (String)entry.getKey();
                    stringBuilder.append(' ');
                    stringBuilder.append("xmlns");
                    if (string != null && string.length() > 0) {
                        stringBuilder.append(':');
                        stringBuilder.append(string);
                    }
                    stringBuilder.append("=\"");
                    stringBuilder.append(FCGSerializationRootStubGenerator.escapeURI(string2));
                    stringBuilder.append('\"');
                }
                FCGSerializationRootStubGenerator.initializeStaticByteArrayField(fcgInstructionList, fcgField, stringBuilder.toString());
            }
            fcgInstructionList.endMethod();
        }
    }

    private void generateConstructor(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newConstructorGen(FcgAttrs.PUBLIC);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadNull();
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
        fcgInstructionList.invokeSuperConstructor(fcgClassReferenceType2, 1);
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateWriteMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][] fcgFieldArray, FcgField fcgField) {
        FcgVariable fcgVariable;
        Object object;
        Object object2;
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "write");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(FcgType.OBJECT, "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = fcgInstructionList.loadThis();
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_CONTEXT);
        fcgInstructionList.loadInstanceField(fcgClassReferenceType, "fContext", fcgClassReferenceType2);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "getElementDeclarationIndex", (FcgType)FcgType.INT, new FcgType[]{FcgType.OBJECT});
        FcgVariable fcgVariable3 = fcgInstructionList.defineVar(FcgType.INT, "propertyId", true);
        fcgInstructionList.loadVar(fcgVariable3);
        fcgInstructionList.beginSwitch();
        for (int i = 0; i < this.model.elementDeclarations.length; ++i) {
            object2 = this.model.elementDeclarations[i];
            if (((ElementDeclaration)object2).factoryMethod != null && !Context.hasConsistentXMLRootElement((ElementDeclaration)object2)) continue;
            fcgInstructionList.beginSwitchCaseBlock(i);
            FCGSerializationRootStubGenerator.invokeWriteBytes(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgFieldArray[i][0]);
            if (fcgField != null) {
                FCGSerializationRootStubGenerator.invokeWriteBytes(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgField);
            }
            object = fcgCodeGen.getClassReferenceType(CLASS_STUB);
            fcgInstructionList.loadThis();
            fcgInstructionList.loadInstanceField(fcgClassReferenceType, "fContext", fcgClassReferenceType2);
            fcgInstructionList.loadLiteral(((ElementDeclaration)object2).typeInfo.valueType.valueClass.classId);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "getSerializationStub", (FcgType)object, new FcgType[]{FcgType.INT});
            fcgVariable = fcgInstructionList.defineVar((FcgType)object, "stub_" + i, true);
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.invokeInstanceMethod((FcgClassReferenceType)object, "write", (FcgType)FcgType.VOID, new FcgType[]{FcgType.OBJECT});
            FCGSerializationRootStubGenerator.invokeWriteBytes(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgFieldArray[i][1]);
            fcgInstructionList.endSwitchCaseBlock();
        }
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_ELEMENT);
        fcgInstructionList.beginSwitchCaseBlock(this.model.elementDeclarations.length);
        if (this.model.qName2GlobalElementMap.size() > 0) {
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.convertExpr(fcgVariable2.getType(), fcgClassReferenceType3);
            object2 = fcgInstructionList.defineVar(fcgClassReferenceType3, "jaxbElement", true);
            fcgInstructionList.loadVar((FcgVariable)object2);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType3, "getValue", (FcgType)FcgType.OBJECT, 0);
            object = fcgInstructionList.defineVar(FcgType.OBJECT, "jaxbElementValue", true);
            fcgInstructionList.loadVar((FcgVariable)object2);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType3, "isNil", (FcgType)FcgType.BOOLEAN, 0);
            fcgVariable = fcgInstructionList.defineVar(FcgType.BOOLEAN, "jaxbElementIsNil", true);
            fcgInstructionList.loadThis();
            fcgInstructionList.loadInstanceField(fcgClassReferenceType, "fContext", fcgClassReferenceType2);
            fcgInstructionList.loadVar((FcgVariable)object2);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "getRootQNameIndex", (FcgType)FcgType.INT, new FcgType[]{fcgClassReferenceType3});
            FcgVariable fcgVariable4 = fcgInstructionList.defineVar(FcgType.INT, "qNameId", true);
            fcgInstructionList.loadVar(fcgVariable4);
            fcgInstructionList.beginSwitch();
            for (int i = 0; i < this.model.elementDeclarations.length; ++i) {
                Object object3;
                ElementDeclaration elementDeclaration = this.model.elementDeclarations[i];
                if (elementDeclaration.factoryMethod == null) continue;
                fcgInstructionList.beginSwitchCaseBlock(i);
                Variety variety = Variety.ATOMIC;
                Class clazz = null;
                Class<? extends XmlAdapter> clazz2 = elementDeclaration.typeInfo.adapterClass;
                if (clazz2 != null) {
                    if (clazz2 == NormalizedStringAdapter.class) {
                        clazz = String.class;
                    } else if (clazz2 == CollapsedStringAdapter.class) {
                        clazz = String.class;
                    } else if (clazz2 == HexBinaryAdapter.class) {
                        clazz = byte[].class;
                    }
                }
                if (clazz == null) {
                    Class clazz3;
                    ParameterizedType parameterizedType;
                    Type type;
                    object3 = elementDeclaration.typeInfo.boundType;
                    if (clazz2 != null && object3 instanceof Class) {
                        clazz = (Class)object3;
                    } else if (object3 instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)object3).getRawType()) instanceof Class && Collection.class.isAssignableFrom(clazz3 = (Class)type)) {
                        clazz = clazz3;
                        variety = List.class.isAssignableFrom(clazz) && (clazz.isInterface() || RandomAccess.class.isAssignableFrom(clazz)) ? Variety.LIST : Variety.COLLECTION;
                    }
                    if (clazz == null) {
                        clazz = elementDeclaration.typeInfo.valueType.javaType;
                    }
                }
                if (FCGTypeUtil.isPrimitiveType((FcgType)(object3 = FCGTypeUtil.getFcgType(clazz, fcgCodeGen)))) {
                    object3 = FCGTypeUtil.getPrimitiveWrapperType(fcgCodeGen, (FcgType)object3);
                }
                if (object3 == FcgType.BYTE_ARRAY) {
                    this.writeJAXBElement(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgFieldArray, fcgField, elementDeclaration, (FcgVariable)object, fcgVariable, variety, i);
                } else {
                    fcgInstructionList.loadVar((FcgVariable)object);
                    if (object3 != FcgType.OBJECT) {
                        fcgInstructionList.runtimeTypeCheck((FcgReferenceType)object3);
                    } else {
                        fcgInstructionList.runtimeTypeCheck(fcgCodeGen.getInterfaceType(FCGSerializationStubGeneratorHelper.CLASS_DOM_ELEMENT));
                        fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
                    }
                    fcgInstructionList.beginIf();
                    this.writeJAXBElement(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgFieldArray, fcgField, elementDeclaration, (FcgVariable)object, fcgVariable, variety, i);
                    fcgInstructionList.beginElse();
                    this.invokeWriteRootJAXBElement(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, (FcgVariable)object2, fcgField);
                    fcgInstructionList.endIf();
                }
                fcgInstructionList.endSwitchCaseBlock();
            }
            fcgInstructionList.beginSwitchDefaultBlock();
            this.invokeWriteRootJAXBElement(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, (FcgVariable)object2, fcgField);
            fcgInstructionList.endSwitchDefaultBlock();
            fcgInstructionList.endSwitch();
        } else {
            this.invokeWriteRootJAXBElement(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgField);
        }
        fcgInstructionList.endSwitchCaseBlock();
        fcgInstructionList.beginSwitchDefaultBlock();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgClassReferenceType, "fContext", fcgClassReferenceType2);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "reportInvalidRoot", (FcgType)FcgType.VOID, new FcgType[]{FcgType.OBJECT});
        fcgInstructionList.endSwitchDefaultBlock();
        fcgInstructionList.endSwitch();
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void writeJAXBElement(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgField[][] fcgFieldArray, FcgField fcgField, ElementDeclaration elementDeclaration, FcgVariable fcgVariable, FcgVariable fcgVariable2, Variety variety, int n) {
        FCGSerializationRootStubGenerator.invokeWriteBytes(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgFieldArray[n][0]);
        if (fcgField != null) {
            FCGSerializationRootStubGenerator.invokeWriteBytes(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgField);
        }
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.beginIf();
        FCGSerializationRootStubGenerator.invokeWriteXSINilFragmentMinusTwo(fcgCodeGen, fcgClassGen, fcgInstructionList);
        fcgInstructionList.endIf();
        PropertyTypeInformation propertyTypeInformation = elementDeclaration.typeInfo;
        ValueTypeInformation valueTypeInformation = propertyTypeInformation.valueType;
        boolean bl = valueTypeInformation.typeId == 18;
        FcgVariable fcgVariable3 = null;
        if (FCGSerializationRootStubGenerator.hasAdapterClass(propertyTypeInformation)) {
            fcgVariable = this.callAdapter(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, propertyTypeInformation, true);
        }
        if (bl) {
            FCGSerializationStubGeneratorHelper.invokePushNSContext(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList);
            fcgVariable3 = FCGSerializationStubGeneratorHelper.invokeGetPrefixAndDeclareNS(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, variety);
        }
        if (valueTypeInformation.valueClass != null) {
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_CONTEXT);
            FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
            FcgClassReferenceType fcgClassReferenceType3 = fcgInstructionList.loadThis();
            fcgInstructionList.loadInstanceField(fcgClassReferenceType3, "fContext", fcgClassReferenceType);
            fcgInstructionList.loadLiteral(valueTypeInformation.valueClass.classId);
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "getSerializationStub", (FcgType)fcgClassReferenceType2, new FcgType[]{FcgType.INT, FcgType.OBJECT});
            FcgVariable fcgVariable4 = fcgInstructionList.defineVar(fcgClassReferenceType2, "stub_" + n, true);
            if (variety == Variety.ATOMIC) {
                fcgInstructionList.loadVar(fcgVariable4);
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "write", (FcgType)FcgType.VOID, new FcgType[]{FcgType.OBJECT});
            } else {
                FCGSerializationStubGeneratorHelper.invokeWriteByte(fcgCodeGen, fcgClassGen, fcgInstructionList, (byte)62);
                FCGSerializationStubGeneratorHelper.writeSimpleTypeObjectList(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable4, variety);
            }
        } else if (valueTypeInformation.enumClass != null) {
            FCGSerializationStubGeneratorHelper.invokeWriteByte(fcgCodeGen, fcgClassGen, fcgInstructionList, (byte)62);
            FCGSerializationStubGeneratorHelper.writeEnumValue(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable3, propertyTypeInformation, variety, false);
        } else {
            FCGSerializationStubGeneratorHelper.invokeWriteByte(fcgCodeGen, fcgClassGen, fcgInstructionList, (byte)62);
            FCGSerializationStubGeneratorHelper.writeSimpleTypeValue(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable3, propertyTypeInformation, variety, false);
        }
        if (bl) {
            FCGSerializationStubGeneratorHelper.invokePopNSContext(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList);
        }
        FCGSerializationRootStubGenerator.invokeWriteBytes(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgFieldArray[n][1]);
    }

    private void invokeWriteRootJAXBElement(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgField fcgField) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_JAXB_ELEMENT);
        FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(fcgVariable.getType(), fcgClassReferenceType);
        if (fcgField != null) {
            fcgInstructionList.loadClassField(fcgField);
        } else {
            fcgInstructionList.loadNull();
        }
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "writeRootJAXBElement", (FcgType)FcgType.VOID, new FcgType[]{fcgClassReferenceType, FcgType.BYTE_ARRAY});
    }

    private static String escapeURI(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<' && c != '&' && c != '\"' && c != '\t' && c != '\n' && c != '\r') continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (i = 0; i < n; ++i) {
                c = string.charAt(i);
                if (c == '<') {
                    stringBuilder.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    stringBuilder.append("&amp;");
                    continue;
                }
                if (c == '\"') {
                    stringBuilder.append("&quot;");
                    continue;
                }
                if (c == '\t') {
                    stringBuilder.append("&#x9;");
                    continue;
                }
                if (c == '\n') {
                    stringBuilder.append("&#xA;");
                    continue;
                }
                if (c == '\r') {
                    stringBuilder.append("&#xD;");
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }
}

