/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal;

import com.ibm.xml.xlxp2.jaxb.PropertyKeyAdapter;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationContext;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationStubFactory;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.msg.JAXBMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class MarshallerImpl
implements Marshaller {
    private static final byte[] XML_DECLARATION;
    private static final boolean FRAGMENT_DEFAULT = false;
    private static final String ENCODING_DEFAULT = "UTF-8";
    private static final int SCHEMA_SET = 1;
    private static final int LISTENER_SET = 2;
    private static final int PROPERTIES_SET = 4;
    private static final int VALIDATION_EVENT_HANDLER_SET = 8;
    private static final int ADAPTER_INSTANCES_SET = 16;
    private static final int NON_UTF8_ENCODING_SET = 32;
    private final SerializationContext fContext;
    private final JAXBContext fFallbackContext;
    private final PropertyKeyAdapter fPropertyKeyAdapter;
    private Marshaller fFallbackMarshaller;
    private ValidationEventHandler fEventHandler;
    private Schema fSchema;
    private AttachmentMarshaller fAttachmentMarshaller;
    private Marshaller.Listener fListener;
    private HashMap<String, Object> fInitProperties;
    private boolean fFragment = false;
    private String fEncoding = "UTF-8";
    private int flags;

    public MarshallerImpl(JAXBModel jAXBModel, JAXBContext jAXBContext, SerializationStubFactory serializationStubFactory, PropertyKeyAdapter propertyKeyAdapter) throws JAXBException {
        this.fFallbackContext = jAXBContext;
        this.fPropertyKeyAdapter = propertyKeyAdapter;
        this.fContext = new SerializationContext(jAXBModel, serializationStubFactory, this);
    }

    public Node getNode(Object object) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        this.initFallbackMarshaller();
        return this.fFallbackMarshaller.getNode(object);
    }

    public void marshal(Object object, Result result) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (result == null) {
            MarshallerImpl.reportNullParameter(Result.class);
        }
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            Writer writer = streamResult.getWriter();
            if (writer != null) {
                this.marshal(object, writer);
                return;
            }
            OutputStream outputStream = streamResult.getOutputStream();
            if (outputStream != null) {
                this.marshal(object, outputStream);
                return;
            }
        } else if (result instanceof StAXResult) {
            StAXResult stAXResult = (StAXResult)result;
            XMLStreamWriter xMLStreamWriter = stAXResult.getXMLStreamWriter();
            if (xMLStreamWriter != null) {
                this.marshal(object, xMLStreamWriter);
            } else {
                this.marshal(object, stAXResult.getXMLEventWriter());
            }
            return;
        }
        this.initFallbackMarshaller();
        this.fFallbackMarshaller.marshal(object, result);
    }

    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (outputStream == null) {
            MarshallerImpl.reportNullParameter(OutputStream.class);
        }
        if (this.flags == 0) {
            try {
                this.fContext.output.setup(outputStream);
                if (!this.fFragment) {
                    this.fContext.output.write(XML_DECLARATION);
                }
                this.fContext.rootStub.write(object);
                this.fContext.output.writePending();
                return;
            }
            catch (IOException iOException) {
                JAXBMessageProvider.throwMarshalException(iOException);
            }
            catch (JAXBMessageProvider.MarshalExceptionWrapper marshalExceptionWrapper) {
                JAXBMessageProvider.throwMarshalException(marshalExceptionWrapper);
            }
            catch (StackOverflowError stackOverflowError) {
                MarshallerImpl.reportDetectedCycle(object);
            }
        }
        this.initFallbackMarshaller();
        this.fFallbackMarshaller.marshal(object, outputStream);
    }

    public void marshal(Object object, File file) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (file == null) {
            MarshallerImpl.reportNullParameter(File.class);
        }
        try {
            this.marshal(object, new FileOutputStream(file));
        }
        catch (IOException iOException) {
            throw new MarshalException((Throwable)iOException);
        }
    }

    public void marshal(Object object, Writer writer) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (writer == null) {
            MarshallerImpl.reportNullParameter(Writer.class);
        }
        this.initFallbackMarshaller();
        this.fFallbackMarshaller.marshal(object, writer);
    }

    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (contentHandler == null) {
            MarshallerImpl.reportNullParameter(ContentHandler.class);
        }
        this.initFallbackMarshaller();
        this.fFallbackMarshaller.marshal(object, contentHandler);
    }

    public void marshal(Object object, Node node) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (node == null) {
            MarshallerImpl.reportNullParameter(Node.class);
        }
        this.initFallbackMarshaller();
        this.fFallbackMarshaller.marshal(object, node);
    }

    public void marshal(Object object, XMLStreamWriter xMLStreamWriter) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (xMLStreamWriter == null) {
            MarshallerImpl.reportNullParameter(XMLStreamWriter.class);
        }
        this.initFallbackMarshaller();
        this.fFallbackMarshaller.marshal(object, xMLStreamWriter);
    }

    public void marshal(Object object, XMLEventWriter xMLEventWriter) throws JAXBException {
        if (object == null) {
            MarshallerImpl.reportNullParameter(Object.class);
        }
        if (xMLEventWriter == null) {
            MarshallerImpl.reportNullParameter(XMLEventWriter.class);
        }
        this.initFallbackMarshaller();
        this.fFallbackMarshaller.marshal(object, xMLEventWriter);
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.setFlag(8, validationEventHandler != null);
        this.fEventHandler = validationEventHandler;
        if (this.fFallbackMarshaller != null) {
            this.fFallbackMarshaller.setEventHandler(validationEventHandler);
        }
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        if (this.fEventHandler != null) {
            return this.fEventHandler;
        }
        this.initFallbackMarshaller();
        return this.fFallbackMarshaller.getEventHandler();
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            MarshallerImpl.reportNullParameter(String.class);
        }
        if ("jaxb.fragment".equals(string) && object instanceof Boolean) {
            this.fFragment = (Boolean)object;
            if (this.fFallbackMarshaller != null) {
                this.fFallbackMarshaller.setProperty("jaxb.fragment", object);
            }
            return;
        }
        if ("jaxb.encoding".equals(string) && object instanceof String) {
            this.fEncoding = (String)object;
            if (this.fFallbackMarshaller != null) {
                this.fFallbackMarshaller.setProperty("jaxb.encoding", object);
            }
            this.setFlag(32, !ENCODING_DEFAULT.equals(object));
            return;
        }
        try {
            this.initFallbackMarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new PropertyException((Throwable)jAXBException);
        }
        string = this.fPropertyKeyAdapter.adaptKey(string);
        if (this.fInitProperties == null) {
            this.fInitProperties = new HashMap();
        }
        boolean bl = this.fInitProperties.containsKey(string);
        Object object2 = null;
        if (!bl) {
            try {
                object2 = this.fFallbackMarshaller.getProperty(string);
            }
            catch (PropertyException propertyException) {
                object2 = null;
            }
        }
        this.fFallbackMarshaller.setProperty(string, object);
        if (!bl) {
            if (object2 != object) {
                this.fInitProperties.put(string, object2);
            }
        } else {
            Object object3 = this.fInitProperties.get(string);
            if (object3 == object || object3 instanceof Boolean && object3.equals(object)) {
                this.fInitProperties.remove(string);
            }
        }
        this.setFlag(4, this.fInitProperties.size() > 0);
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            MarshallerImpl.reportNullParameter(String.class);
        }
        try {
            this.initFallbackMarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new PropertyException((Throwable)jAXBException);
        }
        return this.fFallbackMarshaller.getProperty(this.fPropertyKeyAdapter.adaptKey(string));
    }

    public void setSchema(Schema schema) {
        this.setFlag(1, schema != null);
        this.fSchema = schema;
        if (this.fFallbackMarshaller != null) {
            this.fFallbackMarshaller.setSchema(schema);
        }
    }

    public Schema getSchema() {
        return this.fSchema;
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        if (xmlAdapter == null) {
            MarshallerImpl.reportNullParameter(XmlAdapter.class);
        }
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        if (clazz == null) {
            MarshallerImpl.reportNullParameter(Class.class);
        }
        try {
            this.initFallbackMarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
        this.setFlag(16, true);
        this.fFallbackMarshaller.setAdapter(clazz, a);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        if (clazz == null) {
            MarshallerImpl.reportNullParameter(Class.class);
        }
        if (this.fFallbackMarshaller != null) {
            return (A)this.fFallbackMarshaller.getAdapter(clazz);
        }
        return null;
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        this.fAttachmentMarshaller = attachmentMarshaller;
        if (this.fFallbackMarshaller != null) {
            this.fFallbackMarshaller.setAttachmentMarshaller(attachmentMarshaller);
        }
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.fAttachmentMarshaller;
    }

    public void setListener(Marshaller.Listener listener) {
        this.setFlag(2, listener != null);
        this.fListener = listener;
        if (this.fFallbackMarshaller != null) {
            this.fFallbackMarshaller.setListener(listener);
        }
    }

    public Marshaller.Listener getListener() {
        return this.fListener;
    }

    private void initFallbackMarshaller() throws JAXBException {
        if (this.fFallbackMarshaller == null) {
            Marshaller marshaller = this.fFallbackContext.createMarshaller();
            if (this.fEventHandler != null) {
                marshaller.setEventHandler(this.fEventHandler);
            }
            if (this.fSchema != null) {
                marshaller.setSchema(this.fSchema);
            }
            if (this.fAttachmentMarshaller != null) {
                marshaller.setAttachmentMarshaller(this.fAttachmentMarshaller);
            }
            if (this.fListener != null) {
                marshaller.setListener(this.fListener);
            }
            marshaller.setProperty("jaxb.fragment", (Object)this.fFragment);
            marshaller.setProperty("jaxb.encoding", (Object)this.fEncoding);
            this.fFallbackMarshaller = marshaller;
        }
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? this.flags | n : this.flags & ~n;
    }

    private static void reportNullParameter(Class<?> clazz) {
        throw new IllegalArgumentException(JAXBMessageProvider.createMessage(null, 24, clazz.getName()));
    }

    private static final void reportDetectedCycle(Object object) throws MarshalException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(object.getClass().getName().toString());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(System.identityHashCode(object)));
        JAXBMessageProvider.throwMarshalException(JAXBMessageProvider.createMessage(null, 28, stringBuilder.toString()));
    }

    static {
        byte[] byArray = null;
        try {
            byArray = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>".getBytes(ENCODING_DEFAULT);
        }
        catch (Exception exception) {
            byArray = new byte[]{};
        }
        XML_DECLARATION = byArray;
    }
}

