/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb;

import com.ibm.xml.xlxp2.grammar.Grammar;
import com.ibm.xml.xlxp2.jaxb.PropertyKeyAdapter;
import com.ibm.xml.xlxp2.jaxb.Version;
import com.ibm.xml.xlxp2.jaxb.binder.BinderProxy;
import com.ibm.xml.xlxp2.jaxb.marshal.MarshallerImpl;
import com.ibm.xml.xlxp2.jaxb.marshal.MarshallerProxy;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationStubFactory;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.ValueTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.builder.ContextBuilder;
import com.ibm.xml.xlxp2.jaxb.model.builder.util.Util;
import com.ibm.xml.xlxp2.jaxb.model.converter.JAXBModelConverter;
import com.ibm.xml.xlxp2.jaxb.msg.JAXBMessageProvider;
import com.ibm.xml.xlxp2.jaxb.unmarshal.UnmarshallerImpl;
import com.ibm.xml.xlxp2.jaxb.unmarshal.UnmarshallerProxy;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationStubFactory;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.SymbolMapHolder;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class JAXBContextImpl
extends JAXBContext {
    private static final String OPTI_LEVEL_PROPERTY = "com.ibm.xml.xlxp.jaxb.opti.level";
    private static final String JAXB_DESERIALIZATION_STUB_FACTORY_PROPERTY = "jaxb.stub.factory";
    private static final String DEFAULT_JAXB_DESERIALIZATION_STUB_FACTORY = "com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.FCGStubFactory";
    private static final String JAXB_SERIALIZATION_STUB_FACTORY_PROPERTY = "jaxb.serialization.stub.factory";
    private static final String DEFAULT_JAXB_SERIALIZATION_STUB_FACTORY = "com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.FCGStubFactory";
    private static final String CREATE_CONTEXT_METHOD_NAME = "createContext";
    private static final String BUILTIN_RI_CONTEXT_FACTORY = "com.sun.xml.internal.bind.v2.ContextFactory";
    private static final String STANDALONE_RI_CONTEXT_FACTORY = "com.sun.xml.bind.v2.ContextFactory";
    private final int fOptiLevel;
    private final JAXBModel fModel;
    private final Grammar fGrammar;
    private final DeserializationStubFactory fDeserializationStubFactory;
    private final SerializationStubFactory fSerializationStubFactory;
    private final PropertyKeyAdapter fPropertyKeyAdapter;
    private final JAXBContext fFallbackContext;
    private static final SymbolMapHolder fgSymbolMapHolder = new SymbolMapHolder();

    public JAXBContextImpl(String string, ClassLoader classLoader, Map<String, ?> map) throws JAXBException {
        JAXBModel jAXBModel = null;
        Grammar grammar = null;
        DeserializationStubFactory deserializationStubFactory = null;
        SerializationStubFactory serializationStubFactory = null;
        this.fOptiLevel = this.getOptiLevel();
        if (this.fOptiLevel > 0) {
            try {
                jAXBModel = ContextBuilder.buildModel(string, classLoader);
                grammar = new JAXBModelConverter().convert(jAXBModel);
                deserializationStubFactory = this.createDeserializationStubFactory();
                serializationStubFactory = this.createSerializationStubFactory();
            }
            catch (VirtualMachineError virtualMachineError) {
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.handleFailedModelConstruction(throwable);
                jAXBModel = null;
                grammar = null;
                deserializationStubFactory = null;
                serializationStubFactory = null;
            }
        }
        this.fModel = jAXBModel;
        this.fGrammar = grammar;
        this.fDeserializationStubFactory = deserializationStubFactory;
        this.fSerializationStubFactory = serializationStubFactory;
        this.fPropertyKeyAdapter = new PropertyKeyAdapter();
        this.fFallbackContext = this.createFallbackContext(string, classLoader, map);
    }

    public JAXBContextImpl(Class[] classArray, Map<String, ?> map) throws JAXBException {
        JAXBModel jAXBModel = null;
        Grammar grammar = null;
        DeserializationStubFactory deserializationStubFactory = null;
        SerializationStubFactory serializationStubFactory = null;
        this.fOptiLevel = this.getOptiLevel();
        if (this.fOptiLevel > 0) {
            try {
                ArrayList arrayList = new ArrayList();
                int n = classArray != null ? classArray.length : 0;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(classArray[i]);
                }
                jAXBModel = ContextBuilder.buildContext(arrayList).model;
                grammar = new JAXBModelConverter().convert(jAXBModel);
                deserializationStubFactory = this.createDeserializationStubFactory();
                serializationStubFactory = this.createSerializationStubFactory();
            }
            catch (VirtualMachineError virtualMachineError) {
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.handleFailedModelConstruction(throwable);
                jAXBModel = null;
                grammar = null;
                deserializationStubFactory = null;
                serializationStubFactory = null;
            }
        }
        this.fModel = jAXBModel;
        this.fGrammar = grammar;
        this.fDeserializationStubFactory = deserializationStubFactory;
        this.fSerializationStubFactory = serializationStubFactory;
        this.fPropertyKeyAdapter = new PropertyKeyAdapter();
        this.fFallbackContext = this.createFallbackContext(classArray, map);
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        if (this.fModel != null && (this.fOptiLevel == 1 || this.fOptiLevel > 2)) {
            try {
                return new UnmarshallerImpl(this.fModel, this.fGrammar, this.fFallbackContext, this.fDeserializationStubFactory, fgSymbolMapHolder, this.createDatatypeFactory(), this.fPropertyKeyAdapter);
            }
            catch (VirtualMachineError virtualMachineError) {
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.handleFailedUnmarshallerConstruction(throwable);
            }
        }
        return new UnmarshallerProxy(this.fFallbackContext, this.fPropertyKeyAdapter);
    }

    public Marshaller createMarshaller() throws JAXBException {
        if (this.fModel != null && this.fOptiLevel > 1) {
            try {
                return new MarshallerImpl(this.fModel, this.fFallbackContext, this.fSerializationStubFactory, this.fPropertyKeyAdapter);
            }
            catch (VirtualMachineError virtualMachineError) {
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.handleFailedMarshallerConstruction(throwable);
            }
        }
        return new MarshallerProxy(this.fFallbackContext, this.fPropertyKeyAdapter);
    }

    public Validator createValidator() throws JAXBException {
        return this.fFallbackContext.createValidator();
    }

    public <T> Binder<T> createBinder(Class<T> clazz) {
        return new BinderProxy<T>(this.fFallbackContext, clazz, this.fPropertyKeyAdapter);
    }

    public Binder<Node> createBinder() {
        return this.createBinder(Node.class);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return this.fFallbackContext.createJAXBIntrospector();
    }

    public void generateSchema(SchemaOutputResolver schemaOutputResolver) throws IOException {
        this.fFallbackContext.generateSchema(schemaOutputResolver);
    }

    private DeserializationStubFactory createDeserializationStubFactory() throws JAXBException {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string = null;
                try {
                    string = System.getProperty(JAXBContextImpl.JAXB_DESERIALIZATION_STUB_FACTORY_PROPERTY);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return string;
            }
        });
        if (string == null) {
            string = DEFAULT_JAXB_DESERIALIZATION_STUB_FACTORY;
        }
        try {
            return (DeserializationStubFactory)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new JAXBException((Throwable)exception);
        }
    }

    private SerializationStubFactory createSerializationStubFactory() throws JAXBException {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string = null;
                try {
                    string = System.getProperty(JAXBContextImpl.JAXB_SERIALIZATION_STUB_FACTORY_PROPERTY);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return string;
            }
        });
        if (string == null) {
            string = DEFAULT_JAXB_SERIALIZATION_STUB_FACTORY;
        }
        try {
            return (SerializationStubFactory)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new JAXBException((Throwable)exception);
        }
    }

    private DatatypeFactory createDatatypeFactory() throws JAXBException {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (Exception exception) {
            throw new JAXBException((Throwable)exception);
        }
    }

    private JAXBContext createFallbackContext(String string, ClassLoader classLoader, Map<String, ?> map) throws JAXBException {
        try {
            Class<?> clazz = Class.forName(BUILTIN_RI_CONTEXT_FACTORY);
            Method method = clazz.getMethod(CREATE_CONTEXT_METHOD_NAME, String.class, ClassLoader.class, Map.class);
            this.fPropertyKeyAdapter.setAdapterMode(true);
            return (JAXBContext)method.invoke(null, string, classLoader, this.adaptKeys(BUILTIN_RI_CONTEXT_FACTORY, map));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof JAXBException) {
                throw (JAXBException)throwable;
            }
            throw new JAXBException((Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            if (Util.VERBOSE) {
                System.err.println(JAXBMessageProvider.createMessage(null, 25));
                exception.printStackTrace();
            }
            try {
                Class<?> clazz = Class.forName(STANDALONE_RI_CONTEXT_FACTORY);
                Method method = clazz.getMethod(CREATE_CONTEXT_METHOD_NAME, String.class, ClassLoader.class, Map.class);
                this.fPropertyKeyAdapter.setAdapterMode(false);
                return (JAXBContext)method.invoke(null, string, classLoader, this.adaptKeys(STANDALONE_RI_CONTEXT_FACTORY, map));
            }
            catch (Exception exception2) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof JAXBException) {
                    throw (JAXBException)throwable;
                }
                throw new JAXBException((Throwable)exception2);
            }
        }
    }

    private JAXBContext createFallbackContext(Class[] classArray, Map<String, ?> map) throws JAXBException {
        try {
            Class<?> clazz = Class.forName(BUILTIN_RI_CONTEXT_FACTORY);
            Method method = clazz.getMethod(CREATE_CONTEXT_METHOD_NAME, Class[].class, Map.class);
            this.fPropertyKeyAdapter.setAdapterMode(true);
            return (JAXBContext)method.invoke(null, classArray, this.adaptKeys(BUILTIN_RI_CONTEXT_FACTORY, map));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof JAXBException) {
                throw (JAXBException)throwable;
            }
            throw new JAXBException((Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            if (Util.VERBOSE) {
                System.err.println(JAXBMessageProvider.createMessage(null, 25));
                exception.printStackTrace();
            }
            try {
                Class<?> clazz = Class.forName(STANDALONE_RI_CONTEXT_FACTORY);
                Method method = clazz.getMethod(CREATE_CONTEXT_METHOD_NAME, Class[].class, Map.class);
                this.fPropertyKeyAdapter.setAdapterMode(false);
                return (JAXBContext)method.invoke(null, classArray, this.adaptKeys(STANDALONE_RI_CONTEXT_FACTORY, map));
            }
            catch (Exception exception2) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof JAXBException) {
                    throw (JAXBException)throwable;
                }
                throw new JAXBException((Throwable)exception2);
            }
        }
    }

    private Map<String, ?> adaptKeys(String string, Map<String, ?> map) throws JAXBException {
        if (map != null) {
            Iterator<Map.Entry<String, ?>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ?> entry2 = iterator.next();
                String string2 = entry2.getKey();
                String string3 = this.fPropertyKeyAdapter.adaptKey(string2);
                if (string3 == string2) continue;
                HashMap hashMap = new HashMap();
                for (Map.Entry<String, ?> entry2 : map.entrySet()) {
                    string3 = this.fPropertyKeyAdapter.adaptKey(entry2.getKey());
                    hashMap.put(string3, entry2.getValue());
                }
                return hashMap;
            }
        }
        return map;
    }

    private void handleFailedModelConstruction(Throwable throwable) throws JAXBException {
        if (Util.VERBOSE) {
            System.err.println(JAXBMessageProvider.createMessage(null, 3));
            throwable.printStackTrace();
        }
    }

    private void handleFailedUnmarshallerConstruction(Throwable throwable) throws JAXBException {
        if (Util.VERBOSE) {
            System.err.println(JAXBMessageProvider.createMessage(null, 4));
            throwable.printStackTrace();
        }
    }

    private void handleFailedMarshallerConstruction(Throwable throwable) throws JAXBException {
        if (Util.VERBOSE) {
            System.err.println(JAXBMessageProvider.createMessage(null, 4));
            throwable.printStackTrace();
        }
    }

    private int getOptiLevel() {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    String string = System.getProperty(JAXBContextImpl.OPTI_LEVEL_PROPERTY);
                    if (string != null) {
                        return Integer.parseInt(string);
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return 1;
            }
        });
    }

    public String toString() {
        Serializable serializable;
        StringBuilder stringBuilder = new StringBuilder();
        String string = JAXBContextImpl.class.getSimpleName();
        try {
            serializable = JAXBContextImpl.class.getResource(string + ".class");
            if (serializable != null) {
                string = ((URL)serializable).toExternalForm();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append("Primary JAXBContext:\n");
        stringBuilder.append(string);
        stringBuilder.append(",\nVersion: ");
        stringBuilder.append(Version.getVersion());
        stringBuilder.append(",\nTimestamp: ");
        stringBuilder.append(Version.getBuildTimeStamp());
        stringBuilder.append(",\nClasses known to this context:\n");
        if (this.fModel != null) {
            Object object;
            serializable = new TreeSet();
            JAXBContextImpl.addBuiltInClasses((SortedSet<String>)((Object)serializable));
            ValueTypeInformation[] valueTypeInformationArray = this.fModel.processedTypesInformation;
            int n = valueTypeInformationArray != null ? valueTypeInformationArray.length : 0;
            for (int i = 0; i < n; ++i) {
                object = this.fModel.processedTypesInformation[i];
                if (object == null) continue;
                serializable.add(JAXBContextImpl.toString(((ValueTypeInformation)object).javaType));
            }
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuilder.append("  ");
                stringBuilder.append((String)object);
                stringBuilder.append("\n");
            }
        } else {
            stringBuilder.append("  [NONE] (Fallback JAXBContext will be used to process any requests.)\n");
        }
        if (this.fFallbackContext != null) {
            stringBuilder.append("\nFallback JAXBContext:\n");
            stringBuilder.append(this.fFallbackContext.toString());
        }
        return stringBuilder.toString();
    }

    private static String toString(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getName());
        ClassLoader classLoader = JAXBContextImpl.getClassLoader(clazz);
        if (classLoader != null) {
            Class<?> clazz2 = classLoader.getClass();
            stringBuilder.append(" [");
            stringBuilder.append(clazz2.getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(System.identityHashCode(classLoader)));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = clazz.getClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    private static void addBuiltInClasses(SortedSet<String> sortedSet) {
        sortedSet.add(Object.class.getName());
        sortedSet.add(JAXBElement.class.getName());
        sortedSet.add(Boolean.class.getName());
        sortedSet.add(Byte.class.getName());
        sortedSet.add(Short.class.getName());
        sortedSet.add(Integer.class.getName());
        sortedSet.add(Long.class.getName());
        sortedSet.add(Float.class.getName());
        sortedSet.add(Double.class.getName());
        sortedSet.add(Character.class.getName());
        sortedSet.add(Void.class.getName());
        sortedSet.add(Boolean.TYPE.getName());
        sortedSet.add(Byte.TYPE.getName());
        sortedSet.add(Short.TYPE.getName());
        sortedSet.add(Integer.TYPE.getName());
        sortedSet.add(Long.TYPE.getName());
        sortedSet.add(Float.TYPE.getName());
        sortedSet.add(Double.TYPE.getName());
        sortedSet.add(Character.TYPE.getName());
        sortedSet.add(Void.TYPE.getName());
        sortedSet.add(String.class.getName());
        sortedSet.add(Object.class.getName());
        sortedSet.add(String.class.getName());
        sortedSet.add(BigInteger.class.getName());
        sortedSet.add(BigDecimal.class.getName());
        sortedSet.add(Calendar.class.getName());
        sortedSet.add(GregorianCalendar.class.getName());
        sortedSet.add(Date.class.getName());
        sortedSet.add(QName.class.getName());
        sortedSet.add(URI.class.getName());
        sortedSet.add(URL.class.getName());
        sortedSet.add(File.class.getName());
        sortedSet.add(XMLGregorianCalendar.class.getName());
        sortedSet.add(Duration.class.getName());
        sortedSet.add(Image.class.getName());
        sortedSet.add(DataHandler.class.getName());
        sortedSet.add(Source.class.getName());
        sortedSet.add(UUID.class.getName());
        sortedSet.add(byte[].class.getName());
    }
}

