/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XShort;
import com.ibm.xml.xlxp2.datatype.validation.Pattern;
import com.ibm.xml.xlxp2.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ShortDV
extends TypeValidator {
    private final int totalDigits;
    private final short[] enumeration;
    private final short maxInclusive;
    private final short maxExclusive;
    private final short minInclusive;
    private final short minExclusive;

    public ShortDV(String string, String string2, String string3, String[] stringArray, short[] sArray, short s, short s2, short s3, short s4, int n, int n2) {
        super(string, string2, string3, 35, 4, stringArray, ShortDV.computeDefinedFacets(n2, s, s2, s3, s4), false);
        this.totalDigits = n;
        this.enumeration = sArray;
        this.maxInclusive = s3;
        this.maxExclusive = s4;
        this.minInclusive = s;
        this.minExclusive = s2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XShort xShort = new XShort(ShortDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xShort;
            validatedInfo.errorCode = 0;
        }
        return xShort;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        short s = XSIntegerUtil.parseShort(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = s == ((XShort)validatedInfo.actualValue).value ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(s, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXShort(s);
    }

    public int preCheckFacets(short s, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(s, xMLString);
        }
        return 0;
    }

    private int checkFacets(short s, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && this.getTotalDigits(s) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && s < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && s <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && s > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && s >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != s) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n, short s, short s2, short s3, short s4) {
        if ((n & 0x100) != 0 && s <= Short.MIN_VALUE) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x20) != 0 && s3 >= Short.MAX_VALUE) {
            n &= 0xFFFFFFDF;
        }
        if ((n & 0x80) != 0 && s2 < Short.MIN_VALUE) {
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x40) != 0 && s4 > Short.MAX_VALUE) {
            n &= 0xFFFFFFBF;
        }
        return n;
    }

    private int getTotalDigits(short s) {
        if (s >= 0) {
            if (s < 1000) {
                return s < 10 ? 1 : (s < 100 ? 2 : 3);
            }
            return s < 10000 ? 4 : 5;
        }
        if (s > -1000) {
            return s > -10 ? 1 : (s > -100 ? 2 : 3);
        }
        return s > -10000 ? 4 : 5;
    }

    protected Pattern createPattern(String[] stringArray, int n) {
        int n2;
        if ((n & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n3 = n2 = stringArray != null ? stringArray.length : 0;
        if (n2 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static short parse(XMLString xMLString) {
        return XSIntegerUtil.parseShort(xMLString, dummyOneElementArray);
    }
}

