/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.XInt;
import com.ibm.xml.xlxp2.datatype.XLong;
import com.ibm.xml.xlxp2.datatype.validation.Pattern;
import com.ibm.xml.xlxp2.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class IntDV
extends TypeValidator {
    private static final int SIGNED_INT_MULTMIN = -214748364;
    private final int totalDigits;
    private final int[] enumeration;
    private final int maxInclusive;
    private final int maxExclusive;
    private final int minInclusive;
    private final int minExclusive;

    public IntDV(String string, String string2, String string3, String[] stringArray, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(string, string2, string3, 34, 4, stringArray, IntDV.computeDefinedFacets(n6, n, n2, n3, n4), false);
        this.totalDigits = n5;
        this.enumeration = nArray;
        this.maxInclusive = n3;
        this.maxExclusive = n4;
        this.minInclusive = n;
        this.minExclusive = n2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XInt xInt = new XInt(IntDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xInt;
            validatedInfo.errorCode = 0;
        }
        return xInt;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        int n = XSIntegerUtil.parseInt(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            Object object = validatedInfo.actualValue;
            validatedInfo2.errorCode = object instanceof XInt ? (n == ((XInt)validatedInfo.actualValue).value ? 0 : 1) : (object instanceof XLong ? ((long)n == ((XLong)object).value ? 0 : 1) : (object instanceof XDecimal ? (((XDecimal)object).equals(n) ? 0 : 1) : 1));
            validatedInfo2.actualValue = object;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(n, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXInt(n);
    }

    public int preCheckFacets(int n, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(n, xMLString);
        }
        return 0;
    }

    private int checkFacets(int n, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && XSIntegerUtil.getTotalDigits(xMLString) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && n < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && n <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && n > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && n >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x100) != 0 && n2 <= Integer.MIN_VALUE) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x20) != 0 && n4 >= Integer.MAX_VALUE) {
            n &= 0xFFFFFFDF;
        }
        if ((n & 0x80) != 0 && n3 < Integer.MIN_VALUE) {
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x40) != 0 && n5 > Integer.MAX_VALUE) {
            n &= 0xFFFFFFBF;
        }
        return n;
    }

    protected Pattern createPattern(String[] stringArray, int n) {
        int n2;
        if ((n & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n3 = n2 = stringArray != null ? stringArray.length : 0;
        if (n2 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static int parse(XMLString xMLString) {
        return XSIntegerUtil.parseInt(xMLString, dummyOneElementArray);
    }

    private int parseIntUnbuffered(ParsedEntity parsedEntity, XInt xInt, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        boolean bl = false;
        int n3 = -2147483647;
        int n4 = -214748364;
        if ((n = IntDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        byte by = byArray[n];
        if (by == 45) {
            bl = true;
            n3 = Integer.MIN_VALUE;
            if (++n < n2) {
                by = byArray[n];
            }
        } else if (by == 43 && ++n < n2) {
            by = byArray[n];
        }
        if (by >= 48 && by <= 57) {
            ++n;
            int n5 = 48 - by;
            while (n < n2 && (by = byArray[n]) >= 48 && by <= 57) {
                int n6;
                if (n5 >= n4 && (n5 *= 10) >= n3 + (n6 = by - 48)) {
                    n5 -= n6;
                } else {
                    return -1;
                }
                ++n;
            }
            if ((n = IntDV.removeWhitespace(byArray, n, n2, blArray)) < n2) {
                xInt.value = bl ? n5 : -n5;
                return n;
            }
        }
        return -1;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XInt xInt = vMContext.dvContext.getXInt(0);
        int n = this.parseIntUnbuffered(parsedEntity, xInt, this.fNormalized);
        if (n == -1) {
            return null;
        }
        parsedEntity.offset = n;
        return xInt;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets(((XInt)object).value, xMLString);
    }
}

