/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XFloat;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class FloatDV
extends TypeValidator {
    private final float[] enumeration;
    private final float maxInclusive;
    private final float maxExclusive;
    private final float minInclusive;
    private final float minExclusive;

    public FloatDV(String string, String string2, String string3, String[] stringArray, float[] fArray, float f, float f2, float f3, float f4, int n) {
        super(string, string2, string3, 5, 5, stringArray, n, false);
        this.enumeration = fArray;
        this.maxInclusive = f3;
        this.maxExclusive = f4;
        this.minInclusive = f;
        this.minExclusive = f2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        float f = FloatDV.parse(xMLString);
        XFloat xFloat = new XFloat(f);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xFloat;
            validatedInfo.errorCode = 0;
        }
        return xFloat;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        float f = FloatDV.parse(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = ((XFloat)validatedInfo.actualValue).equals(f) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(f, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXFloat(f);
    }

    public int preCheckFacets(float f, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(f, xMLString);
        }
        return 0;
    }

    private int checkFacets(float f, XMLString xMLString) {
        if ((this.definedFacets & 0x100) != 0 && !(f >= this.minInclusive) && !(f != f & this.minInclusive != this.minInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && !(f > this.minExclusive)) {
            return 1;
        }
        if (!((this.definedFacets & 0x20) == 0 || f <= this.maxInclusive || f != f && this.maxInclusive != this.maxInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && !(f < this.maxExclusive)) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!XFloat.equals(this.enumeration[i], f)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static float parse(XMLString xMLString) {
        return FloatDV.parse(xMLString, dummyOneElementArray);
    }

    public static float parse(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0.0f;
        }
        if (xMLString.bytes != null) {
            return FloatDV.parseFloatUnbuffered(xMLString, nArray);
        }
        return FloatDV.parseFloatBuffered(xMLString, nArray);
    }

    private static float parseFloatBuffered(XMLString xMLString, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        if (by == 78) {
            while (true) {
                if (++n < n2) break;
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0.0f;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by = dataBuffer.bytes[n];
            if (by == 97) {
                while (true) {
                    if (++n < n2) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - 1;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by = dataBuffer.bytes[n];
                if (by == 78) {
                    while (true) {
                        if (++n < n2) {
                            by = dataBuffer.bytes[n];
                            break;
                        }
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    if (by <= 32) {
                        while (true) {
                            if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                                by = dataBuffer.bytes[n];
                                continue;
                            }
                            if (n != n2 || dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by = dataBuffer.bytes[n];
                        }
                    }
                    if (n < n2) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    return Float.NaN;
                }
            }
            nArray[0] = 1;
            return 0.0f;
        }
        boolean bl = false;
        if (by == 43 || by == 45 || by == 73) {
            boolean bl2 = bl = by == 45;
            if (bl || by == 43) {
                while (true) {
                    if (++n < n2) {
                        by = dataBuffer.bytes[n];
                        break;
                    }
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - 1;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
            }
            if (by == 73) {
                while (true) {
                    if (++n < n2) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - 1;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by = dataBuffer.bytes[n];
                if (by == 78) {
                    while (true) {
                        if (++n < n2) break;
                        if (dataBuffer == dataBuffer2) {
                            nArray[0] = 1;
                            return 0.0f;
                        }
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n];
                    if (by == 70) {
                        while (true) {
                            if (++n < n2) {
                                by = dataBuffer.bytes[n];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n = dataBuffer.startOffset - 1;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        if (by <= 32) {
                            while (true) {
                                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                                    by = dataBuffer.bytes[n];
                                    continue;
                                }
                                if (n != n2 || dataBuffer == dataBuffer2) break;
                                dataBuffer = dataBuffer.next;
                                n = dataBuffer.startOffset;
                                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                                by = dataBuffer.bytes[n];
                            }
                        }
                        if (n < n2) {
                            nArray[0] = 1;
                            return 0.0f;
                        }
                        return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
                    }
                }
                nArray[0] = 1;
                return 0.0f;
            }
        }
        StringBuilder stringBuilder = new StringBuilder((n2 - n) * 2);
        if (by >= 48 && by <= 57 || by == 46) {
            stringBuilder.append((char)by);
            while (true) {
                if (++n < n2) {
                    by = dataBuffer.bytes[n];
                    if ((by >= 48 && by <= 57 || by == 46 || by == 69 || by == 101 || by == 43 || by == 45) && by != 32 && by != 10 && by != 9 && by != 13) {
                        stringBuilder.append((char)by);
                        continue;
                    }
                    if (by == 32 || by == 10 || by == 9 || by == 13) break;
                    nArray[0] = 1;
                    return 0.0f;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                        by = dataBuffer.bytes[n];
                        continue;
                    }
                    if (n != n2 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = dataBuffer.bytes[n];
                }
            }
            if (n < n2) {
                nArray[0] = 1;
                return 0.0f;
            }
            try {
                float f = Float.parseFloat(stringBuilder.toString());
                return bl ? -f : f;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 1;
                return 0.0f;
            }
        }
        nArray[0] = 1;
        return 0.0f;
    }

    private static float parseFloatUnbuffered(XMLString xMLString, int[] nArray) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        byte by = xMLString.bytes[n];
        int n3 = n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2);
        if (by == 78 && n + 2 <= n2 && xMLString.bytes[++n] == 97 && xMLString.bytes[++n] == 78) {
            if (++n < n2 && (n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                nArray[0] = 1;
                return 0.0f;
            }
            return Float.NaN;
        }
        if (by == 73 && n + 2 <= n2 && xMLString.bytes[++n] == 78 && xMLString.bytes[++n] == 70) {
            if (++n < n2 && (n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                nArray[0] = 1;
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        if ((by == 45 || by == 43) && xMLString.bytes[n + 1] == 73 && ++n + 2 <= n2 && xMLString.bytes[++n] == 78 && xMLString.bytes[++n] == 70) {
            if (++n < n2 && (n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                nArray[0] = 1;
                return 0.0f;
            }
            return by == 45 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        while (n < n2) {
            by = xMLString.bytes[n];
            if ((by < 48 || by > 57) && by != 46 && by != 69 && by != 101 && by != 43 && by != 45 && by != 32 && by != 10 && by != 9 && by != 13) {
                nArray[0] = 1;
                return 0.0f;
            }
            if (by == 32 || by == 10 || by == 9 || by == 13) break;
            ++n;
        }
        int n4 = n;
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
            nArray[0] = 1;
            return 0.0f;
        }
        try {
            float f = Float.parseFloat(new String(xMLString.bytes, n3, n4 - n3, "UTF-8"));
            return f;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            nArray[0] = 1;
            return 0.0f;
        }
    }

    private int parseFloatUnbuffered(ParsedEntity parsedEntity, XFloat xFloat, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes == null ? parsedEntity.buffer.bytes : parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        if ((n = FloatDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        byte by = byArray[n];
        if (by == 78 && n + 2 < n2 && byArray[++n] == 97 && byArray[++n] == 78) {
            ++n;
            if ((n = FloatDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xFloat.value = Float.NaN;
            return n;
        }
        if (by == 73 && n + 2 < n2 && byArray[++n] == 78 && byArray[++n] == 70) {
            ++n;
            if ((n = FloatDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xFloat.value = Float.POSITIVE_INFINITY;
            return n;
        }
        if (by == 45 && n + 3 < n2 && byArray[n + 1] == 73 && byArray[n += 2] == 78 && byArray[++n] == 70) {
            ++n;
            if ((n = FloatDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xFloat.value = Float.NEGATIVE_INFINITY;
            return n;
        }
        int n3 = n;
        while ((by >= 48 && by <= 57 || by == 46 || by == 69 || by == 101 || by == 43 || by == 45) && ++n < n2) {
            by = byArray[n];
        }
        int n4 = n;
        if ((n = FloatDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        try {
            xFloat.value = Float.parseFloat(new String(byArray, n3, n4 - n3, "UTF-8"));
            return n;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XFloat xFloat = vMContext.dvContext.getXFloat(0.0f);
        int n = this.parseFloatUnbuffered(parsedEntity, xFloat, this.fNormalized);
        if (n == -1) {
            return null;
        }
        parsedEntity.offset = n;
        return xFloat;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets(((XFloat)object).value, xMLString);
    }
}

