/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.lang.ref.SoftReference;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class Pool {
    private static final int MAXIMUM_SIZE = 10;
    private final ReferencePool refPool;
    private final Poolable[] array = new Poolable[10];
    private int size = 0;

    public Pool() {
        this.refPool = new ReferencePool();
    }

    public synchronized Poolable get() {
        if (this.size == 0) {
            return this.refPool.get();
        }
        return this.array[--this.size];
    }

    public void assignToPool(Poolable poolable) {
        PoolableHelper poolableHelper = poolable.getPoolableHelper();
        poolableHelper.setPool(this);
    }

    private synchronized void put(Poolable poolable) {
        if (this.size == 10) {
            this.refPool.put(poolable);
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (poolable != this.array[i]) continue;
                throw new RuntimeException("Pool: Poolable " + poolable + " is already in the Pool");
            }
            this.array[this.size++] = poolable;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class ReferencePool {
        private SoftReference<Poolable>[] array = ArrayAllocator.newObjectArray(SoftReference.class, 8);
        private int size = 0;

        private ReferencePool() {
        }

        private Poolable get() {
            while (this.size > 0) {
                --this.size;
                Poolable poolable = this.array[this.size].get();
                this.array[this.size] = null;
                if (poolable != null) {
                    return poolable;
                }
                this.removeDeadReferences();
            }
            return null;
        }

        private void put(Poolable poolable) {
            for (int i = 0; i < this.size; ++i) {
                if (poolable != this.array[i].get()) continue;
                throw new RuntimeException("Pool: Poolable " + poolable + " is already in the Pool");
            }
            if (this.size == this.array.length) {
                this.array = ArrayAllocator.resizeObjectArray(SoftReference.class, this.array, this.size * 2);
            }
            this.array[this.size++] = new SoftReference<Poolable>(poolable);
        }

        private void removeDeadReferences() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.size) {
                while (n2 < this.size && this.array[n2].get() == null) {
                    this.array[n2] = null;
                    ++n2;
                }
                while (n2 < this.size && this.array[n2].get() != null) {
                    this.array[n] = this.array[n2];
                    if (n2 != n) {
                        this.array[n2] = null;
                    }
                    ++n;
                    ++n2;
                }
            }
            this.size = n;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class PoolableHelper {
        private Pool fPool;
        private Poolable fPooledObj;

        public PoolableHelper(Poolable poolable) {
            this.fPooledObj = poolable;
        }

        public void returnToPool() {
            this.fPool.put(this.fPooledObj);
        }

        public void setPool(Pool pool) {
            this.fPool = pool;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static interface Poolable {
        public PoolableHelper getPoolableHelper();
    }
}

