/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax.serializer;

import com.ibm.xml.xlxp2.api.stax.serializer.Encoding;
import com.ibm.xml.xlxp2.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp2.api.util.Pool;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UTF8Writer
extends StAXWriter {
    private static final Pool fPool = new Pool();

    public static final UTF8Writer getInstance() {
        UTF8Writer uTF8Writer = (UTF8Writer)fPool.get();
        if (uTF8Writer == null) {
            uTF8Writer = new UTF8Writer();
            fPool.assignToPool(uTF8Writer);
        }
        return uTF8Writer;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 * 3 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n, n2);
        } else {
            this.write0(cArray, n, n2);
        }
    }

    private void write0(char[] cArray, int n, int n2) throws IOException {
        this.flushInternal();
        int n3 = n + n2;
        while (n + this.fBuffer.length / 3 < n3) {
            char c = cArray[n + this.fBuffer.length / 3 - 1];
            if (c >= '\ud800' && c <= '\udbff') {
                this.encodeAndWrite(cArray, n, this.fBuffer.length / 3 - 1);
                n += this.fBuffer.length / 3 - 1;
            } else {
                this.encodeAndWrite(cArray, n, this.fBuffer.length / 3);
                n += this.fBuffer.length / 3;
            }
            this.flushInternal();
        }
        this.encodeAndWrite(cArray, n, n3 - n);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 * 3 < this.fBuffer.length) {
            this.encodeAndWrite(string, n, n2);
        } else {
            this.write0(string, n, n2);
        }
    }

    private void write0(String string, int n, int n2) throws IOException {
        this.flushInternal();
        int n3 = n + n2;
        while (n + this.fBuffer.length / 3 < n3) {
            char c = string.charAt(n + this.fBuffer.length / 3 - 1);
            if (c >= '\ud800' && c <= '\udbff') {
                this.encodeAndWrite(string, n, this.fBuffer.length / 3 - 1);
                n += this.fBuffer.length / 3 - 1;
            } else {
                this.encodeAndWrite(string, n, this.fBuffer.length / 3);
                n += this.fBuffer.length / 3;
            }
            this.flushInternal();
        }
        this.encodeAndWrite(string, n, n3 - n);
    }

    public void write(int n) throws IOException {
        if (this.fNumBytes + 3 >= this.fBuffer.length) {
            this.flushInternal();
        }
        if (n <= 127) {
            this.fBuffer[this.fNumBytes++] = (byte)n;
        } else if (n >= 128 && n <= 2047) {
            this.fBuffer[this.fNumBytes++] = (byte)(192 + (n >> 6));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n & 0x3F));
        } else {
            this.fBuffer[this.fNumBytes++] = (byte)(224 + (n >> 12));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n >> 6 & 0x3F));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n & 0x3F));
        }
    }

    private void encodeAndWrite(char[] cArray, int n, int n2) throws IOException {
        char c;
        int n3;
        int n4 = n + n2;
        int n5 = this.fNumBytes;
        for (n3 = n; n3 < n4 && (c = cArray[n3]) <= '\u007f'; ++n3) {
            this.fBuffer[n5++] = (byte)c;
        }
        if (n3 == n4) {
            this.fNumBytes = n5;
        } else {
            this.encodeAndWrite0(cArray, n3, n4, n5);
        }
    }

    private void encodeAndWrite0(char[] cArray, int n, int n2, int n3) throws IOException {
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c <= '\u007f') {
                this.fBuffer[n3++] = (byte)c;
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff') {
                this.fBuffer[n3++] = (byte)(192 + (c >> 6));
                this.fBuffer[n3++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                char c2 = cArray[++i];
                int n4 = Encoding.toCodePoint(c, c2);
                this.fBuffer[n3++] = (byte)(240 + (n4 >> 18 & 0x1F));
                this.fBuffer[n3++] = (byte)(128 + (n4 >> 12 & 0x3F));
                this.fBuffer[n3++] = (byte)(128 + (n4 >> 6 & 0x3F));
                this.fBuffer[n3++] = (byte)(128 + (n4 & 0x3F));
                continue;
            }
            this.fBuffer[n3++] = (byte)(224 + (c >> 12));
            this.fBuffer[n3++] = (byte)(128 + (c >> 6 & 0x3F));
            this.fBuffer[n3++] = (byte)(128 + (c & 0x3F));
        }
        this.fNumBytes = n3;
    }

    private void encodeAndWrite(String string, int n, int n2) throws IOException {
        char c;
        int n3;
        int n4 = n + n2;
        int n5 = this.fNumBytes;
        for (n3 = n; n3 < n4 && (c = string.charAt(n3)) <= '\u007f'; ++n3) {
            this.fBuffer[n5++] = (byte)c;
        }
        if (n3 == n4) {
            this.fNumBytes = n5;
        } else {
            this.encodeAndWrite0(string, n3, n4, n5);
        }
    }

    private void encodeAndWrite0(String string, int n, int n2, int n3) throws IOException {
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                this.fBuffer[n3++] = (byte)c;
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff') {
                this.fBuffer[n3++] = (byte)(192 + (c >> 6));
                this.fBuffer[n3++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                char c2 = string.charAt(++i);
                int n4 = Encoding.toCodePoint(c, c2);
                this.fBuffer[n3++] = (byte)(240 + (n4 >> 18 & 0x1F));
                this.fBuffer[n3++] = (byte)(128 + (n4 >> 12 & 0x3F));
                this.fBuffer[n3++] = (byte)(128 + (n4 >> 6 & 0x3F));
                this.fBuffer[n3++] = (byte)(128 + (n4 & 0x3F));
                continue;
            }
            this.fBuffer[n3++] = (byte)(224 + (c >> 12));
            this.fBuffer[n3++] = (byte)(128 + (c >> 6 & 0x3F));
            this.fBuffer[n3++] = (byte)(128 + (c & 0x3F));
        }
        this.fNumBytes = n3;
    }

    public static void release(UTF8Writer uTF8Writer) {
        uTF8Writer.reset(null);
        uTF8Writer.release();
    }
}

