/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.stax.XMLStreamWriterBase;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.api.stax.serializer.Encoding;
import com.ibm.xml.xlxp2.api.stax.serializer.SingleByteWriter;
import com.ibm.xml.xlxp2.api.stax.serializer.UTF8Writer;
import com.ibm.xml.xlxp2.api.stax.serializer.Windows125XWriter;
import com.ibm.xml.xlxp2.api.util.encoding.IANACharset;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLStreamWriterImpl
extends XMLStreamWriterBase {
    private static final byte[] CHARACTERS_CHAR_MAP = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 1, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] ATTRIBUTE_CHAR_MAP = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 9, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] CHARACTERS_CHAR_MAP_ASCII = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 1, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private static final byte[] ATTRIBUTE_CHAR_MAP_ASCII = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 9, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private static final byte[] CHARACTERS_CHAR_MAP_UNKNOWN = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 1, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] ATTRIBUTE_CHAR_MAP_UNKNOWN = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 9, 8, 8, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final char[] OPEN_END_TAG = new char[]{'<', '/'};
    private static final char[] CLOSE_EMPTY_ELEMENT_TAG = new char[]{'/', '>'};
    private static final char[] COMMENT_START = new char[]{'<', '!', '-', '-'};
    private static final char[] COMMENT_END = new char[]{'-', '-', '>'};
    private static final char[] PROCESSING_INSTRUCTION_START = new char[]{'<', '?'};
    private static final char[] PROCESSING_INSTRUCTION_END = new char[]{'?', '>'};
    private static final char[] CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATA_END = new char[]{']', ']', '>'};
    private static final char[] HEX_CHAR_REF_START = new char[]{'&', '#', 'x'};
    private static final char[] XMLNS_EQUALS_QUOTE = new char[]{' ', 'x', 'm', 'l', 'n', 's', '=', '\"'};
    private static final char[] XMLNS_COLON = new char[]{' ', 'x', 'm', 'l', 'n', 's', ':'};
    private static final char[] EQUALS_QUOTE = new char[]{'=', '\"'};
    private static final char[] NEWLINE = new char[]{'&', '#', 'x', 'A', ';'};
    private static final char[] LESS_THAN = new char[]{'&', 'l', 't', ';'};
    private static final char[] GREATER_THAN = new char[]{'&', 'g', 't', ';'};
    private static final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};
    private static final char[] CARRIAGE_RETURN = new char[]{'&', '#', 'x', 'D', ';'};
    private static final char[] AMPERSAND = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] LSEP = new char[]{'&', '#', 'x', '2', '0', '2', '8', ';'};
    private static final String SYSTEM_LINE_SEPARATOR;
    private UTF8Writer fDefaultWriter;
    private Writer fWriter;
    private OutputStream fStream;
    private boolean fIsXML11;
    private String[] fCharsetName = ArrayAllocator.newStringArray(1);
    private boolean fIsExternalWriter;
    private Encoding fEncoding;
    private boolean fEncodingSet;
    private String fJavaEncodingString;
    private int fIANAEncoding;
    private String[] fElementNameStack = ArrayAllocator.newStringArray(32);
    private int fNumElements;
    private boolean fIsDocument;
    private byte[] fCharactersCharMap;
    private byte[] fAttributeCharMap;

    public XMLStreamWriterImpl(boolean bl) throws IOException, XMLStreamException {
        this.reset(bl);
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        this.fIsXML11 = false;
        this.fEncodingSet = false;
        this.fEncoding = null;
        this.fNumElements = 0;
        this.fIsDocument = false;
    }

    public void setWriter(Writer writer, boolean bl) throws XMLStreamException {
        this.reset(bl);
        this.fWriter = writer;
        this.fIsExternalWriter = true;
        this.setDefaultEncoding();
        this.fCharactersCharMap = CHARACTERS_CHAR_MAP_UNKNOWN;
        this.fAttributeCharMap = ATTRIBUTE_CHAR_MAP_UNKNOWN;
    }

    public void setOutputStream(OutputStream outputStream, boolean bl) throws XMLStreamException {
        this.reset(bl);
        this.fStream = outputStream;
        this.setDefaultEncoding();
        this.setDefaultWriter();
    }

    public void setOutputStream(OutputStream outputStream, String string, boolean bl) throws XMLStreamException {
        this.reset(bl);
        this.fStream = outputStream;
        this.setEncoding(string);
        this.fEncodingSet = true;
        this.setWriter();
    }

    private void setWriter() throws XMLStreamException {
        this.fIsExternalWriter = false;
        if (this.fDefaultWriter != null) {
            UTF8Writer.release(this.fDefaultWriter);
            this.fDefaultWriter = null;
        }
        switch (this.fIANAEncoding) {
            case 0: {
                this.fCharactersCharMap = CHARACTERS_CHAR_MAP;
                this.fAttributeCharMap = ATTRIBUTE_CHAR_MAP;
                UTF8Writer uTF8Writer = UTF8Writer.getInstance();
                uTF8Writer.reset(this.fStream);
                this.fWriter = uTF8Writer;
                break;
            }
            case 2: {
                this.fCharactersCharMap = CHARACTERS_CHAR_MAP;
                this.fAttributeCharMap = ATTRIBUTE_CHAR_MAP;
                SingleByteWriter singleByteWriter = SingleByteWriter.getInstance();
                singleByteWriter.reset(this.fStream);
                this.fWriter = singleByteWriter;
                break;
            }
            case 1: {
                this.fCharactersCharMap = CHARACTERS_CHAR_MAP_ASCII;
                this.fAttributeCharMap = ATTRIBUTE_CHAR_MAP_ASCII;
                SingleByteWriter singleByteWriter = SingleByteWriter.getInstance();
                singleByteWriter.reset(this.fStream);
                this.fWriter = singleByteWriter;
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.fCharactersCharMap = CHARACTERS_CHAR_MAP_UNKNOWN;
                this.fAttributeCharMap = ATTRIBUTE_CHAR_MAP_UNKNOWN;
                Windows125XWriter windows125XWriter = Windows125XWriter.getInstance();
                windows125XWriter.reset(this.fIANAEncoding, this.fStream);
                this.fWriter = windows125XWriter;
                break;
            }
            default: {
                this.fCharactersCharMap = CHARACTERS_CHAR_MAP_UNKNOWN;
                this.fAttributeCharMap = ATTRIBUTE_CHAR_MAP_UNKNOWN;
                try {
                    this.fWriter = new OutputStreamWriter(this.fStream, this.fJavaEncodingString);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    StAXMessageProvider.throwXMLStreamException(unsupportedEncodingException);
                }
            }
        }
    }

    private void setDefaultEncoding() {
        this.fIANAEncoding = 0;
        this.fJavaEncodingString = "UTF8";
        this.fEncoding = Encoding.getUTF8Encoding();
    }

    private void setDefaultWriter() {
        this.fCharactersCharMap = CHARACTERS_CHAR_MAP;
        this.fAttributeCharMap = ATTRIBUTE_CHAR_MAP;
        this.fDefaultWriter = UTF8Writer.getInstance();
        this.fDefaultWriter.reset(this.fStream);
        this.fWriter = this.fDefaultWriter;
        this.fIsExternalWriter = false;
    }

    private void setEncoding(String string) throws XMLStreamException {
        try {
            this.fCharsetName[0] = string;
            this.fIANAEncoding = IANACharset.getCharsetType(this.fCharsetName);
            this.fJavaEncodingString = this.fCharsetName[0];
            this.fEncoding = Encoding.getEncoding(this.fIANAEncoding, this.fJavaEncodingString);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StAXMessageProvider.throwXMLStreamException(unsupportedEncodingException);
        }
    }

    private void setVersion(String string) {
        if ("1.1".equals(string)) {
            this.fIsXML11 = true;
        }
    }

    public void writeAsEncodedUnicode(XMLEvent xMLEvent) throws XMLStreamException {
        xMLEvent.writeAsEncodedUnicode(this.fWriter);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("UTF-8", "1.0");
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.fIsDocument = true;
        if (string == null) {
            string = "1.0";
        }
        this.setVersion(string);
        try {
            this.fWriter.write("<?xml version=\"");
            this.fWriter.write(string);
            this.fWriter.write("\"?>");
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.fIsDocument = true;
        if (string2 == null) {
            string2 = "1.0";
        }
        if (string == null) {
            string = "UTF-8";
        } else if (!this.fEncodingSet) {
            this.fEncodingSet = true;
            this.setEncoding(string);
            if (this.fStream != null) {
                this.setWriter();
            }
        }
        this.setVersion(string2);
        try {
            this.fWriter.write("<?xml version=\"");
            this.fWriter.write(string2);
            this.fWriter.write("\" encoding=\"");
            this.fWriter.write(string);
            this.fWriter.write("\"?>");
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    protected void handleStartElement(String string, String string2, String string3) throws XMLStreamException {
        try {
            this.fWriter.write(60);
            if (string != "") {
                this.fWriter.write(string);
                this.fWriter.write(58);
            }
            this.fWriter.write(string2);
            if (!this.fIsEmptyState) {
                int n = this.fNumElements * 2;
                if (n == this.fElementNameStack.length) {
                    this.fElementNameStack = ArrayAllocator.resizeStringArray(this.fElementNameStack, n << 1);
                }
                this.fElementNameStack[n] = string;
                this.fElementNameStack[n + 1] = string2;
                ++this.fNumElements;
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    protected void finishStartElement() throws XMLStreamException {
        try {
            if (this.fIsEmptyState) {
                this.fWriter.write(CLOSE_EMPTY_ELEMENT_TAG, 0, CLOSE_EMPTY_ELEMENT_TAG.length);
            } else {
                this.fWriter.write(62);
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    protected void handleAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        try {
            this.fWriter.write(32);
            if (string != "") {
                this.fWriter.write(string);
                this.fWriter.write(58);
            }
            this.fWriter.write(string3);
            this.fWriter.write(EQUALS_QUOTE, 0, EQUALS_QUOTE.length);
            if (string4 != null) {
                this.escapeAndWrite(string4, this.fAttributeCharMap);
            }
            this.fWriter.write(34);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    protected void handleNamespace(String string, String string2) throws XMLStreamException {
        try {
            if (string == "") {
                this.fWriter.write(XMLNS_EQUALS_QUOTE, 0, XMLNS_EQUALS_QUOTE.length);
            } else {
                this.fWriter.write(XMLNS_COLON, 0, XMLNS_COLON.length);
                this.fWriter.write(string);
                this.fWriter.write(EQUALS_QUOTE, 0, EQUALS_QUOTE.length);
            }
            this.escapeAndWrite(string2, this.fAttributeCharMap);
            this.fWriter.write(34);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    protected final boolean atRootContext() {
        return this.fNumElements == 0;
    }

    protected void handleEndElement() throws XMLStreamException {
        if (!this.fIsEmptyState) {
            if (this.atRootContext()) {
                StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 39));
            }
            String string = this.fElementNameStack[2 * this.fNumElements - 2];
            String string2 = this.fElementNameStack[2 * this.fNumElements - 1];
            --this.fNumElements;
            try {
                this.fWriter.write(OPEN_END_TAG, 0, OPEN_END_TAG.length);
                if (string != "") {
                    this.fWriter.write(string);
                    this.fWriter.write(58);
                }
                this.fWriter.write(string2);
                this.fWriter.write(62);
            }
            catch (IOException iOException) {
                StAXMessageProvider.throwXMLStreamException(iOException);
            }
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        super.writeEndDocument();
        try {
            this.fWriter.flush();
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void close() throws XMLStreamException {
        super.close();
        try {
            this.fWriter.flush();
            if (!this.fIsExternalWriter) {
                this.fWriter.close();
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
        this.fWriter = null;
        this.fDefaultWriter = null;
        this.fStream = null;
        this.fPoolableHelper.returnToPool();
    }

    public void writeComment(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            this.fWriter.write(COMMENT_START, 0, COMMENT_START.length);
            this.fWriter.write(string);
            this.fWriter.write(COMMENT_END, 0, COMMENT_END.length);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 49));
        }
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 50));
        }
        try {
            this.fWriter.write(PROCESSING_INSTRUCTION_START, 0, PROCESSING_INSTRUCTION_START.length);
            this.fWriter.write(string);
            if (string2 != null) {
                this.fWriter.write(32);
                this.fWriter.write(string2);
            }
            this.fWriter.write(PROCESSING_INSTRUCTION_END, 0, PROCESSING_INSTRUCTION_END.length);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeCData(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 48));
        }
        try {
            this.fWriter.write(CDATA_START, 0, CDATA_START.length);
            this.fWriter.write(string);
            this.fWriter.write(CDATA_END, 0, CDATA_END.length);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeDTD(String string) throws XMLStreamException {
        try {
            this.fWriter.write(string);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            this.fWriter.write(38);
            this.fWriter.write(string);
            this.fWriter.write(59);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            if (string != null) {
                this.escapeAndWrite(string, this.fCharactersCharMap);
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            this.escapeAndWrite(cArray, n, n2, this.fCharactersCharMap);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void flush() throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            this.fWriter.flush();
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    private void escapeAndWrite(String string, byte[] byArray) throws XMLStreamException, IOException {
        char c;
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && (c = string.charAt(n)) < byArray.length && byArray[c] == 0; ++n) {
        }
        if (n == n2) {
            this.fWriter.write(string, 0, n2);
        } else {
            this.escapeAndWrite(string, n, n2, byArray);
        }
    }

    private void escapeAndWrite(String string, int n, int n2, byte[] byArray) throws XMLStreamException, IOException {
        int n3 = 0;
        block15: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < byArray.length) {
                block0 : switch (byArray[c]) {
                    case 0: {
                        ++i;
                        while (i < n2) {
                            c = string.charAt(i);
                            if (c >= byArray.length || byArray[c] != 0) {
                                --i;
                                break block0;
                            }
                            ++i;
                        }
                        continue block15;
                    }
                    case 1: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(SYSTEM_LINE_SEPARATOR);
                        n3 = i + 1;
                        break;
                    }
                    case 2: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(TAB, 0, TAB.length);
                        n3 = i + 1;
                        break;
                    }
                    case 3: {
                        if (this.fIsDocument && this.atRootContext()) continue block15;
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(CARRIAGE_RETURN, 0, CARRIAGE_RETURN.length);
                        n3 = i + 1;
                        break;
                    }
                    case 4: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(LESS_THAN, 0, LESS_THAN.length);
                        n3 = i + 1;
                        break;
                    }
                    case 5: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(GREATER_THAN, 0, GREATER_THAN.length);
                        n3 = i + 1;
                        break;
                    }
                    case 6: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(AMPERSAND, 0, AMPERSAND.length);
                        n3 = i + 1;
                        break;
                    }
                    case 7: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(QUOTE, 0, QUOTE.length);
                        n3 = i + 1;
                        break;
                    }
                    case 8: {
                        if (!this.fIsXML11) continue block15;
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n3 = i + 1;
                        break;
                    }
                    case 9: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(NEWLINE, 0, NEWLINE.length);
                        n3 = i + 1;
                        break;
                    }
                    case 10: {
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n3 = i + 1;
                        break;
                    }
                    case -1: {
                        if (this.fEncoding.isEncodable(c)) continue block15;
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n3 = i + 1;
                        break;
                    }
                    case -2: {
                        if (!this.fIsXML11 && this.fEncoding.isEncodable(c)) continue block15;
                        this.fWriter.write(string, n3, i - n3);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n3 = i + 1;
                        break;
                    }
                }
                continue;
            }
            if (!(c != '\u2028' || !this.fIsXML11 || this.fIsDocument && this.atRootContext())) {
                this.fWriter.write(string, n3, i - n3);
                this.fWriter.write(LSEP, 0, LSEP.length);
                n3 = i + 1;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i < n2 - 1) {
                    char c2;
                    if (this.fEncoding.isEncodable(c, c2 = string.charAt(++i))) continue;
                    this.fWriter.write(string, n3, i - n3 - 1);
                    this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                    this.fWriter.write(Integer.toHexString(Encoding.toCodePoint(c, c2)));
                    this.fWriter.write(59);
                    n3 = i + 1;
                    continue;
                }
                StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 52, Integer.toHexString(c)));
                continue;
            }
            if (this.fEncoding.isEncodable(c)) continue;
            this.fWriter.write(string, n3, i - n3);
            this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
            this.fWriter.write(Integer.toHexString(c));
            this.fWriter.write(59);
            n3 = i + 1;
        }
        this.fWriter.write(string, n3, n2 - n3);
    }

    private void escapeAndWrite(char[] cArray, int n, int n2, byte[] byArray) throws XMLStreamException, IOException {
        char c;
        int n3;
        int n4 = n + n2;
        for (n3 = n; n3 < n4 && (c = cArray[n3]) < byArray.length && byArray[c] == 0; ++n3) {
        }
        if (n3 == n4) {
            this.fWriter.write(cArray, n, n2);
        } else {
            this.escapeAndWrite(cArray, n, n3, n4, byArray);
        }
    }

    private void escapeAndWrite(char[] cArray, int n, int n2, int n3, byte[] byArray) throws XMLStreamException, IOException {
        int n4 = n;
        block15: for (int i = n2; i < n3; ++i) {
            char c = cArray[i];
            if (c < byArray.length) {
                block0 : switch (byArray[c]) {
                    case 0: {
                        ++i;
                        while (i < n3) {
                            c = cArray[i];
                            if (c >= byArray.length || byArray[c] != 0) {
                                --i;
                                break block0;
                            }
                            ++i;
                        }
                        continue block15;
                    }
                    case 1: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(SYSTEM_LINE_SEPARATOR);
                        n4 = i + 1;
                        break;
                    }
                    case 2: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(TAB, 0, TAB.length);
                        n4 = i + 1;
                        break;
                    }
                    case 3: {
                        if (this.fIsDocument && this.atRootContext()) continue block15;
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(CARRIAGE_RETURN, 0, CARRIAGE_RETURN.length);
                        n4 = i + 1;
                        break;
                    }
                    case 4: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(LESS_THAN, 0, LESS_THAN.length);
                        n4 = i + 1;
                        break;
                    }
                    case 5: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(GREATER_THAN, 0, GREATER_THAN.length);
                        n4 = i + 1;
                        break;
                    }
                    case 6: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(AMPERSAND, 0, AMPERSAND.length);
                        n4 = i + 1;
                        break;
                    }
                    case 7: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(QUOTE, 0, QUOTE.length);
                        n4 = i + 1;
                        break;
                    }
                    case 8: {
                        if (!this.fIsXML11) continue block15;
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n4 = i + 1;
                        break;
                    }
                    case 9: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(NEWLINE, 0, NEWLINE.length);
                        n4 = i + 1;
                        break;
                    }
                    case 10: {
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n4 = i + 1;
                        break;
                    }
                    case -1: {
                        if (this.fEncoding.isEncodable(c)) continue block15;
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n4 = i + 1;
                        break;
                    }
                    case -2: {
                        if (!this.fIsXML11 && this.fEncoding.isEncodable(c)) continue block15;
                        this.fWriter.write(cArray, n4, i - n4);
                        this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                        this.fWriter.write(Integer.toHexString(c));
                        this.fWriter.write(59);
                        n4 = i + 1;
                        break;
                    }
                }
                continue;
            }
            if (!(c != '\u2028' || !this.fIsXML11 || this.fIsDocument && this.atRootContext())) {
                this.fWriter.write(cArray, n4, i - n4);
                this.fWriter.write(LSEP, 0, LSEP.length);
                n4 = i + 1;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i < n3 - 1) {
                    char c2;
                    if (this.fEncoding.isEncodable(c, c2 = cArray[++i])) continue;
                    this.fWriter.write(cArray, n4, i - n4 - 1);
                    this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
                    this.fWriter.write(Integer.toHexString(Encoding.toCodePoint(c, c2)));
                    this.fWriter.write(59);
                    n4 = i + 1;
                    continue;
                }
                StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 52, Integer.toHexString(c)));
                continue;
            }
            if (this.fEncoding.isEncodable(c)) continue;
            this.fWriter.write(cArray, n4, i - n4);
            this.fWriter.write(HEX_CHAR_REF_START, 0, HEX_CHAR_REF_START.length);
            this.fWriter.write(Integer.toHexString(c));
            this.fWriter.write(59);
            n4 = i + 1;
        }
        this.fWriter.write(cArray, n4, n3 - n4);
    }

    static {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty("line.separator");
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
        });
        SYSTEM_LINE_SEPARATOR = string != null && (string.equals("\r\n") || string.equals("\r")) ? string : "\n";
    }
}

