/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp2.api.stax.StAXDTDScanner;
import com.ibm.xml.xlxp2.api.stax.StAXImplProperties;
import com.ibm.xml.xlxp2.api.stax.StAXReaderToWriter;
import com.ibm.xml.xlxp2.api.stax.XMLStreamExceptionWrapper;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp2.api.util.Pool;
import com.ibm.xml.xlxp2.api.util.SimplePositionHelper;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DTDSupport;
import com.ibm.xml.xlxp2.scan.DocumentScanner;
import com.ibm.xml.xlxp2.scan.msg.MessageProvider;
import com.ibm.xml.xlxp2.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DocumentPosition;
import com.ibm.xml.xlxp2.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.PositionHelper;
import com.ibm.xml.xlxp2.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.SymbolMapHolder;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLStreamReaderImpl
extends VMContext
implements XMLStreamReader,
EntityResolver,
Pool.Poolable {
    protected static final int NO_EVENT = -1;
    protected static final SymbolMapHolder fgSymbolMapHolder = new SymbolMapHolder();
    protected final Pool.PoolableHelper fPoolableHelper = new Pool.PoolableHelper(this);
    protected StAXReaderToWriter fReaderToWriter;
    protected StAXImplProperties fProperties;
    protected final DTDSupportProxy fDTDSupportProxy;
    protected StAXDTDScanner fDTDScanner;
    protected final SAX2ParsedEntityFactory fEntityFactory;
    protected int fEventType;
    protected int fNextEventType;
    protected final String[] fActualEncoding;
    protected boolean fUserSpecifiedEncoding;
    protected final char[][] fCharacters = ArrayAllocator.newCharArray2(1);
    protected final int[] fCharactersOffset;
    protected int fCharactersLength;
    protected Location fLocation;
    protected StAXNamespaceContext fStAXNamespaceContext;
    protected String fPublicId;
    protected String fSystemId;
    protected final char[] fSurrogatePair;
    protected boolean fHasCoalescedContent;
    protected XMLString fCoalescedContent;
    protected int fCoalescedContentOffset;
    protected int fCoalescedEventType;
    protected boolean fIsSingleCharacter;
    protected boolean fIsLeafElement;
    private PositionHelper fPositionHelper;
    private DocumentPosition fDocumentPosition;

    public XMLStreamReaderImpl(InputSource inputSource, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        this(inputSource, stAXImplProperties, false, true, false, true, true);
    }

    public XMLStreamReaderImpl(InputSource inputSource, StAXImplProperties stAXImplProperties, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws XMLStreamException {
        super(new SimpleDataBufferFactory(), new SymbolTable(fgSymbolMapHolder), bl, bl2, bl3, bl4, bl5);
        this.fCharacters[0] = ArrayAllocator.newCharArray(1024);
        this.fCharactersOffset = ArrayAllocator.newIntArray(1);
        this.fSurrogatePair = ArrayAllocator.newCharArray(2);
        this.fActualEncoding = ArrayAllocator.newStringArray(1);
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.fDTDSupportProxy = new DTDSupportProxy(this);
        this.setDTDSupport(this.fDTDSupportProxy);
        this.fCoalescedContent = new XMLString();
        this.setDocumentEntity(inputSource, stAXImplProperties);
    }

    public void reset(boolean bl) {
        if (this.fDTDScanner != null) {
            this.fDTDScanner.reset(true);
        } else if (this.fCurrentEntity != null) {
            this.fCurrentEntity.release();
            this.fCurrentEntity = null;
        }
        this.fCoalescedContent.clear();
        this.fEntityFactory.reset(true);
        super.reset(bl);
        this.fSymbolTable.reset(true);
        this.fBufferFactory.reset(bl);
    }

    public void setDocumentEntity(InputSource inputSource, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        if (stAXImplProperties != this.fProperties) {
            this.fProperties = stAXImplProperties;
            this.setNamespaceAwareness(this.fProperties.isNamespaceAware);
            this.fDTDSupportProxy.setDTDProperties(this.fProperties);
            if (this.fProperties.resolver != null) {
                this.fEntityFactory.setEntityResolver(this);
            } else {
                this.fEntityFactory.setEntityResolver(null);
            }
            this.fEntityFactory.setCoordinatesAware(this.fProperties.isSupportingLocationCoordinates);
        }
        this.fActualEncoding[0] = null;
        ParsedEntity parsedEntity = null;
        try {
            parsedEntity = this.fEntityFactory.createParsedEntity(inputSource, this.fActualEncoding);
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            StAXMessageProvider.throwXMLStreamException(iOExceptionWrapper.getIOException());
        }
        if (parsedEntity.error != null) {
            if (parsedEntity.error.exception != null) {
                StAXMessageProvider.throwXMLStreamException(parsedEntity.error.exception);
            } else {
                StAXMessageProvider.throwXMLStreamException(parsedEntity.error.formatErrorMessage(), this.getLocation());
            }
        }
        this.fUserSpecifiedEncoding = inputSource.getEncoding() != null || inputSource.getCharacterStream() != null;
        this.fPublicId = inputSource.getPublicId();
        this.fSystemId = inputSource.getSystemId();
        this.fHasCoalescedContent = false;
        this.fCoalescedContent.clear();
        this.fIsSingleCharacter = false;
        this.fIsLeafElement = false;
        this.fEventType = -1;
        this.encName.length = 0;
        this.version.length = 0;
        this.setDocumentEntity(parsedEntity);
        this.next();
    }

    public Pool.PoolableHelper getPoolableHelper() {
        return this.fPoolableHelper;
    }

    public InputSource resolveEntity(String string, String string2) {
        try {
            Object object = this.fProperties.resolver.resolveEntity(string, string2, null, null);
            if (object == null) {
                return null;
            }
            if (object instanceof InputStream) {
                return new InputSource((InputStream)object);
            }
            if (object instanceof XMLStreamReader) {
                if (this.fReaderToWriter == null) {
                    this.fReaderToWriter = new StAXReaderToWriter();
                }
                return this.fReaderToWriter.toInputSource((XMLStreamReader)object);
            }
            if (object instanceof XMLEventReader) {
                if (this.fReaderToWriter == null) {
                    this.fReaderToWriter = new StAXReaderToWriter();
                }
                return this.fReaderToWriter.toInputSource((XMLEventReader)object);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StAXMessageProvider.throwXMLStreamExceptionWrapper(xMLStreamException);
        }
        return null;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.equals("javax.xml.stream.isInterning")) {
                return Boolean.TRUE;
            }
            if (this.fEventType == 11) {
                if (string.equals("javax.xml.stream.notations")) {
                    return this.fDTDScanner.getNotationDecls();
                }
                if (string.equals("javax.xml.stream.entities")) {
                    return this.fDTDScanner.getEntityDecls();
                }
                if (string.equals("javax.xml.stream.dtd.processingInstructions")) {
                    return this.fDTDScanner.getPIsInDTD();
                }
                if (string.equals("javax.xml.stream.dtd.comments")) {
                    return this.fDTDScanner.getCommentsInDTD();
                }
                if (string.equals("javax.xml.stream.dtd.declaration")) {
                    XMLString xMLString = this.doctypeText();
                    return xMLString != null ? xMLString.toString() : null;
                }
                return null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 9));
        return null;
    }

    boolean isPropertySupported(String string) {
        if (string.equals("javax.xml.stream.isInterning")) {
            return true;
        }
        if (this.fEventType == 11) {
            return string.equals("javax.xml.stream.dtd.declaration") || string.equals("javax.xml.stream.notations") || string.equals("javax.xml.stream.entities") || string.equals("javax.xml.stream.dtd.processingInstructions") || string.equals("javax.xml.stream.dtd.comments");
        }
        return false;
    }

    public int next() throws XMLStreamException {
        if (this.fEventType == 8) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
        }
        try {
            if (this.fHasCoalescedContent) {
                this.fHasCoalescedContent = false;
                this.setCurrentEvent(this.fNextEventType);
            } else if (this.fIsLeafElement) {
                if (this.fEventType == 1 && this.elementValue != null) {
                    this.setCurrentEvent(4);
                } else {
                    this.fIsLeafElement = false;
                    this.setCurrentEvent(2);
                }
            } else {
                this.fEventType = -1;
                do {
                    this.nextEvent();
                } while (this.fEventType == -1);
                if (this.fHasCoalescedContent) {
                    this.fNextEventType = this.fEventType;
                    if (this.fCoalescedContentOffset != -1) {
                        this.fStringBuffer.setStringValues(this.fCoalescedContentOffset, this.fStringBuffer.getOffset(), this.fCoalescedContent);
                    }
                    this.setCurrentEvent(this.fCoalescedEventType);
                }
            }
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            StAXMessageProvider.throwXMLStreamException(iOExceptionWrapper.getIOException());
        }
        catch (XMLStreamExceptionWrapper xMLStreamExceptionWrapper) {
            throw xMLStreamExceptionWrapper.getXMLStreamException();
        }
        this.fCharactersLength = -1;
        return this.fEventType;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.fEventType == n) {
            if (string != null) {
                if (this.hasName()) {
                    if (string.length() == 0) {
                        if (this.getNamespaceURI() != null) {
                            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                        }
                    } else if (!string.equals(this.getNamespaceURI())) {
                        StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                    }
                } else {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                }
            }
            if (string2 != null) {
                if (this.hasName() || this.fEventType == 9) {
                    if (!string2.equals(this.getLocalName())) {
                        StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string2, this.getLocalName()));
                    }
                } else {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string2, ""));
                }
            }
        } else {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 11, n, this.fEventType));
        }
    }

    public String getElementText() throws XMLStreamException {
        if (!this.isStartElement()) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = this.next()) == 4 || n == 12 || n == 6 || n == 9) {
                stringBuilder.append(this.getText());
                continue;
            }
            if (n != 5 && n != 3) break;
        }
        if (!this.isEndElement()) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 15));
        }
        return stringBuilder.toString();
    }

    public int nextTag() throws XMLStreamException {
        int n;
        while ((n = this.next()) != 1 && n != 2) {
            if (n == 5 || n == 3 || n == 6 || n == 4 && this.isWhiteSpace()) continue;
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 16));
        }
        return n;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    public void close() throws XMLStreamException {
        this.reset(true);
        this.fSymbolTable.updateSymbolMapHolder();
        this.fPoolableHelper.returnToPool();
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
        }
        if (!string.equals("xmlns")) {
            return this.prefixMapping(this.fSymbolTable.addSymbol(string));
        }
        return "http://www.w3.org/2000/xmlns/";
    }

    public boolean isStartElement() {
        return this.fEventType == 1;
    }

    public boolean isEndElement() {
        return this.fEventType == 2;
    }

    public boolean isCharacters() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6;
    }

    public boolean isWhiteSpace() {
        if (this.fEventType == 4) {
            if (this.fIsSingleCharacter) {
                return this.singleCh == 32 || this.singleCh == 10 || this.singleCh == 9 || this.singleCh == 13;
            }
            return this.content().isAllWhitespace();
        }
        return this.fEventType == 6;
    }

    public String getAttributeValue(String string, String string2) {
        if (this.fEventType == 1) {
            if (this.fIsNamespaceAware) {
                if (string != null) {
                    for (int i = 0; i < this.attrCount; ++i) {
                        com.ibm.xml.xlxp2.scan.util.QName qName = this.attributeName(i);
                        if (!string2.equals(qName.localName) || !string.equals(qName.nsURI)) continue;
                        return this.attributeValue(i).toString();
                    }
                } else {
                    for (int i = 0; i < this.attrCount; ++i) {
                        com.ibm.xml.xlxp2.scan.util.QName qName = this.attributeName(i);
                        if (!string2.equals(qName.localName)) continue;
                        return this.attributeValue(i).toString();
                    }
                }
            } else {
                for (int i = 0; i < this.attrCount; ++i) {
                    com.ibm.xml.xlxp2.scan.util.QName qName = this.attributeName(i);
                    if (!string2.equals(qName.rawName)) continue;
                    return this.attributeValue(i).toString();
                }
            }
            return null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public int getAttributeCount() {
        if (this.fEventType == 1) {
            return this.attrCount;
        }
        if (this.fEventType == 10) {
            return -1;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return -1;
    }

    public QName getAttributeName(int n) {
        if (this.fEventType == 1) {
            return this.createQName(this.attributeName(n));
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeNamespace(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                String string = this.attributeName((int)n).nsURI;
                return string != "" ? string : null;
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeLocalName(int n) {
        if (this.fEventType == 1) {
            return this.attributeName((int)n).localName;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributePrefix(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                String string = this.attributeName((int)n).prefix;
                return string != "" ? string : null;
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeType(int n) {
        if (this.fEventType == 1) {
            String string = this.attributeType(n);
            return string != "" ? string : "CDATA";
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeValue(int n) {
        if (this.fEventType == 1) {
            return this.attributeValue(n).toString();
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public boolean isAttributeSpecified(int n) {
        if (this.fEventType == 1) {
            return this.attributeSpecified(n);
        }
        if (this.fEventType == 10) {
            return false;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return false;
    }

    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.nsDeclCount();
        }
        if (this.fEventType == 13) {
            return -1;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return -1;
    }

    public String getNamespacePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 2) {
            String string = this.nsDeclPrefix(n);
            return string != "" ? string : null;
        }
        if (this.fEventType == 13) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return null;
    }

    public String getNamespaceURI(int n) {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.nsDeclURI(n);
        }
        if (this.fEventType == 13) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        if (this.fStAXNamespaceContext == null) {
            this.fStAXNamespaceContext = new StAXNamespaceContext();
        }
        return this.fStAXNamespaceContext;
    }

    public int getEventType() {
        return this.fEventType;
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6) {
            if (this.fIsSingleCharacter) {
                if (this.singleCh < 65536) {
                    return String.valueOf((char)this.singleCh);
                }
                int n = this.singleCh - 65536;
                this.fSurrogatePair[0] = (char)(55296 + (n >> 10));
                this.fSurrogatePair[1] = (char)(56320 + (n & 0x3FF));
                return new String(this.fSurrogatePair);
            }
            return this.content().toString();
        }
        if (this.fEventType == 5) {
            return this.content.toString();
        }
        if (this.fEventType == 11) {
            XMLString xMLString = this.internalSubsetText();
            return xMLString != null ? xMLString.toString() : null;
        }
        if (this.fEventType == 9) {
            XMLString xMLString = this.entityText(this.entityName);
            return xMLString != null ? xMLString.toString() : null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    public char[] getTextCharacters() {
        if (this.fCharactersLength >= 0) {
            return this.fCharacters[0];
        }
        if (this.hasTextType()) {
            if (this.getCharacters()) {
                return this.fCharacters[0];
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this.fCharactersLength >= 0) {
            char[] cArray2 = this.fCharacters[0];
            int n4 = this.fCharactersLength - n;
            if (n4 < n3) {
                n3 = n4;
            }
            System.arraycopy(cArray2, n, cArray, n2, n3);
            return n3;
        }
        if (this.hasTextType()) {
            if (this.getCharacters()) {
                char[] cArray3 = this.fCharacters[0];
                int n5 = this.fCharactersLength - n;
                if (n5 < n3) {
                    n3 = n5;
                }
                System.arraycopy(cArray3, n, cArray, n2, n3);
                return n3;
            }
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    public int getTextStart() {
        if (this.fCharactersLength >= 0 || this.hasTextType()) {
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    public int getTextLength() {
        if (this.fCharactersLength >= 0) {
            return this.fCharactersLength;
        }
        if (this.hasTextType()) {
            if (this.getCharacters()) {
                return this.fCharactersLength;
            }
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    public String getEncoding() {
        if (this.fEventType == 7) {
            if (this.fUserSpecifiedEncoding) {
                return this.fActualEncoding[0];
            }
            if (this.encName.length != 0) {
                return this.encName.toString();
            }
            return this.fActualEncoding[0];
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    public boolean hasText() {
        return this.hasTextType() || this.fEventType == 11 || this.fEventType == 9;
    }

    public Location getLocation() {
        if (this.fLocation == null) {
            this.fDocumentPosition = new DocumentPosition();
            this.fLocation = new LocationImpl();
        }
        if (this.fProperties.isSupportingLocationCoordinates) {
            if (this.fPositionHelper == null) {
                this.fPositionHelper = new SimplePositionHelper();
            }
            this.fPositionHelper.setCurrentExternalEntity(this.fCurrentEntity);
            this.fPositionHelper.getCurrentPosition(this.fDocumentPosition);
        } else {
            this.fDocumentPosition.lineNumber = -1;
            this.fDocumentPosition.columnNumber = -1;
            this.fDocumentPosition.byteOffset = -1;
        }
        return this.fLocation;
    }

    public QName getName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.createQName(this.elementType);
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.elementType.localName;
        }
        if (this.fEventType == 9) {
            return this.entityName.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 22));
        return null;
    }

    public boolean hasName() {
        return this.fEventType == 1 || this.fEventType == 2;
    }

    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            if (this.fIsNamespaceAware) {
                String string = this.elementType.nsURI;
                return string != "" ? string : null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            if (this.fIsNamespaceAware) {
                String string = this.elementType.prefix;
                return string != "" ? string : null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    public String getVersion() {
        if (this.fEventType == 7) {
            return this.version.length == 0 ? null : this.version.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    public boolean isStandalone() {
        if (this.fEventType == 7) {
            return this.standalone.length == 3;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return false;
    }

    public boolean standaloneSet() {
        if (this.fEventType == 7) {
            return this.standalone.length > 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return false;
    }

    public String getCharacterEncodingScheme() {
        if (this.fEventType == 7) {
            return this.encName.length == 0 ? null : this.encName.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.piTarget.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
        return null;
    }

    public String getPIData() {
        if (this.fEventType == 3) {
            return this.content.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
        return null;
    }

    private QName createQName(com.ibm.xml.xlxp2.scan.util.QName qName) {
        return new QName(qName.nsURI != null ? qName.nsURI : "", qName.localName, qName.prefix != null ? qName.prefix : "");
    }

    private String getErrorMessage() {
        StAXMessageProvider.loadMessageProvider();
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.errorURI);
        int n = this.errorParamsCount;
        Object[] objectArray = ArrayAllocator.newObjectArray(XMLString.class, n);
        while (n-- > 0) {
            objectArray[n] = this.errorParamStrings[n];
        }
        String string = messageProvider.createMessage(null, this.errorCode, objectArray);
        return string;
    }

    private boolean hasTextType() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 5 || this.fEventType == 6;
    }

    private boolean getCharacters() {
        if (this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6) {
            if (this.fIsSingleCharacter) {
                if (this.singleCh < 65536) {
                    this.fCharacters[0][0] = (char)this.singleCh;
                    this.fCharactersLength = 1;
                } else {
                    int n = this.singleCh - 65536;
                    this.fCharacters[0][0] = (char)(55296 + (n >> 10));
                    this.fCharacters[0][1] = (char)(56320 + (n & 0x3FF));
                    this.fCharactersLength = 2;
                }
                return true;
            }
            this.fCharactersOffset[0] = 0;
            this.content().getChars(this.fCharacters, this.fCharactersOffset);
            this.fCharactersLength = this.fCharactersOffset[0];
            return true;
        }
        if (this.fEventType == 5) {
            this.fCharactersOffset[0] = 0;
            this.content.getChars(this.fCharacters, this.fCharactersOffset);
            this.fCharactersLength = this.fCharactersOffset[0];
            return true;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 25));
        return false;
    }

    private XMLString internalSubsetText() {
        return this.fDTDScanner.getInternalSubsetString();
    }

    private XMLString doctypeText() {
        return this.fDTDScanner.getDoctypeString();
    }

    protected XMLString entityText(XMLString xMLString) {
        EntityDeclPool.EntityDecl entityDecl = this.fDTDScanner.lookupEntity(xMLString);
        if (entityDecl != null) {
            return entityDecl.content;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 24));
        return null;
    }

    private XMLString content() {
        if (this.fHasCoalescedContent) {
            return this.fCoalescedContent;
        }
        return this.content;
    }

    private void setCurrentEvent(int n) {
        this.fEventType = n;
    }

    private void startCoalescing(boolean bl) {
        this.fHasCoalescedContent = true;
        if (bl) {
            this.fStringBuffer.reset(true);
            this.fCoalescedContentOffset = this.fStringBuffer.getOffset();
        } else {
            this.fCoalescedContentOffset = -1;
        }
    }

    public boolean produceStartDocumentEvent() {
        super.produceStartDocumentEvent();
        this.setCurrentEvent(7);
        return false;
    }

    public boolean produceEndDocumentEvent() {
        super.produceEndDocumentEvent();
        this.setCurrentEvent(8);
        return false;
    }

    public boolean produceStartElementEvent() {
        super.produceStartElementEvent();
        this.setCurrentEvent(1);
        return false;
    }

    public boolean produceLeafElementEvent() {
        super.produceLeafElementEvent();
        this.fIsLeafElement = true;
        this.setCurrentEvent(1);
        return false;
    }

    public boolean produceEndElementEvent() {
        super.produceEndElementEvent();
        this.setCurrentEvent(2);
        return false;
    }

    public boolean produceCharactersEvent() {
        super.produceCharactersEvent();
        return this.processCharactersCDATAOrWhitespaceEvent(4);
    }

    public boolean produceCDATASectionEvent() {
        super.produceCDATASectionEvent();
        return this.processCharactersCDATAOrWhitespaceEvent(12);
    }

    public boolean produceWhitespaceEvent() {
        super.produceWhitespaceEvent();
        return this.processCharactersCDATAOrWhitespaceEvent(6);
    }

    private boolean processCharactersCDATAOrWhitespaceEvent(int n) {
        this.fIsSingleCharacter = false;
        if (this.fHasCoalescedContent) {
            if (this.fProperties.isCoalescing) {
                if (this.fCoalescedContentOffset == -1) {
                    this.startCoalescing(true);
                    this.fStringBuffer.appendXMLString(this.fCoalescedContent);
                }
                this.fStringBuffer.appendXMLString(this.content);
                return true;
            }
            this.setCurrentEvent(n);
            return false;
        }
        this.startCoalescing(false);
        this.fCoalescedContent.setValues(this.content);
        this.fCoalescedEventType = this.fProperties.isCoalescing ? 4 : n;
        return true;
    }

    public boolean produceCharacterEvent() {
        super.produceCharacterEvent();
        return this.processSingleCharacterEvent();
    }

    public boolean producePredefinedEntityEvent() {
        super.producePredefinedEntityEvent();
        return this.processSingleCharacterEvent();
    }

    private boolean processSingleCharacterEvent() {
        if (this.fHasCoalescedContent) {
            if (this.fCoalescedContentOffset == -1) {
                this.startCoalescing(true);
                this.fStringBuffer.appendXMLString(this.fCoalescedContent);
            }
            this.fStringBuffer.appendChar(this.singleCh);
            return true;
        }
        if (this.fProperties.isCoalescing) {
            this.startCoalescing(true);
            this.fCoalescedEventType = 4;
            this.fStringBuffer.appendChar(this.singleCh);
            return true;
        }
        this.fIsSingleCharacter = true;
        this.setCurrentEvent(4);
        return false;
    }

    public boolean produceProcessingInstructionEvent() {
        super.produceProcessingInstructionEvent();
        this.setCurrentEvent(3);
        return false;
    }

    public boolean produceCommentEvent() {
        super.produceCommentEvent();
        this.setCurrentEvent(5);
        return false;
    }

    public boolean produceDoctypeEvent() {
        super.produceDoctypeEvent();
        this.setCurrentEvent(11);
        return false;
    }

    public boolean produceEntityReferenceEvent() {
        super.produceEntityReferenceEvent();
        this.setCurrentEvent(9);
        return false;
    }

    public boolean produceWarningEvent() {
        super.produceWarningEvent();
        if (this.fProperties.reporter != null) {
            try {
                this.fProperties.reporter.report(this.getErrorMessage(), "WARNING", null, this.getLocation());
            }
            catch (XMLStreamException xMLStreamException) {
                StAXMessageProvider.throwXMLStreamExceptionWrapper(xMLStreamException);
            }
        }
        return true;
    }

    public boolean produceRecoverableErrorEvent() {
        super.produceRecoverableErrorEvent();
        if (this.fProperties.reporter != null) {
            try {
                this.fProperties.reporter.report(this.getErrorMessage(), "RECOVERABLE_ERROR", null, this.getLocation());
            }
            catch (XMLStreamException xMLStreamException) {
                StAXMessageProvider.throwXMLStreamExceptionWrapper(xMLStreamException);
            }
        }
        return true;
    }

    public boolean produceFatalErrorEvent() {
        super.produceFatalErrorEvent();
        StAXMessageProvider.throwWrappedXMLStreamException(this.getErrorMessage(), this.getLocation());
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private final class StAXNamespaceContext
    implements NamespaceContext {
        @Override
        public String getNamespaceURI(String string) {
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
            }
            if (!string.equals("xmlns")) {
                return XMLStreamReaderImpl.this.prefixMapping(XMLStreamReaderImpl.this.fSymbolTable.addSymbol(string));
            }
            return "http://www.w3.org/2000/xmlns/";
        }

        @Override
        public String getPrefix(String string) {
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
            }
            if (!string.equals("http://www.w3.org/2000/xmlns/")) {
                return XMLStreamReaderImpl.this.prefixForNamespaceURI(XMLStreamReaderImpl.this.fSymbolTable.addSymbol(string));
            }
            return "xmlns";
        }

        @Override
        public Iterator<String> getPrefixes(String string) {
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (!string.equals("http://www.w3.org/2000/xmlns/")) {
                int n = XMLStreamReaderImpl.this.totalMappingsCount();
                String[] stringArray = ArrayAllocator.newStringArray(n);
                int n2 = XMLStreamReaderImpl.this.prefixesForNamespaceURI(stringArray, XMLStreamReaderImpl.this.fSymbolTable.addSymbol(string));
                for (int i = 0; i < n2; ++i) {
                    hashSet.add(stringArray[i]);
                }
            } else {
                hashSet.add("xmlns");
            }
            return hashSet.iterator();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private class LocationImpl
    implements Location {
        private LocationImpl() {
        }

        public int getLineNumber() {
            return ((XMLStreamReaderImpl)XMLStreamReaderImpl.this).fDocumentPosition.lineNumber;
        }

        public int getColumnNumber() {
            return ((XMLStreamReaderImpl)XMLStreamReaderImpl.this).fDocumentPosition.columnNumber;
        }

        public int getCharacterOffset() {
            return ((XMLStreamReaderImpl)XMLStreamReaderImpl.this).fDocumentPosition.byteOffset;
        }

        public String getPublicId() {
            return XMLStreamReaderImpl.this.fPublicId;
        }

        public String getSystemId() {
            return XMLStreamReaderImpl.this.fSystemId;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private class DTDSupportProxy
    extends DTDSupport {
        private ParsedEntity fDocumentEntity;
        private boolean fStandalone;
        private boolean fIsReplacingEntityReferences;
        private boolean fIsSupportingExternalEntities;
        private boolean fSupportDTD;
        private boolean fResolveDTDURIs;

        public DTDSupportProxy(DocumentScanner documentScanner) {
            super(documentScanner);
        }

        public void setDTDProperties(StAXImplProperties stAXImplProperties) {
            this.fIsReplacingEntityReferences = XMLStreamReaderImpl.this.fProperties.isReplacingEntityReferences;
            this.fIsSupportingExternalEntities = XMLStreamReaderImpl.this.fProperties.isSupportingExternalEntities;
            this.fSupportDTD = XMLStreamReaderImpl.this.fProperties.supportDTD;
            this.fResolveDTDURIs = XMLStreamReaderImpl.this.fProperties.resolveDTDURIs;
            if (XMLStreamReaderImpl.this.fDTDScanner != null) {
                this.setPropertiesOnDTDScanner();
            }
        }

        private void setPropertiesOnDTDScanner() {
            XMLStreamReaderImpl.this.fDTDScanner.setScanInternalGeneralEntities(this.fIsReplacingEntityReferences);
            if (this.fIsReplacingEntityReferences) {
                XMLStreamReaderImpl.this.fDTDScanner.setScanExternalGeneralEntities(this.fIsSupportingExternalEntities);
                XMLStreamReaderImpl.this.fDTDScanner.setScanExternalParameterEntities(this.fIsSupportingExternalEntities);
            } else {
                XMLStreamReaderImpl.this.fDTDScanner.setScanExternalGeneralEntities(false);
                XMLStreamReaderImpl.this.fDTDScanner.setScanExternalParameterEntities(false);
            }
            XMLStreamReaderImpl.this.fDTDScanner.setSupportDTD(this.fSupportDTD);
            XMLStreamReaderImpl.this.fDTDScanner.setResolveDTDURIs("http://xml.org/sax/features/resolve-dtd-uris", this.fResolveDTDURIs);
        }

        public boolean scanDoctypeDecl() {
            XMLStreamReaderImpl.this.fDTDScanner = new StAXDTDScanner((DocumentScanner)XMLStreamReaderImpl.this, XMLStreamReaderImpl.this.fSymbolTable, XMLStreamReaderImpl.this.fEntityFactory);
            XMLStreamReaderImpl.this.setDTDSupport(XMLStreamReaderImpl.this.fDTDScanner);
            XMLStreamReaderImpl.this.fDTDScanner.setDocumentEntity(this.fDocumentEntity);
            if (this.fStandalone) {
                XMLStreamReaderImpl.this.fDTDScanner.setStandalone();
            }
            this.setPropertiesOnDTDScanner();
            return XMLStreamReaderImpl.this.fDTDScanner.scanDoctypeDecl();
        }

        public void setDocumentEntity(ParsedEntity parsedEntity) {
            this.fDocumentEntity = parsedEntity;
        }

        public void setStandalone() {
            this.fStandalone = true;
        }
    }
}

