/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.websvcs.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoader;
import java.security.PrivilegedAction;
import org.apache.axis2.java.security.AccessController;

public class PolicySetLoaderMgr {
    private static final TraceComponent _tc = Tr.register(PolicySetLoaderMgr.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static ThreadLocal<PolicySetLoader> tlPSL = new ThreadLocal();

    public static PolicySetLoader setContextPolicySetLoader(PolicySetLoader psl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicySetLoaderMgr.setContextPolicySetLoader()...", "PSLoader: " + psl);
        }
        PolicySetLoader oldPolicySetLoader = tlPSL.get();
        tlPSL.set(psl);
        return oldPolicySetLoader;
    }

    public static PolicySetLoader getContextPolicySetLoader() {
        PolicySetLoader policySetLoader = tlPSL.get();
        if (policySetLoader == null) {
            policySetLoader = PolicySetLoaderMgr.getDefaultPolicySetLoader();
            PolicySetLoaderMgr.setContextPolicySetLoader(policySetLoader);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Default policy set loader retrieved and stored in thread local.");
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "PolicySetLoaderMgr.getContextPolicySetLoader() = " + policySetLoader);
        }
        return policySetLoader;
    }

    private static PolicySetLoader getDefaultPolicySetLoader() {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
        return new WASAxis2PolicySetConfigurator(cl, cl);
    }
}

