/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.RequestUtils";
    private static final String SHORT_ENGLISH = "8859_1";
    private static boolean ignoreInvalidQueryString = WCCustomProperties.IGNORE_INVALID_QUERY_STRING;

    public static Hashtable parseQueryString(String s) {
        return RequestUtils.parseQueryString(s, SHORT_ENGLISH);
    }

    public static Hashtable parseQueryString(String s, String encoding) {
        String[] oldVals;
        String value;
        String key;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "parseQueryString(String, String)");
        }
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException("query string or post data is null");
        }
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        char[] ch = s.toCharArray();
        int lgth = ch.length;
        boolean encoding_is_ShortEnglish = true;
        if (!encoding.endsWith(SHORT_ENGLISH) && !encoding.endsWith("8859-1") && encoding.indexOf("8859-1-Windows") == -1) {
            encoding_is_ShortEnglish = false;
        }
        int pair_start = 0;
        int i = 0;
        int j = 0;
        int equalSign = 0;
        for (i = 0; i < lgth; ++i) {
            if (ch[i] != '&') continue;
            for (equalSign = pair_start; equalSign < i && ch[equalSign] != '='; ++equalSign) {
            }
            if (equalSign < i) {
                key = RequestUtils.parseName(ch, pair_start, equalSign);
                value = RequestUtils.parseName(ch, equalSign + 1, i);
                if (ignoreInvalidQueryString && (value == null || key == null)) {
                    pair_start = i + 1;
                    continue;
                }
                if (!encoding_is_ShortEnglish) {
                    try {
                        key = new String(key.getBytes(SHORT_ENGLISH), encoding);
                        value = new String(value.getBytes(SHORT_ENGLISH), encoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", "unsupported exception", uee);
                        throw new IllegalArgumentException();
                    }
                }
                if (ht.containsKey(key)) {
                    oldVals = (String[])ht.get(key);
                    valArray = new String[oldVals.length + 1];
                    for (j = 0; j < oldVals.length; ++j) {
                        valArray[j] = oldVals[j];
                    }
                    valArray[oldVals.length] = value;
                } else {
                    valArray = new String[]{value};
                }
                ht.put(key, valArray);
            }
            pair_start = i + 1;
        }
        for (equalSign = pair_start; equalSign < i && ch[equalSign] != '='; ++equalSign) {
        }
        if (equalSign < i) {
            key = RequestUtils.parseName(ch, pair_start, equalSign);
            value = RequestUtils.parseName(ch, equalSign + 1, i);
            if (ignoreInvalidQueryString && (value == null || key == null)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "parseQueryString(String, String)");
                }
                return ht;
            }
            if (!encoding_is_ShortEnglish) {
                try {
                    key = new String(key.getBytes(SHORT_ENGLISH), encoding);
                    value = new String(value.getBytes(SHORT_ENGLISH), encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", "unsupported exception", uee);
                    throw new IllegalArgumentException();
                }
            }
            if (ht.containsKey(key)) {
                oldVals = (String[])ht.get(key);
                valArray = new String[oldVals.length + 1];
                for (j = 0; j < oldVals.length; ++j) {
                    valArray[j] = oldVals[j];
                }
                valArray[oldVals.length] = value;
            } else {
                valArray = new String[]{value};
            }
            ht.put(key, valArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "parseQueryString(String, String)");
        }
        return ht;
    }

    private static String parseName(char[] ch, int startOffset, int endOffset) {
        int j = 0;
        int startOffsetLocal = startOffset;
        int endOffsetLocal = endOffset;
        char[] chLocal = ch;
        char[] c = new char[endOffsetLocal - startOffsetLocal];
        block4: for (int i = startOffsetLocal; i < endOffsetLocal; ++i) {
            switch (chLocal[i]) {
                case '+': {
                    c[j++] = 32;
                    continue block4;
                }
                case '%': {
                    if (i + 2 < endOffsetLocal) {
                        int num1 = Character.digit(chLocal[++i], 16);
                        int num2 = Character.digit(chLocal[++i], 16);
                        if (num1 == -1 || num2 == -1) {
                            if (ignoreInvalidQueryString) {
                                logger.logp(Level.WARNING, CLASS_NAME, "parseName", "invalid.query.string");
                                return null;
                            }
                            throw new IllegalArgumentException();
                        }
                        c[j++] = (char)(num1 << 4 | num2);
                        continue block4;
                    }
                    while (i < endOffsetLocal) {
                        c[j++] = chLocal[i];
                        ++i;
                    }
                    continue block4;
                }
                default: {
                    c[j++] = chLocal[i];
                }
            }
        }
        return new String(c, 0, j);
    }

    public static String getURIForCurrentDispatch(HttpServletRequest req) {
        String includeURI = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (includeURI == null) {
            return req.getRequestURI();
        }
        return includeURI;
    }
}

