/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.WebContainerConfig;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EncodingUtils {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.EncodingUtils";
    private static Object lock = new Object();
    private static Properties _localeProps = null;
    private static Properties _converterProps = null;
    private static HashMap _localeMap = new HashMap();
    private static HashMap _converterMap = new HashMap();
    private static boolean inited = false;
    private static Hashtable supportedEncodingsCache = new Hashtable();
    private static final byte[] TEST_CHAR = new byte[]{97};
    public static boolean setContentTypeBySetHeader;
    private static final Hashtable localesCache;
    private static Locale cachedLocale;
    private static String cachedEncoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (inited) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "initing EncodingUtils");
        }
        Object object = lock;
        synchronized (object) {
            if (inited) {
                return;
            }
            WebContainer wc = WebContainer.getWebContainer();
            WebContainerConfig wcConfig = wc.getWebContainerConfig();
            if (wcConfig != null) {
                _localeProps = wcConfig.getLocaleProps();
                _converterProps = wcConfig.getConverterProps();
            }
            if (_localeProps == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", "locale properties using default location");
                }
                _localeProps = new Properties();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            Enumeration<URL> enumeration = EncodingUtils.class.getClassLoader().getResources("encoding.properties");
                            while (enumeration.hasMoreElements()) {
                                URL url = enumeration.nextElement();
                                InputStream is = url.openStream();
                                _localeProps.load(is);
                                is.close();
                            }
                            return null;
                        }
                    });
                }
                catch (Throwable ex) {
                    FFDCFilter.processException(ex, "com.ibm.ws.webcontainer.srt.SRTRequestUtils", "56");
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "failed.to.load.encoding.properties", ex);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "locale properties specified by webcontainer shell");
            }
            if (_converterProps == null) {
                _converterProps = new Properties();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", "converter properties using default location");
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            Enumeration<URL> enumeration = EncodingUtils.class.getClassLoader().getResources("converter.properties");
                            while (enumeration.hasMoreElements()) {
                                URL url = enumeration.nextElement();
                                InputStream is = url.openStream();
                                _converterProps.load(is);
                                is.close();
                            }
                            return null;
                        }
                    });
                    Properties newProps = new Properties();
                    Enumeration<?> e = _converterProps.propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = (String)_converterProps.get(key);
                        newProps.put(key.toLowerCase(), value);
                    }
                    _converterProps = newProps;
                }
                catch (Throwable ex) {
                    FFDCFilter.processException(ex, "com.ibm.ws.webcontainer.srt.SRTRequestUtils", "74");
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "failed.to.load.converter.properties", ex);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "converter properties specified by webcontainer shell");
            }
            _localeMap.putAll(_localeProps);
            _converterMap.putAll(_converterProps);
            inited = true;
        }
    }

    public static String getCharsetFromContentType(String type) {
        EncodingUtils.init();
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        return afterSemi.substring(charsetLocation + 8).trim();
    }

    public static Vector getLocales(HttpServletRequest req) {
        EncodingUtils.init();
        String acceptLanguage = req.getHeader("Accept-Language");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocales", "Accept-Language --> " + acceptLanguage);
        }
        if (acceptLanguage == null) {
            Vector<Locale> def = new Vector<Locale>();
            def.addElement(Locale.getDefault());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getLocales", "processed Locales --> ", def);
            }
            return def;
        }
        Vector langList = null;
        langList = (Vector)localesCache.get(acceptLanguage);
        if (langList == null) {
            langList = EncodingUtils.processAcceptLanguage(acceptLanguage);
            langList = EncodingUtils.extractLocales(langList);
            localesCache.put(acceptLanguage, langList);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocales", "processed Locales --> " + langList);
        }
        return langList;
    }

    public static Vector processAcceptLanguage(String acceptLanguage) {
        EncodingUtils.init();
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        TreeMap map = new TreeMap(Collections.reverseOrder());
        while (languageTokenizer.hasMoreTokens()) {
            String language = languageTokenizer.nextToken().trim();
            if (language == null || language.length() == 0) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "Encountered zero length language token without quality index.. skipping token");
                logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "acceptLanguage param = [" + acceptLanguage + "]");
                continue;
            }
            int semicolonIndex = language.indexOf(59);
            Double qValue = new Double(1.0);
            if (semicolonIndex > -1) {
                int qIndex = language.indexOf("q=");
                String qValueStr = language.substring(qIndex + 2);
                try {
                    qValue = new Double(qValueStr.trim());
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, "com.ibm.ws.webcontainer.srt.SRTRequestUtils.processAcceptLanguage", "215");
                }
                language = language.substring(0, semicolonIndex);
            }
            if (language.length() > 0) {
                if (!(qValue > 0.0) || language.charAt(0) == '*') continue;
                Vector newVector = new Vector();
                if (map.containsKey(qValue)) {
                    newVector = (Vector)map.get(qValue);
                }
                newVector.addElement(language);
                map.put(qValue, newVector);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "Encountered zero length language token with quality index.. skipping token");
            logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "acceptLanguage param = [" + acceptLanguage + "]");
        }
        if (map.isEmpty()) {
            Vector<String> v = new Vector<String>();
            v.addElement(Locale.getDefault().toString());
            map.put("1", v);
        }
        return new Vector(map.values());
    }

    public static Vector extractLocales(Vector languages) {
        EncodingUtils.init();
        Enumeration e = languages.elements();
        Vector<Locale> l = new Vector<Locale>();
        while (e.hasMoreElements()) {
            Vector langVector = (Vector)e.nextElement();
            Enumeration enumeration = langVector.elements();
            while (enumeration.hasMoreElements()) {
                String language = (String)enumeration.nextElement();
                String country = "";
                String variant = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                    int variantIndex = country.indexOf("-");
                    if (variantIndex > -1) {
                        variant = country.substring(variantIndex + 1).trim();
                        country = country.substring(0, variantIndex).trim();
                    }
                }
                l.addElement(new Locale(language, country, variant));
            }
        }
        return l;
    }

    public static String getEncodingFromLocale(Locale locale) {
        EncodingUtils.init();
        if (locale == cachedLocale) {
            return cachedEncoding;
        }
        String encoding = (String)_localeMap.get(locale.toString());
        if (encoding == null && (encoding = (String)_localeMap.get(locale.getLanguage() + "_" + locale.getCountry())) == null) {
            encoding = (String)_localeMap.get(locale.getLanguage());
        }
        cachedEncoding = encoding;
        cachedLocale = locale;
        return encoding;
    }

    public static String getJvmConverter(String encoding) {
        EncodingUtils.init();
        String converter = (String)_converterMap.get(encoding.toLowerCase());
        if (converter != null) {
            return converter;
        }
        return encoding;
    }

    public static boolean isCharsetSupported(String charset) {
        Boolean supported = (Boolean)supportedEncodingsCache.get(charset);
        if (supported != null) {
            return supported;
        }
        try {
            new String(TEST_CHAR, charset);
            supportedEncodingsCache.put(charset, Boolean.TRUE);
        }
        catch (UnsupportedEncodingException e) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isCharsetSupported", "Encountered UnsupportedEncoding charset [" + charset + "]");
            }
            supportedEncodingsCache.put(charset, Boolean.FALSE);
            return false;
        }
        return true;
    }

    public static void setContentTypeByCustomProperty(String type, String matchString, HttpServletResponse resp) {
        if (type == null) {
            type = matchString.endsWith(".html") || matchString.endsWith(".htm") ? "text/html" : "text/plain";
        }
        if (setContentTypeBySetHeader) {
            resp.setHeader("Content-Type", type);
        } else {
            resp.setContentType(type);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setContentTypeByCustomProperty", "setContentType --> " + type);
        }
    }

    static {
        String propStr = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.setcontenttypebysetheader");
        setContentTypeBySetHeader = propStr == null || propStr.equalsIgnoreCase("true");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "staticInitializer", "setContentTypeBySetHeader=" + Boolean.toString(setContentTypeBySetHeader));
        }
        localesCache = new Hashtable();
        cachedLocale = null;
        cachedEncoding = null;
    }
}

