/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.ResponseBuffer;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedWriter
extends Writer
implements ResponseBuffer {
    protected Writer out;
    protected char[] buf = new char[0];
    protected int count;
    protected int total;
    protected int limit;
    protected IResponse response;
    protected int length = -1;
    protected IOutputStreamObserver obs;
    protected boolean _hasWritten;
    protected boolean _hasFlushed;
    protected IOException except;
    protected boolean committed;
    private int bufferSize;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.BufferedWriter";
    private boolean closeOnClose = false;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public BufferedWriter(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "BufferedWriter", "Constructor --> " + size);
        }
        this.buf = new char[size];
        this.bufferSize = size;
        this._hasWritten = false;
        this._hasFlushed = false;
    }

    public BufferedWriter() {
        this(1024);
    }

    public void init(Writer out, int bufSize) {
        this.initNewBuffer(out, bufSize);
    }

    void initNewBuffer(Writer out, int bufSize) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "initNewBuffer size --> " + bufSize);
        }
        this.out = out;
        this.except = null;
        if (this.buf.length != bufSize) {
            this.bufferSize = bufSize;
            this.buf = new char[this.bufferSize];
        }
    }

    public void finish() throws IOException {
        WebContainerRequestState reqState;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "finish", "finish");
        }
        if (this.length == -1 && this.total != 0) {
            this.length = this.total;
        }
        if (WCCustomProperties.FINISH_RESPONSE_ON_CLOSE && ((reqState = WebContainerRequestState.getInstance(false)) == null || reqState.getAttribute("com.ibm.ws.webcontainer.appIsArdEnabled") == null)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "finish", "finishresponseonclose and appIsNotArdEnabled, setLastBuffer to true");
            }
            this.response.setLastBuffer(true);
        }
        this.flush();
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "reset", "reset");
        }
        this.out = null;
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.committed = false;
        this._hasWritten = false;
        this._hasFlushed = false;
        this.response = null;
    }

    public int getTotal() {
        return this.total;
    }

    public void setObserver(IOutputStreamObserver obs) {
        this.obs = obs;
        this.limit = -1;
    }

    public boolean isCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "isCommitted: " + this.committed);
        }
        return this.committed;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            this.flush();
            throw this.except;
        }
    }

    public void write(int c) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "write --> " + c);
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (this.count == this.buf.length) {
            this.response.setFlushMode(false);
            this.flushChars();
            this.response.setFlushMode(true);
        }
        this.buf[this.count++] = (char)c;
        ++this.total;
    }

    public void write(char[] b, int off, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "write total: " + this.total + " len: " + len + " limit: " + this.limit + " buf.length: " + this.buf.length + " count: " + this.count);
        }
        if (len < 0) {
            logger.logp(Level.SEVERE, CLASS_NAME, "write", "Illegal.Argument.Trying.to.write.chars");
            throw new IllegalArgumentException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total + len > this.limit) {
            len = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        if (len >= this.buf.length) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "write", "len >= buf.length");
            }
            this.response.setFlushMode(false);
            this.flushChars();
            this.total += len;
            this.writeOut(b, off, len);
            this.response.setFlushMode(true);
            this.check();
            return;
        }
        int avail = this.buf.length - this.count;
        if (len > avail) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "write", "len >= avail");
            }
            this.response.setFlushMode(false);
            this.flushChars();
            this.response.setFlushMode(true);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
        this.total += len;
        this.check();
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flush", "flush");
        }
        this.flushChars();
    }

    protected void flushChars() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flushChars", "flushChars");
        }
        if (!this.committed && !this._hasFlushed && this.obs != null) {
            this._hasFlushed = true;
            this.obs.alertFirstFlush();
        }
        this.committed = true;
        if (this.count > 0) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "flushChars", " Count =" + this.count);
            }
            this.writeOut(this.buf, 0, this.count);
            this.count = 0;
        } else if (this.response.getFlushMode()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "flushChars", " Count 0 still flush mode is true , forceful flush");
            }
            this.response.flushBufferedContent();
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flushChars", " flush mode is false");
        }
    }

    public void print(String s) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "print", "print --> ", s);
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        int len = s.length();
        if (this.limit > -1 && this.total + len > this.limit) {
            len = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        int off = 0;
        while (len > 0) {
            int n = this.buf.length - this.count;
            if (n == 0) {
                this.response.setFlushMode(false);
                this.flushChars();
                this.response.setFlushMode(true);
                n = this.buf.length - this.count;
            }
            if (n > len) {
                n = len;
            }
            s.getChars(off, off + n, this.buf, this.count);
            this.count += n;
            this.total += n;
            off += n;
            len -= n;
        }
        this.check();
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "close", "close");
        }
        this.finish();
        try {
            this.obs.alertClose();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webcontainer.srt.BufferedWriter.close", "397", this);
        }
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public void setResponse(IResponse resp) {
        this.response = resp;
    }

    protected void writeOut(char[] buf, int offset, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "writeOut", "writeOut --> " + len);
        }
        try {
            this.out.write(buf, offset, len);
            this.out.flush();
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webcontainer.srt.BufferedWriter.writeOut", "416", this);
            this.count = 0;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "writeOut", "IOException occurred in writeOut method, observer alerting close.");
            }
            this.obs.alertClose();
            this.obs.alertException();
            throw ioe;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setBufferSize", "setBufferSize --> " + size);
        }
        if (this.total > 0) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setBufferSize", "setBufferSize(): illegal state--> already wrote " + this.total + " bytes");
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.initNewBuffer(this.out, size);
    }

    public void clearBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clearBuffer", "clearBuffer");
        }
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "clearBuffer", "clearBuffer(): illegal state--> stream is committed ");
            }
            throw new IllegalStateException();
        }
        this.total = 0;
        this.count = 0;
        this._hasWritten = false;
    }

    public void flushBuffer() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "flushBuffer");
        }
        this.flush();
    }
}

