/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.collaborator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.webcontainer.collaborator.ConnectionCollaborator;
import com.ibm.ws.webcontainer.collaborator.WebAppNameSpaceCollaborator;
import com.ibm.ws.webcontainer.collaborator.WebAppSecurityCollaborator;
import com.ibm.ws.webcontainer.collaborator.WebAppTransactionCollaborator;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IConnectionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppTransactionCollaborator;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CollaboratorHelper
implements ICollaboratorHelper {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.collaborator");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.collaborator.CollaboratorHelper";
    protected WebApp webApp;
    protected IWebAppSecurityCollaborator securityCollaborator;
    protected IWebAppNameSpaceCollaborator nameSpaceCollaborator;
    protected IWebAppTransactionCollaborator transactionCollaborator;

    public CollaboratorHelper(WebApp webApp) {
        this.webApp = webApp;
    }

    public Object processSecurityPreInvokeException(SecurityViolationException sve, RequestProcessor requestProcessor, HttpServletRequest request, HttpServletResponse response, WebAppDispatcherContext dispatchContext, WebApp context, String name) throws ServletErrorReport {
        Object secObject = null;
        secObject = sve.getWebSecurityContext();
        int sc = sve.getStatusCode();
        Throwable cause = sve.getCause();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "processSecurityPreInvokeException");
            logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "SecurityCollaboratorHelper.processPreInvokeException():  WebSecurityException thrown (" + sve.toString() + ").  HTTP status code: " + sc + "resource : " + name);
        }
        if (sc == 403) {
            if (context.isErrorPageDefined(sc)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using user defined error page for HTTP status code " + sc);
                }
                WebAppErrorReport wErrorReport = new WebAppErrorReport(cause);
                wErrorReport.setErrorCode(sc);
                context.sendError(request, response, wErrorReport);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using default security error page for HTTP status code " + sc);
                }
                try {
                    this.securityCollaborator.handleException(request, response, cause);
                }
                catch (Exception ex) {
                    if (requestProcessor instanceof IServletWrapper) {
                        throw ((IServletWrapper)requestProcessor).constructErrorReport(ex, dispatchContext.getCurrentServletReference());
                    }
                    throw CollaboratorHelper.constructErrorReport(ex, name);
                }
            }
        } else if (sc == 401) {
            try {
                this.securityCollaborator.handleException(request, response, cause);
            }
            catch (Exception ex) {
                if (requestProcessor instanceof IServletWrapper) {
                    throw ((IServletWrapper)requestProcessor).constructErrorReport(ex, dispatchContext.getCurrentServletReference());
                }
                throw CollaboratorHelper.constructErrorReport(ex, name);
            }
            if (context.isErrorPageDefined(sc)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using user defined error page for HTTP status code " + sc);
                }
                WebAppErrorReport wErrorReport = new WebAppErrorReport(cause);
                wErrorReport.setErrorCode(sc);
                context.sendError(request, response, wErrorReport);
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using default security error page for HTTP status code " + sc);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "HTTP status code: " + sc);
            }
            try {
                this.securityCollaborator.handleException(request, response, cause);
            }
            catch (Exception ex) {
                if (requestProcessor instanceof IServletWrapper) {
                    throw ((IServletWrapper)requestProcessor).constructErrorReport(ex, dispatchContext.getCurrentServletReference());
                }
                throw CollaboratorHelper.constructErrorReport(ex, name);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "processSecurityPreInvokeException");
        }
        return secObject;
    }

    private static ServletErrorReport constructErrorReport(Throwable th, String path) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructErrorReport", "constructing error report for path -->" + path + " Throwable -->" + th);
        }
        WebAppErrorReport r = new WebAppErrorReport(th);
        r.setTargetServletName(path);
        Throwable rootCause = th;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (rootCause instanceof FileNotFoundException) {
            r.setErrorCode(404);
        } else if (rootCause instanceof UnavailableException) {
            UnavailableException ue = (UnavailableException)rootCause;
            if (ue.isPermanent()) {
                r.setErrorCode(404);
            } else {
                r.setErrorCode(503);
            }
        } else {
            r.setErrorCode(500);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructErrorReport", "returning new servlet error report");
        }
        return r;
    }

    public IWebAppNameSpaceCollaborator getWebAppNameSpaceCollaborator() {
        if (this.nameSpaceCollaborator == null) {
            this.nameSpaceCollaborator = new WebAppNameSpaceCollaborator();
        }
        return this.nameSpaceCollaborator;
    }

    public IConnectionCollaborator getWebAppConnectionCollaborator() {
        return new ConnectionCollaborator();
    }

    public void doInvocationCollaboratorsPreInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd, ServletRequest request, ServletResponse response) {
    }

    public void doInvocationCollaboratorsPostInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd, ServletRequest request, ServletResponse response) {
    }

    public void doInvocationCollaboratorsPreInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd) {
    }

    public void doInvocationCollaboratorsPostInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd) {
    }

    public IWebAppSecurityCollaborator getSecurityCollaborator() {
        if (this.securityCollaborator == null) {
            this.securityCollaborator = new WebAppSecurityCollaborator();
        }
        return this.securityCollaborator;
    }

    public IWebAppTransactionCollaborator getWebAppTransactionCollaborator() {
        if (this.transactionCollaborator == null) {
            this.transactionCollaborator = new WebAppTransactionCollaborator();
        }
        return this.transactionCollaborator;
    }
}

