/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer;

import com.ibm.ejs.ras.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebContainerRequestState {
    protected static Logger logger = Logger.getLogger("com.ibm.wsspi.webcontainer");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.WebContainerRequestState";
    private Map _attributes = null;
    private boolean _invokedFilters;
    private boolean completed;
    private boolean ardRequest;
    private static ThreadLocal<WebContainerRequestState> instance = new ThreadLocal();

    public static WebContainerRequestState getInstance(boolean create) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getInstance", "create->" + create);
        }
        WebContainerRequestState tempState = null;
        tempState = instance.get();
        if (tempState == null && create) {
            tempState = WebContainerRequestState.createInstance();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "createInstance", "webcontainer request state->" + tempState);
        }
        return tempState;
    }

    private static WebContainerRequestState createInstance() {
        WebContainerRequestState newState = new WebContainerRequestState();
        instance.set(newState);
        return newState;
    }

    public void init() {
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._invokedFilters = false;
        this.completed = false;
        this.ardRequest = false;
    }

    public void setAttribute(String string, Object obj) {
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        this._attributes.put(string, obj);
    }

    public Object getAttribute(String arg0) {
        if (this._attributes == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAttribute", " name --> " + arg0);
        }
        Object obj = this._attributes.get(arg0);
        return obj;
    }

    public void removeAttribute(String arg0) {
        if (this._attributes == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeAttribute", " name --> " + arg0);
        }
        Object oldValue = this._attributes.remove(arg0);
    }

    public boolean isInvokedFilters() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isInvokedFilters", " _invokedFilters --> " + this._invokedFilters);
        }
        return this._invokedFilters;
    }

    public void setInvokedFilters(boolean filters) {
        this._invokedFilters = filters;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isInvokedFilters", " _invokedFilters --> " + this._invokedFilters);
        }
    }

    public boolean isCompleted() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCompleted", " completed --> " + this.completed);
        }
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setCompleted", " completed --> " + completed);
        }
    }

    public boolean isArdRequest() {
        return this.ardRequest;
    }

    public void setArdRequest(boolean ardRequest) {
        this.ardRequest = ardRequest;
    }
}

