/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.ContainerHelper;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ConfigLocatorAdapter;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.provisioning.ComponentMetaDataMgr;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsContainer
extends WsComponentImpl {
    private static final TraceComponent tc = Tr.register(WsContainer.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private List components = Collections.EMPTY_LIST;
    private List<Object> applicationComponents = Collections.EMPTY_LIST;
    private List children = Collections.synchronizedList(new ArrayList());
    private String pluginId;
    private ContainerHelper helper = new ContainerHelper(this);

    protected WsContainer(String pluginId) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init> plugin=" + pluginId);
        }
        this.pluginId = pluginId;
    }

    @Override
    public void destroy() {
        this.destroyComponents();
    }

    protected void destroyComponents() {
        this.helper.destroyComponents(this.components, this.applicationComponents);
    }

    @Override
    public void initialize(Object config2) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", new Object[]{config2, this});
            }
            try {
                this.loadComponents(this.pluginId);
                if (config2 instanceof ContainerConfig) {
                    ContainerConfig containerConfig = (ContainerConfig)config2;
                    EObject configObject = null;
                    try {
                        configObject = (EObject)containerConfig.getConfig();
                    }
                    catch (ClassCastException ignore) {
                        Manager.Ffdc.log(ignore, this, WsComponentImpl.class.getName(), "141");
                    }
                    this.initializeComponents(configObject, containerConfig.getLocators());
                    break block13;
                }
                if (config2 instanceof com.ibm.wsspi.runtime.config.ContainerConfig) {
                    com.ibm.wsspi.runtime.config.ContainerConfig containerConfig = (com.ibm.wsspi.runtime.config.ContainerConfig)config2;
                    ConfigObject configObject = null;
                    try {
                        configObject = containerConfig.getConfig();
                    }
                    catch (ClassCastException ignore) {
                        Manager.Ffdc.log(ignore, this, WsComponentImpl.class.getName(), "154");
                    }
                    this.initializeComponents(configObject, containerConfig.getLocators());
                    break block13;
                }
                this.initializeComponents(null, new ConfigLocator[0]);
            }
            catch (Exception e) {
                if (e instanceof ComponentDisabledException) {
                    throw (ComponentDisabledException)e;
                }
                if (e instanceof ConfigurationWarning) {
                    throw (ConfigurationWarning)e;
                }
                if (e instanceof ConfigurationError) {
                    throw (ConfigurationError)e;
                }
                Manager.Ffdc.log(e, this, WsComponent.class.getName(), "127");
                throw new ConfigurationWarning(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    @Override
    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
    }

    protected void startComponents() throws RuntimeWarning, RuntimeError {
        this.helper.startComponents(this.components);
    }

    @Override
    public void stop() {
        this.stopComponents();
    }

    protected List loadComponents(String extensionPointId) throws ConfigurationError {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadComponents", new Object[]{this, extensionPointId});
        }
        List componentList = ComponentMetaDataMgr.instance().getComponentsByExtensionPoint(extensionPointId, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadedComponents " + componentList.size(), this);
            for (int i = 0; i < componentList.size(); ++i) {
                Tr.debug(tc, " component " + i, componentList.get(i));
            }
        }
        this.components = componentList;
        return this.components;
    }

    private ConfigLocatorAdapter[] createConfigLocatorAdapters(Object[] locators) {
        return this.helper.createConfigLocatorAdapters(locators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponents(ConfigObject rootConfig, com.ibm.wsspi.runtime.config.ConfigLocator[] locators) throws ConfigurationWarning, ConfigurationError {
        List loadedComponents = Collections.synchronizedList(new ArrayList());
        try {
            this.helper.initializeComponents(rootConfig, this.createConfigLocatorAdapters(locators), this.components, loadedComponents);
        }
        finally {
            this.components = loadedComponents;
        }
    }

    protected void initializeComponents(EObject rootConfig, ConfigLocator[] locators) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponents((Object)rootConfig, this.createConfigLocatorAdapters(locators));
    }

    private void initializeComponents(Object rootConfig, ConfigLocatorAdapter[] locators) throws ConfigurationWarning, ConfigurationError {
        List loadedComponents = Collections.synchronizedList(new ArrayList());
        try {
            this.helper.initializeComponents(rootConfig, locators, this.components, loadedComponents);
            this.components = loadedComponents;
        }
        catch (ConfigurationWarning e) {
            this.components = loadedComponents;
            throw e;
        }
    }

    protected void stopComponents() {
        this.helper.stopComponents(this.components, this.applicationComponents);
    }

    public boolean add(Object o) {
        if (this.children.contains(o)) {
            return false;
        }
        this.children.add(o);
        return true;
    }

    public boolean remove(Object o) {
        if (!this.children.contains(o)) {
            return false;
        }
        this.children.remove(o);
        return true;
    }

    public ContainerHelper getContainerHelper() {
        return this.helper;
    }

    public void addActivatedComponents(List<Object> activatedComponents) {
        if (this.applicationComponents == Collections.EMPTY_LIST) {
            this.applicationComponents = new ArrayList<Object>(3);
        }
        this.helper.addActivatedComponents(activatedComponents, this.applicationComponents);
    }
}

