/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.ejbcontainer;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_StubPluginImpl;
import com.ibm.wsspi.classloader.JIT_StubClassPlugin;

public final class JITDeploy {
    private static final String CLASS_NAME = JITDeploy.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");

    private JITDeploy() {
        throw new IllegalStateException();
    }

    public static String getStubClassName(Class remoteInterface) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStubClassName : " + remoteInterface.getName());
        }
        String remoteInterfaceName = remoteInterface.getName();
        StringBuilder stubBuilder = new StringBuilder(remoteInterfaceName);
        int packageOffset = stubBuilder.lastIndexOf(".") + 1;
        stubBuilder.insert(packageOffset, '_');
        stubBuilder.append("_Stub");
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStubClassName : " + stubBuilder.toString());
        }
        return stubBuilder.toString();
    }

    public static byte[] generateStubBytes(Class remoteInterface) throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateStubBytes : " + remoteInterface.getName());
        }
        byte[] stubBytes = JIT_Stub.generateStubBytes(remoteInterface);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateStubBytes : " + stubBytes.length + " bytes");
        }
        return stubBytes;
    }

    public static void registerJIT_StubClassPlugin(ClassLoader classloader) {
        if (classloader instanceof CompoundClassLoader) {
            CompoundClassLoader compoundCl = (CompoundClassLoader)classloader;
            JIT_StubClassPlugin stubPlugin = compoundCl.getJIT_StubClassPlugin();
            if (stubPlugin == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "registerJIT_StubClassPlugin : " + compoundCl);
                }
                stubPlugin = new JIT_StubPluginImpl(compoundCl);
                compoundCl.setJIT_StubClassPlugin(stubPlugin);
            }
        } else {
            throw new IllegalArgumentException("Specified ClassLoader does not support JIT_StubClassPlugin : " + classloader);
        }
    }
}

