/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.Iterator;
import java.util.List;

public class LocalProcessRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(LocalProcessRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static ClusterMemberService cms;

    public void subset(List identities, StringBuffer reason) {
        super.subset(identities, reason);
        LocalProcessRule.match(identities, reason);
    }

    private static void match(List identities, StringBuffer reason) {
        if (cms == null) {
            cms = (ClusterMemberService)ProcessProperties.getInstance().get("key.clustermember.service");
        }
        if (cms == null) {
            identities.clear();
            reason.append("All members removed, no cluster member service.");
        } else {
            Iterator iter = identities.iterator();
            while (iter.hasNext()) {
                Identity memberIdentity = (Identity)iter.next();
                if (cms.getServerClusterContextListener().validateClusterProcessResidency(memberIdentity)) continue;
                iter.remove();
                reason.append(memberIdentity + " removed: Not process local. ");
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.10 ");
        }
        cms = (ClusterMemberService)ProcessProperties.getInstance().get("key.clustermember.service");
    }
}

